# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.address import Address
from paypalserversdk.models.authentication_response import AuthenticationResponse
from paypalserversdk.models.bin_details import BinDetails
from paypalserversdk.models.card_attributes_response import CardAttributesResponse
from paypalserversdk.models.card_from_request import CardFromRequest


class ApplePayCardResponse(object):

    """Implementation of the 'Apple Pay Card Response' model.

    The Card from Apple Pay Wallet used to fund the payment.

    Attributes:
        name (str): The card holder's name as it appears on the card.
        last_digits (str): The last digits of the payment card.
        brand (CardBrand): The card network or brand. Applies to credit,
            debit, gift, and payment cards.
        available_networks (List[CardBrand]): Array of brands or networks
            associated with the card.
        mtype (CardType): Type of card. i.e Credit, Debit and so on.
        authentication_result (AuthenticationResponse): Results of
            Authentication such as 3D Secure.
        attributes (CardAttributesResponse): Additional attributes associated
            with the use of this card.
        from_request (CardFromRequest): Representation of card details as
            received in the request.
        expiry (str): The year and month, in ISO-8601 `YYYY-MM` date format.
            See [Internet date and time
            format](https://tools.ietf.org/html/rfc3339#section-5.6).
        bin_details (BinDetails): Bank Identification Number (BIN) details
            used to fund a payment.
        billing_address (Address): The portable international postal address.
            Maps to
            [AddressValidationMetadata](https://github.com/googlei18n/libaddres
            sinput/wiki/AddressValidationMetadata) and HTML 5.1 [Autofilling
            form controls: the autocomplete
            attribute](https://www.w3.org/TR/html51/sec-forms.html#autofilling-
            form-controls-the-autocomplete-attribute).
        country_code (str): The [two-character ISO 3166-1
            code](/api/rest/reference/country-codes/) that identifies the
            country or region.<blockquote><strong>Note:</strong> The country
            code for Great Britain is <code>GB</code> and not <code>UK</code>
            as used in the top-level domain names for that country. Use the
            `C2` country code for China worldwide for comparable uncontrolled
            price (CUP) method, bank card, and cross-border
            transactions.</blockquote>

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "name": 'name',
        "last_digits": 'last_digits',
        "brand": 'brand',
        "available_networks": 'available_networks',
        "mtype": 'type',
        "authentication_result": 'authentication_result',
        "attributes": 'attributes',
        "from_request": 'from_request',
        "expiry": 'expiry',
        "bin_details": 'bin_details',
        "billing_address": 'billing_address',
        "country_code": 'country_code'
    }

    _optionals = [
        'name',
        'last_digits',
        'brand',
        'available_networks',
        'mtype',
        'authentication_result',
        'attributes',
        'from_request',
        'expiry',
        'bin_details',
        'billing_address',
        'country_code',
    ]

    def __init__(self,
                 name=APIHelper.SKIP,
                 last_digits=APIHelper.SKIP,
                 brand=APIHelper.SKIP,
                 available_networks=APIHelper.SKIP,
                 mtype=APIHelper.SKIP,
                 authentication_result=APIHelper.SKIP,
                 attributes=APIHelper.SKIP,
                 from_request=APIHelper.SKIP,
                 expiry=APIHelper.SKIP,
                 bin_details=APIHelper.SKIP,
                 billing_address=APIHelper.SKIP,
                 country_code=APIHelper.SKIP):
        """Constructor for the ApplePayCardResponse class"""

        # Initialize members of the class
        if name is not APIHelper.SKIP:
            self.name = name 
        if last_digits is not APIHelper.SKIP:
            self.last_digits = last_digits 
        if brand is not APIHelper.SKIP:
            self.brand = brand 
        if available_networks is not APIHelper.SKIP:
            self.available_networks = available_networks 
        if mtype is not APIHelper.SKIP:
            self.mtype = mtype 
        if authentication_result is not APIHelper.SKIP:
            self.authentication_result = authentication_result 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 
        if from_request is not APIHelper.SKIP:
            self.from_request = from_request 
        if expiry is not APIHelper.SKIP:
            self.expiry = expiry 
        if bin_details is not APIHelper.SKIP:
            self.bin_details = bin_details 
        if billing_address is not APIHelper.SKIP:
            self.billing_address = billing_address 
        if country_code is not APIHelper.SKIP:
            self.country_code = country_code 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        name = dictionary.get("name") if dictionary.get("name") else APIHelper.SKIP
        last_digits = dictionary.get("last_digits") if dictionary.get("last_digits") else APIHelper.SKIP
        brand = dictionary.get("brand") if dictionary.get("brand") else APIHelper.SKIP
        available_networks = dictionary.get("available_networks") if dictionary.get("available_networks") else APIHelper.SKIP
        mtype = dictionary.get("type") if dictionary.get("type") else APIHelper.SKIP
        authentication_result = AuthenticationResponse.from_dictionary(dictionary.get('authentication_result')) if 'authentication_result' in dictionary.keys() else APIHelper.SKIP
        attributes = CardAttributesResponse.from_dictionary(dictionary.get('attributes')) if 'attributes' in dictionary.keys() else APIHelper.SKIP
        from_request = CardFromRequest.from_dictionary(dictionary.get('from_request')) if 'from_request' in dictionary.keys() else APIHelper.SKIP
        expiry = dictionary.get("expiry") if dictionary.get("expiry") else APIHelper.SKIP
        bin_details = BinDetails.from_dictionary(dictionary.get('bin_details')) if 'bin_details' in dictionary.keys() else APIHelper.SKIP
        billing_address = Address.from_dictionary(dictionary.get('billing_address')) if 'billing_address' in dictionary.keys() else APIHelper.SKIP
        country_code = dictionary.get("country_code") if dictionary.get("country_code") else APIHelper.SKIP
        # Return an object of this model
        return cls(name,
                   last_digits,
                   brand,
                   available_networks,
                   mtype,
                   authentication_result,
                   attributes,
                   from_request,
                   expiry,
                   bin_details,
                   billing_address,
                   country_code)
