# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.customer_information import CustomerInformation
from paypalserversdk.models.vault_instruction import VaultInstruction


class ApplePayAttributes(object):

    """Implementation of the 'Apple Pay Attributes' model.

    Additional attributes associated with apple pay.

    Attributes:
        customer (CustomerInformation): The details about a customer in
            PayPal's system of record.
        vault (VaultInstruction): Base vaulting specification. The object can
            be extended for specific use cases within each payment_source that
            supports vaulting.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "customer": 'customer',
        "vault": 'vault'
    }

    _optionals = [
        'customer',
        'vault',
    ]

    def __init__(self,
                 customer=APIHelper.SKIP,
                 vault=APIHelper.SKIP):
        """Constructor for the ApplePayAttributes class"""

        # Initialize members of the class
        if customer is not APIHelper.SKIP:
            self.customer = customer 
        if vault is not APIHelper.SKIP:
            self.vault = vault 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        customer = CustomerInformation.from_dictionary(dictionary.get('customer')) if 'customer' in dictionary.keys() else APIHelper.SKIP
        vault = VaultInstruction.from_dictionary(dictionary.get('vault')) if 'vault' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(customer,
                   vault)
