# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.amount_breakdown import AmountBreakdown


class AmountWithBreakdown(object):

    """Implementation of the 'Amount With Breakdown' model.

    The total order amount with an optional breakdown that provides details,
    such as the total item amount, total tax amount, shipping, handling,
    insurance, and discounts, if any.<br/>If you specify `amount.breakdown`,
    the amount equals `item_total` plus `tax_total` plus `shipping` plus
    `handling` plus `insurance` minus `shipping_discount` minus
    discount.<br/>The amount must be a positive number. For listed of
    supported currencies and decimal precision, see the PayPal REST APIs <a
    href="/docs/integration/direct/rest/currency-codes/">Currency Codes</a>.

    Attributes:
        currency_code (str): The [three-character ISO-4217 currency
            code](/api/rest/reference/currency-codes/) that identifies the
            currency.
        value (str): The value, which might be:<ul><li>An integer for
            currencies like `JPY` that are not typically fractional.</li><li>A
            decimal fraction for currencies like `TND` that are subdivided
            into thousandths.</li></ul>For the required number of decimal
            places for a currency code, see [Currency
            Codes](/api/rest/reference/currency-codes/).
        breakdown (AmountBreakdown): The breakdown of the amount. Breakdown
            provides details such as total item amount, total tax amount,
            shipping, handling, insurance, and discounts, if any.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "currency_code": 'currency_code',
        "value": 'value',
        "breakdown": 'breakdown'
    }

    _optionals = [
        'breakdown',
    ]

    def __init__(self,
                 currency_code=None,
                 value=None,
                 breakdown=APIHelper.SKIP):
        """Constructor for the AmountWithBreakdown class"""

        # Initialize members of the class
        self.currency_code = currency_code 
        self.value = value 
        if breakdown is not APIHelper.SKIP:
            self.breakdown = breakdown 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        currency_code = dictionary.get("currency_code") if dictionary.get("currency_code") else None
        value = dictionary.get("value") if dictionary.get("value") else None
        breakdown = AmountBreakdown.from_dictionary(dictionary.get('breakdown')) if 'breakdown' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(currency_code,
                   value,
                   breakdown)
