# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.money import Money


class AmountBreakdown(object):

    """Implementation of the 'Amount Breakdown' model.

    The breakdown of the amount. Breakdown provides details such as total item
    amount, total tax amount, shipping, handling, insurance, and discounts, if
    any.

    Attributes:
        item_total (Money): The currency and amount for a financial
            transaction, such as a balance or payment due.
        shipping (Money): The currency and amount for a financial transaction,
            such as a balance or payment due.
        handling (Money): The currency and amount for a financial transaction,
            such as a balance or payment due.
        tax_total (Money): The currency and amount for a financial
            transaction, such as a balance or payment due.
        insurance (Money): The currency and amount for a financial
            transaction, such as a balance or payment due.
        shipping_discount (Money): The currency and amount for a financial
            transaction, such as a balance or payment due.
        discount (Money): The currency and amount for a financial transaction,
            such as a balance or payment due.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "item_total": 'item_total',
        "shipping": 'shipping',
        "handling": 'handling',
        "tax_total": 'tax_total',
        "insurance": 'insurance',
        "shipping_discount": 'shipping_discount',
        "discount": 'discount'
    }

    _optionals = [
        'item_total',
        'shipping',
        'handling',
        'tax_total',
        'insurance',
        'shipping_discount',
        'discount',
    ]

    def __init__(self,
                 item_total=APIHelper.SKIP,
                 shipping=APIHelper.SKIP,
                 handling=APIHelper.SKIP,
                 tax_total=APIHelper.SKIP,
                 insurance=APIHelper.SKIP,
                 shipping_discount=APIHelper.SKIP,
                 discount=APIHelper.SKIP):
        """Constructor for the AmountBreakdown class"""

        # Initialize members of the class
        if item_total is not APIHelper.SKIP:
            self.item_total = item_total 
        if shipping is not APIHelper.SKIP:
            self.shipping = shipping 
        if handling is not APIHelper.SKIP:
            self.handling = handling 
        if tax_total is not APIHelper.SKIP:
            self.tax_total = tax_total 
        if insurance is not APIHelper.SKIP:
            self.insurance = insurance 
        if shipping_discount is not APIHelper.SKIP:
            self.shipping_discount = shipping_discount 
        if discount is not APIHelper.SKIP:
            self.discount = discount 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        item_total = Money.from_dictionary(dictionary.get('item_total')) if 'item_total' in dictionary.keys() else APIHelper.SKIP
        shipping = Money.from_dictionary(dictionary.get('shipping')) if 'shipping' in dictionary.keys() else APIHelper.SKIP
        handling = Money.from_dictionary(dictionary.get('handling')) if 'handling' in dictionary.keys() else APIHelper.SKIP
        tax_total = Money.from_dictionary(dictionary.get('tax_total')) if 'tax_total' in dictionary.keys() else APIHelper.SKIP
        insurance = Money.from_dictionary(dictionary.get('insurance')) if 'insurance' in dictionary.keys() else APIHelper.SKIP
        shipping_discount = Money.from_dictionary(dictionary.get('shipping_discount')) if 'shipping_discount' in dictionary.keys() else APIHelper.SKIP
        discount = Money.from_dictionary(dictionary.get('discount')) if 'discount' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(item_total,
                   shipping,
                   handling,
                   tax_total,
                   insurance,
                   shipping_discount,
                   discount)
