# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.name import Name
from paypalserversdk.models.phone import Phone


class AddressDetails(object):

    """Implementation of the 'Address Details' model.

    Address request details.

    Attributes:
        address_line_1 (str): The first line of the address, such as number
            and street, for example, `173 Drury Lane`. Needed for data entry,
            and Compliance and Risk checks. This field needs to pass the full
            address.
        address_line_2 (str): The second line of the address, for example, a
            suite or apartment number.
        admin_area_2 (str): A city, town, or village. Smaller than
            `admin_area_level_1`.
        admin_area_1 (str): The highest-level sub-division in a country, which
            is usually a province, state, or ISO-3166-2 subdivision. This data
            is formatted for postal delivery, for example, `CA` and not
            `California`. Value, by country, is:<ul><li>UK. A
            county.</li><li>US. A state.</li><li>Canada. A
            province.</li><li>Japan. A prefecture.</li><li>Switzerland. A
            *kanton*.</li></ul>
        postal_code (str): The postal code, which is the ZIP code or
            equivalent. Typically required for countries with a postal code or
            an equivalent. See [postal
            code](https://en.wikipedia.org/wiki/Postal_code).
        country_code (str): The [2-character ISO 3166-1
            code](/api/rest/reference/country-codes/) that identifies the
            country or region.<blockquote><strong>Note:</strong> The country
            code for Great Britain is <code>GB</code> and not <code>UK</code>
            as used in the top-level domain names for that country. Use the
            `C2` country code for China worldwide for comparable uncontrolled
            price (CUP) method, bank card, and cross-border
            transactions.</blockquote>
        name (Name): The name of the party.
        id (str): The resource ID of the address.
        company (str): The name of the company or business associated to the
            address.
        phone (str): The phone number that can go on the mailing label with
            the address to track the shipping. Phone number is in E.164
            format.
        phone_number (Phone): The phone number, in its canonical international
            [E.164 numbering plan
            format](https://www.itu.int/rec/T-REC-E.164/en).

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "country_code": 'country_code',
        "address_line_1": 'address_line_1',
        "address_line_2": 'address_line_2',
        "admin_area_2": 'admin_area_2',
        "admin_area_1": 'admin_area_1',
        "postal_code": 'postal_code',
        "name": 'name',
        "id": 'id',
        "company": 'company',
        "phone": 'phone',
        "phone_number": 'phone_number'
    }

    _optionals = [
        'address_line_1',
        'address_line_2',
        'admin_area_2',
        'admin_area_1',
        'postal_code',
        'name',
        'id',
        'company',
        'phone',
        'phone_number',
    ]

    def __init__(self,
                 country_code=None,
                 address_line_1=APIHelper.SKIP,
                 address_line_2=APIHelper.SKIP,
                 admin_area_2=APIHelper.SKIP,
                 admin_area_1=APIHelper.SKIP,
                 postal_code=APIHelper.SKIP,
                 name=APIHelper.SKIP,
                 id=APIHelper.SKIP,
                 company=APIHelper.SKIP,
                 phone=APIHelper.SKIP,
                 phone_number=APIHelper.SKIP):
        """Constructor for the AddressDetails class"""

        # Initialize members of the class
        if address_line_1 is not APIHelper.SKIP:
            self.address_line_1 = address_line_1 
        if address_line_2 is not APIHelper.SKIP:
            self.address_line_2 = address_line_2 
        if admin_area_2 is not APIHelper.SKIP:
            self.admin_area_2 = admin_area_2 
        if admin_area_1 is not APIHelper.SKIP:
            self.admin_area_1 = admin_area_1 
        if postal_code is not APIHelper.SKIP:
            self.postal_code = postal_code 
        self.country_code = country_code 
        if name is not APIHelper.SKIP:
            self.name = name 
        if id is not APIHelper.SKIP:
            self.id = id 
        if company is not APIHelper.SKIP:
            self.company = company 
        if phone is not APIHelper.SKIP:
            self.phone = phone 
        if phone_number is not APIHelper.SKIP:
            self.phone_number = phone_number 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        country_code = dictionary.get("country_code") if dictionary.get("country_code") else None
        address_line_1 = dictionary.get("address_line_1") if dictionary.get("address_line_1") else APIHelper.SKIP
        address_line_2 = dictionary.get("address_line_2") if dictionary.get("address_line_2") else APIHelper.SKIP
        admin_area_2 = dictionary.get("admin_area_2") if dictionary.get("admin_area_2") else APIHelper.SKIP
        admin_area_1 = dictionary.get("admin_area_1") if dictionary.get("admin_area_1") else APIHelper.SKIP
        postal_code = dictionary.get("postal_code") if dictionary.get("postal_code") else APIHelper.SKIP
        name = Name.from_dictionary(dictionary.get('name')) if 'name' in dictionary.keys() else APIHelper.SKIP
        id = dictionary.get("id") if dictionary.get("id") else APIHelper.SKIP
        company = dictionary.get("company") if dictionary.get("company") else APIHelper.SKIP
        phone = dictionary.get("phone") if dictionary.get("phone") else APIHelper.SKIP
        phone_number = Phone.from_dictionary(dictionary.get('phone_number')) if 'phone_number' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(country_code,
                   address_line_1,
                   address_line_2,
                   admin_area_2,
                   admin_area_1,
                   postal_code,
                   name,
                   id,
                   company,
                   phone,
                   phone_number)
