# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper


class Address(object):

    """Implementation of the 'Address' model.

    The portable international postal address. Maps to
    [AddressValidationMetadata](https://github.com/googlei18n/libaddressinput/w
    iki/AddressValidationMetadata) and HTML 5.1 [Autofilling form controls:
    the autocomplete
    attribute](https://www.w3.org/TR/html51/sec-forms.html#autofilling-form-con
    trols-the-autocomplete-attribute).

    Attributes:
        address_line_1 (str): The first line of the address, such as number
            and street, for example, `173 Drury Lane`. Needed for data entry,
            and Compliance and Risk checks. This field needs to pass the full
            address.
        address_line_2 (str): The second line of the address, for example, a
            suite or apartment number.
        admin_area_2 (str): A city, town, or village. Smaller than
            `admin_area_level_1`.
        admin_area_1 (str): The highest-level sub-division in a country, which
            is usually a province, state, or ISO-3166-2 subdivision. This data
            is formatted for postal delivery, for example, `CA` and not
            `California`. Value, by country, is:<ul><li>UK. A
            county.</li><li>US. A state.</li><li>Canada. A
            province.</li><li>Japan. A prefecture.</li><li>Switzerland. A
            *kanton*.</li></ul>
        postal_code (str): The postal code, which is the ZIP code or
            equivalent. Typically required for countries with a postal code or
            an equivalent. See [postal
            code](https://en.wikipedia.org/wiki/Postal_code).
        country_code (str): The [2-character ISO 3166-1
            code](/api/rest/reference/country-codes/) that identifies the
            country or region.<blockquote><strong>Note:</strong> The country
            code for Great Britain is <code>GB</code> and not <code>UK</code>
            as used in the top-level domain names for that country. Use the
            `C2` country code for China worldwide for comparable uncontrolled
            price (CUP) method, bank card, and cross-border
            transactions.</blockquote>

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "country_code": 'country_code',
        "address_line_1": 'address_line_1',
        "address_line_2": 'address_line_2',
        "admin_area_2": 'admin_area_2',
        "admin_area_1": 'admin_area_1',
        "postal_code": 'postal_code'
    }

    _optionals = [
        'address_line_1',
        'address_line_2',
        'admin_area_2',
        'admin_area_1',
        'postal_code',
    ]

    def __init__(self,
                 country_code=None,
                 address_line_1=APIHelper.SKIP,
                 address_line_2=APIHelper.SKIP,
                 admin_area_2=APIHelper.SKIP,
                 admin_area_1=APIHelper.SKIP,
                 postal_code=APIHelper.SKIP):
        """Constructor for the Address class"""

        # Initialize members of the class
        if address_line_1 is not APIHelper.SKIP:
            self.address_line_1 = address_line_1 
        if address_line_2 is not APIHelper.SKIP:
            self.address_line_2 = address_line_2 
        if admin_area_2 is not APIHelper.SKIP:
            self.admin_area_2 = admin_area_2 
        if admin_area_1 is not APIHelper.SKIP:
            self.admin_area_1 = admin_area_1 
        if postal_code is not APIHelper.SKIP:
            self.postal_code = postal_code 
        self.country_code = country_code 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        country_code = dictionary.get("country_code") if dictionary.get("country_code") else None
        address_line_1 = dictionary.get("address_line_1") if dictionary.get("address_line_1") else APIHelper.SKIP
        address_line_2 = dictionary.get("address_line_2") if dictionary.get("address_line_2") else APIHelper.SKIP
        admin_area_2 = dictionary.get("admin_area_2") if dictionary.get("admin_area_2") else APIHelper.SKIP
        admin_area_1 = dictionary.get("admin_area_1") if dictionary.get("admin_area_1") else APIHelper.SKIP
        postal_code = dictionary.get("postal_code") if dictionary.get("postal_code") else APIHelper.SKIP
        # Return an object of this model
        return cls(country_code,
                   address_line_1,
                   address_line_2,
                   admin_area_2,
                   admin_area_1,
                   postal_code)
