# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper


class ActivityTimestamps(object):

    """Implementation of the 'Activity Timestamps' model.

    The date and time stamps that are common to authorized payment, captured
    payment, and refund transactions.

    Attributes:
        create_time (str): The date and time, in [Internet date and time
            format](https://tools.ietf.org/html/rfc3339#section-5.6). Seconds
            are required while fractional seconds are
            optional.<blockquote><strong>Note:</strong> The regular expression
            provides guidance but does not reject all invalid
            dates.</blockquote>
        update_time (str): The date and time, in [Internet date and time
            format](https://tools.ietf.org/html/rfc3339#section-5.6). Seconds
            are required while fractional seconds are
            optional.<blockquote><strong>Note:</strong> The regular expression
            provides guidance but does not reject all invalid
            dates.</blockquote>

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "create_time": 'create_time',
        "update_time": 'update_time'
    }

    _optionals = [
        'create_time',
        'update_time',
    ]

    def __init__(self,
                 create_time=APIHelper.SKIP,
                 update_time=APIHelper.SKIP):
        """Constructor for the ActivityTimestamps class"""

        # Initialize members of the class
        if create_time is not APIHelper.SKIP:
            self.create_time = create_time 
        if update_time is not APIHelper.SKIP:
            self.update_time = update_time 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        create_time = dictionary.get("create_time") if dictionary.get("create_time") else APIHelper.SKIP
        update_time = dictionary.get("update_time") if dictionary.get("update_time") else APIHelper.SKIP
        # Return an object of this model
        return cls(create_time,
                   update_time)
