# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from paypalserversdk.api_helper import APIHelper
import paypalserversdk.exceptions.api_exception
from paypalserversdk.models.error_details import ErrorDetails
from paypalserversdk.models.link_description import LinkDescription


class ErrorException(paypalserversdk.exceptions.api_exception.APIException):
    def __init__(self, reason, response):
        """Constructor for the ErrorException class

        Args:
            reason (string): The reason (or error message) for the Exception
                to be raised.
            response (HttpResponse): The HttpResponse of the API call.

        """
        super(ErrorException, self).__init__(reason, response)
        dictionary = APIHelper.json_deserialize(self.response.text)
        if isinstance(dictionary, dict):
            self.unbox(dictionary)

    def unbox(self, dictionary):
        """Populates the properties of this object by extracting them from a dictionary.

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        """
        self.name = dictionary.get("name") if dictionary.get("name") else None
        self.message = dictionary.get("message") if dictionary.get("message") else None
        self.debug_id = dictionary.get("debug_id") if dictionary.get("debug_id") else None
        self.details = None
        if dictionary.get('details') is not None:
            self.details = [ErrorDetails.from_dictionary(x) for x in dictionary.get('details')]
        else:
            self.details = None
        self.links = None
        if dictionary.get('links') is not None:
            self.links = [LinkDescription.from_dictionary(x) for x in dictionary.get('links')]
        else:
            self.links = None
