# README.md

Этот репозиторий содержит код для взаимодействия с Jenkins с использованием библиотеки `invoke`. Он предоставляет функциональность для экспорта всех заданий из Jenkins и создания/обновления конкретных заданий.

## Предварительные требования

-   Python 3.8 или выше
-   Библиотека `invoke`
-   Библиотека `pyyaml`

## Начало работы

1. Клонируйте этот репозиторий на свой локальный компьютер.
2. Установите необходимые зависимости, выполнив следующую команду:
    ```
    poetry install
    ```
3. Настройте информацию о сервере Jenkins в файле `inventory.yml`. Добавьте необходимую информацию о серверах Jenkins, с которыми вы хотите взаимодействовать.

## Пример

Вот пример использования задач:

1.  Экспорта указанной задачи с сервера Jenkins в XML файл:

    ```
    python -m pyjej job.export -s мой_сервер_jenkins -j моё_задание
    ```

1.  Экспорт всех заданий с сервера Jenkins в XML файлы:

    ```
    python -m pyjej job.export-all -s мой_сервер_jenkins
    ```

1.  Создание задания на сервере Jenkins из XML файла:

    ```
    python -m pyjej job.create -s мой_сервер_jenkins -j моё_задание -i входная_папка
    ```

1.  Обновление задания на сервере Jenkins из XML файла:

    ```
    python -m pyjej job.update -s мой_сервер_jenkins -j моё_задание -i входная_папка
    ```

1.  Экспорт всех плагинов:

    ```
    python -m pyjej plugins.export-all -s мой_сервер_jenkins
    ```

1.  Установка указного плагина в Jenkins:

    ```
    python -m pyjej plugins.install -s мой_сервер_jenkins -p имя_плагина
    ```

1.  Скачать настройки из плагина Jenkins Configuration as Code:

    ```
    python -m pyjej jcasc.export -s мой_сервер_jenkins
    ```

Убедитесь, что заменяете `мой_сервер_jenkins` на фактическое имя сервера, определенное в файле `inventory.yml`, `моё_задание` на желаемое имя задания и `входная_папка` на папку, содержащую файл XML для задания.

## Использование

### tasks.py

В этом файле содержатся основные задачи для взаимодействия с Jenkins.

#### Задача `job.export`

Эта задача экспортирует указанную задачу с указанного сервера Jenkins и сохраняет её в виде файла XML.

**Использование:**

```shell
python -m pyjej job.export --server <имя_сервера> --jobname <имя_задания>
```

-   `<имя_сервера>`: Имя сервера Jenkins, определенное в файле `inventory.yml`.
-   `<имя_задания>`: Имя задания для экспорта.

#### Задача `job.export-all`

Эта задача экспортирует все задания с указанного сервера Jenkins и сохраняет их в виде файлов XML.

**Использование:**

```shell
python -m pyjej job.export-all --server <имя_сервера>
```

-   `<имя_сервера>`: Имя сервера Jenkins, определенное в файле `inventory.yml`.

#### Задача `job.create`

Эта задача создает конкретное задание на сервере Jenkins с использованием файла XML.

**Использование:**

```shell
python -m pyjej job.create --server <имя_сервера> --jobname <имя_задания> --in_server <входная_папка>
```

-   `<имя_сервера>`: Имя сервера Jenkins, определенное в файле `inventory.yml`.
-   `<имя_задания>`: Имя задания для создания.
-   `<входная_папка>`: Папка, содержащая файл XML для задания.

#### Задача `job.update`

Эта задача обновляет конкретное задание на сервере Jenkins с использованием файла XML.

**Использование:**

```shell
python -m pyjej job.update --server <имя_сервера> --jobname <имя_задания> --in_server <входная_папка>
```

-   `<имя_сервера>`: Имя сервера Jenkins, определенное в файле `inventory.yml`.
-   `<имя_задания>`: Имя задания для обновления.
-   `<входная_папка>`: Папка, содержащая файл XML для задания.

#### Задача `plugins.export-all`

Эта задача позволяет получить список всех установленных плагинов на указанном сервере Jenkins.

**Использование:**

```shell
python -m pyjej plugins.export-all --server <имя_сервера>
```

-   `<имя_сервера>`: Имя сервера Jenkins, определенное в файле `inventory.yml`.

Результат выполнения команды будет выведен на экран. Если у команды не было ошибок, список плагинов будет сохранен в файле `data/<имя_сервера>/plains.txt`.

#### Задача `plugins.install`

Эта задача позволяет установить указанный плагин на сервере Jenkins.

**Использование:**

```shell
python -m pyjej plugins.install --server <имя_сервера> --plugin <имя_плагина>
```

-   `<имя_сервера>`: Имя сервера Jenkins, определенное в файле `inventory.yml`.
-   `<имя_плагина>`: Имя плагина, который нужно установить.

Результат выполнения команды будет выведен на экран.

#### Задача `jcasc.export`

Эта задача позволяет скачать конфигурации Jenkins которые формируются через плагин `Jenkins Configuration as Code (a.k.a. JCasC) Plugin`.
https://github.com/jenkinsci/configuration-as-code-plugin

**Использование:**

```shell
python -m pyjej jcasc.export --server <имя_сервера>
```

-   `<имя_сервера>`: Имя сервера Jenkins, определенное в файле `inventory.yml`.

Результат выполнения команды будет выведен на экран и записан в файл `data/<имя_сервера>/jenkins.yaml`.

# Пример создания файла inventory.yml

Файл `inventory.yml` используется для настройки подключения к серверам Jenkins в коде. В этой главе мы предоставим пример создания файла `inventory.yml` с фиктивными значениями.

Пример содержимого файла `inventory.yml`:

```yaml
my_server:
    JENKINS_USER_ID: "user"
    JENKINS_API_TOKEN: "111111111111111111111111111"
    PATH_JENKINS_CLI_JAR: "jenkins-cli.jar"
    JENKINS_URL: "111.111.111.111:8080"
    BASE_COMMAND_CLI: "java -jar {PATH_JENKINS_CLI_JAR} -s http://{JENKINS_USER_ID}:{JENKINS_API_TOKEN}@{JENKINS_URL}"
```

Для каждого сервера указаны следующие параметры:

-   `JENKINS_USER_ID`: Идентификатор пользователя Jenkins для аутентификации.
-   `JENKINS_API_TOKEN`: API-токен пользователя Jenkins для аутентификации.
-   `PATH_JENKINS_CLI_JAR`: Путь к файлу `jenkins-cli.jar` на вашей системе.
-   `JENKINS_URL`: URL-адрес сервера Jenkins.
-   `BASE_COMMAND_CLI`: Базовая команда для выполнения операций через командную строку Jenkins CLI.

Убедитесь, что заменяете фиктивные значения реальными данными серверов Jenkins, к которым вы хотите подключиться.

Создайте файл `inventory.yml` в корневой папке проекта и добавьте соответствующую информацию для ваших серверов Jenkins. Этот файл будет использоваться кодом для установления связи с серверами Jenkins.

В следующей главе мы рассмотрим пример использования задач из `tasks.py` для взаимодействия с серверами Jenkins, настроенными в файле `inventory.yml`.
