import * as iam from '@aws-cdk/aws-iam';
import { Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { ISecret } from './secret';
/**
 * Construction properties for a ResourcePolicy.
 */
export interface ResourcePolicyProps {
    /**
     * The secret to attach a resource-based permissions policy.
     */
    readonly secret: ISecret;
}
/**
 * Secret Resource Policy.
 */
export declare class ResourcePolicy extends Resource {
    /**
     * The IAM policy document for this policy.
     */
    readonly document: iam.PolicyDocument;
    /**
     *
     */
    constructor(scope: Construct, id: string, props: ResourcePolicyProps);
}
