/*
 * Decompiled with CFR 0.152.
 */
package librec.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import librec.util.FileIO;
import librec.util.Maths;

public class Strings {
    public static final String EMPTY = "";
    private static String SEP = "\n";
    private static final DecimalFormat intFormatter = new DecimalFormat("#,###");
    private static final int PAD_LIMIT = 8192;

    public static String last(String str, int maxLength) {
        if (str.length() + 3 <= maxLength) {
            return str;
        }
        return "..." + str.substring(str.length() - maxLength + 3);
    }

    public static float toFloat(String str) {
        return Float.parseFloat(str);
    }

    public static float toFloat(String str, float val) {
        return str != null ? Float.parseFloat(str) : val;
    }

    public static int toInt(String str) {
        return Integer.parseInt(str);
    }

    public static int toInt(String str, int val) {
        return str != null ? Integer.parseInt(str) : val;
    }

    public static long toLong(String str) {
        return Long.parseLong(str);
    }

    public static long toLong(String str, long val) {
        return str != null ? Long.parseLong(str) : val;
    }

    public static double toDouble(String str) {
        return Double.parseDouble(str);
    }

    public static double toDouble(String str, double val) {
        return str != null ? Double.parseDouble(str) : val;
    }

    public static void toClipboard(String data) throws Exception {
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection ss = new StringSelection(data);
        cb.setContents(ss, ss);
    }

    /*
     * Exception decompiling
     */
    public static boolean isOn(String option) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[6] lbl30 : CaseStatement: default:\u000a, @NONE, blocks:[6] lbl30 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String toString(Object[] objs, String sep) {
        return Joiner.on(sep).skipNulls().join(objs);
    }

    public static String toString(Object[] strings) {
        return Strings.toString(strings, ", ");
    }

    public static String repeat(char ch, int repeat) {
        char[] buf = new char[repeat];
        int i = repeat - 1;
        while (i >= 0) {
            buf[i] = ch;
            --i;
        }
        return new String(buf);
    }

    public static String repeat(String str, int repeat) {
        if (str == null) {
            return null;
        }
        if (repeat <= 0) {
            return EMPTY;
        }
        int inputLength = str.length();
        if (repeat == 1 || inputLength == 0) {
            return str;
        }
        if (inputLength == 1 && repeat <= 8192) {
            return Strings.repeat(str.charAt(0), repeat);
        }
        int outputLength = inputLength * repeat;
        switch (inputLength) {
            case 1: {
                return Strings.repeat(str.charAt(0), repeat);
            }
            case 2: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char[] output2 = new char[outputLength];
                int i = repeat * 2 - 2;
                while (i >= 0) {
                    output2[i] = ch0;
                    output2[i + 1] = ch1;
                    --i;
                    --i;
                }
                return new String(output2);
            }
        }
        StringBuilder buf = new StringBuilder(outputLength);
        int i = 0;
        while (i < repeat) {
            buf.append(str);
            ++i;
        }
        return buf.toString();
    }

    public static String toString(double data) {
        return Strings.toString(data, 4);
    }

    public static String toString(long data) {
        return intFormatter.format(data);
    }

    public static String toString(double[][] data) {
        int rows = data.length;
        StringBuilder sb = new StringBuilder();
        sb.append("Dimension: " + rows + " x " + data[0].length + "\n");
        int i = 0;
        while (i < rows) {
            sb.append("[");
            int j = 0;
            while (j < data[i].length) {
                sb.append((float)data[i][j]);
                if (j < data[i].length - 1) {
                    sb.append("\t");
                }
                ++j;
            }
            sb.append("]\n");
            ++i;
        }
        return sb.toString();
    }

    public static String toString(int[][] data) {
        int rows = data.length;
        StringBuilder sb = new StringBuilder();
        sb.append("Dimension: " + rows + " x " + data[0].length + "\n");
        int i = 0;
        while (i < rows) {
            sb.append("[");
            int j = 0;
            while (j < data[i].length) {
                sb.append(data[i][j]);
                if (j < data[i].length - 1) {
                    sb.append("\t");
                }
                ++j;
            }
            sb.append("]\n");
            ++i;
        }
        return sb.toString();
    }

    public static String toString(Number data, int bits) {
        double val = data.doubleValue();
        if (Maths.isInt(val)) {
            return String.valueOf((int)val);
        }
        String format = "%." + bits + "f";
        return String.format(format, val);
    }

    public static List<String> toList(String str, String reg) {
        Iterable<String> iter = Splitter.on(reg).omitEmptyStrings().trimResults().split(str);
        return Lists.newArrayList(iter);
    }

    public static String shortStr(String input) {
        return Strings.shortStr(input, 50);
    }

    public static String shortStr(String input, int len) {
        int begin = 0;
        if (input.length() > len) {
            begin = input.length() - len;
        }
        return input.substring(begin);
    }

    public static <T> String toString(Collection<T> ts) {
        if (ts instanceof Multiset) {
            StringBuilder sb = new StringBuilder();
            Multiset es = (Multiset)ts;
            for (Object e : es.elementSet()) {
                int count = es.count(e);
                sb.append(e + ", " + count + "\n");
            }
            return sb.toString();
        }
        return Strings.toString(ts, ",");
    }

    public static <T> String toString(Collection<T> ts, String sep) {
        return Joiner.on(sep).skipNulls().join(ts);
    }

    public static <T> String toString(Collection<T> ts, FileIO.Converter<T, String> lw) throws Exception {
        if (ts == null || ts.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int N = ts.size();
        int i = 0;
        for (T t : ts) {
            String line = lw != null ? lw.transform(t) : t.toString();
            sb.append(line);
            if (i++ >= N - 1) continue;
            sb.append(SEP);
        }
        return sb.toString();
    }

    public static <K, V> String toString(Map<K, V> map) {
        return Strings.toString(map, "\n");
    }

    public static <K, V> String toString(Map<K, V> map, String sep) {
        return Joiner.on(sep).withKeyValueSeparator(" -> ").join(map);
    }

    public static <K, V> String toString(Map<K, V> map, FileIO.MapWriter<K, V> mw) {
        StringBuilder sb = new StringBuilder();
        int size = map.size();
        int count = 0;
        for (Map.Entry<K, V> en : map.entrySet()) {
            K key = en.getKey();
            V val = en.getValue();
            String line = mw != null ? mw.processEntry(key, val) : key + " -> " + val;
            sb.append(line);
            if (count++ >= size - 1) continue;
            sb.append(SEP);
        }
        return sb.toString();
    }

    public static String toString(double[] data) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int i = 0;
        while (i < data.length) {
            sb.append(Strings.toString(data[i]));
            if (i < data.length - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public static String toString(int[] data) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int i = 0;
        while (i < data.length) {
            sb.append(data[i]);
            if (i < data.length - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public static String toSection(List<String> msgs) {
        StringBuilder sb = new StringBuilder();
        int repeat = 50;
        sb.append(" *\n");
        for (String msg : msgs) {
            sb.append(" * " + msg + "\n");
            if (msg.length() <= repeat) continue;
            repeat = msg.length();
        }
        sb.append(" *\n");
        String stars = Strings.repeat('*', repeat);
        String head = "\n/*" + stars + "\n";
        sb.insert(0, head);
        String tail = " *" + stars + "/";
        sb.append(tail);
        return sb.toString();
    }
}

