/*
 * Decompiled with CFR 0.152.
 */
package librec.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import librec.util.Lists;
import librec.util.Logs;
import librec.util.Maths;

public class Measures {
    public static <T> double AP(List<T> rankedList, List<T> groundTruth) {
        int hits = 0;
        double sum_precs = 0.0;
        int n = 0;
        int m = rankedList.size();
        while (n < m) {
            T item = rankedList.get(n);
            if (groundTruth.contains(item)) {
                sum_precs += (double)(++hits) / ((double)n + 1.0);
            }
            ++n;
        }
        if (hits > 0) {
            return sum_precs / (double)groundTruth.size();
        }
        return 0.0;
    }

    public static <T> Map<Integer, Double> PrecAt(List<T> rankedList, List<T> groundTruth, List<Integer> ns) {
        HashMap<Integer, Double> prec_at_n = new HashMap<Integer, Double>();
        for (int n : ns) {
            prec_at_n.put(n, Measures.PrecAt(rankedList, groundTruth, n));
        }
        return prec_at_n;
    }

    public static <T> double PrecAt(List<T> rankedList, List<T> groundTruth, int n) {
        return (double)Measures.HitsAt(rankedList, groundTruth, n) / ((double)n + 0.0);
    }

    public static <T> Map<Integer, Double> RecallAt(List<T> rankedList, List<T> groundTruth, List<Integer> ns) {
        HashMap<Integer, Double> recall_at_n = new HashMap<Integer, Double>();
        for (int n : ns) {
            recall_at_n.put(n, Measures.RecallAt(rankedList, groundTruth, n));
        }
        return recall_at_n;
    }

    public static <T> Double RecallAt(List<T> rankedList, List<T> groundTruth, int n) {
        return (double)Measures.HitsAt(rankedList, groundTruth, n) / ((double)groundTruth.size() + 0.0);
    }

    public static <T> int HitsAt(List<T> rankedList, List<T> groundTruth, int n) {
        int hits = 0;
        int i = 0;
        int k = rankedList.size();
        while (i < k) {
            T item = rankedList.get(i);
            if (groundTruth.contains(item)) {
                if (i >= n) break;
                ++hits;
            }
            ++i;
        }
        return hits;
    }

    public static <T> double nDCG(List<T> rankedList, List<T> groundTruth) {
        double dcg = 0.0;
        double idcg = Measures.IDCG(groundTruth.size());
        int i = 0;
        int n = rankedList.size();
        while (i < n) {
            T item_id = rankedList.get(i);
            if (groundTruth.contains(item_id)) {
                int rank = i + 1;
                dcg += 1.0 / Maths.log(rank + 1, 2);
            }
            ++i;
        }
        return dcg / idcg;
    }

    public static double IDCG(int n) {
        double idcg = 0.0;
        int i = 0;
        while (i < n) {
            idcg += 1.0 / Maths.log(i + 2, 2);
            ++i;
        }
        return idcg;
    }

    public static <T> double RR(List<T> rankedList, List<T> groundTruth) {
        int i = 0;
        int n = rankedList.size();
        while (i < n) {
            T item = rankedList.get(i);
            if (groundTruth.contains(item)) {
                return 1.0 / ((double)i + 1.0);
            }
            ++i;
        }
        return 0.0;
    }

    public static <T> double AUC(List<T> rankedList, List<T> groundTruth, int num_dropped_items) {
        int num_rele_items = Lists.overlapSize(groundTruth, rankedList);
        int num_eval_items = rankedList.size() + num_dropped_items;
        int num_eval_pairs = (num_eval_items - num_rele_items) * num_rele_items;
        if (num_eval_pairs < 0) {
            Logs.error("num_eval_pairs cannot be less than 0");
            System.exit(-1);
        }
        if (num_eval_pairs == 0) {
            return 0.5;
        }
        int num_correct_pairs = 0;
        int hits = 0;
        for (T item_id : rankedList) {
            if (!groundTruth.contains(item_id)) {
                num_correct_pairs += hits;
                continue;
            }
            ++hits;
        }
        int num_miss_items = Lists.exceptSize(groundTruth, rankedList);
        return ((double)(num_correct_pairs += hits * (num_dropped_items - num_miss_items)) + 0.0) / (double)num_eval_pairs;
    }

    public static double ASYMMLoss(double rate, double pred, double minRate, double maxRate) {
        double med = (minRate + maxRate) / 2.0;
        double loss = 0.0;
        loss = rate <= med && pred <= med ? 0.0 : (rate > med && pred <= med ? rate - pred : (rate <= med && pred > med ? (pred - rate) * (1.0 + (med - rate + 1.0) * 0.5) : 0.0));
        return loss;
    }
}

