/*
 * Decompiled with CFR 0.152.
 */
package librec.rating;

import com.google.common.collect.HashBasedTable;
import librec.data.AddConfiguration;
import librec.data.DenseMatrix;
import librec.data.DenseVector;
import librec.data.MatrixEntry;
import librec.data.SparseMatrix;
import librec.intf.GraphicRecommender;
import librec.util.Gamma;
import librec.util.Logs;
import librec.util.Strings;

@AddConfiguration(before="factors, alpha, beta")
public class URP
extends GraphicRecommender {
    private double preRMSE;
    private int[][][] Nkir;
    private double[][][] PkirSum;
    protected double[][][] Pkir;

    public URP(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) {
        super(trainMatrix, testMatrix, fold);
    }

    @Override
    protected void initModel() throws Exception {
        this.PukSum = new DenseMatrix(numUsers, numFactors);
        this.PkirSum = new double[numFactors][numItems][numLevels];
        this.Nuk = new DenseMatrix(numUsers, numFactors);
        this.Nu = new DenseVector(numUsers);
        this.Nkir = new int[numFactors][numItems][numLevels];
        this.Nki = new DenseMatrix(numFactors, numItems);
        this.alpha = new DenseVector(numFactors);
        this.alpha.setAll(initAlpha);
        this.beta = new DenseVector(numLevels);
        this.beta.setAll(initBeta);
        this.z = HashBasedTable.create();
        for (MatrixEntry me : this.trainMatrix) {
            int u = me.row();
            int i = me.column();
            double rui = me.get();
            int r = ratingScale.indexOf(rui);
            int t = (int)(Math.random() * (double)numFactors);
            this.z.put(u, i, t);
            this.Nuk.add(u, t, 1.0);
            this.Nu.add(u, 1.0);
            int[] nArray = this.Nkir[t][i];
            int n = r;
            nArray[n] = nArray[n] + 1;
            this.Nki.add(t, i, 1.0);
        }
    }

    @Override
    protected void eStep() {
        double sumAlpha = this.alpha.sum();
        double sumBeta = this.beta.sum();
        for (MatrixEntry me : this.trainMatrix) {
            int u = me.row();
            int i = me.column();
            double rui = me.get();
            int r = (int)(rui / minRate - 1.0);
            int t = (Integer)this.z.get(u, i);
            this.Nuk.add(u, t, -1.0);
            this.Nu.add(u, -1.0);
            int[] nArray = this.Nkir[t][i];
            int n = r;
            nArray[n] = nArray[n] - 1;
            this.Nki.add(t, i, -1.0);
            double[] p = new double[numFactors];
            int k = 0;
            while (k < numFactors) {
                p[k] = (this.Nuk.get(u, k) + this.alpha.get(k)) / (this.Nu.get(u) + sumAlpha) * ((double)this.Nkir[k][i][r] + this.beta.get(r)) / (this.Nki.get(k, i) + sumBeta);
                ++k;
            }
            k = 1;
            while (k < p.length) {
                int n2 = k;
                p[n2] = p[n2] + p[k - 1];
                ++k;
            }
            double rand = Math.random() * p[numFactors - 1];
            t = 0;
            while (t < p.length) {
                if (rand < p[t]) break;
                ++t;
            }
            this.z.put(u, i, t);
            this.Nuk.add(u, t, 1.0);
            this.Nu.add(u, 1.0);
            int[] nArray2 = this.Nkir[t][i];
            int n3 = r;
            nArray2[n3] = nArray2[n3] + 1;
            this.Nki.add(t, i, 1.0);
        }
    }

    @Override
    protected void mStep() {
        double denominator;
        double numerator;
        double sumAlpha = this.alpha.sum();
        double sumBeta = this.beta.sum();
        int k = 0;
        while (k < numFactors) {
            double ak = this.alpha.get(k);
            numerator = 0.0;
            denominator = 0.0;
            int u = 0;
            while (u < numUsers) {
                numerator += Gamma.digamma(this.Nuk.get(u, k) + ak) - Gamma.digamma(ak);
                denominator += Gamma.digamma(this.Nu.get(u) + sumAlpha) - Gamma.digamma(sumAlpha);
                ++u;
            }
            if (numerator != 0.0) {
                this.alpha.set(k, ak * (numerator / denominator));
            }
            ++k;
        }
        int r = 0;
        while (r < numLevels) {
            double br = this.beta.get(r);
            numerator = 0.0;
            denominator = 0.0;
            int i = 0;
            while (i < numItems) {
                int k2 = 0;
                while (k2 < numFactors) {
                    numerator += Gamma.digamma((double)this.Nkir[k2][i][r] + br) - Gamma.digamma(br);
                    denominator += Gamma.digamma(this.Nki.get(k2, i) + sumBeta) - Gamma.digamma(sumBeta);
                    ++k2;
                }
                ++i;
            }
            if (numerator != 0.0) {
                this.beta.set(r, br * (numerator / denominator));
            }
            ++r;
        }
    }

    @Override
    protected void readoutParams() {
        double val = 0.0;
        double sumAlpha = this.alpha.sum();
        int u = 0;
        while (u < numUsers) {
            int k = 0;
            while (k < numFactors) {
                val = (this.Nuk.get(u, k) + this.alpha.get(k)) / (this.Nu.get(u) + sumAlpha);
                this.PukSum.add(u, k, val);
                ++k;
            }
            ++u;
        }
        double sumBeta = this.beta.sum();
        int k = 0;
        while (k < numFactors) {
            int i = 0;
            while (i < numItems) {
                int r = 0;
                while (r < numLevels) {
                    val = ((double)this.Nkir[k][i][r] + this.beta.get(r)) / (this.Nki.get(k, i) + sumBeta);
                    double[] dArray = this.PkirSum[k][i];
                    int n = r++;
                    dArray[n] = dArray[n] + val;
                }
                ++i;
            }
            ++k;
        }
        ++this.numStats;
    }

    @Override
    protected void estimateParams() {
        this.Puk = this.PukSum.scale(1.0 / (double)this.numStats);
        this.Pkir = new double[numFactors][numItems][numLevels];
        int k = 0;
        while (k < numFactors) {
            int i = 0;
            while (i < numItems) {
                int r = 0;
                while (r < numLevels) {
                    this.Pkir[k][i][r] = this.PkirSum[k][i][r] / (double)this.numStats;
                    ++r;
                }
                ++i;
            }
            ++k;
        }
    }

    @Override
    protected boolean isConverged(int iter) throws Exception {
        if (this.validationMatrix == null) {
            return false;
        }
        this.estimateParams();
        int numCount = 0;
        double sum = 0.0;
        for (MatrixEntry me : this.validationMatrix) {
            int j;
            double rate = me.get();
            int u = me.row();
            double pred = this.predict(u, j = me.column(), true);
            if (Double.isNaN(pred)) continue;
            double err = rate - pred;
            sum += err * err;
            ++numCount;
        }
        double RMSE = Math.sqrt(sum / (double)numCount);
        double delta = RMSE - this.preRMSE;
        if (verbose) {
            Logs.debug("{}{} iter {} achieves RMSE = {}, delta_RMSE = {}", this.algoName, this.foldInfo, iter, Float.valueOf((float)RMSE), Float.valueOf((float)delta));
        }
        if (this.numStats > 1 && delta > 0.0) {
            return true;
        }
        this.preRMSE = RMSE;
        return false;
    }

    @Override
    protected double predict(int u, int i) throws Exception {
        double pred = 0.0;
        int r = 0;
        while (r < numLevels) {
            double rate = (Double)ratingScale.get(r);
            double prob = 0.0;
            int k = 0;
            while (k < numFactors) {
                prob += this.Puk.get(u, k) * this.Pkir[k][i][r];
                ++k;
            }
            pred += prob * rate;
            ++r;
        }
        return pred;
    }

    @Override
    public String toString() {
        return String.valueOf(Strings.toString(new Object[]{numFactors, this.alpha, this.beta})) + ", " + super.toString();
    }
}

