/*
 * Decompiled with CFR 0.152.
 */
package librec.rating;

import librec.data.DenseMatrix;
import librec.data.SparseMatrix;
import librec.data.SparseVector;
import librec.data.VectorEntry;
import librec.intf.SocialRecommender;
import librec.util.Strings;

public class RSTE
extends SocialRecommender {
    private float alpha;

    public RSTE(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) {
        super(trainMatrix, testMatrix, fold);
        this.initByNorm = false;
        this.alpha = algoOptions.getFloat("-alpha");
    }

    @Override
    protected void buildModel() throws Exception {
        int iter = 1;
        while (iter <= numIters) {
            double sum;
            double pred1;
            this.loss = 0.0;
            DenseMatrix PS = new DenseMatrix(numUsers, numFactors);
            DenseMatrix QS = new DenseMatrix(numItems, numFactors);
            for (int u : this.trainMatrix.rows()) {
                SparseVector tu = socialMatrix.row(u);
                int[] tks = tu.getIndex();
                double ws = 0.0;
                int[] nArray = tks;
                int n = tks.length;
                int n2 = 0;
                while (n2 < n) {
                    int k = nArray[n2];
                    ws += tu.get(k);
                    ++n2;
                }
                double[] sum_us = new double[numFactors];
                int f = 0;
                while (f < numFactors) {
                    int[] nArray2 = tks;
                    int n3 = tks.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int k = nArray2[n4];
                        int n5 = f;
                        sum_us[n5] = sum_us[n5] + tu.get(k) * this.P.get(k, f);
                        ++n4;
                    }
                    ++f;
                }
                for (VectorEntry ve : this.trainMatrix.row(u)) {
                    int j = ve.index();
                    double rate = ve.get();
                    double ruj = this.normalize(rate);
                    pred1 = DenseMatrix.rowMult(this.P, u, this.Q, j);
                    sum = 0.0;
                    int[] nArray3 = tks;
                    int n6 = tks.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        int k = nArray3[n7];
                        sum += tu.get(k) * DenseMatrix.rowMult(this.P, k, this.Q, j);
                        ++n7;
                    }
                    double pred2 = ws > 0.0 ? sum / ws : 0.0;
                    double pred = (double)this.alpha * pred1 + (double)(1.0f - this.alpha) * pred2;
                    double euj = this.g(pred) - ruj;
                    this.loss += euj * euj;
                    double csgd = this.gd(pred) * euj;
                    int f2 = 0;
                    while (f2 < numFactors) {
                        double puf = this.P.get(u, f2);
                        double qjf = this.Q.get(j, f2);
                        double usgd = (double)this.alpha * csgd * qjf + (double)regU * puf;
                        double jd = ws > 0.0 ? sum_us[f2] / ws : 0.0;
                        double jsgd = csgd * ((double)this.alpha * puf + (double)(1.0f - this.alpha) * jd) + (double)regI * qjf;
                        PS.add(u, f2, usgd);
                        QS.add(j, f2, jsgd);
                        this.loss += (double)regU * puf * puf + (double)regI * qjf * qjf;
                        ++f2;
                    }
                }
            }
            for (int u : socialMatrix.columns()) {
                SparseVector bu = socialMatrix.column(u);
                int[] nArray = bu.getIndex();
                int n = nArray.length;
                int n8 = 0;
                while (n8 < n) {
                    int p = nArray[n8];
                    if (p < this.trainMatrix.numRows()) {
                        SparseVector pp = this.trainMatrix.row(p);
                        SparseVector tp = socialMatrix.row(p);
                        int[] tps = tp.getIndex();
                        int[] nArray4 = pp.getIndex();
                        int n9 = nArray4.length;
                        int n10 = 0;
                        while (n10 < n9) {
                            int j = nArray4[n10];
                            pred1 = DenseMatrix.rowMult(this.P, p, this.Q, j);
                            sum = 0.0;
                            double ws = 0.0;
                            int[] nArray5 = tps;
                            int euj = tps.length;
                            int n11 = 0;
                            while (n11 < euj) {
                                int k = nArray5[n11];
                                double tuk = tp.get(k);
                                sum += tuk * DenseMatrix.rowMult(this.P, k, this.Q, j);
                                ws += tuk;
                                ++n11;
                            }
                            double pred2 = ws > 0.0 ? sum / ws : 0.0;
                            double pred = (double)this.alpha * pred1 + (double)(1.0f - this.alpha) * pred2;
                            double epj = this.g(pred) - this.normalize(pp.get(j));
                            double csgd = this.gd(pred) * epj * bu.get(p);
                            int f = 0;
                            while (f < numFactors) {
                                PS.add(u, f, (double)(1.0f - this.alpha) * csgd * this.Q.get(j, f));
                                ++f;
                            }
                            ++n10;
                        }
                    }
                    ++n8;
                }
            }
            this.loss *= 0.5;
            this.P = this.P.add(PS.scale(-this.lRate));
            this.Q = this.Q.add(QS.scale(-this.lRate));
            if (this.isConverged(iter)) break;
            ++iter;
        }
    }

    @Override
    protected double predict(int u, int j, boolean bound) {
        double pred1 = DenseMatrix.rowMult(this.P, u, this.Q, j);
        double sum = 0.0;
        double ws = 0.0;
        SparseVector tu = socialMatrix.row(u);
        int[] nArray = tu.getIndex();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int k = nArray[n2];
            double tuk = tu.get(k);
            sum += tuk * DenseMatrix.rowMult(this.P, k, this.Q, j);
            ws += tuk;
            ++n2;
        }
        double pred2 = ws > 0.0 ? sum / ws : 0.0;
        double pred = (double)this.alpha * pred1 + (double)(1.0f - this.alpha) * pred2;
        if (bound) {
            return this.denormalize(this.g(pred));
        }
        return pred;
    }

    @Override
    public String toString() {
        return Strings.toString(new Object[]{Float.valueOf(initLRate), Float.valueOf(maxLRate), Float.valueOf(regU), Float.valueOf(regI), numFactors, numIters, isBoldDriver, Float.valueOf(this.alpha)}, ",");
    }
}

