/*
 * Decompiled with CFR 0.152.
 */
package librec.rating;

import librec.data.MatrixEntry;
import librec.data.SparseMatrix;
import librec.intf.IterativeRecommender;

public class PMF
extends IterativeRecommender {
    public PMF(SparseMatrix rm, SparseMatrix tm, int fold) {
        super(rm, tm, fold);
    }

    @Override
    protected void buildModel() throws Exception {
        int iter = 1;
        while (iter <= numIters) {
            this.loss = 0.0;
            for (MatrixEntry me : this.trainMatrix) {
                int u = me.row();
                int j = me.column();
                double ruj = me.get();
                double puj = this.predict(u, j, false);
                double euj = ruj - puj;
                this.loss += euj * euj;
                int f = 0;
                while (f < numFactors) {
                    double puf = this.P.get(u, f);
                    double qjf = this.Q.get(j, f);
                    this.P.add(u, f, this.lRate * (euj * qjf - (double)regU * puf));
                    this.Q.add(j, f, this.lRate * (euj * puf - (double)regI * qjf));
                    this.loss += (double)regU * puf * puf + (double)regI * qjf * qjf;
                    ++f;
                }
            }
            this.loss *= 0.5;
            if (this.isConverged(iter)) break;
            ++iter;
        }
    }
}

