/*
 * Decompiled with CFR 0.152.
 */
package librec.rating;

import librec.data.DenseMatrix;
import librec.data.DenseVector;
import librec.data.SparseMatrix;
import librec.data.TensorEntry;
import librec.intf.TensorRecommender;

public class CPTF
extends TensorRecommender {
    private DenseMatrix[] M;
    private DenseVector lambda;

    public CPTF(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) throws Exception {
        super(trainMatrix, testMatrix, fold);
    }

    @Override
    protected void initModel() throws Exception {
        this.M = new DenseMatrix[numDimensions];
        this.lambda = new DenseVector(numFactors);
        this.lambda.setAll(1.0);
        int d = 0;
        while (d < numDimensions) {
            this.M[d] = new DenseMatrix(dimensions[d], numFactors);
            this.M[d].init(smallValue);
            this.normalize(d);
            ++d;
        }
        this.lRate = 0.0;
    }

    private void normalize(int d) {
        int f = 0;
        while (f < numFactors) {
            double norm = 0.0;
            int r = 0;
            while (r < this.M[d].numRows()) {
                norm += Math.pow(this.M[d].get(r, f), 2.0);
                ++r;
            }
            norm = Math.sqrt(norm);
            this.lambda.set(f, this.lambda.get(f) * norm);
            r = 0;
            while (r < this.M[d].numRows()) {
                this.M[d].set(r, f, this.M[d].get(r, f) / norm);
                ++r;
            }
            ++f;
        }
    }

    @Override
    protected void buildModel() throws Exception {
        int iter = 1;
        while (iter < numIters) {
            this.lambda.setAll(1.0);
            int d = 0;
            while (d < numDimensions) {
                DenseMatrix V = new DenseMatrix(numFactors, numFactors);
                V.setAll(1.0);
                int dim = 0;
                while (dim < numDimensions) {
                    if (dim != d) {
                        V = DenseMatrix.hadamardProduct(V, this.M[dim].transMult());
                    }
                    ++dim;
                }
                V = V.pinv();
                SparseMatrix X = this.trainTensor.matricization(d);
                DenseMatrix A = null;
                int dim2 = numDimensions - 1;
                while (dim2 >= 0) {
                    if (dim2 != d) {
                        A = A == null ? this.M[dim2] : DenseMatrix.khatriRaoProduct(A, this.M[dim2]);
                    }
                    --dim2;
                }
                this.M[d] = DenseMatrix.mult(X, A).mult(V);
                this.normalize(d);
                ++d;
            }
            this.loss = 0.0;
            for (TensorEntry te : this.trainTensor) {
                int[] keys = te.keys();
                double rate = te.get();
                double pred = this.predict(keys);
                double e = pred - rate;
                this.loss += e * e;
            }
            this.loss *= 0.5;
            if (this.isConverged(iter)) break;
            ++iter;
        }
    }

    @Override
    protected double predict(int u, int j) throws Exception {
        int index = this.testTensor.getIndices(u, j).get(0);
        return this.predict(this.testTensor.keys(index));
    }

    private double predict(int[] keys) {
        double pred = 0.0;
        int f = 0;
        while (f < numFactors) {
            double prod = this.lambda.get(f);
            int d = 0;
            while (d < numDimensions) {
                prod *= this.M[d].get(keys[d], f);
                ++d;
            }
            pred += prod;
            ++f;
        }
        return pred;
    }
}

