/*
 * Decompiled with CFR 0.152.
 */
package librec.rating;

import librec.data.DenseMatrix;
import librec.data.DenseVector;
import librec.data.MatrixEntry;
import librec.data.SparseMatrix;
import librec.intf.IterativeRecommender;

public class BiasedMF
extends IterativeRecommender {
    public BiasedMF(SparseMatrix rm, SparseMatrix tm, int fold) {
        super(rm, tm, fold);
    }

    @Override
    protected void initModel() throws Exception {
        super.initModel();
        this.userBias = new DenseVector(numUsers);
        this.itemBias = new DenseVector(numItems);
        this.userBias.init(initMean, initStd);
        this.itemBias.init(initMean, initStd);
    }

    @Override
    protected void buildModel() throws Exception {
        int iter = 1;
        while (iter <= numIters) {
            this.loss = 0.0;
            for (MatrixEntry me : this.trainMatrix) {
                int u = me.row();
                int j = me.column();
                double ruj = me.get();
                double pred = this.predict(u, j, false);
                double euj = ruj - pred;
                this.loss += euj * euj;
                double bu = this.userBias.get(u);
                double sgd = euj - (double)regB * bu;
                this.userBias.add(u, this.lRate * sgd);
                this.loss += (double)regB * bu * bu;
                double bj = this.itemBias.get(j);
                sgd = euj - (double)regB * bj;
                this.itemBias.add(j, this.lRate * sgd);
                this.loss += (double)regB * bj * bj;
                int f = 0;
                while (f < numFactors) {
                    double puf = this.P.get(u, f);
                    double qjf = this.Q.get(j, f);
                    double delta_u = euj * qjf - (double)regU * puf;
                    double delta_j = euj * puf - (double)regI * qjf;
                    this.P.add(u, f, this.lRate * delta_u);
                    this.Q.add(j, f, this.lRate * delta_j);
                    this.loss += (double)regU * puf * puf + (double)regI * qjf * qjf;
                    ++f;
                }
            }
            this.loss *= 0.5;
            if (this.isConverged(iter)) break;
            ++iter;
        }
    }

    @Override
    protected double predict(int u, int j) throws Exception {
        return this.globalMean + this.userBias.get(u) + this.itemBias.get(j) + DenseMatrix.rowMult(this.P, u, this.Q, j);
    }
}

