/*
 * Decompiled with CFR 0.152.
 */
package librec.ranking;

import librec.data.SparseMatrix;
import librec.data.SparseVector;
import librec.intf.IterativeRecommender;
import librec.util.Randoms;
import librec.util.Strings;

public class BPR
extends IterativeRecommender {
    public BPR(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) {
        super(trainMatrix, testMatrix, fold);
        isRankingPred = true;
        this.initByNorm = false;
    }

    @Override
    protected void initModel() throws Exception {
        super.initModel();
        this.userCache = this.trainMatrix.rowCache(cacheSpec);
    }

    @Override
    protected void buildModel() throws Exception {
        int iter = 1;
        while (iter <= numIters) {
            this.loss = 0.0;
            int s = 0;
            int smax = numUsers * 100;
            while (s < smax) {
                SparseVector pu;
                int u = 0;
                int i = 0;
                int j = 0;
                while ((pu = (SparseVector)this.userCache.get(u = Randoms.uniform(numUsers))).getCount() == 0) {
                }
                int[] is = pu.getIndex();
                i = is[Randoms.uniform(is.length)];
                while (pu.contains(j = Randoms.uniform(numItems))) {
                }
                double xui = this.predict(u, i);
                double xuj = this.predict(u, j);
                double xuij = xui - xuj;
                double vals = -Math.log(this.g(xuij));
                this.loss += vals;
                double cmg = this.g(-xuij);
                int f = 0;
                while (f < numFactors) {
                    double puf = this.P.get(u, f);
                    double qif = this.Q.get(i, f);
                    double qjf = this.Q.get(j, f);
                    this.P.add(u, f, this.lRate * (cmg * (qif - qjf) - (double)regU * puf));
                    this.Q.add(i, f, this.lRate * (cmg * puf - (double)regI * qif));
                    this.Q.add(j, f, this.lRate * (cmg * -puf - (double)regI * qjf));
                    this.loss += (double)regU * puf * puf + (double)regI * qif * qif + (double)regI * qjf * qjf;
                    ++f;
                }
                ++s;
            }
            if (this.isConverged(iter)) break;
            ++iter;
        }
    }

    @Override
    public String toString() {
        return Strings.toString(new Object[]{Float.valueOf(binThold), numFactors, Float.valueOf(initLRate), Float.valueOf(maxLRate), Float.valueOf(regU), Float.valueOf(regI), numIters}, ",");
    }
}

