/*
 * Decompiled with CFR 0.152.
 */
package librec.main;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import librec.baseline.ConstantGuess;
import librec.baseline.GlobalAverage;
import librec.baseline.ItemAverage;
import librec.baseline.ItemCluster;
import librec.baseline.MostPopular;
import librec.baseline.RandomGuess;
import librec.baseline.UserAverage;
import librec.baseline.UserCluster;
import librec.data.DataDAO;
import librec.data.DataSplitter;
import librec.data.MatrixEntry;
import librec.data.SparseMatrix;
import librec.ext.AR;
import librec.ext.External;
import librec.ext.Hybrid;
import librec.ext.NMF;
import librec.ext.PD;
import librec.ext.PRankD;
import librec.ext.SlopeOne;
import librec.intf.GraphicRecommender;
import librec.intf.IterativeRecommender;
import librec.intf.Recommender;
import librec.ranking.BHfree;
import librec.ranking.BPR;
import librec.ranking.BUCM;
import librec.ranking.CLiMF;
import librec.ranking.FISMauc;
import librec.ranking.FISMrmse;
import librec.ranking.GBPR;
import librec.ranking.ItemBigram;
import librec.ranking.LDA;
import librec.ranking.LRMF;
import librec.ranking.RankALS;
import librec.ranking.RankSGD;
import librec.ranking.SBPR;
import librec.ranking.SLIM;
import librec.ranking.WBPR;
import librec.ranking.WRMF;
import librec.rating.BPMF;
import librec.rating.BiasedMF;
import librec.rating.CPTF;
import librec.rating.GPLSA;
import librec.rating.ItemKNN;
import librec.rating.LDCC;
import librec.rating.PMF;
import librec.rating.RSTE;
import librec.rating.RfRec;
import librec.rating.SVDPlusPlus;
import librec.rating.SoRec;
import librec.rating.SoReg;
import librec.rating.SocialMF;
import librec.rating.TimeSVD;
import librec.rating.TrustMF;
import librec.rating.TrustSVD;
import librec.rating.URP;
import librec.rating.UserKNN;
import librec.util.Dates;
import librec.util.EMailer;
import librec.util.FileConfiger;
import librec.util.FileIO;
import librec.util.LineConfiger;
import librec.util.Logs;
import librec.util.Randoms;
import librec.util.Strings;
import librec.util.Systems;

public class LibRec {
    protected static String version = "1.4";
    protected static String tempDirPath = "./Results/";
    protected FileConfiger cf;
    protected List<String> configFiles;
    protected String algorithm;
    protected float binThold;
    protected int[] columns;
    protected TimeUnit timeUnit;
    protected DataDAO rateDao;
    protected LineConfiger ratingOptions;
    protected LineConfiger outputOptions;
    protected SparseMatrix rateMatrix;
    protected SparseMatrix timeMatrix;

    protected void execute(String[] args) throws Exception {
        this.cmdLine(args);
        for (String config : this.configFiles) {
            this.preset(config);
            this.readData();
            this.run();
        }
        String filename = String.valueOf(this.configFiles.size() > 1 ? "multiAlgorithms" : this.algorithm) + "@" + Dates.now() + ".txt";
        String results = String.valueOf(tempDirPath) + filename;
        FileIO.copyFile("results.txt", results);
        this.notifyMe(results);
    }

    protected void readData() throws Exception {
        this.rateDao = new DataDAO(this.cf.getPath("dataset.ratings"));
        this.ratingOptions = this.cf.getParamOptions("ratings.setup");
        List<String> cols = this.ratingOptions.getOptions("-columns");
        this.columns = new int[cols.size()];
        int i = 0;
        while (i < cols.size()) {
            this.columns[i] = Integer.parseInt(cols.get(i));
            ++i;
        }
        this.rateDao.setHeadline(this.ratingOptions.contains("-headline"));
        this.binThold = this.ratingOptions.getFloat("-threshold");
        this.timeUnit = TimeUnit.valueOf(this.ratingOptions.getString("--time-unit", "seconds").toUpperCase());
        this.rateDao.setTimeUnit(this.timeUnit);
        SparseMatrix[] data = this.ratingOptions.contains("--as-tensor") ? this.rateDao.readTensor(this.columns, this.binThold) : this.rateDao.readData(this.columns, this.binThold);
        this.rateMatrix = data[0];
        this.timeMatrix = data[1];
        Recommender.rateMatrix = this.rateMatrix;
        Recommender.timeMatrix = this.timeMatrix;
        Recommender.rateDao = this.rateDao;
        Recommender.binThold = this.binThold;
    }

    protected void preset(String configFile) throws Exception {
        Recommender.cf = this.cf = new FileConfiger(configFile);
        Recommender.resetStatics = true;
        IterativeRecommender.resetStatics = true;
        GraphicRecommender.resetStatics = true;
        this.outputOptions = this.cf.getParamOptions("output.setup");
        if (this.outputOptions != null) {
            tempDirPath = this.outputOptions.getString("-dir", "./Results/");
        }
        Recommender.tempDirPath = FileIO.makeDirectory(tempDirPath);
        LineConfiger evalOptions = this.cf.getParamOptions("evaluation.setup");
        Randoms.seed(evalOptions.getLong("--rand-seed", System.currentTimeMillis()));
    }

    public static void main(String[] args) {
        try {
            new LibRec().execute(args);
        }
        catch (Exception e) {
            Logs.error(e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * Exception decompiling
     */
    protected void cmdLine(String[] args) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[5] lbl107 : CaseStatement: default:\u000a, @NONE, blocks:[5] lbl107 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void writeMatrix(SparseMatrix data, String filePath) throws Exception {
        FileIO.deleteFile(filePath);
        ArrayList<String> lines = new ArrayList<String>(1500);
        for (MatrixEntry me : data) {
            int u = me.row();
            int j = me.column();
            double ruj = me.get();
            if (ruj <= 0.0) continue;
            String user = this.rateDao.getUserId(u);
            String item = this.rateDao.getItemId(j);
            String timestamp = this.timeMatrix != null ? " " + this.timeMatrix.get(u, j) : "";
            lines.add(String.valueOf(user) + " " + item + " " + (float)ruj + timestamp);
            if (lines.size() < 1000) continue;
            FileIO.writeList(filePath, lines, true);
            lines.clear();
        }
        if (lines.size() > 0) {
            FileIO.writeList(filePath, lines, true);
        }
        Logs.debug("Matrix data is written to: {}", (Object)filePath);
    }

    protected void run() throws Exception {
        String setup = this.cf.getString("evaluation.setup");
        LineConfiger evalOptions = new LineConfiger(setup);
        Logs.info("With Setup: {}", (Object)setup);
        int numRepeats = evalOptions.getInt("--repeat", 1);
        int i = 0;
        while (i < numRepeats) {
            this.runAlgorithm(evalOptions);
            ++i;
        }
    }

    /*
     * Exception decompiling
     */
    private void runAlgorithm(LineConfiger evalOptions) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[19] lbl71 : CaseStatement: default:\u000a, @NONE, blocks:[19] lbl71 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void runCrossValidation(LineConfiger params) throws Exception {
        int n;
        Recommender algo2;
        int kFold = params.getInt("-k", 5);
        boolean isParallelFold = params.isOn("-p", true);
        DataSplitter ds = new DataSplitter(this.rateMatrix, kFold);
        Thread[] ts = new Thread[kFold];
        Recommender[] algos = new Recommender[kFold];
        int i = 0;
        while (i < kFold) {
            algos[i] = algo2 = this.getRecommender(ds.getKthFold(i + 1), i + 1);
            ts[i] = new Thread(algo2);
            ts[i].start();
            if (!isParallelFold) {
                ts[i].join();
            }
            ++i;
        }
        if (isParallelFold) {
            Thread[] threadArray = ts;
            n = ts.length;
            int algo2 = 0;
            while (algo2 < n) {
                Thread t = threadArray[algo2];
                t.join();
                ++algo2;
            }
        }
        HashMap<Recommender.Measure, Double> avgMeasure = new HashMap<Recommender.Measure, Double>();
        Recommender[] recommenderArray = algos;
        int n2 = algos.length;
        n = 0;
        while (n < n2) {
            algo2 = recommenderArray[n];
            for (Map.Entry<Recommender.Measure, Double> en : algo2.measures.entrySet()) {
                Recommender.Measure m = en.getKey();
                double val = avgMeasure.containsKey((Object)m) ? (Double)avgMeasure.get((Object)m) : 0.0;
                avgMeasure.put(m, val + en.getValue() / (double)kFold);
            }
            ++n;
        }
        this.printEvalInfo(algos[0], avgMeasure);
    }

    private void runLeaveOneOut(LineConfiger params) throws Exception {
        int numThreads = params.getInt("-t", Runtime.getRuntime().availableProcessors());
        Thread[] ts = new Thread[numThreads];
        Recommender[] algos = new Recommender[numThreads];
        HashMap<Recommender.Measure, Double> avgMeasure = new HashMap<Recommender.Measure, Double>();
        int rows = this.rateMatrix.numRows();
        int cols = this.rateMatrix.numColumns();
        int count = 0;
        for (MatrixEntry me : this.rateMatrix) {
            Recommender algo;
            double rui = me.get();
            if (rui <= 0.0) continue;
            int u = me.row();
            int i = me.column();
            SparseMatrix trainMatrix = new SparseMatrix(this.rateMatrix);
            trainMatrix.set(u, i, 0.0);
            SparseMatrix.reshape(trainMatrix);
            HashBasedTable<Integer, Integer, Double> dataTable = HashBasedTable.create();
            HashMultimap<Integer, Integer> colMap = HashMultimap.create();
            dataTable.put(u, i, rui);
            colMap.put(i, u);
            SparseMatrix testMatrix = new SparseMatrix(rows, cols, dataTable, colMap);
            algos[count] = algo = this.getRecommender(new SparseMatrix[]{trainMatrix, testMatrix}, count + 1);
            ts[count] = new Thread(algo);
            ts[count].start();
            if (numThreads == 1) {
                ts[count].join();
                for (Map.Entry<Recommender.Measure, Double> en : algo.measures.entrySet()) {
                    Recommender.Measure m = en.getKey();
                    double val = avgMeasure.containsKey((Object)m) ? (Double)avgMeasure.get((Object)m) : 0.0;
                    avgMeasure.put(m, val + en.getValue());
                }
            } else if (count < numThreads) {
                ++count;
            }
            if (count != numThreads) continue;
            Runnable[] runnableArray = ts;
            int n = ts.length;
            int n2 = 0;
            while (n2 < n) {
                Thread t = runnableArray[n2];
                t.join();
                ++n2;
            }
            count = 0;
            runnableArray = algos;
            n = algos.length;
            n2 = 0;
            while (n2 < n) {
                Runnable algo2 = runnableArray[n2];
                for (Map.Entry<Recommender.Measure, Double> en : ((Recommender)algo2).measures.entrySet()) {
                    Recommender.Measure m = en.getKey();
                    double val = avgMeasure.containsKey((Object)m) ? (Double)avgMeasure.get((Object)m) : 0.0;
                    avgMeasure.put(m, val + en.getValue());
                }
                ++n2;
            }
        }
        int size = this.rateMatrix.size();
        for (Map.Entry en : avgMeasure.entrySet()) {
            Recommender.Measure m = (Recommender.Measure)((Object)en.getKey());
            double val = (Double)en.getValue();
            avgMeasure.put(m, val / (double)size);
        }
        this.printEvalInfo(algos[0], avgMeasure);
    }

    private void printEvalInfo(Recommender algo, Map<Recommender.Measure, Double> ms) throws Exception {
        String result = Recommender.getEvalInfo(ms);
        String time = String.format("'%s','%s'", Dates.parse(ms.get((Object)Recommender.Measure.TrainTime).longValue()), Dates.parse(ms.get((Object)Recommender.Measure.TestTime).longValue()));
        StringBuilder sb = new StringBuilder();
        String config = algo.toString();
        sb.append(algo.algoName).append(",").append(result).append(",,");
        if (!config.isEmpty()) {
            sb.append(config).append(",");
        }
        sb.append(time).append("\n");
        String evalInfo = sb.toString();
        Logs.info(evalInfo);
        if (this.outputOptions.contains("--to-clipboard")) {
            Strings.toClipboard(evalInfo);
            Logs.debug("Results have been copied to clipboard!");
        }
        if (this.outputOptions.contains("--to-file")) {
            String filePath = this.outputOptions.getString("--to-file", String.valueOf(tempDirPath) + this.algorithm + ".txt");
            FileIO.writeString(filePath, evalInfo, true);
            Logs.debug("Results have been collected to file: {}", (Object)filePath);
        }
    }

    protected void notifyMe(String attachment) throws Exception {
        String hostInfo = String.valueOf(FileIO.getCurrentFolder()) + "." + this.algorithm + " [" + Systems.getIP() + "]";
        LineConfiger emailOptions = this.cf.getParamOptions("email.setup");
        if (emailOptions == null || !emailOptions.isMainOn()) {
            System.out.println("Program " + hostInfo + " has completed!");
            return;
        }
        EMailer notifier = new EMailer();
        Properties props = notifier.getProps();
        props.setProperty("mail.debug", "false");
        String port = emailOptions.getString("-port");
        props.setProperty("mail.smtp.host", emailOptions.getString("-host"));
        props.setProperty("mail.smtp.port", port);
        props.setProperty("mail.smtp.auth", emailOptions.getString("-auth"));
        props.put("mail.smtp.socketFactory.port", port);
        props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        String user = emailOptions.getString("-user");
        props.setProperty("mail.smtp.user", user);
        props.setProperty("mail.smtp.password", emailOptions.getString("-password"));
        props.setProperty("mail.from", user);
        props.setProperty("mail.to", emailOptions.getString("-to"));
        props.setProperty("mail.subject", hostInfo);
        props.setProperty("mail.text", "Program was completed @" + Dates.now());
        String msg = "Program [" + this.algorithm + "] has completed !";
        notifier.send(msg, attachment);
    }

    protected Recommender getRecommender(SparseMatrix[] data, int fold) throws Exception {
        this.algorithm = this.cf.getString("recommender");
        SparseMatrix trainMatrix = data[0];
        SparseMatrix testMatrix = data[1];
        this.writeData(trainMatrix, testMatrix, fold);
        switch (this.algorithm.toLowerCase()) {
            case "globalavg": {
                return new GlobalAverage(trainMatrix, testMatrix, fold);
            }
            case "useravg": {
                return new UserAverage(trainMatrix, testMatrix, fold);
            }
            case "itemavg": {
                return new ItemAverage(trainMatrix, testMatrix, fold);
            }
            case "usercluster": {
                return new UserCluster(trainMatrix, testMatrix, fold);
            }
            case "itemcluster": {
                return new ItemCluster(trainMatrix, testMatrix, fold);
            }
            case "random": {
                return new RandomGuess(trainMatrix, testMatrix, fold);
            }
            case "constant": {
                return new ConstantGuess(trainMatrix, testMatrix, fold);
            }
            case "mostpop": {
                return new MostPopular(trainMatrix, testMatrix, fold);
            }
            case "userknn": {
                return new UserKNN(trainMatrix, testMatrix, fold);
            }
            case "itemknn": {
                return new ItemKNN(trainMatrix, testMatrix, fold);
            }
            case "itembigram": {
                return new ItemBigram(trainMatrix, testMatrix, fold);
            }
            case "regsvd": {
                return new PMF(trainMatrix, testMatrix, fold);
            }
            case "rfrec": {
                return new RfRec(trainMatrix, testMatrix, fold);
            }
            case "biasedmf": {
                return new BiasedMF(trainMatrix, testMatrix, fold);
            }
            case "gplsa": {
                return new GPLSA(trainMatrix, testMatrix, fold);
            }
            case "svd++": {
                return new SVDPlusPlus(trainMatrix, testMatrix, fold);
            }
            case "timesvd++": {
                return new TimeSVD(trainMatrix, testMatrix, fold);
            }
            case "pmf": {
                return new PMF(trainMatrix, testMatrix, fold);
            }
            case "bpmf": {
                return new BPMF(trainMatrix, testMatrix, fold);
            }
            case "socialmf": {
                return new SocialMF(trainMatrix, testMatrix, fold);
            }
            case "trustmf": {
                return new TrustMF(trainMatrix, testMatrix, fold);
            }
            case "sorec": {
                return new SoRec(trainMatrix, testMatrix, fold);
            }
            case "soreg": {
                return new SoReg(trainMatrix, testMatrix, fold);
            }
            case "rste": {
                return new RSTE(trainMatrix, testMatrix, fold);
            }
            case "trustsvd": {
                return new TrustSVD(trainMatrix, testMatrix, fold);
            }
            case "urp": {
                return new URP(trainMatrix, testMatrix, fold);
            }
            case "ldcc": {
                return new LDCC(trainMatrix, testMatrix, fold);
            }
            case "cptf": {
                return new CPTF(trainMatrix, testMatrix, fold);
            }
            case "climf": {
                return new CLiMF(trainMatrix, testMatrix, fold);
            }
            case "fismrmse": {
                return new FISMrmse(trainMatrix, testMatrix, fold);
            }
            case "fismauc": 
            case "fism": {
                return new FISMauc(trainMatrix, testMatrix, fold);
            }
            case "lrmf": {
                return new LRMF(trainMatrix, testMatrix, fold);
            }
            case "rankals": {
                return new RankALS(trainMatrix, testMatrix, fold);
            }
            case "ranksgd": {
                return new RankSGD(trainMatrix, testMatrix, fold);
            }
            case "wrmf": {
                return new WRMF(trainMatrix, testMatrix, fold);
            }
            case "bpr": {
                return new BPR(trainMatrix, testMatrix, fold);
            }
            case "wbpr": {
                return new WBPR(trainMatrix, testMatrix, fold);
            }
            case "gbpr": {
                return new GBPR(trainMatrix, testMatrix, fold);
            }
            case "sbpr": {
                return new SBPR(trainMatrix, testMatrix, fold);
            }
            case "slim": {
                return new SLIM(trainMatrix, testMatrix, fold);
            }
            case "lda": {
                return new LDA(trainMatrix, testMatrix, fold);
            }
            case "nmf": {
                return new NMF(trainMatrix, testMatrix, fold);
            }
            case "hybrid": {
                return new Hybrid(trainMatrix, testMatrix, fold);
            }
            case "slopeone": {
                return new SlopeOne(trainMatrix, testMatrix, fold);
            }
            case "pd": {
                return new PD(trainMatrix, testMatrix, fold);
            }
            case "ar": {
                return new AR(trainMatrix, testMatrix, fold);
            }
            case "prankd": {
                return new PRankD(trainMatrix, testMatrix, fold);
            }
            case "external": {
                return new External(trainMatrix, testMatrix, fold);
            }
            case "bucm": {
                return new BUCM(trainMatrix, testMatrix, fold);
            }
            case "bhfree": {
                return new BHfree(trainMatrix, testMatrix, fold);
            }
        }
        throw new Exception("No recommender is specified!");
    }

    protected void writeData(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) {
        if (this.outputOptions != null && this.outputOptions.contains("--fold-data")) {
            String prefix = String.valueOf(this.rateDao.getDataDirectory()) + this.rateDao.getDataName();
            String suffix = String.valueOf(fold >= 0 ? "-" + fold : "") + ".txt";
            try {
                this.writeMatrix(trainMatrix, String.valueOf(prefix) + "-train" + suffix);
                this.writeMatrix(testMatrix, String.valueOf(prefix) + "-test" + suffix);
            }
            catch (Exception e) {
                Logs.error(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public void setConfigFiles(String ... configurations) {
        this.configFiles = Arrays.asList(configurations);
    }

    private void about() {
        String about = "\nLibRec version " + version + ", copyright (C) 2014-2015 Guibing Guo \n\n" + "LibRec is free software: you can redistribute it and/or modify \n" + "it under the terms of the GNU General Public License as published by \n" + "the Free Software Foundation, either version 3 of the License, \n" + "or (at your option) any later version. \n\n" + "LibRec is distributed in the hope that it will be useful, \n" + "but WITHOUT ANY WARRANTY; without even the implied warranty of \n" + "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the \n" + "GNU General Public License for more details. \n\n" + "You should have received a copy of the GNU General Public License \n" + "along with LibRec. If not, see <http://www.gnu.org/licenses/>.";
        System.out.println(about);
    }
}

