/*
 * Decompiled with CFR 0.152.
 */
package librec.ext;

import librec.data.DenseMatrix;
import librec.data.SparseMatrix;
import librec.data.SparseVector;
import librec.intf.Recommender;

public class SlopeOne
extends Recommender {
    private DenseMatrix devMatrix;
    private DenseMatrix cardMatrix;

    public SlopeOne(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) {
        super(trainMatrix, testMatrix, fold);
    }

    @Override
    protected void initModel() throws Exception {
        this.devMatrix = new DenseMatrix(numItems, numItems);
        this.cardMatrix = new DenseMatrix(numItems, numItems);
    }

    @Override
    protected void buildModel() throws Exception {
        int u = 0;
        while (u < numUsers) {
            int[] items;
            SparseVector uv = this.trainMatrix.row(u);
            int[] nArray = items = uv.getIndex();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                double rui = uv.get(i);
                int[] nArray2 = items;
                int n3 = items.length;
                int n4 = 0;
                while (n4 < n3) {
                    int j = nArray2[n4];
                    if (i != j) {
                        double ruj = uv.get(j);
                        this.devMatrix.add(i, j, rui - ruj);
                        this.cardMatrix.add(i, j, 1.0);
                    }
                    ++n4;
                }
                ++n2;
            }
            ++u;
        }
        int i = 0;
        while (i < numItems) {
            int j = 0;
            while (j < numItems) {
                double card = this.cardMatrix.get(i, j);
                if (card > 0.0) {
                    double sum = this.devMatrix.get(i, j);
                    this.devMatrix.set(i, j, sum / card);
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    protected double predict(int u, int j) {
        SparseVector uv = this.trainMatrix.row(u, j);
        double preds = 0.0;
        double cards = 0.0;
        int[] nArray = uv.getIndex();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            double card = this.cardMatrix.get(j, i);
            if (card > 0.0) {
                preds += (this.devMatrix.get(j, i) + uv.get(i)) * card;
                cards += card;
            }
            ++n2;
        }
        return cards > 0.0 ? preds / cards : this.globalMean;
    }
}

