/*
 * Decompiled with CFR 0.152.
 */
package librec.ext;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Map;
import librec.data.SparseMatrix;
import librec.data.SparseVector;
import librec.data.VectorEntry;
import librec.intf.Recommender;

public class AR
extends Recommender {
    private Table<Integer, Integer, Double> A;

    public AR(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) {
        super(trainMatrix, testMatrix, fold);
        isRankingPred = true;
    }

    @Override
    protected void initModel() throws Exception {
        super.initModel();
        this.A = HashBasedTable.create(numItems, numItems);
        this.userCache = this.trainMatrix.rowCache(cacheSpec);
    }

    @Override
    protected void buildModel() throws Exception {
        int x = 0;
        while (x < numItems) {
            SparseVector qx = this.trainMatrix.column(x);
            int total = qx.getCount();
            int y = 0;
            while (y < numItems) {
                int count = 0;
                for (VectorEntry ve : qx) {
                    int u = ve.index();
                    double ruy = this.trainMatrix.get(u, y);
                    if (!(ruy > 0.0)) continue;
                    ++count;
                }
                if (count > 0) {
                    double conf = ((double)count + 0.0) / (double)total;
                    this.A.put(x, y, conf);
                }
                ++y;
            }
            ++x;
        }
    }

    @Override
    protected double ranking(int u, int j) throws Exception {
        SparseVector pu = (SparseVector)this.userCache.get(u);
        double rank = 0.0;
        for (Map.Entry<Integer, Double> en : this.A.column(j).entrySet()) {
            int i = en.getKey();
            double support = en.getValue();
            rank += pu.get(i) * support;
        }
        return rank;
    }
}

