/*
 * Decompiled with CFR 0.152.
 */
package librec.data;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import librec.data.MatrixEntry;
import librec.data.RatingContext;
import librec.data.SparseMatrix;
import librec.data.SparseVector;
import librec.util.FileIO;
import librec.util.Lists;
import librec.util.Logs;
import librec.util.Randoms;
import librec.util.Sortor;

public class DataSplitter {
    private SparseMatrix rateMatrix;
    private SparseMatrix assignMatrix;
    private int numFold;

    public DataSplitter(SparseMatrix rateMatrix, int kfold) {
        this.rateMatrix = rateMatrix;
        this.splitFolds(kfold);
    }

    public DataSplitter(SparseMatrix rateMatrix) {
        this.rateMatrix = rateMatrix;
    }

    private void splitFolds(int kfold) {
        assert (kfold > 0);
        this.assignMatrix = new SparseMatrix(this.rateMatrix);
        int numRates = this.rateMatrix.getData().length;
        this.numFold = kfold > numRates ? numRates : kfold;
        double[] rdm = new double[numRates];
        int[] fold = new int[numRates];
        double indvCount = ((double)numRates + 0.0) / (double)this.numFold;
        int i = 0;
        while (i < numRates) {
            rdm[i] = Randoms.uniform();
            fold[i] = (int)((double)i / indvCount) + 1;
            ++i;
        }
        Sortor.quickSort(rdm, fold, 0, numRates - 1, true);
        int[] row_ptr = this.rateMatrix.getRowPointers();
        int[] col_idx = this.rateMatrix.getColumnIndices();
        int f = 0;
        int u = 0;
        int um = this.rateMatrix.numRows();
        while (u < um) {
            int idx = row_ptr[u];
            int end = row_ptr[u + 1];
            while (idx < end) {
                int j = col_idx[idx];
                this.assignMatrix.set(u, j, fold[f++]);
                ++idx;
            }
            ++u;
        }
    }

    public SparseMatrix[] getRatioByRating(double ratio) {
        assert (ratio > 0.0 && ratio < 1.0);
        SparseMatrix trainMatrix = new SparseMatrix(this.rateMatrix);
        SparseMatrix testMatrix = new SparseMatrix(this.rateMatrix);
        int u = 0;
        int um = this.rateMatrix.numRows();
        while (u < um) {
            SparseVector uv = this.rateMatrix.row(u);
            int[] nArray = uv.getIndex();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int j = nArray[n2];
                double rdm = Math.random();
                if (rdm < ratio) {
                    testMatrix.set(u, j, 0.0);
                } else {
                    trainMatrix.set(u, j, 0.0);
                }
                ++n2;
            }
            ++u;
        }
        SparseMatrix.reshape(trainMatrix);
        SparseMatrix.reshape(testMatrix);
        this.debugInfo(trainMatrix, testMatrix, -1);
        return new SparseMatrix[]{trainMatrix, testMatrix};
    }

    public SparseMatrix[] getRatioByRatingDate(double ratio, SparseMatrix timestamps) {
        int i;
        int u;
        assert (ratio > 0.0 && ratio < 1.0);
        ArrayList<RatingContext> rcs = new ArrayList<RatingContext>(timestamps.size());
        for (MatrixEntry me : this.rateMatrix) {
            u = me.row();
            i = me.column();
            long timestamp = (long)timestamps.get(u, i);
            rcs.add(new RatingContext(u, i, timestamp));
        }
        Collections.sort(rcs);
        SparseMatrix trainMatrix = new SparseMatrix(this.rateMatrix);
        SparseMatrix testMatrix = new SparseMatrix(this.rateMatrix);
        int trainSize = (int)((double)rcs.size() * ratio);
        i = 0;
        while (i < rcs.size()) {
            RatingContext rc = (RatingContext)rcs.get(i);
            u = rc.getUser();
            int j = rc.getItem();
            if (i < trainSize) {
                testMatrix.set(u, j, 0.0);
            } else {
                trainMatrix.set(u, j, 0.0);
            }
            ++i;
        }
        rcs = null;
        SparseMatrix.reshape(trainMatrix);
        SparseMatrix.reshape(testMatrix);
        this.debugInfo(trainMatrix, testMatrix, -1);
        return new SparseMatrix[]{trainMatrix, testMatrix};
    }

    public SparseMatrix[] getRatioByUserDate(double ratio, SparseMatrix timeMatrix) {
        assert (ratio > 0.0 && ratio < 1.0);
        SparseMatrix trainMatrix = new SparseMatrix(this.rateMatrix);
        SparseMatrix testMatrix = new SparseMatrix(this.rateMatrix);
        int user = 0;
        int um = this.rateMatrix.numRows;
        while (user < um) {
            List<Integer> unsortedItems = this.rateMatrix.getColumns(user);
            int size = unsortedItems.size();
            ArrayList<RatingContext> rcs = new ArrayList<RatingContext>(size);
            for (int item : unsortedItems) {
                rcs.add(new RatingContext(user, item, (long)timeMatrix.get(user, item)));
            }
            Collections.sort(rcs);
            int trainSize = (int)((double)rcs.size() * ratio);
            int i = 0;
            while (i < rcs.size()) {
                RatingContext rc = (RatingContext)rcs.get(i);
                int u = rc.getUser();
                int j = rc.getItem();
                if (i < trainSize) {
                    testMatrix.set(u, j, 0.0);
                } else {
                    trainMatrix.set(u, j, 0.0);
                }
                ++i;
            }
            ++user;
        }
        SparseMatrix.reshape(trainMatrix);
        SparseMatrix.reshape(testMatrix);
        this.debugInfo(trainMatrix, testMatrix, -1);
        return new SparseMatrix[]{trainMatrix, testMatrix};
    }

    public SparseMatrix[] getRatioByItemDate(double ratio, SparseMatrix timestamps) {
        assert (ratio > 0.0 && ratio < 1.0);
        SparseMatrix trainMatrix = new SparseMatrix(this.rateMatrix);
        SparseMatrix testMatrix = new SparseMatrix(this.rateMatrix);
        int item = 0;
        int im = this.rateMatrix.numColumns;
        while (item < im) {
            List<Integer> unsortedUsers = this.rateMatrix.getRows(item);
            int size = unsortedUsers.size();
            ArrayList<RatingContext> rcs = new ArrayList<RatingContext>(size);
            for (int user : unsortedUsers) {
                rcs.add(new RatingContext(user, item, (long)timestamps.get(user, item)));
            }
            Collections.sort(rcs);
            int trainSize = (int)((double)rcs.size() * ratio);
            int i = 0;
            while (i < rcs.size()) {
                RatingContext rc = (RatingContext)rcs.get(i);
                int u = rc.getUser();
                int j = rc.getItem();
                if (i < trainSize) {
                    testMatrix.set(u, j, 0.0);
                } else {
                    trainMatrix.set(u, j, 0.0);
                }
                ++i;
            }
            ++item;
        }
        SparseMatrix.reshape(trainMatrix);
        SparseMatrix.reshape(testMatrix);
        this.debugInfo(trainMatrix, testMatrix, -1);
        return new SparseMatrix[]{trainMatrix, testMatrix};
    }

    public SparseMatrix[] getRatio(double trainRatio, double validRatio) {
        assert (trainRatio > 0.0 && validRatio > 0.0 && trainRatio + validRatio < 1.0);
        SparseMatrix trainMatrix = new SparseMatrix(this.rateMatrix);
        SparseMatrix validMatrix = new SparseMatrix(this.rateMatrix);
        SparseMatrix testMatrix = new SparseMatrix(this.rateMatrix);
        double sum = trainRatio + validRatio;
        int u = 0;
        int um = this.rateMatrix.numRows();
        while (u < um) {
            SparseVector uv = this.rateMatrix.row(u);
            int[] nArray = uv.getIndex();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int j = nArray[n2];
                double rdm = Math.random();
                if (rdm < trainRatio) {
                    testMatrix.set(u, j, 0.0);
                    validMatrix.set(u, j, 0.0);
                } else if (rdm < sum) {
                    trainMatrix.set(u, j, 0.0);
                    testMatrix.set(u, j, 0.0);
                } else {
                    trainMatrix.set(u, j, 0.0);
                    validMatrix.set(u, j, 0.0);
                }
                ++n2;
            }
            ++u;
        }
        SparseMatrix.reshape(trainMatrix);
        SparseMatrix.reshape(validMatrix);
        SparseMatrix.reshape(testMatrix);
        return new SparseMatrix[]{trainMatrix, validMatrix, testMatrix};
    }

    public SparseMatrix[] getLOOByUser(boolean isByDate, SparseMatrix timestamps) throws Exception {
        SparseMatrix trainMatrix = new SparseMatrix(this.rateMatrix);
        HashBasedTable<Integer, Integer, Double> dataTable = HashBasedTable.create();
        HashMultimap<Integer, Integer> colMap = HashMultimap.create();
        int u = 0;
        int um = this.rateMatrix.numRows();
        while (u < um) {
            List<Integer> items = this.rateMatrix.getColumns(u);
            int i = -1;
            if (!isByDate) {
                int randIdx = (int)((double)items.size() * Math.random());
                i = items.get(randIdx);
            } else {
                ArrayList<RatingContext> rcs = new ArrayList<RatingContext>();
                for (int j : items) {
                    rcs.add(new RatingContext(u, j, (long)timestamps.get(u, j)));
                }
                Collections.sort(rcs);
                i = ((RatingContext)rcs.get(rcs.size() - 1)).getItem();
            }
            trainMatrix.set(u, i, 0.0);
            dataTable.put(u, i, this.rateMatrix.get(u, i));
            colMap.put(i, u);
            ++u;
        }
        SparseMatrix.reshape(trainMatrix);
        SparseMatrix testMatrix = new SparseMatrix(this.rateMatrix.numRows, this.rateMatrix.numColumns, dataTable, colMap);
        this.debugInfo(trainMatrix, testMatrix, -1);
        return new SparseMatrix[]{trainMatrix, testMatrix};
    }

    public SparseMatrix[] getLOOByItem(boolean isByDate, SparseMatrix timestamps) throws Exception {
        SparseMatrix trainMatrix = new SparseMatrix(this.rateMatrix);
        HashBasedTable<Integer, Integer, Double> dataTable = HashBasedTable.create();
        HashMultimap<Integer, Integer> colMap = HashMultimap.create();
        int i = 0;
        int im = this.rateMatrix.numColumns();
        while (i < im) {
            List<Integer> users = this.rateMatrix.getRows(i);
            int u = -1;
            if (!isByDate) {
                int randIdx = (int)((double)users.size() * Math.random());
                u = users.get(randIdx);
            } else {
                ArrayList<RatingContext> rcs = new ArrayList<RatingContext>();
                for (int v : users) {
                    rcs.add(new RatingContext(v, i, (long)timestamps.get(v, i)));
                }
                Collections.sort(rcs);
                u = ((RatingContext)rcs.get(rcs.size() - 1)).getUser();
            }
            trainMatrix.set(u, i, 0.0);
            dataTable.put(u, i, this.rateMatrix.get(u, i));
            colMap.put(i, u);
            ++i;
        }
        SparseMatrix.reshape(trainMatrix);
        SparseMatrix testMatrix = new SparseMatrix(this.rateMatrix.numRows, this.rateMatrix.numColumns, dataTable, colMap);
        this.debugInfo(trainMatrix, testMatrix, -1);
        return new SparseMatrix[]{trainMatrix, testMatrix};
    }

    public SparseMatrix[] getGivenNByUser(int numGiven) throws Exception {
        assert (numGiven > 0);
        SparseMatrix trainMatrix = new SparseMatrix(this.rateMatrix);
        SparseMatrix testMatrix = new SparseMatrix(this.rateMatrix);
        int u = 0;
        int um = this.rateMatrix.numRows();
        while (u < um) {
            List<Integer> items = this.rateMatrix.getColumns(u);
            int numRated = items.size();
            if (numRated > numGiven) {
                int[] givenIndex = Randoms.nextIntArray(numGiven, numRated);
                int i = 0;
                int j = 0;
                while (j < numRated) {
                    if (i < givenIndex.length && givenIndex[i] == j) {
                        testMatrix.set(u, items.get(j), 0.0);
                        ++i;
                    } else {
                        trainMatrix.set(u, items.get(j), 0.0);
                    }
                    ++j;
                }
            } else {
                for (int j : items) {
                    testMatrix.set(u, j, 0.0);
                }
            }
            ++u;
        }
        SparseMatrix.reshape(trainMatrix);
        SparseMatrix.reshape(testMatrix);
        this.debugInfo(trainMatrix, testMatrix, -1);
        return new SparseMatrix[]{trainMatrix, testMatrix};
    }

    public SparseMatrix[] getGivenNByUserDate(int numGiven, SparseMatrix timestamps) throws Exception {
        assert (numGiven > 0);
        SparseMatrix trainMatrix = new SparseMatrix(this.rateMatrix);
        SparseMatrix testMatrix = new SparseMatrix(this.rateMatrix);
        int u = 0;
        int um = this.rateMatrix.numRows();
        while (u < um) {
            List<Integer> items = this.rateMatrix.getColumns(u);
            int capacity = Lists.initSize(items.size());
            ArrayList<RatingContext> rcs = new ArrayList<RatingContext>(capacity);
            for (int j : items) {
                rcs.add(new RatingContext(u, j, (long)timestamps.get(u, j)));
            }
            Collections.sort(rcs);
            int i = 0;
            while (i < rcs.size()) {
                RatingContext rc = (RatingContext)rcs.get(i);
                int j = rc.getItem();
                if (i < numGiven) {
                    testMatrix.set(u, j, 0.0);
                } else {
                    trainMatrix.set(u, j, 0.0);
                }
                ++i;
            }
            ++u;
        }
        SparseMatrix.reshape(trainMatrix);
        SparseMatrix.reshape(testMatrix);
        this.debugInfo(trainMatrix, testMatrix, -1);
        return new SparseMatrix[]{trainMatrix, testMatrix};
    }

    public SparseMatrix[] getGivenNByItemDate(int numGiven, SparseMatrix timestamps) throws Exception {
        assert (numGiven > 0);
        SparseMatrix trainMatrix = new SparseMatrix(this.rateMatrix);
        SparseMatrix testMatrix = new SparseMatrix(this.rateMatrix);
        int j = 0;
        int jm = this.rateMatrix.numRows();
        while (j < jm) {
            List<Integer> users = this.rateMatrix.getRows(j);
            int capacity = Lists.initSize(users.size());
            ArrayList<RatingContext> rcs = new ArrayList<RatingContext>(capacity);
            for (int u : users) {
                rcs.add(new RatingContext(u, j, (long)timestamps.get(u, j)));
            }
            Collections.sort(rcs);
            int i = 0;
            while (i < rcs.size()) {
                RatingContext rc = (RatingContext)rcs.get(i);
                int u = rc.getUser();
                if (i < numGiven) {
                    testMatrix.set(u, j, 0.0);
                } else {
                    trainMatrix.set(u, j, 0.0);
                }
                ++i;
            }
            ++j;
        }
        SparseMatrix.reshape(trainMatrix);
        SparseMatrix.reshape(testMatrix);
        this.debugInfo(trainMatrix, testMatrix, -1);
        return new SparseMatrix[]{trainMatrix, testMatrix};
    }

    public SparseMatrix[] getGivenNByItem(int numGiven) throws Exception {
        assert (numGiven > 0);
        SparseMatrix trainMatrix = new SparseMatrix(this.rateMatrix);
        SparseMatrix testMatrix = new SparseMatrix(this.rateMatrix);
        int j = 0;
        int jm = this.rateMatrix.numColumns();
        while (j < jm) {
            List<Integer> users = this.rateMatrix.getRows(j);
            int numRated = users.size();
            if (numRated > numGiven) {
                int[] givenIndex = Randoms.nextIntArray(numGiven, numRated);
                int i = 0;
                int k = 0;
                while (k < numRated) {
                    if (i < givenIndex.length && givenIndex[i] == k) {
                        testMatrix.set(users.get(k), j, 0.0);
                        ++i;
                    } else {
                        trainMatrix.set(users.get(k), j, 0.0);
                    }
                    ++k;
                }
            } else {
                for (int u : users) {
                    testMatrix.set(u, j, 0.0);
                }
            }
            ++j;
        }
        SparseMatrix.reshape(trainMatrix);
        SparseMatrix.reshape(testMatrix);
        this.debugInfo(trainMatrix, testMatrix, -1);
        return new SparseMatrix[]{trainMatrix, testMatrix};
    }

    public SparseMatrix[] getRatioByUser(double ratio) throws Exception {
        assert (ratio > 0.0 && ratio < 1.0);
        SparseMatrix trainMatrix = new SparseMatrix(this.rateMatrix);
        SparseMatrix testMatrix = new SparseMatrix(this.rateMatrix);
        int u = 0;
        int um = this.rateMatrix.numRows();
        while (u < um) {
            List<Integer> items = this.rateMatrix.getColumns(u);
            for (int j : items) {
                double rand = Math.random();
                if (rand < ratio) {
                    testMatrix.set(u, j, 0.0);
                    continue;
                }
                trainMatrix.set(u, j, 0.0);
            }
            ++u;
        }
        SparseMatrix.reshape(trainMatrix);
        SparseMatrix.reshape(testMatrix);
        this.debugInfo(trainMatrix, testMatrix, -1);
        return new SparseMatrix[]{trainMatrix, testMatrix};
    }

    public SparseMatrix[] getRatioByItem(double ratio) throws Exception {
        assert (ratio > 0.0 && ratio < 1.0);
        SparseMatrix trainMatrix = new SparseMatrix(this.rateMatrix);
        SparseMatrix testMatrix = new SparseMatrix(this.rateMatrix);
        int i = 0;
        int im = this.rateMatrix.numColumns();
        while (i < im) {
            List<Integer> users = this.rateMatrix.getRows(i);
            for (int u : users) {
                double rand = Math.random();
                if (rand < ratio) {
                    testMatrix.set(u, i, 0.0);
                    continue;
                }
                trainMatrix.set(u, i, 0.0);
            }
            ++i;
        }
        SparseMatrix.reshape(trainMatrix);
        SparseMatrix.reshape(testMatrix);
        this.debugInfo(trainMatrix, testMatrix, -1);
        return new SparseMatrix[]{trainMatrix, testMatrix};
    }

    public void getSample(int numUsers, int numItems) throws Exception {
        int rows = this.rateMatrix.numRows();
        int cols = this.rateMatrix.numColumns();
        int users = numUsers <= 0 || numUsers > rows ? rows : numUsers;
        int items = numItems <= 0 || numItems > cols ? cols : numItems;
        int[] userIds = Randoms.nextIntArray(users, rows);
        int[] itemIds = Randoms.nextIntArray(items, cols);
        String path = String.valueOf(FileIO.desktop) + "sample.txt";
        FileIO.deleteFile(path);
        ArrayList<String> lines = new ArrayList<String>(2000);
        int cnt = 0;
        int[] nArray = userIds;
        int n = userIds.length;
        int n2 = 0;
        while (n2 < n) {
            int userId = nArray[n2];
            int[] nArray2 = itemIds;
            int n3 = itemIds.length;
            int n4 = 0;
            while (n4 < n3) {
                int itemId = nArray2[n4];
                double rate = this.rateMatrix.get(userId, itemId);
                if (rate > 0.0) {
                    lines.add(String.valueOf(userId + 1) + " " + (itemId + 1) + " " + (float)rate);
                    ++cnt;
                    if (lines.size() >= 1500) {
                        FileIO.writeList(path, lines, null, true);
                        lines.clear();
                    }
                }
                ++n4;
            }
            ++n2;
        }
        if (lines.size() > 0) {
            FileIO.writeList(path, lines, null, true);
        }
        Logs.debug("Sample [size: {}] has been created!", (Object)cnt);
    }

    public SparseMatrix[] getDataView(String view) {
        SparseMatrix trainMatrix = new SparseMatrix(this.rateMatrix);
        SparseMatrix testMatrix = new SparseMatrix(this.rateMatrix);
        switch (view.toLowerCase()) {
            case "cold-start": {
                int u = 0;
                int um = this.rateMatrix.numRows;
                while (u < um) {
                    int i;
                    int n;
                    int n2;
                    int[] nArray;
                    SparseVector uv = this.rateMatrix.row(u);
                    if (uv.getCount() < 5) {
                        nArray = uv.getIndex();
                        n2 = nArray.length;
                        n = 0;
                        while (n < n2) {
                            i = nArray[n];
                            trainMatrix.set(u, i, 0.0);
                            ++n;
                        }
                    } else {
                        nArray = uv.getIndex();
                        n2 = nArray.length;
                        n = 0;
                        while (n < n2) {
                            i = nArray[n];
                            testMatrix.set(u, i, 0.0);
                            ++n;
                        }
                    }
                    ++u;
                }
                break;
            }
            default: {
                return null;
            }
        }
        SparseMatrix.reshape(trainMatrix);
        SparseMatrix.reshape(testMatrix);
        return new SparseMatrix[]{trainMatrix, testMatrix};
    }

    public SparseMatrix[] getKthFold(int k) {
        if (k > this.numFold || k < 1) {
            return null;
        }
        SparseMatrix trainMatrix = new SparseMatrix(this.rateMatrix);
        SparseMatrix testMatrix = new SparseMatrix(this.rateMatrix);
        int u = 0;
        int um = this.rateMatrix.numRows();
        while (u < um) {
            SparseVector items = this.rateMatrix.row(u);
            int[] nArray = items.getIndex();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int j = nArray[n2];
                if (this.assignMatrix.get(u, j) == (double)k) {
                    trainMatrix.set(u, j, 0.0);
                } else {
                    testMatrix.set(u, j, 0.0);
                }
                ++n2;
            }
            ++u;
        }
        SparseMatrix.reshape(trainMatrix);
        SparseMatrix.reshape(testMatrix);
        this.debugInfo(trainMatrix, testMatrix, k);
        return new SparseMatrix[]{trainMatrix, testMatrix};
    }

    private void debugInfo(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) {
        String foldInfo = fold > 0 ? "Fold [" + fold + "]: " : "";
        Logs.debug("{}training amount: {}, test amount: {}", foldInfo, trainMatrix.size(), testMatrix.size());
    }
}

