/*
 * Decompiled with CFR 0.152.
 */
package happy.coding.io;

import java.lang.reflect.Array;

public class HashCoder {
    public static final int SEED = 23;
    private static final int fODD_PRIME_NUMBER = 37;

    public static int hash(int aSeed, boolean aBoolean) {
        return HashCoder.firstTerm(aSeed) + (aBoolean ? 1 : 0);
    }

    public static int hash(int aSeed, char aChar) {
        return HashCoder.firstTerm(aSeed) + aChar;
    }

    public static int hash(int aSeed, int aInt) {
        return HashCoder.firstTerm(aSeed) + aInt;
    }

    public static int hash(int aSeed, long aLong) {
        return HashCoder.firstTerm(aSeed) + (int)(aLong ^ aLong >>> 32);
    }

    public static int hash(int aSeed, float aFloat) {
        return HashCoder.hash(aSeed, Float.floatToIntBits(aFloat));
    }

    public static int hash(int aSeed, double aDouble) {
        return HashCoder.hash(aSeed, Double.doubleToLongBits(aDouble));
    }

    public static int hash(int aSeed, StringBuffer aSB) {
        if (aSB == null) {
            return HashCoder.hash(aSeed, 0);
        }
        return HashCoder.hash(aSeed, aSB.toString().hashCode());
    }

    public static int hash(int aSeed, Object aObject) {
        int result = aSeed;
        if (aObject == null) {
            result = HashCoder.hash(result, 0);
        } else if (!HashCoder.isArray(aObject)) {
            result = HashCoder.hash(result, aObject.hashCode());
        } else {
            int length = Array.getLength(aObject);
            int idx = 0;
            while (idx < length) {
                Object item = Array.get(aObject, idx);
                result = HashCoder.hash(result, item);
                ++idx;
            }
        }
        return result;
    }

    private static int firstTerm(int aSeed) {
        return 37 * aSeed;
    }

    private static boolean isArray(Object aObject) {
        return aObject.getClass().isArray();
    }
}

