/*
 * Decompiled with CFR 0.152.
 */
package carskit.data.processor;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import happy.coding.io.FileIO;
import happy.coding.io.Logs;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class DataTransformer
implements Runnable {
    protected int flag_train;
    protected int flag_test;
    protected String dataPath_train;
    protected String dataPath_test;
    protected String outputfolder;

    public void setParameters(int f_train, String path_train, int f_test, String path_test, String folder) {
        this.flag_train = f_train;
        this.flag_test = f_test;
        this.dataPath_train = path_train;
        this.dataPath_test = path_test;
        this.outputfolder = folder;
    }

    private Multimap<String, String> getConditions() throws Exception {
        Logs.info("flags - train: " + this.flag_train + ", test: " + this.flag_test);
        TreeMultimap<String, String> conditions = TreeMultimap.create();
        switch (this.flag_train) {
            case 1: {
                this.getConditionsFromBinaryData(this.dataPath_train, conditions);
                break;
            }
            case 2: {
                this.getConditionsFromLooseData(this.dataPath_train, conditions);
                break;
            }
            case 3: {
                this.getConditionsFromCompactData(this.dataPath_train, conditions);
            }
        }
        switch (this.flag_test) {
            case 1: {
                this.getConditionsFromBinaryData(this.dataPath_test, conditions);
                break;
            }
            case 2: {
                this.getConditionsFromLooseData(this.dataPath_test, conditions);
                break;
            }
            case 3: {
                this.getConditionsFromCompactData(this.dataPath_test, conditions);
                break;
            }
        }
        for (String dim : conditions.keySet()) {
            Collection conds = conditions.get(dim);
            if (conds.contains("na")) continue;
            conditions.put(dim, "na");
        }
        return conditions;
    }

    private void getConditionsFromBinaryData(String dataPath, Multimap<String, String> conditions) throws Exception {
        BufferedReader br = FileIO.getReader(dataPath);
        String line = br.readLine();
        br.close();
        String[] header = line.split(",", -1);
        for (int i = 3; i < header.length; ++i) {
            String[] strs = header[i].split(":", -1);
            conditions.put(strs[0].trim().toLowerCase(), strs[1].trim().toLowerCase());
        }
    }

    private void getConditionsFromLooseData(String dataPath, Multimap<String, String> conditions) throws Exception {
        BufferedReader br = FileIO.getReader(dataPath);
        String line = br.readLine();
        while ((line = br.readLine()) != null) {
            String[] strs = line.split(",", -1);
            String cond = strs[4].trim().toLowerCase();
            if (cond.equals("")) {
                cond = "na";
            }
            conditions.put(strs[3].trim().toLowerCase(), cond);
        }
        br.close();
    }

    private void getConditionsFromCompactData(String dataPath, Multimap<String, String> conditions) throws Exception {
        BufferedReader br = FileIO.getReader(dataPath);
        String line = br.readLine();
        String[] header = line.split(",", -1);
        int dimscount = header.length - 3;
        String[] dims = new String[dimscount];
        for (int i = 3; i < header.length; ++i) {
            dims[i - 3] = header[i].trim().toLowerCase();
        }
        while ((line = br.readLine()) != null) {
            String[] strs = line.split(",", -1);
            HashMap ratingcontext = new HashMap();
            for (int i = 3; i < 3 + dimscount; ++i) {
                String cond = strs[i].trim().toLowerCase();
                if (cond.equals("")) {
                    cond = "na";
                }
                conditions.put(dims[i - 3], cond);
            }
        }
        br.close();
    }

    public String getHeader(Multimap<String, String> conditions) {
        String header = "User, Item, Rating";
        for (String dim : conditions.keySet()) {
            for (String cond : conditions.get(dim)) {
                header = header + ", " + dim + ":" + cond;
            }
        }
        return header;
    }

    public String TransformationFromBinaryToBinary(String dataPath, boolean isTestSet, Multimap<String, String> conditions) throws Exception {
        String[] strs;
        BufferedReader br = FileIO.getReader(dataPath);
        String line = br.readLine();
        String[] header = line.split(",", -1);
        ArrayList<String> dims = new ArrayList<String>();
        for (int i = 3; i < header.length; ++i) {
            strs = header[i].trim().split(":", -1);
            String dim = strs[0].trim().toLowerCase();
            if (dims.contains(dim)) continue;
            dims.add(dim);
        }
        HashMap<String, HashMap<String, String>> newlines = new HashMap<String, HashMap<String, String>>();
        if (conditions == null) {
            conditions = LinkedHashMultimap.create();
        }
        while ((line = br.readLine()) != null) {
            strs = line.split(",", -1);
            HashMap<String, String> ratingcontext = new HashMap<String, String>();
            for (int i = 3; i < header.length; ++i) {
                int cond = Integer.parseInt(strs[i].trim().toLowerCase());
                if (cond == 0) continue;
                String dimcond = header[i];
                String[] rs = dimcond.split(":", -1);
                ratingcontext.put(rs[0].trim().toLowerCase(), rs[1].trim().toLowerCase());
                if (isTestSet) continue;
                conditions.put(rs[0].trim().toLowerCase(), rs[1].trim().toLowerCase());
            }
            newlines.put(line, ratingcontext);
        }
        br.close();
        String filename = isTestSet ? "test.csv" : "train.csv";
        this.PublishNewRatingFiles(this.outputfolder, conditions, newlines, false, filename);
        if (FileIO.exist(this.outputfolder + filename)) {
            return "Data transformaton completed (from Compact to Binary format). See new rating file: " + this.outputfolder + filename;
        }
        return "Data transformaton completed (from Compact to Binary format). See " + this.outputfolder;
    }

    public String TransformationFromLooseToBinary(String dataPath, boolean isTestSet, Multimap<String, String> conditions) throws Exception {
        BufferedReader br = FileIO.getReader(dataPath);
        String line = br.readLine();
        HashMap<String, HashMap<String, String>> newlines = new HashMap<String, HashMap<String, String>>();
        if (conditions == null) {
            conditions = LinkedHashMultimap.create();
        }
        while ((line = br.readLine()) != null) {
            HashMap<Object, Object> ratingcontext;
            String[] strs = line.split(",", -1);
            String key = strs[0].trim().toLowerCase() + "," + strs[1].trim().toLowerCase() + "," + strs[2].trim().toLowerCase();
            String cond = strs[4].trim().toLowerCase();
            if (cond.equals("")) {
                cond = "na";
            }
            if (!isTestSet) {
                conditions.put(strs[3].trim().toLowerCase(), cond);
            }
            if (newlines.containsKey(key)) {
                ratingcontext = newlines.get(key);
                ratingcontext.put(strs[3].trim().toLowerCase(), cond);
                continue;
            }
            ratingcontext = new HashMap();
            ratingcontext.put(strs[3].trim().toLowerCase(), cond);
            newlines.put(key, ratingcontext);
        }
        br.close();
        String filename = isTestSet ? "test.csv" : "train.csv";
        this.PublishNewRatingFiles(this.outputfolder, conditions, newlines, true, filename);
        if (FileIO.exist(this.outputfolder + filename)) {
            return "Data transformaton completed (from Loose to Binary format). See new rating file: " + this.outputfolder + filename;
        }
        return "Data transformation failed. See output folder: " + this.outputfolder;
    }

    public String TransformationFromCompactToBinary(String dataPath, boolean isTestSet, Multimap<String, String> conditions) throws Exception {
        BufferedReader br = FileIO.getReader(dataPath);
        String line = br.readLine();
        String[] header = line.split(",", -1);
        int dimscount = header.length - 3;
        String[] dims = new String[dimscount];
        for (int i = 3; i < header.length; ++i) {
            dims[i - 3] = header[i].trim().toLowerCase();
        }
        HashMap<String, HashMap<String, String>> newlines = new HashMap<String, HashMap<String, String>>();
        if (conditions == null) {
            conditions = LinkedHashMultimap.create();
        }
        while ((line = br.readLine()) != null) {
            String[] strs = line.split(",", -1);
            HashMap<String, String> ratingcontext = new HashMap<String, String>();
            for (int i = 3; i < 3 + dimscount; ++i) {
                String cond = strs[i].trim().toLowerCase();
                if (cond.equals("")) {
                    cond = "na";
                }
                ratingcontext.put(dims[i - 3], cond);
                if (isTestSet) continue;
                conditions.put(dims[i - 3], cond);
            }
            newlines.put(line, ratingcontext);
        }
        br.close();
        String filename = isTestSet ? "test.csv" : "train.csv";
        this.PublishNewRatingFiles(this.outputfolder, conditions, newlines, false, filename);
        if (FileIO.exist(this.outputfolder + filename)) {
            return "Data transformaton completed (from Compact to Binary format). See new rating file: " + this.outputfolder + filename;
        }
        return "Data transformaton completed (from Compact to Binary format). See " + this.outputfolder;
    }

    private void PublishNewRatingFiles(String outputfolder, Multimap<String, String> conditions, HashMap<String, HashMap<String, String>> newlines, boolean isLoose, String filename) throws Exception {
        String header = this.getHeader(conditions);
        Logs.info(header);
        BufferedWriter bw = FileIO.getWriter(outputfolder + filename);
        bw.write(header + "\n");
        bw.flush();
        for (String key : newlines.keySet()) {
            HashMap<String, String> ratingcontext = newlines.get(key);
            StringBuilder conditionBuilder = new StringBuilder();
            for (String dim : conditions.keySet()) {
                boolean isNA = false;
                boolean isCompleted = false;
                Collection<String> conds = conditions.get(dim);
                String dimCondition = ratingcontext.get(dim);
                if (dimCondition == null) {
                    isNA = true;
                } else if (dimCondition.equals("na")) {
                    isNA = true;
                }
                for (String cond : conds) {
                    if (conditionBuilder.length() > 0) {
                        conditionBuilder.append(",");
                    }
                    if (isLoose) {
                        if (isNA) {
                            if (cond.equals("na")) {
                                conditionBuilder.append("1");
                                isCompleted = true;
                                continue;
                            }
                            conditionBuilder.append("0");
                            continue;
                        }
                        if (isCompleted) {
                            conditionBuilder.append("0");
                            continue;
                        }
                        if (cond.equals(dimCondition)) {
                            conditionBuilder.append("1");
                            isCompleted = true;
                            continue;
                        }
                        conditionBuilder.append("0");
                        continue;
                    }
                    if (dimCondition.equals(cond)) {
                        conditionBuilder.append("1");
                        continue;
                    }
                    conditionBuilder.append("0");
                }
            }
            String[] skey = key.split(",", -1);
            if (skey.length > 3) {
                key = skey[0].trim().toLowerCase() + "," + skey[1].trim().toLowerCase() + "," + skey[2].trim().toLowerCase();
            }
            bw.write(key + "," + conditionBuilder.toString() + "\n");
            bw.flush();
        }
        bw.close();
    }

    @Override
    public void run() {
        try {
            if (this.flag_test == -1) {
                switch (this.flag_train) {
                    case 1: {
                        FileIO.copyFile(this.dataPath_train, this.outputfolder + "train.csv");
                        break;
                    }
                    case 2: {
                        Logs.warn("You rating data is in Loose format. CARSKit is working on transformation on the data format...");
                        Logs.info(this.TransformationFromLooseToBinary(this.dataPath_train, false, null));
                        break;
                    }
                    case 3: {
                        Logs.warn("You rating data is in Compact format. CARSKit is working on transformation on the data format...");
                        Logs.info(this.TransformationFromCompactToBinary(this.dataPath_train, false, null));
                        break;
                    }
                    default: {
                        Logs.warn("You rating data is not shaped in the correct format. Please read our guideline on data preparation...");
                        break;
                    }
                }
            } else {
                Multimap<String, String> conditions = this.getConditions();
                switch (this.flag_train) {
                    case 1: {
                        Logs.info(this.TransformationFromBinaryToBinary(this.dataPath_train, false, conditions));
                        break;
                    }
                    case 2: {
                        Logs.warn("You training data is in Loose format. CARSKit is working on transformation on the data format...");
                        Logs.info(this.TransformationFromLooseToBinary(this.dataPath_train, false, conditions));
                        break;
                    }
                    case 3: {
                        Logs.warn("You training data is in Compact format. CARSKit is working on transformation on the data format...");
                        Logs.info(this.TransformationFromCompactToBinary(this.dataPath_train, false, conditions));
                        break;
                    }
                    default: {
                        Logs.warn("You training data is not shaped in the correct format. Please read our guideline on data preparation...");
                    }
                }
                switch (this.flag_test) {
                    case 1: {
                        Logs.info(this.TransformationFromBinaryToBinary(this.dataPath_test, true, conditions));
                        break;
                    }
                    case 2: {
                        Logs.warn("You testing data is in Loose format. CARSKit is working on transformation on the data format...");
                        Logs.info(this.TransformationFromLooseToBinary(this.dataPath_test, true, conditions));
                        break;
                    }
                    case 3: {
                        Logs.warn("You testing data is in Compact format. CARSKit is working on transformation on the data format...");
                        Logs.info(this.TransformationFromCompactToBinary(this.dataPath_test, true, conditions));
                        break;
                    }
                    default: {
                        Logs.warn("You testing data is not shaped in the correct format. Please read our guideline on data preparation...");
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

