# Generated by Django 2.2.18 on 2021-02-26 16:30
from enum import Enum

from django.db import migrations
from PIL import Image
from nidhoggr.core.texture import TextureType
from sps_parser import parse_metadata, SkinMetadata


def backfill_metadata(apps, schema_editor):
    Texture = apps.get_model("lavender", "Texture")
    for texture in Texture.objects.filter(kind__exact=TextureType.SKIN.value).all():
        with Image.open(texture.image.open()) as image:
            metadata: SkinMetadata = parse_metadata(image)
            print(f"Parsed metadata for {texture.id}: {metadata}")
        dict_metadata = {
            key: value.name
            if isinstance(value, Enum) else value
            for key, value
            in metadata.__dict__.items()
        }
        dict_metadata["model"] = "default"
        texture.metadata = dict_metadata
        texture.save()


class Migration(migrations.Migration):
    dependencies = [
        ('lavender', '0003_texture_metadata'),
    ]

    operations = [
        migrations.RunPython(backfill_metadata)
    ]
