###
## Give GNU/Linux directory naming to cmake http://www.gnu.org/prep/standards/html_node/Directory-Variables.html
## 
## Define installation PATHs
## Re-use naming convention of package managers (RPM, dpkg) 

## setup default app name
IF(NOT DEFINED "${PROJECT_NAME}_APPLICATION_NAME")
  SET(APPLICATION_NAME "${PROJECT_NAME}")
ELSE()
  SET(APPLICATION_NAME "${PROJECT_NAME}_APPLICATION_NAME")
ENDIF()


### If no project specific prefix is define
##  use standard prefix
IF(NOT DEFINED ${APPLICATION_NAME}_INSTALL_PREFIX)

	IF("${CMAKE_INSTALL_PREFIX}" STREQUAL "/")
		## override simple "/", buggy with  cmake <= 2.8
		SET(INTERNAL_BASE_PREFIX "")
	ELSE()
		SET(INTERNAL_BASE_PREFIX "${CMAKE_INSTALL_PREFIX}")
	ENDIF()

ELSE()
	# support apps specific prefix installation
	# for sub-project style usage
	SET(INTERNAL_BASE_PREFIX "${${APPLICATION_NAME}_INSTALL_PREFIX}")
ENDIF()


# detect lib suffix
GET_PROPERTY(LIB64_SUFFIX GLOBAL PROPERTY FIND_LIBRARY_USE_LIB64_PATHS)

## library suffix : default ""
## Use specify lib{32,64}
IF(NOT DEFINED LIB_SUFFIX)
	IF(LIB64_SUFFIX)
	   SET(LIB_SUFFIX "64")
	ELSE()
	   SET(LIB_SUFFIX "")
	ENDIF()
ENDIF()


##
# execprefix (default: "$CMAKE_INSTALL_PREFIX" )
IF(NOT DEFINED EXEC_INSTALL_PREFIX)
	SET(EXEC_INSTALL_PREFIX
		"${CMAKE_INSTALL_PREFIX}")
ENDIF()

##
# share install dir prefix
# (RPM macro compat)
IF(NOT DEFINED SHARE_INSTALL_PREFIX)
	SET(SHARE_INSTALL_PREFIX
		"${INTERNAL_BASE_PREFIX}/share")
ENDIF()


##
# sysconfdir (default: /etc )
# 
IF(NOT DEFINED SYSCONF_INSTALL_DIR)
	SET(SYSCONF_INSTALL_DIR
		"${CMAKE_INSTALL_PREFIX}/etc")
ENDIF()

##
# apps specific datadir
# 
IF(NOT DEFINED DATA_INSTALL_PREFIX)
	SET(DATA_INSTALL_PREFIX
		"${INTERNAL_BASE_PREFIX}/${APPLICATION_NAME}")
ENDIF()


##
# bindir
IF(NOT DEFINED BIN_INSTALL_DIR)
	SET(BIN_INSTALL_DIR
		"${INTERNAL_BASE_PREFIX}/bin")
ENDIF()

##
# sbindir
IF(NOT DEFINED SBIN_INSTALL_DIR)
	SET(SBIN_INSTALL_DIR
		"${INTERNAL_BASE_PREFIX}/sbin")
ENDIF()

## 
# libdir
IF(NOT DEFINED LIB_INSTALL_DIR)
	SET(LIB_INSTALL_DIR
		"${INTERNAL_BASE_PREFIX}/lib${LIB_SUFFIX}")
ENDIF()

##
# libexecdir
IF(NOT DEFINED LIBEXEC_INSTALL_DIR)
	SET(LIBEXEC_INSTALL_DIR
		"${INTERNAL_BASE_PREFIX}/libexec")
ENDIF()

##
# pkgconfig dir
IF(NOT DEFINED PKGCONFIG_FILES_DIR)
	SET(PKGCONFIG_FILES_DIR
		"${LIB_INSTALL_DIR}/pkgconfig/")
ENDIF()

##
# plugin app dir
IF(NOT DEFINED PLUGIN_INSTALL_DIR)
	SET(PLUGIN_INSTALL_DIR
		"${LIB_INSTALL_DIR}/${APPLICATION_NAME}")
ENDIF()

##
# includedir
IF(NOT DEFINED INCLUDE_INSTALL_DIR)
	SET(INCLUDE_INSTALL_DIR
		"${INTERNAL_BASE_PREFIX}/include")
ENDIF()

##
# data install dir
IF(NOT DEFINED DATA_INSTALL_DIR)
	SET(DATA_INSTALL_DIR
		"${DATA_INSTALL_PREFIX}")
ENDIF()

##
# CMake.config install dir
IF(NOT DEFINED CMAKE_TARGET_CONFIG_INSTALL_DIR)
	SET(CMAKE_TARGET_CONFIG_INSTALL_DIR
		"${DATA_INSTALL_PREFIX}/${APPLICATION_NAME}/CMake")
ENDIF()


##
# doc install dir
IF(NOT DEFINED DOC_INSTALL_DIR)
	SET(DOC_INSTALL_DIR
	"${SHARE_INSTALL_PREFIX}/doc/${APPLICATION_NAME}")
ENDIF()

##
# mandir
IF(NOT DEFINED MAN_INSTALL_DIR)
	SET(MAN_INSTALL_DIR
		"${SHARE_INSTALL_PREFIX}/man")
ENDIF()

##
# infodir
IF(NOT DEFINED INFO_INSTALL_DIR)
	SET(INFO_INSTALL_DIR
		"${SHARE_INSTALL_PREFIX}/info")
ENDIF()



IF(NOT DEFINED HTML_INSTALL_DIR)
	SET(HTML_INSTALL_DIR
		"${DATA_INSTALL_PREFIX}/doc/html")
ENDIF()



IF(NOT DEFINED ICON_INSTALL_DIR)
	SET(ICON_INSTALL_DIR
		"${DATA_INSTALL_PREFIX}/icons")
ENDIF()



IF(NOT DEFINED SOUND_INSTALL_DIR)
	SET(SOUND_INSTALL_DIR
		"${DATA_INSTALL_PREFIX}/sounds")
ENDIF()



IF(NOT DEFINED LOCALE_INSTALL_DIR)
	SET(LOCALE_INSTALL_DIR
		"${SHARE_INSTALL_PREFIX}/locale")
ENDIF()



IF(NOT DEFINED XDG_APPS_DIR)
	SET(XDG_APPS_DIR
	"${SHARE_INSTALL_PREFIX}/applications")
ENDIF()


IF(NOT DEFINED XDG_DIRECTORY_DIR)
	SET(XDG_DIRECTORY_DIR
	"${SHARE_INSTALL_PREFIX}/desktop-directories")
ENDIF()




