# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/docindex.ipynb (unless otherwise specified).

__all__ = ['build_index', 'mdglob', 'get_idx', 'NbdevLookup', 'nbdoc_linkify']

# Cell
from functools import partial
import re
from pprint import pformat
import json
from nbdev.export import nbglob, get_config
from fastcore.utils import Path, urlread
from fastcore.basics import merge
from fastcore.script import call_parse

_re_name = re.compile(r'<DocSection type="(?!decorator)\S+" name="(\S+)"')
_re_decname = re.compile(r'<DocSection type="decorator" name="(\S+)"')
_re_slug = re.compile(r'---.*slug: (\S+).*---', flags=re.DOTALL)

# Cell
mdglob = partial(nbglob, recursive=True, extension='.md', config_key='doc_path')

def _add_at(s):
    if s: return s if s.startswith('@') else '@'+s

def build_index(path=None):
    "Build an index of names generated with `ShowDoc` to document paths."
    cfg = get_config()
    if path:
        path = Path(path)
    else:
        path = cfg['doc_path']

    doc_host = cfg['doc_host']
    base_url = cfg['doc_baseurl']

    if doc_host.endswith('/'): doc_host = doc_host[:-1]
    if not base_url.startswith('/'): base_url = '/' + base_url
    if not base_url.endswith('/'): base_url += '/'
    doc_url = doc_host + base_url

    files = mdglob(path) if path else mdglob(config_key='doc_path')
    reverse_idx = {}
    for f in files:
        txt = f.read_text()
        decnames = [_add_at(s) for s in _re_decname.findall(txt)]
        names = _re_name.findall(txt)
        slug_match = _re_slug.search(txt)

        if slug_match:
            doc_path = slug_match.group(1)
        else:
            doc_path = str(f.relative_to(path).with_suffix(''))

        for n in names+decnames: reverse_idx[n] = doc_url + doc_path + f'#{n}'

    if reverse_idx:
        (cfg.config_path/'_nbdoc_index.json').write_text(f'{json.dumps(reverse_idx, indent=4)}')
    return reverse_idx

# Cell
_re_backticks = re.compile(r'`([^`\s]+)`')
def get_idx(url): return json.loads(urlread(url))

class NbdevLookup:
    "Mapping from symbol names to URLs with docs"
    def __init__(self, local=True, md_path=None):
        self.md_path = md_path
        self.local = local
        self.mdfiles = mdglob(md_path) if md_path else mdglob(config_key='doc_path')

    def build_syms(self):
        cfg = get_config()
        urls = cfg.get('remote_idx', '').split()
        self.syms = merge(*[get_idx(url) for url in urls])

        if self.local:
            build_index(self.md_path)
            idx_file = cfg.config_path/'_nbdoc_index.json'
            if idx_file.exists(): self.syms = merge(self.syms, json.loads(idx_file.read_text()))


    def _link_sym(self, m):
        l = m.group(1)
        s = self[l]
        if s is None: return m.group(0)
        return rf"[{l}]({s})"

    def _link_line(self, l): return _re_backticks.sub(self._link_sym, l)

    def linkify(self, md):
        in_fence=False
        lines = md.splitlines()
        for i,l in enumerate(lines):
            if l.startswith("```"): in_fence=not in_fence
            elif not l.startswith('    ') and not in_fence: lines[i] = self._link_line(l)
        return '\n'.join(lines)

    def __getitem__(self, s): return self.syms.get(s, None)

    def update_markdown(self):
        self.build_syms()
        if self.syms:
            for f in self.mdfiles:
                print(f'Updating: {str(f)}')
                f.write_text(self.linkify(f.read_text()))

# Cell
@call_parse
def nbdoc_linkify(
    local:bool=True,  # Whether or not to build an index based on local documents
    md_path:str=None, # Root path to search recursively containing markdown files to linkify
):
    "Convert names in `backticks` in markdown files that have been documented with nbdoc.showdoc.ShowDoc to appropriate links."
    nl = NbdevLookup(local=local, md_path=md_path)
    nl.update_markdown()