"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeDeployEcsDeployAction = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline = require("@aws-cdk/aws-codepipeline");
const iam = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const action_1 = require("../action");
class CodeDeployEcsDeployAction extends action_1.Action {
    constructor(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_codepipeline_actions_CodeDeployEcsDeployActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CodeDeployEcsDeployAction);
            }
            throw error;
        }
        const inputs = [];
        inputs.push(determineTaskDefinitionArtifact(props));
        inputs.push(determineAppSpecArtifact(props));
        if (props.containerImageInputs) {
            if (props.containerImageInputs.length > 4) {
                throw new Error(`Action cannot have more than 4 container image inputs, got: ${props.containerImageInputs.length}`);
            }
            for (const imageInput of props.containerImageInputs) {
                inputs.push(imageInput.input);
            }
        }
        super({
            ...props,
            resource: props.deploymentGroup,
            category: codepipeline.ActionCategory.DEPLOY,
            provider: 'CodeDeployToECS',
            artifactBounds: { minInputs: 1, maxInputs: 5, minOutputs: 0, maxOutputs: 0 },
            inputs,
        });
        this.actionProps = props;
    }
    bound(_scope, _stage, options) {
        // permissions, based on:
        // https://docs.aws.amazon.com/codedeploy/latest/userguide/auth-and-access-control-permissions-reference.html
        options.role.addToPolicy(new iam.PolicyStatement({
            resources: [this.actionProps.deploymentGroup.application.applicationArn],
            actions: ['codedeploy:GetApplication', 'codedeploy:GetApplicationRevision', 'codedeploy:RegisterApplicationRevision'],
        }));
        options.role.addToPolicy(new iam.PolicyStatement({
            resources: [this.actionProps.deploymentGroup.deploymentGroupArn],
            actions: ['codedeploy:CreateDeployment', 'codedeploy:GetDeployment'],
        }));
        options.role.addToPolicy(new iam.PolicyStatement({
            resources: [this.actionProps.deploymentGroup.deploymentConfig.deploymentConfigArn],
            actions: ['codedeploy:GetDeploymentConfig'],
        }));
        // Allow action to register the task definition template file with ECS
        options.role.addToPolicy(new iam.PolicyStatement({
            resources: ['*'],
            actions: ['ecs:RegisterTaskDefinition'],
        }));
        // Allow passing any roles specified in the task definition template file to ECS
        options.role.addToPolicy(new iam.PolicyStatement({
            actions: ['iam:PassRole'],
            resources: ['*'],
            conditions: {
                StringEqualsIfExists: {
                    'iam:PassedToService': [
                        'ecs-tasks.amazonaws.com',
                    ],
                },
            },
        }));
        // the Action's Role needs to read from the Bucket to get artifacts
        options.bucket.grantRead(options.role);
        const taskDefinitionTemplateArtifact = determineTaskDefinitionArtifact(this.actionProps);
        const appSpecTemplateArtifact = determineAppSpecArtifact(this.actionProps);
        const actionConfig = {
            configuration: {
                ApplicationName: this.actionProps.deploymentGroup.application.applicationName,
                DeploymentGroupName: this.actionProps.deploymentGroup.deploymentGroupName,
                TaskDefinitionTemplateArtifact: core_1.Lazy.string({ produce: () => taskDefinitionTemplateArtifact.artifactName }),
                TaskDefinitionTemplatePath: this.actionProps.taskDefinitionTemplateFile
                    ? this.actionProps.taskDefinitionTemplateFile.fileName
                    : 'taskdef.json',
                AppSpecTemplateArtifact: core_1.Lazy.string({ produce: () => appSpecTemplateArtifact.artifactName }),
                AppSpecTemplatePath: this.actionProps.appSpecTemplateFile
                    ? this.actionProps.appSpecTemplateFile.fileName
                    : 'appspec.yaml',
            },
        };
        if (this.actionProps.containerImageInputs) {
            for (let i = 1; i <= this.actionProps.containerImageInputs.length; i++) {
                const imageInput = this.actionProps.containerImageInputs[i - 1];
                actionConfig.configuration[`Image${i}ArtifactName`] = core_1.Lazy.string({ produce: () => imageInput.input.artifactName });
                actionConfig.configuration[`Image${i}ContainerName`] = imageInput.taskDefinitionPlaceholder
                    ? imageInput.taskDefinitionPlaceholder
                    : 'IMAGE';
            }
        }
        return actionConfig;
    }
}
exports.CodeDeployEcsDeployAction = CodeDeployEcsDeployAction;
_a = JSII_RTTI_SYMBOL_1;
CodeDeployEcsDeployAction[_a] = { fqn: "@aws-cdk/aws-codepipeline-actions.CodeDeployEcsDeployAction", version: "1.168.0" };
function determineTaskDefinitionArtifact(props) {
    if (props.taskDefinitionTemplateFile && props.taskDefinitionTemplateInput) {
        throw new Error("Exactly one of 'taskDefinitionTemplateInput' or 'taskDefinitionTemplateFile' can be provided in the ECS CodeDeploy Action");
    }
    if (props.taskDefinitionTemplateFile) {
        return props.taskDefinitionTemplateFile.artifact;
    }
    if (props.taskDefinitionTemplateInput) {
        return props.taskDefinitionTemplateInput;
    }
    throw new Error("Specifying one of 'taskDefinitionTemplateInput' or 'taskDefinitionTemplateFile' is required for the ECS CodeDeploy Action");
}
function determineAppSpecArtifact(props) {
    if (props.appSpecTemplateFile && props.appSpecTemplateInput) {
        throw new Error("Exactly one of 'appSpecTemplateInput' or 'appSpecTemplateFile' can be provided in the ECS CodeDeploy Action");
    }
    if (props.appSpecTemplateFile) {
        return props.appSpecTemplateFile.artifact;
    }
    if (props.appSpecTemplateInput) {
        return props.appSpecTemplateInput;
    }
    throw new Error("Specifying one of 'appSpecTemplateInput' or 'appSpecTemplateFile' is required for the ECS CodeDeploy Action");
}
//# sourceMappingURL=data:application/json;base64,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