#!/usr/bin/python
import numpy as np

'''
Frequency scaling factors, taken from the beta 2 version of version 3 of The Trhular group database (https://t1.chem.umn.edu/freqscale/index.html
I. M. Alecu, J. Zheng, Y. Zhao, and D. G. Truhlar, J. Chem. Theory Comput. 6, 2872-2887 (2010).

The array is ordered as:
[level/basis set, zpe_fac, zpe_ref, zpe_meth, harm_fac, harm_ref, harm_meth, fund_fac, fund_ref, fund_meth]
where zpe_fac, harm_fac and fund_fac are the scaling factors for ZPEs, harmonic frequencies, and fundamentals, respectively.

The ref and meth elements refer to original references and method of determinantion by the Truhlar group. All information taken from
https://comp.chem.umn.edu/freqscale/version3b2.htm

Methods
D: The scale factor was directly obtained from the ZPVE15/10 or F38/10 databases given in Ref. 1.
C: The scale factor was obtained by applying a small systematic correction of -0.0025 to preexisting scale factor. The references for the preexisting (uncorrected) scale factors are given in Supporting Information of Ref. 1 and in Version 1 of this database
R: The scale factor was obtained via the Reduced Scale Factor Optimization Model described in Ref. 1. Briefly, this entails using the ZPE6 database for determining ZPE scale factors, and/or using the universal scale factor ratios of aF/ZPE = 0.974 and aH/ZPE = 1.014 to obtain the respective values for the scale factors for fundamental and harmonic frequencies.
'''
scaling_refs = np.array([("none"), ("I. M. Alecu, J. Zheng, Y. Zhao, and D. G. Truhlar, J. Chem. Theory Comput. 6, 2872-2887 (2010)."),("Y. Zhao and D. G. Truhlar, unpublished (2003), modified by systematic correction of -0.0025 by I. M. Alecu (2010)."), ("I. M. Alecu, unpublished (2011)."), ("J. Zheng, R. J. Rocha, M. Pelegrini, L. F. A. Ferrao, E. F. V. Carvalho, O. Roberto-Neto, F. B. C. Machado, and D. G. Truhlar, J. Chem. Phys. 136, 184310/1-10 (2012)."), ("J. Zheng and D. G. Truhlar, unpublished (2014)."), ("J. Bao and D. G. Truhlar, unpublished (2014)."), ("H. Yu, J. Zheng, and D. G. Truhlar, unpublished (2015)")])

scaling_data = np.array([("AM1" ,  0.948 ,  1 ,  "R" ,  0.961 ,  1 ,  "R" ,  0.923 ,  1 ,  "R" ),("B1B95/6-31+G(d,p)" ,  0.971 ,  1 ,  "C" ,  0.985 ,  1 ,  "R" ,  0.946 ,  1 ,  "R" ),("B1B95/MG3S" ,  0.973 ,  1 ,  "C" ,  0.987 ,  1 ,  "R" ,  0.948 ,  1 ,  "R" ),("B1LYP/MG3S" ,  0.978 ,  1 ,  "D" ,  0.994 ,  1 ,  "D" ,  0.955 ,  1 ,  "D" ),("B3LYP/6-31G(2df,2p)" ,  0.981 ,  1 ,  "C" ,  0.995 ,  1 ,  "R" ,  0.955 ,  1 ,  "R" ),("B3LYP/6-31G(d)" ,  0.977 ,  1 ,  "R" ,  0.991 ,  1 ,  "R" ,  0.952 ,  1 ,  "R" ),("B3LYP/aug-cc-pVTZ" ,  0.985 ,  3 ,  "R" ,  0.999 ,  3 ,  "R" ,  0.959 ,  3 ,  "R" ),("B3LYP/def2-TZVP" ,  0.985 ,  3 ,  "R" ,  0.999 ,  3 ,  "R" ,  0.959 ,  3 ,  "R" ),("B3LYP/ma-TZVP" ,  0.986 ,  1 ,  "R" ,  1.000 ,  1 ,  "R" ,  0.960 ,  1 ,  "R" ),("B3LYP/MG3S" ,  0.983 ,  1 ,  "D" ,  0.998 ,  1 ,  "D" ,  0.960 ,  1 ,  "D" ),("B3P86/6-31G(d)" ,  0.971 ,  1 ,  "R" ,  0.985 ,  1 ,  "R" ,  0.946 ,  1 ,  "R" ),("B3PW91/6-31G(d)" ,  0.972 ,  1 ,  "R" ,  0.986 ,  1 ,  "R" ,  0.947 ,  1 ,  "R" ),("B97-3/ma-TZVP" ,  0.975 ,  1 ,  "R" ,  0.989 ,  1 ,  "R" ,  0.950 ,  1 ,  "R" ),("B97-3/MG3S" ,  0.972 ,  1 ,  "D" ,  0.986 ,  1 ,  "D" ,  0.947 ,  1 ,  "D" ),("B98/def2-TZVP" ,  0.984 ,  1 ,  "R" ,  0.998 ,  1 ,  "R" ,  0.958 ,  1 ,  "R" ),("B98/ma-TZVP" ,  0.985 ,  1 ,  "R" ,  0.999 ,  1 ,  "R" ,  0.959 ,  1 ,  "R" ),("B98/MG3S" ,  0.982 ,  1 ,  "D" ,  0.995 ,  1 ,  "D" ,  0.956 ,  1 ,  "D" ),("BB1K/6-31+G(d,p)" ,  0.954 ,  1 ,  "C" ,  0.967 ,  1 ,  "R" ,  0.929 ,  1 ,  "R" ),("BB1K/MG3S" ,  0.957 ,  1 ,  "C" ,  0.970 ,  1 ,  "R" ,  0.932 ,  1 ,  "R" ),("BB95/6-31+G(d,p)" ,  1.011 ,  1 ,  "C" ,  1.025 ,  1 ,  "R" ,  0.985 ,  1 ,  "R" ),("BB95/MG3S" ,  1.012 ,  1 ,  "C" ,  1.026 ,  1 ,  "R" ,  0.986 ,  1 ,  "R" ),("BLYP/6-311G(df,p)" ,  1.013 ,  1 ,  "R" ,  1.027 ,  1 ,  "R" ,  0.987 ,  1 ,  "R" ),("BLYP/6-31G(d)" ,  1.009 ,  1 ,  "R" ,  1.023 ,  1 ,  "R" ,  0.983 ,  1 ,  "R" ),("BLYP/MG3S" ,  1.013 ,  1 ,  "D" ,  1.031 ,  1 ,  "D" ,  0.991 ,  1 ,  "D" ),("BMC-CCSD" ,  0.985 ,  1 ,  "D" ,  1.001 ,  1 ,  "D" ,  0.962 ,  1 ,  "D" ),("BMK/ma-TZVP" ,  0.972 ,  1 ,  "R" ,  0.986 ,  1 ,  "R" ,  0.947 ,  1 ,  "R" ),("BMK/MG3S" ,  0.971 ,  1 ,  "D" ,  0.984 ,  1 ,  "D" ,  0.945 ,  1 ,  "D" ),("BP86/6-31G(d)" ,  1.007 ,  1 ,  "R" ,  1.021 ,  1 ,  "R" ,  0.981 ,  1 ,  "R" ),("BP86/ma-TZVP" ,  1.014 ,  1 ,  "R" ,  1.028 ,  1 ,  "R" ,  0.988 ,  1 ,  "R" ),("BPW60/6-311+G(d,p)" ,  0.934 ,  2 ,  "C" ,  0.910 ,  2 ,  "R" ,  0.947 ,  2 ,  "R" ),("BPW63/MG3S" ,  0.923 ,  2 ,  "C" ,  0.899 ,  2 ,  "R" ,  0.936 ,  2 ,  "R" ),("CAM-B3LYP/ma-TZVP" ,  0.976 ,  1 ,  "R" ,  0.990 ,  1 ,  "R" ,  0.951 ,  1 ,  "R" ),("CCSD(T)/jul-cc-pVTZ" , 0.984 ,  1 ,  "R" ,  0.998 ,  1 ,  "R" ,  0.958 ,  1 ,  "R" ),("CCSD(T)/aug-cc-pVTZ" , 0.987 ,  1 ,  "R" ,  1.001 ,  1 ,  "R" ,  0.961 ,  1 ,  "R" ),("CCSD(T)-F12/jul-cc-pVTZ" , 0.981 ,  1 ,  "R" ,  0.995 ,  1 ,  "R" ,  0.955 ,  1 ,  "R" ),("CCSD(T)-F12a/cc-pVTZ-F12" , 0.984 ,  1 ,  "R" ,  0.998 ,  1 ,  "R" ,  0.958 ,  1 ,  "R" ),("CCSD/jul-cc-pVTZ" ,  0.973 ,  1 ,  "R" ,  0.987 ,  1 ,  "R" ,  0.948 ,  1 ,  "R" ),("CCSD-F12/jul-cc-pVTZ" ,  0.971 ,  1 ,  "R" ,  0.985 ,  1 ,  "R" ,  0.946 ,  1 ,  "R" ),("G96LYP80/6-311+G(d,p)" ,  0.911 ,  2 ,  "C" ,  0.887 ,  2 ,  "R" ,  0.924 ,  2 ,  "R" ),("G96LYP82/MG3S" ,  0.907 ,  2 ,  "C" ,  0.883 ,  2 ,  "R" ,  0.920 ,  2 ,  "R" ),("GAM/def2-TZVP" ,  0.980 ,  7 ,  "D" ,  0.994 ,  7 ,  "D" ,  0.955 ,  7 ,  "D" ),("GAM/ma-TZVP" ,  0.981 ,  7 ,  "D" ,  0.995 ,  7 ,  "D" ,  0.956 ,  7 ,  "D" ),("HF/3-21G" ,  0.919 ,  1 ,  "R" ,  0.932 ,  1 ,  "R" ,  0.895 ,  1 ,  "R" ),("HF/6-31+G(d)" ,  0.911 ,  1 ,  "R" ,  0.924 ,  1 ,  "R" ,  0.887 ,  1 ,  "R" ),("HF/6-31+G(d,p)" ,  0.915 ,  1 ,  "C" ,  0.928 ,  1 ,  "R" ,  0.891 ,  1 ,  "R" ),("HF/6-311G(d,p)" ,  0.920 ,  1 ,  "R" ,  0.933 ,  1 ,  "R" ,  0.896 ,  1 ,  "R" ),("HF/6-311G(df,p)" ,  0.920 ,  1 ,  "R" ,  0.933 ,  1 ,  "R" ,  0.896 ,  1 ,  "R" ),("HF/6-31G(d)" ,  0.909 ,  1 ,  "R" ,  0.922 ,  1 ,  "R" ,  0.885 ,  1 ,  "R" ),("HF/6-31G(d,p)" ,  0.913 ,  1 ,  "R" ,  0.926 ,  1 ,  "R" ,  0.889 ,  1 ,  "R" ),("HF/MG3S" ,  0.919 ,  1 ,  "D" ,  0.932 ,  1 ,  "D" ,  0.895 ,  1 ,  "D" ),("HFLYP/MG3S" ,  0.899 ,  1 ,  "D" ,  0.912 ,  1 ,  "D" ,  0.876 ,  1 ,  "D" ),("HSEh1PBE/ma-TZVP" ,  0.979 ,  1 ,  "R" ,  0.993 ,  1 ,  "R" ,  0.954 ,  1 ,  "R" ),("M05/aug-cc-pVTZ" ,  0.978 ,  1 ,  "R" ,  0.992 ,  1 ,  "R" ,  0.953 ,  1 ,  "R" ),("M05/def2-TZVP" ,  0.978 ,  3 ,  "R" ,  0.991 ,  3 ,  "R" ,  0.952 ,  3 ,  "R" ),("M05/ma-TZVP" ,  0.979 ,  1 ,  "R" ,  0.993 ,  1 ,  "R" ,  0.954 ,  1 ,  "R" ),("M05/maug-cc-pVTZ" ,  0.978 ,  1 ,  "R" ,  0.992 ,  1 ,  "R" ,  0.953 ,  1 ,  "R" ),("M05/MG3S" ,  0.977 ,  1 ,  "D" ,  0.989 ,  1 ,  "D" ,  0.951 ,  1 ,  "D" ),("M05-2X/6-31+G(d,p)" ,  0.961 ,  1 ,  "D" ,  0.974 ,  1 ,  "D" ,  0.936 ,  1 ,  "D" ),("M05-2X/aug-cc-pVTZ" ,  0.964 ,  1 ,  "R" ,  0.977 ,  1 ,  "R" ,  0.939 ,  1 ,  "R" ),("M05-2X/def2-TZVPP" ,  0.962 ,  1 ,  "D" ,  0.976 ,  1 ,  "D" ,  0.938 ,  1 ,  "D" ),("M05-2X/ma-TZVP" ,  0.965 ,  1 ,  "R" ,  0.979 ,  1 ,  "R" ,  0.940 ,  1 ,  "R" ),("M05-2X/maug-cc-pVTZ" ,  0.964 ,  1 ,  "R" ,  0.977 ,  1 ,  "R" ,  0.939 ,  1 ,  "R" ),("M05-2X/MG3S" ,  0.962 ,  1 ,  "D" ,  0.975 ,  1 ,  "D" ,  0.937 ,  1 ,  "D" ),("M06/6-31+G(d,p)" ,  0.980 ,  1 ,  "D" ,  0.989 ,  1 ,  "D" ,  0.950 ,  1 ,  "D" ),("M06/aug-cc-pVTZ" ,  0.984 ,  1 ,  "R" ,  0.998 ,  1 ,  "R" ,  0.958 ,  1 ,  "R" ),("M06/def2-TZVP" ,  0.982 ,  3 ,  "R" ,  0.996 ,  3 ,  "R" ,  0.956 ,  3 ,  "R" ),("M06/def2-TZVPP" ,  0.979 ,  1 ,  "D" ,  0.992 ,  1 ,  "D" ,  0.953 ,  1 ,  "D" ),("M06/ma-TZVP" ,  0.982 ,  1 ,  "R" ,  0.996 ,  1 ,  "R" ,  0.956 ,  1 ,  "R" ),("M06/maug-cc-pVTZ" ,  0.982 ,  1 ,  "R" ,  0.996 ,  1 ,  "R" ,  0.956 ,  1 ,  "R" ),("M06/MG3S" ,  0.981 ,  1 ,  "D" ,  0.994 ,  1 ,  "D" ,  0.955 ,  1 ,  "D" ),("M06-2X/6-31+G(d,p)" ,  0.967 ,  1 ,  "D" ,  0.979 ,  1 ,  "D" ,  0.940 ,  1 ,  "D" ),("M06-2X/6-311+G(d,p)" ,  0.970 ,  5 ,  "D" ,  0.983 ,  5 ,  "R" ,  0.944 ,  5 ,  "R" ),("M06-2X/6-311++G(d,p)" ,  0.970 ,  5 ,  "D" ,  0.983 ,  5 ,  "R" ,  0.944 ,  5 ,  "R" ),("M06-2X/aug-cc-pVTZ" ,  0.971 ,  1 ,  "D" ,  0.985 ,  1 ,  "D" ,  0.946 ,  1 ,  "D" ),("M06-2X/def2-TZVP" ,  0.971 ,  7 ,  "D" ,  0.984 ,  7 ,  "D" ,  0.946 ,  7 ,  "D" ),("M06-2X/def2-QZVP" ,  0.970 ,  7 ,  "D" ,  0.983 ,  7 ,  "D" ,  0.945 ,  7 ,  "D" ),("M06-2X/def2-TZVPP" ,  0.970 ,  1 ,  "D" ,  0.983 ,  1 ,  "D" ,  0.945 ,  1 ,  "D" ),("M06-2X/ma-TZVP" ,  0.972 ,  1 ,  "R" ,  0.986 ,  1 ,  "R" ,  0.947 ,  1 ,  "R" ),("M06/maug-cc-pVTZ" , 0.971 ,  1 ,  "D" ,  0.984 ,  1 ,  "D" ,  0.945 ,  1 ,  "D" ),("M06-2X/MG3S" ,  0.970 ,  1 ,  "D" ,  0.982 ,  1 ,  "D" ,  0.944 ,  1 ,  "D" ),("M06-HF/6-31+G(d,p)" ,  0.954 ,  1 ,  "D" ,  0.969 ,  1 ,  "D" ,  0.931 ,  1 ,  "D" ),("M06-HF/aug-cc-pVTZ" ,  0.961 ,  1 ,  "R" ,  0.974 ,  1 ,  "R" ,  0.936 ,  1 ,  "R" ),("M06-HF/def2-TZVPP" ,  0.958 ,  1 ,  "D" ,  0.970 ,  1 ,  "D" ,  0.932 ,  1 ,  "D" ),("M06-HF/ma-TZVP" ,  0.957 ,  1 ,  "R" ,  0.970 ,  1 ,  "R" ,  0.932 ,  1 ,  "R" ),("M06-HF/maug-cc-pVTZ" ,  0.959 ,  1 ,  "R" ,  0.972 ,  1 ,  "R" ,  0.934 ,  1 ,  "R" ),("M06-HF/MG3S" ,  0.955 ,  1 ,  "D" ,  0.967 ,  1 ,  "D" ,  0.930 ,  1 ,  "D" ),("M06-L/6-31+G(d,p)" ,  0.978 ,  1 ,  "D" ,  0.992 ,  1 ,  "D" ,  0.953 ,  1 ,  "D" ),("M06-L/aug-cc-pVTZ" ,  0.980 ,  1 ,  "R" ,  0.994 ,  1 ,  "R" ,  0.955 ,  1 ,  "R" ),("M06-L(DKH2)/aug-cc-pwcVTZ-DK" ,  0.985 ,  1 ,  "D" ,  0.999 ,  1 ,  "R" ,  0.959 ,  1 ,  "R" ),("M06-L/def2-TZVP" ,  0.976 ,  3 ,  "R" ,  0.990 ,  3 ,  "R" ,  0.951 ,  3 ,  "R" ),("M06-L/def2-TZVPP" ,  0.976 ,  1 ,  "D" ,  0.995 ,  1 ,  "D" ,  0.956 ,  1 ,  "D" ),("M06-L/ma-TZVP" ,  0.977 ,  1 ,  "R" ,  0.991 ,  1 ,  "R" ,  0.952 ,  1 ,  "R" ),("M06-L/maug-cc-pVTZ" ,  0.977 ,  1 ,  "R" ,  0.991 ,  1 ,  "R" ,  0.952 ,  1 ,  "R" ),("M06-L/MG3S" ,  0.978 ,  1 ,  "D" ,  0.996 ,  1 ,  "D" ,  0.958 ,  1 ,  "D" ),("M08-HX/6-31+G(d,p)" ,  0.972 ,  1 ,  "D" ,  0.983 ,  1 ,  "D" ,  0.944 ,  1 ,  "D" ),("M08-HX/aug-cc-pVTZ" ,  0.975 ,  1 ,  "R" ,  0.989 ,  1 ,  "R" ,  0.950 ,  1 ,  "R" ),("M08-HX/cc-pVTZ+" ,  0.974 ,  1 ,  "D" ,  0.985 ,  1 ,  "D" ,  0.946 ,  1 ,  "D" ),("M08-HX/def2-TZVPP" ,  0.973 ,  1 ,  "D" ,  0.984 ,  1 ,  "D" ,  0.945 ,  1 ,  "D" ),("M08-HX/jun-cc-pVTZ" ,  0.974 ,  6 ,  "D" ,  0.986 ,  6 ,  "D" ,  0.947 ,  6 ,  "D" ),("M08-HX/ma-TZVP" ,  0.976 ,  1 ,  "R" ,  0.990 ,  1 ,  "R" ,  0.951 ,  1 ,  "R" ),("M08-HX/maug-cc-pVTZ" ,  0.976 ,  1 ,  "R" ,  0.990 ,  1 ,  "R" ,  0.951 ,  1 ,  "R" ),("M08-HX/MG3S" ,  0.973 ,  1 ,  "D" ,  0.984 ,  1 ,  "D" ,  0.946 ,  1 ,  "D" ),("M08-SO/6-31+G(d,p)" ,  0.979 ,  1 ,  "D" ,  0.989 ,  1 ,  "D" ,  0.951 ,  1 ,  "D" ),("M08-SO/aug-cc-pVTZ" ,  0.985 ,  1 ,  "R" ,  0.999 ,  1 ,  "R" ,  0.959 ,  1 ,  "R" ),("M08-SO/cc-pVTZ+" ,  0.982 ,  1 ,  "D" ,  0.995 ,  1 ,  "D" ,  0.956 ,  1 ,  "D" ),("M08-SO/def2-TZVPP" ,  0.980 ,  1 ,  "D" ,  0.993 ,  1 ,  "D" ,  0.954 ,  1 ,  "D" ),("M08-SO/ma-TZVP" ,  0.984 ,  1 ,  "R" ,  0.998 ,  1 ,  "R" ,  0.958 ,  1 ,  "R" ),("M08-SO/maug-cc-pVTZ" ,  0.983 ,  1 ,  "R" ,  0.997 ,  1 ,  "R" ,  0.957 ,  1 ,  "R" ),("M08-SO/MG3" ,  0.984 ,  4 ,  "D" ,  0.998 ,  4 ,  "R" ,  0.959 ,  4 ,  "R" ),("M08-SO/MG3S" ,  0.983 ,  1 ,  "D" ,  0.995 ,  1 ,  "D" ,  0.956 ,  1 ,  "D" ),("M08-SO/MG3SXP" ,  0.984 ,  1 ,  "D" ,  0.996 ,  1 ,  "D" ,  0.957 ,  1 ,  "D" ),("MN12-L/MG3S" ,  0.968 ,  6 ,  "D" ,  0.981 ,  6 ,  "D" ,  0.943 ,  6 ,  "D" ),("MN12-SX/6-311++G(d,p)" ,  0.976 ,  6 ,  "D" ,  0.986 ,  6 ,  "D" ,  0.947 ,  6 ,  "D" ),("MN15-L/MG3S" ,  0.977 ,  1 ,  "D" ,  0.991 ,  1 ,  "R" ,  0.952 ,  1 ,  "R" ),("MN15-L/maug-cc-pVTZ" ,  0.979 ,  1 ,  "D" ,  0.993 ,  1 ,  "R" ,  0.954 ,  1 ,  "R" ),("MC3BB" ,  0.965 ,  1 ,  "C" ,  0.979 ,  1 ,  "R" ,  0.940 ,  1 ,  "R" ),("MC3MPW" ,  0.964 ,  1 ,  "C" ,  0.977 ,  1 ,  "R" ,  0.939 ,  1 ,  "R" ),("MC-QCISD/3" ,  0.992 ,  1 ,  "C" ,  1.006 ,  1 ,  "R" ,  0.966 ,  1 ,  "R" ),("MOHLYP/ma-TZVP" ,  1.027 ,  1 ,  "R" ,  1.041 ,  1 ,  "R" ,  1.000 ,  1 ,  "R" ),("MOHLYP/MG3S" ,  1.022 ,  1 ,  "R" ,  1.036 ,  1 ,  "R" ,  0.995 ,  1 ,  "R" ),("MP2(FC)/6-31+G(d,p)" , 0.968 ,  1 ,  "C" ,  0.982 ,  1 ,  "R" ,  0.943 ,  1 ,  "R" ),("MP2(FC)/6-311G(d,p)" , 0.970 ,  1 ,  "R" ,  0.984 ,  1 ,  "R" ,  0.945 ,  1 ,  "R" ),("MP2(FC)/6-31G(d)" ,  0.964 ,  1 ,  "R" ,  0.977 ,  1 ,  "R" ,  0.939 ,  1 ,  "R" ),("MP2(FC)/6-31G(d,p)" , 0.958 ,  1 ,  "R" ,  0.971 ,  1 ,  "R" ,  0.933 ,  1 ,  "R" ),("MP2(FC)/cc-pVDZ" ,  0.977 ,  1 ,  "C" ,  0.991 ,  1 ,  "R" ,  0.952 ,  1 ,  "R" ),("MP2(FULL)/6-31G(d)" ,  0.963 ,  1 ,  "R" ,  0.976 ,  1 ,  "R" ,  0.938 ,  1 ,  "R" ),("MP4(SDQ)/jul-cc-pVTZ", 0.973 ,  1 ,  "R" ,  0.987 ,  1 ,  "R" ,  0.948 ,  1 ,  "R" ),("MPW1B95/6-31+G(d,p)" ,  0.970 ,  1 ,  "C" ,  0.984 ,  1 ,  "R" ,  0.945 ,  1 ,  "R" ),("MPW1B95/MG3" ,  0.970 ,  1 ,  "C" ,  0.984 ,  1 ,  "R" ,  0.945 ,  1 ,  "R" ),("MPW1B95/MG3S" ,  0.972 ,  1 ,  "C" ,  0.986 ,  1 ,  "R" ,  0.947 ,  1 ,  "R" ),("MPW1K/6-31+G(d,p)" ,  0.949 ,  1 ,  "C" ,  0.962 ,  1 ,  "R" ,  0.924 ,  1 ,  "R" ),("MPW1K/ma-TZVP" ,  0.956 ,  1 ,  "R" ,  0.969 ,  1 ,  "R" ,  0.931 ,  1 ,  "R" ),("MPW1K/MG3" ,  0.953 ,  1 ,  "C" ,  0.966 ,  1 ,  "R" ,  0.928 ,  1 ,  "R" ),("MPW1K/MG3S" ,  0.956 ,  1 ,  "C" ,  0.969 ,  1 ,  "R" ,  0.931 ,  1 ,  "R" ),("MPW1K/MIDI!" ,  0.953 ,  1 ,  "R" ,  0.966 ,  1 ,  "R" ,  0.928 ,  1 ,  "R" ),("MPW1K/MIDIY" ,  0.947 ,  1 ,  "R" ,  0.960 ,  1 ,  "R" ,  0.922 ,  1 ,  "R" ),("MPW3LYP/6-31+G(d,p)" ,  0.980 ,  1 ,  "C" ,  0.994 ,  1 ,  "R" ,  0.955 ,  1 ,  "R" ),("MPW3LYP/6-311+G(2d,p)" ,  0.986 ,  1 ,  "R" ,  1.000 ,  1 ,  "R" ,  0.960 ,  1 ,  "R" ),("MPW3LYP/6-31G(d)" ,  0.976 ,  1 ,  "R" ,  0.990 ,  1 ,  "R" ,  0.951 ,  1 ,  "R" ),("MPW3LYP/ma-TZVP" ,  0.986 ,  1 ,  "R" ,  1.000 ,  1 ,  "R" ,  0.960 ,  1 ,  "R" ),("MPW3LYP/MG3S" ,  0.982 ,  1 ,  "C" ,  0.996 ,  1 ,  "R" ,  0.956 ,  1 ,  "R" ),("MPW74/6-311+G(d,p)" ,  0.912 ,  2 ,  "C" ,  0.888 ,  2 ,  "R" ,  0.925 ,  2 ,  "R" ),("MPW76/MG3S" ,  0.909 ,  2 ,  "C" ,  0.885 ,  2 ,  "R" ,  0.922 ,  2 ,  "R" ),("MPWB1K/6-31+G(d,p)" ,  0.951 ,  1 ,  "C" ,  0.964 ,  1 ,  "R" ,  0.926 ,  1 ,  "R" ),("MPWB1K/MG3S" ,  0.954 ,  1 ,  "C" ,  0.967 ,  1 ,  "R" ,  0.929 ,  1 ,  "R" ),("MPWLYP1M/ma-TZVP" ,  1.009 ,  1 ,  "R" ,  1.023 ,  1 ,  "R" ,  0.983 ,  1 ,  "R" ),("OreLYP/ma-TZVP" ,  1.010 ,  7 ,  "D" ,  1.024 ,  7 ,  "D" ,  0.984 ,  7 ,  "D" ),("OreLYP/def2-TZVP" ,  1.008 ,  7 ,  "D" ,  1.023 ,  7 ,  "D" ,  0.982 ,  7 ,  "D" ),("PBE/def2-TZVP" ,  1.011 ,  3 ,  "R" ,  1.026 ,  3 ,  "R" ,  0.985 ,  3 ,  "R" ),("PBE/MG3S" ,  1.010 ,  1 ,  "D" ,  1.025 ,  1 ,  "D" ,  0.985 ,  1 ,  "D" ),("PBE/ma-TZVP" ,  1.014 ,  1 ,  "D" ,  1.028 ,  1 ,  "D" ,  0.987 ,  1 ,  "D" ),("PBE0/MG3S" ,  0.975 ,  1 ,  "D" ,  0.989 ,  1 ,  "D" ,  0.950 ,  1 ,  "D" ),("PBE1KCIS/MG3" ,  0.981 ,  1 ,  "C" ,  0.995 ,  1 ,  "R" ,  0.955 ,  1 ,  "R" ),("PBE1KCIS/MG3S" ,  0.981 ,  1 ,  "C" ,  0.995 ,  1 ,  "R" ,  0.955 ,  1 ,  "R" ),("PM3" ,  0.940 ,  1 ,  "R" ,  0.953 ,  1 ,  "R" ,  0.916 ,  1 ,  "R" ),("PM6" ,  1.078 ,  1 ,  "R" ,  1.093 ,  1 ,  "R" ,  1.050 ,  1 ,  "R" ),("PW6B95/6-31+G(d,p)" ,  0.970 ,  1 ,  "C" ,  0.984 ,  1 ,  "R" ,  0.945 ,  1 ,  "R" ),("QCISD(FC)/6-31G(d)" ,  0.973 ,  1 ,  "R" ,  0.987 ,  1 ,  "R" ,  0.948 ,  1 ,  "R" ),("revTPSS/def2-TZVP" ,  0.998 ,  7 ,  "D" ,  1.012 ,  7 ,  "D" ,  0.972 ,  7 ,  "D" ),("revTPSS/ma-TZVP" ,  0.999 ,  7 ,  "D" ,  1.013 ,  7 ,  "D" ,  0.973 ,  7 ,  "D" ),("SOGGA/ma-TZVP" ,  1.017 ,  1 ,  "R" ,  1.031 ,  1 ,  "R" ,  0.991 ,  1 ,  "R" ),("tHCTHhyb/ma-TZVP" ,  0.989 ,  1 ,  "R" ,  1.003 ,  1 ,  "R" ,  0.963 ,  1 ,  "R" ),("TPSS1KCIS/def2-TZVP" ,  0.982 ,  1 ,  "R" ,  0.996 ,  1 ,  "R" ,  0.956 ,  1 ,  "R" ),("TPSS1KCIS/ma-TZVP" ,  0.983 ,  1 ,  "R" ,  0.997 ,  1 ,  "R" ,  0.957 ,  1 ,  "R" ),("TPSSh/MG3S" ,  0.984 ,  1 ,  "D" ,  1.002 ,  1 ,  "D" ,  0.963 ,  1 ,  "D" ),("VSXC/MG3S" ,  0.986 ,  1 ,  "D" ,  1.001 ,  1 ,  "D" ,  0.962 ,  1 ,  "D" ),("wB97/def2-TZVP", 0.969 ,  1 ,  "R" ,  0.983 ,  1 ,  "R" ,  0.944 ,  1 ,  "R" ),("wB97/ma-TZVP", 0.970 ,  1 ,  "R" ,  0.984 ,  1 ,  "R" ,  0.945 ,  1 ,  "R" ),("wB97X/def2-TZVP", 0.970 ,  1 ,  "R" ,  0.984 ,  1 ,  "R" ,  0.945 ,  1 ,  "R" ),("wB97X/ma-TZVP" , 0.971 ,  1 ,  "R" ,  0.985 ,  1 ,  "R" ,  0.946 ,  1 ,  "R" ),("wB97X-D/def2-TZVP", 0.975 ,  1 ,  "R" ,  0.989 ,  1 ,  "R" ,  0.950 ,  1 ,  "R" ),("wB97X-D/ma-TZVP", 0.975 ,  1 ,  "R" ,  0.989 ,  1 ,  "R" ,  0.950 ,  1 ,  "R" ),("wB97X-D/maug-cc-pVTZ", 0.974 ,  1 ,  "R" ,  0.988 ,  1 ,  "R" ,  0.949 ,  1 ,  "R" ),("X1B95/6-31+G(d,p)" ,  0.968 ,  1 ,  "C" ,  0.982 ,  1 ,  "R" ,  0.943 ,  1 ,  "R" ),("X1B95/MG3S" ,  0.971 ,  1 ,  "C" ,  0.985 ,  1 ,  "R" ,  0.946 ,  1 ,  "R" ),("XB1K/6-31+G(d,p)" ,  0.952 ,  1 ,  "C" ,  0.965 ,  1 ,  "R" ,  0.927 ,  1 ,  "R" ),("XB1K/MG3S" ,  0.955 ,  1 ,  "C" ,  0.968 ,  1 ,  "R" ,  0.930 ,  1 ,  "R" )], dtype=[('level', 'S30'),('zpe_fac', 'f4'), ('zpe_ref', 'i4'), ('zpe_meth', 'S1'), ('harm_fac', 'f4'), ('harm_ref', 'i4'), ('harm_meth', 'S1'), ('fund_fac', 'f4'), ('fund_ref', 'i4'), ('fund_meth', 'S1')])
