import { ITerraformDependable } from 'cdktf';
import { Construct } from 'constructs';
/**
 * @stability stable
 */
export interface ScalingConfig {
    /**
     * @stability stable
     */
    readonly desiredCapacity?: number;
    /**
     * @stability stable
     */
    readonly minCapacity?: number;
    /**
     * @stability stable
     */
    readonly maxCapacity?: number;
}
/**
 * @stability stable
 */
export declare enum CapacityType {
    /**
     * @stability stable
     */
    SPOT = "SPOT",
    /**
     * @stability stable
     */
    ON_DEMAND = "ON_DEMAND"
}
/**
 * @stability stable
 */
export interface NodeGroupBaseOptions {
    /**
     * nodegroup role arn.
     *
     * @default - The IAM role for the default nodegroup.
     * @stability stable
     */
    readonly nodeRole?: string;
    /**
     * scaling configuration for the nodegroup.
     *
     * @see https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/eks_node_group#scaling_config-configuration-block
     * @stability stable
     */
    readonly scalingConfig?: ScalingConfig;
    /**
     * capacity type of the nodegroup.
     *
     * @default CapacityType.ON_DEMAND
     * @stability stable
     */
    readonly capacityType?: CapacityType;
    /**
     * instance types of the nodegroup.
     *
     * @default ['t3.large']
     * @stability stable
     */
    readonly instanceTypes?: string[];
    /**
     * resources to depend on;
     *
     * @stability stable
     */
    readonly dependsOn?: ITerraformDependable[];
}
/**
 * @stability stable
 */
export interface NodeGroupOptions extends NodeGroupBaseOptions {
    /**
     * subnet IDs for the nodegroup.
     *
     * @stability stable
     */
    readonly subnets?: string[];
}
/**
 * @stability stable
 */
export interface NodeGroupProps extends NodeGroupBaseOptions {
    /**
     * cluster name.
     *
     * @stability stable
     */
    readonly clusterName: string;
    /**
     * subnet IDs for the nodegroup.
     *
     * @stability stable
     */
    readonly subnets: string[];
}
/**
 * @stability stable
 */
export declare class NodeGroup extends Construct {
    /**
     * @stability stable
     */
    readonly nodeGroupRoleArn: string;
    private readonly desiredCapacity;
    private readonly minCapacity;
    private readonly maxCapacity;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: NodeGroupProps);
    private _createNodeGroupRole;
}
