import setuptools

with open('README.md', 'r', encoding='utf-8') as readme_file:
    long_description = readme_file.read()

setuptools.setup(
    name = 'command_runner',
    # We may use find_packages in order to not specify each package manually
    # packages = ['command_runner'],
    packages = setuptools.find_packages(),
    version = '0.6.0',
    classifiers = [
        # command_runner is mature
        "Development Status :: 5 - Production/Stable",
        "Intended Audience :: Developers",
        "Topic :: Software Development",
        "Topic :: System",
        "Topic :: System :: Operating System",
        "Topic :: System :: Shells",
        "Programming Language :: Python",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: Implementation :: CPython",
        "Programming Language :: Python :: Implementation :: PyPy",
        "Operating System :: POSIX :: Linux",
        "Operating System :: POSIX :: BSD :: FreeBSD",
        "Operating System :: POSIX :: BSD :: NetBSD",
        "Operating System :: POSIX :: BSD :: OpenBSD",
        "Operating System :: Microsoft",
        "Operating System :: Microsoft :: Windows",
        "License :: OSI Approved :: BSD License",
    ],
    description = 'Platform agnostic command execution and privilege elevation',
    author = 'NetInvent - Orsiris de Jong',
    author_email = 'contact@netinvent.fr',
    url = 'https://github.com/netinvent/command_runner',
    keywords = ['shell', 'execution', 'subprocess', 'check_output', 'wrapper'],
    long_description=long_description,
    long_description_content_type="text/markdown",
    python_requires='>=2.7',
)