# Generated by Django 3.0 on 2021-02-24 14:38

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import phonenumber_field.modelfields
import sms_auth.utils


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='SMSMessage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('phone_number', models.CharField(max_length=20, verbose_name='Phone number')),
            ],
            options={
                'verbose_name': 'Sms log',
                'verbose_name_plural': 'Sms log',
            },
        ),
        migrations.CreateModel(
            name='PhoneCode',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('phone_number', phonenumber_field.modelfields.PhoneNumberField(max_length=128, region=None, unique=True)),
                ('code', models.PositiveIntegerField(default=sms_auth.utils.random_code)),
                ('valid_to', models.DateTimeField(default=sms_auth.utils.valid_to)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('owner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Phone code',
                'verbose_name_plural': 'Phone codes',
                'ordering': ('created_at',),
            },
        ),
    ]
