# 화이트라벨 서비스 소개

헥토파이낸셜 화이트라벨 서비스는 간편현금결제 및 신용카드로 온라인 결제수단을 지원하는 결제 서비스입니다.

# 표준 연동규격서

# 1\. 개요

## 1.1 목적

본 문서는 헥토파이낸셜에서 제공하는 화이트라벨 서비스 연동 개발에 필요한 기술적 이해를 돕고 상세 규격을 정의하기 위해 작성 되었습니다.

## 1.2 대상

본 문서는 헥토파이낸셜 화이트라벨 시스템을 통해 결제를 수행하기 위한 고객사 개발자를 대상으로 합니다.

## 1.3 문서 규격

다음은 본 문서에서 언급하는 연동상의 일반적인 사항에 대하여 설명합니다.

*   요청/응답 파라미터 중 필수 필드는 '●' 기호를 사용하며, 선택 필드는 '○' 기호를 사용합니다.
*   요청/응답 파라미터의 데이터 타입은 다음과 같습니다.
    *   N : 숫자 형식의 문자열
    *   A : 알파벳 형식의 문자열
    *   H : 한글 형식의 문자열
*   요청/응답 파라미터의 길이는 평문을 UTF-8 인코딩한 값(Byte)을 기준으로 합니다.

## 1.4 연동 프로세스

*   "6. 결제창 호출 (UI)" 을 참고하여 1번 인증 요청 UI 연동 호출을 하여 응답 받은 결과에 따라 "7. 결제 API (Non-UI)"를 참고하여 2번 결제 요청 API (NON-UI) 연동 호출하여 결제 진행

![화이트라벨 프로세스](/images/contents/docs/whitelabel_flow.PNG) ![화이트라벨 프로세스](/images/contents/docs/whitelabel_flow.PNG?ver=20220629)

# 2\. 표준결제창(UI) 연동

헥토파이낸셜에서 제공하는 화이트라벨 표준결제창 연동 방법에 대해 기술합니다.

## 2.1 요약 설명

*   기능별 요청 URI를 확인합니다.(\[[2.3 API URI](#item-432)\] 참고)
*   기능별 요청 전문을 확인하여, 요청파라미터를 세팅한 후 POST방식으로 요청합니다.
*   개인/민감정보 관련 파라미터는 암호화 해야합니다.(\[[5.중요 정보 보안](#item-424)\] 참고)
*   핵토파이낸셜 화이트라벨 결제창을 띄우고, 결제를 진행합니다.
*   결제 완료시 요청파라미터 nextUrl에 지정된 URL로 결과(응답파라미터)가 리턴됩니다.
*   사용자가 결제 도중 강제로 결제창을 종료할 시(결제창 'X'버튼), cancUrl 파라미터에 지정된 URL로 결과(응답 파라미터)가 리턴됩니다

## 2.2 주의 사항

*   **크롬, 엣지 브라우저만 지원합니다. 이 외 브라우저는 정상적으로 동작하지 않을 수 있습니다.**
*   **운영환경에서 상점아이디(mchtId)로 테스트 진행시 발생하는 비용은 가맹점 부담입니다.**
*   **요청은 POST method만을 사용합니다.**
*   **요청 파라미터는 연동규격서에 명시된 것만 사용하십시오. 그렇지 않을 경우 오류가 발생할 수 있습니다.**
*   **요청 파라미터에 :, &, ?, \`', new line, <, > 등의 특수문자 사용을 삼가 주십시오.**
*   **요청 파라미터에 이모지 사용을 삼가 주십시오. 이모지가 포함될 경우 사용자의 의도와 관계 없이 제거됩니다.**
*   **요청 및 응답 파라미터는 예고 없이 변동될 수 있어 고려해서 개발해야 합니다.**
*   **결제창 연동시 Iframe 사용하는 경우, 일부 브라우저나 기기에서 정상적으로 작동하지 않는 경우가 있으니, Iframe 사용을 삼가 주십시오.**
*   **nextUrl 파라미터**
    *   헥토파이낸셜 결제 완료시 호출되는 URL입니다. 응답파라미터가 POST방식으로 전달되며, 고객이 결제창을 강제로 종료하는 경우(브라우저 'X'버튼) 호출되지 않습니다. nextUrl은 인증결과를 전달하며 결제요청 결과 성공시에만 서비스를 제공해야 합니다.
*   **nextUrl, cancUrl 프로토콜**
    *   HTTP 사용시 브라우저 정책에 위반되어(cross-origin 등) 결제창이 정상적으로 동작하지 않을 수 있습니다.
    *   따라서 HTTPS 사용을 권장드립니다.

## 2.3 결제창 URI

헥토파이낸셜 화이트라벨 결제창(UI) 서버 도메인 이름은 다음과 같습니다.

 
| 구분  | 도메인 이름 |
| --- | --- |
| 테스트베드 | tbwl.settlebank.co.kr |
| 상용 환경 | wl.settlebank.co.kr |

헥토파이낸셜 화이트라벨 결제창(UI) API URI는 다음과 같습니다.

   
| 기능 구분 | 결제 수단 | URI | HTTP  <br>Method |
| --- | --- | --- | --- |
| 표준결제창 (UI) | 결제창 호출 | https://{domain}/whitelabel/main.do | POST |

## 2.4 요청 및 응답 헤더

 
| 구분  | 내용  |
| --- | --- |
| 요청  | Content-type=application/x-www-form-urlencoded; charset=UTF-8 |
| 응답  | Content-type=text/html; charset=UTF-8 |

## 2.5 요청 파라미터 검증

필수값 누락, HASH 데이터 불일치, 길이체크 등 파라미터 검증 후 이상이 있을 경우 아래와 같은 응답 코드를 반환합니다.

```
{
```

  
 

# 3\. API서버 연동 (Non-UI)

화이트라벨 취소API 서비스 연동 방법에 대해 기술합니다.

## 3.1 요약 설명

*   요청 전문을 확인 후, 해당되는 요청 파라미터를 세팅합니다.
*   Server to Server 로 HTTP Connection 하여 [JSON 데이터](#item-584)로 요청/응답합니다.
*   개인/민감정보 관련 파라미터는 암호화해야 합니다. (\[[5.중요 정보 보안](#item-424)\] 참고)

## 3.2 API URI

헥토파이낸셜 화이트라벨 API 서버 도메인 이름은 다음과 같습니다.

 
| 구분  | 도메인 이름 |
| --- | --- |
| 테스트베드 | tbapi.settlebank.co.kr |
| 상용 환경 | api.settlebank.co.kr |

API 서버 URI는 다음과 같습니다.

   
| 기능구분 | 서비스 | URI | HTTP  <br>Method |
| --- | --- | --- | --- |
| 결제 API  <br>(Non-UI) | 결제 요청 | https://{domain}/whitelabel/v1/pay\_confirm.do | POST |
| 취소 API  <br>(Non-UI) | 취소 요청 | https://{domain}/whitelabel/v1/pay\_cancel.do | POST |

## 3.3 요청 및 응답 헤더

 
| 구분  | 내용  |
| --- | --- |
| 요청  | Content-type=application/json; charset=UTF-8 |
| 응답  | Content-type=application/json; charset=UTF-8 |

## 3.4 JSON 요청 데이터 예시

다음은 결제 요청 전문 JSON 예시입니다.

```
{
```

    `"params"` `: {`  
        `"mchtId"` `:` `"pg_test"``,`  
        `"ver"` `:` `"0A18"``,`  
        `"method"` `:` `"WL"``,`  
        `"bizType"` `:` `"C4"``,`  
        `"encCd"` `:` `"23"``,`  
        `"mchtTrdNo"` `:` `"PG_API20231218085315"``,`  
        `"trdDt"` `:` `"20231218"``,`  
        `"trdTm"` `:` `"085315"``,`  
        `"mobileYn"` `:` `"N"``,`  
        `"osType"` `:` `"W"`  
  `},`  
  `"data"` `: {`  
        `"pktHash"` `:` `"197884af9f63bcd2d9792cd5cd39f7b1e7525e88888e2cee28f64fa23bf53312"``,`  
        `"mchtCustId"` `:` `"hecto01"``,`  
        `"orgTrdNo"` `:` `"STFP_PGCApg_test0000231218090723M1717578"``,`  
        `"trdAmt"` `:` `"vqIWIiimsJ5efjSJpfnnTw=="`  
  `}`  
`}`  
 

# 4\. 연동 서버

## 4.1 서버 IP 주소

다음은 헥토파이낸셜 서버의 IP주소입니다.

   
| 구분  |     | 도메인 이름 | IP주소 |
| --- | --- | --- | --- |
| 결제창(UI) | 테스트 베드 | tbwl.settlebank.co.kr | 61.252.169.78 |
| 상용 환경 | wl.settlebank.co.kr | 61.252.169.80(primary) |
| 14.34.14.38(secondary) |
| 취소 API서비스 (Non-UI) | 테스트 베드 | tbapi.settlebank.co.kr  <br>HTTPS(TCP/443) | 61.252.169.42 |
| 상용 환경 | api.settlebank.co.kr  <br>HTTPS(TCP/443) | 61.252.169.53(primary) |
| 14.34.14.21(secondary) |

*   헥토파이낸셜 PG차세대 시스템은 IDC센터 이중화 구성되어 있습니다.(상용 환경)  
    따라서 예고 없이 GLB시스템 운영으로 주센터와 보조센터 전환이 이루어질 수 있으며, DNS Lookup에 의한 접속을 권장하고 있습니다.  
    따라서 안내드린 2개의 공인 IP주소(상용)를 방화벽에서 접속허용 요청드리며, hosts파일 구성은 권장하지 않습니다.
*   만약 귀사의 내부 정책으로 인하여 hosts파일에 Domain주소를 고정설정으로 구성하시는 경우 헥토파이낸셜 IDC센터 전환시에는 아래와 같이 "#(코멘트) 표시된 IP주소"로 반드시 모든 서버의 hosts파일을 수작업으로 변경처리를 해야만 정상적으로 결제서비스를 이용하실 수 있습니다.
*   모든 통신은 HTTPS(TCP/443) 프로토콜을 사용하며, TLS 1.2 이상을 사용하여 접속하는것을 강력하게 권장드립니다. TLS 1.1 이하버전은 보안권고사항에 따라 사전에 통지 없이 지원이 중단 될 수 있습니다 

# 5\. 중요 정보 보안

## 5.1 개인정보 및 중요정보 암복호화 (암호화/복호화)

데이터 송수신 시 개인정보/중요정보 필드에 대해서는 다음과 같은 암복호화(암호화/복호화)를 수행해야 합니다.

   
| 구분  | 항목  | 적용  | 인코딩 |
| --- | --- | --- | --- |
| 개인정보 | 알고리즘 | AES-256/ECB/PKCS5Padding | Base64 Encoding |
| 대상 필드 | 거래금액, 고객명, 휴대폰번호, 이메일 등  <br>(암호화 대상 필드는 개별 API의 요청 필드 규격의 비고란에 명시됩니다.) |     |     |

## 5.2 개인정보 암호키

개인 정보 및 중요정보 암복호화시 키 정보는 운영 환경에 따라 다르며 다음과 같습니다.  
단순 연동 테스트용으로는 테이블 첫번째 항목을 사용하십시오. 이후 연동이 성공적으로 이루어지면 헥토파이낸셜에서 발급하는 고유 키를 사용하십시오.

 
| 구분  | 암복호화 키 |
| --- | --- |
| 테스트베드 키(테스트용 공용 키) | pgSettle30y739r82jtd709yOfZ2yK5K |
| 상용 환경 키(가맹점 고유 키) | 서비스 이행 시 별도 통보 |

## 5.3 위변조 방지 알고리즘

요청 데이터의 위변조 여부를 검증하기 위해 추가적으로 해쉬키 검증을 수행하며, 해쉬키 생성 알고리즘은 다음과 같습니다.

   
| 구분  | 항목  | 적용  | 인코딩 |
| --- | --- | --- | --- |
| 위변조 | 알고리즘 | SHA-256 | Hex Encoding |

## 5.4 해쉬생성 인증키

단순 연동 테스트용으로는 테이블 첫번째 항목을 사용하시고, 연동이 성공적으로 이루어지면 헥토파이낸셜에서 발급하는 고유 키를 사용하십시오.

 
| 구분  | 인증 키 |
| --- | --- |
| 테스트베드 키(테스트용 공용 키) | ST1009281328226982205 |
| 상용 환경 키(가맹점 고유 키) | 서비스 이행시 별도 통보 |

# 6\. 결제창 호출 (UI)

## 6.1 주의 사항

*   발행금액 파라미터 처리 기준 참고하시기 바랍니다.
    *   ex) 과세 가맹점에서 거래금액 1,000원을 다음과 같이 전송하는 경우
    *   1) 거래금액만 전송 : 과세 901, 부가세 99 로 처리
    *   2) 과세금액 900, 부가세금액 100 전송 : 과세 900, 부가세 100 으로 처리

## 6.2 요청 전문 (가맹점 → 헥토파이낸셜)

     
| 파라미터 | 이름  | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(10) | ●   | "pg\_test" |
| method | 결제수단 | 화이트라벨 결제 구분 코드 | AN(20) | ●   | "whitelabel"  <br>※ 고정값 |
| trdDt | 요청일자 | yyyyMMdd | N(8) | ●   | "20231218" |
| trdTm | 요청시간 | HH24MISS | N(6) | ●   | "100000" |
| mchtTrdNo | 상점주문번호 | 상점에서 생성하는 고유 주문번호  <br>※ 한글 제외 | AN(100) | ●   | "ORDER20211231100000" |
| pmtPrdtNm | 상품명 | 결제상품명 | AHN(300) | ●   | "테스트상품" |
| trdAmt | 거래금액 | 거래금액  <br>※ AES 암호화 | N(12) | ●   | "1000" |
| nextUrl | 결과화면 URL | 결제 후 결과 전달 및 이동페이지 URL | AN(250) | ●   | "https://example.com/nextUrl" |
| cancUrl | 결제취소 URL | 고객 강제 종료시 결과 전달 및 이동페이지 URL | AN(250) | ●   | "https://example.com/cancUrl" |
| mchtParam | 상점예약필드 | 기타 주문 정보를 입력하는 상점 예약 필드 | AHN(4000) | ○   | "name=HongGilDong&age=25" |
| email | 이메일 | 이메일 주소  <br>※ AES 암호화 | AN(60) | ○   | "HongGilDong@example.com" |
| mchtCustId | 상점고객아이디 | 상점에서 보내주는 고유 고객아이디 혹은 유니크키  <br>※ AES 암호화 | AN(100) | ●   | "HongGilDong" |
| taxTypeCd | 면세여부 | N:과세, Y:면세, G:복합과세  <br>공백일 경우 상점 설정에 따름 | A(1) | ○   | "N" |
| taxAmt | 과세금액 | 과세금액(복합과세일 경우 필수)  <br>※ AES 암호화 | N(12) | ○   | "909" |
| vatAmt | 부가세금액 | 부가세금액(복합과세일 경우 필수)  <br>※ AES 암호화 | N(12) | ○   | "91" |
| taxFreeAmt | 비과세금액 | 면세금액(복합과세일 경우 필수)  <br>※ AES 암호화 | N(12) | ○   | "0" |
| svcAmt | 봉사료 | 신용카드 봉사료  <br>※ AES 암호화 | N(12) | ○   | "10" |
| themeColorCd | 테마컬러 | 테마컬러 | AN(10) | ○   | "#630511" |
| custAcntSumry | 고객계좌적요 | 고객의 통장에 찍히는 인자명 | AHN(30) | ○   | "적요" |
| cupDepositAmt | 자원순환보증금 | 컵보증금 | N(12) | ○   | "0" |
| addDdtTypeCd | 현금영수증 추가공제구분 | 현금영수증 추가공제구분 | A(1) | ○   | "Y" : 대중교통  <br>"C" : 도서,공연비 |
| ciChkYn | CI 검증 여부 | 고객아이디 CI 검증 여부  <br>※ 사용(Y)시 고객아이디에 CI 입력 | A(1) | ○   | "N" |
| pktHash | hash데이터 | SHA256 방식으로 생성한 해쉬값  <br>\[[요청 전문 해쉬 코드](#item-772)\] 참고 | AN(200) | ●   | "f395b6725a9a18f2563ce34f8bc76698051d27c05e5ba815f463f00429061c0c" |

## 6.3 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash | 상점아이디 + 결제수단 + 상점주문번호 + 요청일자 + 요청시간 + 거래금액(평문) + 해쉬키 |

## 6.4 응답 전문 (헥토파이낸셜 → 가맹점)

   
화이트라벨 결제창에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의 합니다.

     
| 파라미터 | 이름  | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(10) | ●   | "pg\_test" |
| outStatCd | 거래상태 | 거래상태코드(성공/실패)  <br>0021:성공  <br>0031:실패 | AN(4) | ●   | "0021" |
| outRsltCd | 거절코드 | 거래상태가 "0031"일 경우, 상세 코드 전달  <br>\[[거절 코드 표](#item-544)\] 참고 | AN(4) | ●   | "0000" |
| outRsltMsg | 결과메세지 | 결과 메세지 전달  <br>URL Encoding, UTF-8 | AHN(200) | ●   | "성공" |
| mchtTrdNo | 상점주문번호 | 상점에서 생성하는 고유 주문번호  <br>※ 한글 제외 | AN(100) | ●   | "ORDER20211231100000" |
| mchtCustId | 상점고객아이디 | 보내주는 고유 고객아이디 혹은 유니크 키  <br>※ AES 암호화 | AN(100) | ○   | "HongGilDong" |
| trdNo | 거래번호 | 헥토파이낸셜 거래번호 | AN(40) | ●   | "STFP\_PGCApg\_test0000231218090723M1717578" |
| trdAmt | 거래금액 | 거래금액  <br>※ AES 암호화 | N(12) | ●   | "1000" |
| mchtParam | 상점예약필드 | 요청으로 받은 필드값을 응답으로 Bypass | AHN(4000) | ○   | "name=HongGilDong&age=25" |

   
 

# 7\. 결제 API (Non-UI)

## 7.1 요청 전문 (가맹점 → 헥토파이낸셜)

*   API URI
    *   테스트계 : https://tbapi.settlebank.co.kr/whitelabel/v1/pay\_confirm.do
    *   운영계 : https://api.settlebank.co.kr/whitelabel/v1/pay\_confirm.do

 

      
| 파라미터 |     | 이름  | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- | --- |
| params | mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(12) | ●   | "pg\_test" |
| ver | 버전  | 전문의 버전 | AN(4) | ●   | "0A18"  <br>※ 고정값 |
| method | 결제수단 | 결제수단 | A(2) | ●   | "WL"  <br>※ 고정값 |
| bizType | 업무구분 | 업무 구분코드 | AN(2) | ●   | "B9"  <br>※ 고정값 |
| encCd | 암호화 구분 | 암호화 구분 코드 | N(2) | ●   | "23"  <br>※ 고정값 |
| mchtTrdNo | 상점주문번호 | 상점에서 생성하는 고유한 주문번호 | AN(100) | ●   | "ORDER20211231100000" |
| trdDt | 요청일자 | 현재 전문을 전송하는 일자(YYYYMMDD) | N(8) | ●   | "20231218" |
| trdTm | 요청시간 | 현재 전문을 전송하는 시간(HHMMSS) | N(6) | ●   | "100000" |
| mobileYn | 모바일 여부 | Y:모바일웹/앱, N:PC 또는 그 외 | A(1) | ○   | "N" |
| osType | OS 구분 | A:Android, I:IOS, W:windows, M:Mac, E:기타  <br>공백:확인불가 | A(1) | ○   | "W" |
| data | pktHash | hash데이터 | SHA256 방식으로 생성한 해쉬값  <br>\[[요청 전문 해쉬 코드](#item-1053)\] 참고 | AN(200) | ●   | "f395b6725a9a18f2563ce34f8bc76698051d27c05e5ba815f463f00429061c0c" |
| mchtCustId | 상점고객아이디 | 상점 고객아이디 | AN(100) | ●   | "HongGilDong" |
| authTrdNo | 인증거래번호 | 헥토파이낸셜 거래번호 | AN(40) | ●   | "STFP\_PGCApg\_test0000231218090723M1717578" |
| trdAmt | 거래금액 | 거래금액  <br>※AES 암호화 | N(12) | ●   | "1000" |

## 7.2 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash | 요청일자 + 요청시간 + 상점아이디 + 상점주문번호 + 거래금액(평문) + 해쉬키 |

## 7.3 응답 전문 (헥토파이낸셜 → 가맹점)

      
| 파라미터 |     | 이름  | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- | --- |
| params | mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(12) | ●   | "pg\_test" |
| ver | 버전  | 전문의 버전 | AN(4) | ●   | "0A18"  <br>※ 고정값 |
| method | 결제수단 | 결제수단 | A(2) | ●   | "WL"  <br>※ 고정값 |
| bizType | 업무구분 | 업무 구분코드 | AN(2) | ●   | "B9"  <br>※ 고정값 |
| encCd | 암호화 구분 | 암호화 구분 코드 | N(2) | ●   | "23"  <br>※ 고정값 |
| mchtTrdNo | 상점주문번호 | 상점에서 생성하는 고유한 주문번호 | AN(100) | ●   | "ORDER20211231100000" |
| trdNo | 헥토파이낸셜거래번호 | 헥토파이낸셜에서 발급한 고유한 거래번호 | AN(40) | ●   | "STFP\_PGCApg\_test0000231218090723M1717578" |
| trdDt | 요청일자 | 현재 전문을 전송하는 일자(YYYYMMDD) | N(8) | ●   | "20231218" |
| trdTm | 요청시간 | 현재 전문을 전송하는 시간(HHMMSS) | N(6) | ●   | "100000" |
| outStatCd | 거래상태 | 거래상태코드(성공/실패)  <br>0021:성공  <br>0031:실패 | AN(4) | ●   | "0021" |
| outRsltCd | 거절코드 | 거래상태가 "0031"일 경우, 상세 코드 전달  <br>\[[거절 코드 표](#item-544)\] 참고 | AN(4) | ●   | "0000" |
| outRsltMsg | 결과메세지 | 결과 메세지 전달  <br>URL Encoding, UTF-8 | AHN(200) | ●   | "정상적으로 처리되었습니다." |
| data | pktHash | 해쉬값 | 요청시, hash 값 그대로 return | AN(64) | ●   |     |
| mchtCustId | 상점고객아이디 | 상점 고객아이디 | AN(100) | ●   | "HongGilDong" |
| authTrdNo | 인증거래번호 | 헥토파이낸셜 거래번호 | AN(40) | ●   | "STFP\_PGCApg\_test0000231218090723M1717578" |
| trdAmt | 거래금액 | 거래금액  <br>※AES 암호화 | N(12) | ●   | "1000" |
| payMethod | 업무구분코드 | CA:신용카드  <br>RP: 간편현금 | AN(2) | ●   | "CA" |     |
| fnNm | 카드사명 | 결제한 카드사명 | HA(20) | ○   | (신용카드 전용) "국민" |     |
| fnCd | 카드사코드 | 결제한 카드사 코드 | AN(4) | ○   | (신용카드 전용) "KBC" |     |
| svcDivCd | 간편현금  <br>연동구분 | 1:펌뱅킹, 2:오픈뱅킹 | N(1) | ○   | (간편현금 전용) "1" |     |

## 7.4 응답 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash | 거래상태코드 + 요청일자 + 요청시간 + 상점아이디 + 상점주문번호 + 거래금액 + 해쉬키 |

# 8\. 취소 API (Non-UI)

## 8.1 요청 전문 (가맹점 → 헥토파이낸셜)

*   API URI
    *   테스트계 : https://tbapi.settlebank.co.kr/whitelabel/v1/pay\_cancel.do
    *   운영계 : https://api.settlebank.co.kr/whitelabel/v1/pay\_cancel.do
*   간편현금결제 취소 시 출금된 계좌로 환불(입금)됩니다.

  
가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

      
| 파라미터 |     | 이름  | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- | --- |
| params | mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(12) | ●   | "pg\_test" |
| ver | 버전  | 전문의 버전 | AN(4) | ●   | "0A18"  <br>※ 고정값 |
| method | 결제수단 | 결제수단 | A(2) | ●   | "WL"  <br>※ 고정값 |
| bizType | 업무구분 | 업무 구분코드 | AN(2) | ●   | "C4"  <br>※ 고정값 |
| encCd | 암호화 구분 | 암호화 구분 코드 | N(2) | ●   | "23"  <br>※ 고정값 |
| mchtTrdNo | 상점주문번호 | 상점에서 생성하는 고유한 주문번호 | AN(100) | ●   | "ORDER20211231100000" |
| trdDt | 취소요청일자 | 현재 전문을 전송하는 일자(YYYYMMDD) | N(8) | ●   | "20231218" |
| trdTm | 취소요청시간 | 현재 전문을 전송하는 시간(HHMMSS) | N(6) | ●   | "100000" |
| mobileYn | 모바일 여부 | Y:모바일웹/앱, N:PC 또는 그 외 | A(1) | ○   | "N" |
| osType | OS 구분 | A:Android, I:IOS, W:windows, M:Mac, E:기타, 공백:확인불가 | A(1) | ○   | "W" |
| data | pktHash | hash데이터 | SHA256 방식으로 생성한 해쉬값  <br>\[[요청 전문 해쉬 코드](#item-441)\] 참고 | AN(200) | ●   | "f395b6725a9a18f2563ce34f8bc76698051d27c05e5ba815f463f00429061c0c" |
| mchtCustId | 상점고객아이디 | 상점 고객아이디 | AN(100) | ●   | "HongGilDong" |
| orgTrdNo | 원거래번호 | 결제 시, 헥토파이낸셜에서 발급한 거래번호 | AN(40) | ●   | "STFP\_PGCApg\_test0000231218090723M1717578" |
| taxTypeCd | 면세여부 | Y:면세, N:과세, G:복합과세. 공백일 경우 상점 기본 정보에 따름. | A(1) | ○   | "N" |
| trdAmt | 거래금액 | 거래금액  <br>※AES 암호화 | N(12) | ○   | "1000" |
| taxAmt | 과세금액 | 취소금액 중 과세금액(복합과세인 경우 필수)  <br>※ AES 암호화 | N(12) | ○   | "909" |
| vatAmt | 부가세금액 | 취소금액 중 부가세금액(복합과세인 경우 필수)  <br>※ AES 암호화 | N(12) | ○   | "91" |
| taxFreeAmt | 비과세금액 | 취소금액 중 면세금액(복합과세인 경우 필수)  <br>※ AES 암호화 | N(12) | ○   | "0" |
| svcAmt | 봉사료 | 취소금액 중 봉사료  <br>※ AES 암호화 | N(12) | ○   | "0" |
| crcCd | 통화구분 | 통화 구분 값 | A(3) | ○   | (신용카드 전용) 필수 - "KRW" |
| cnclOrd | 취소회차 | 001부터 시작. 부분취소 2회차의 경우 002 | N(3) | ○   | (신용카드 전용) 필수 - "001" |

## 8.2 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash | 취소요청일자 + 취소요청시간 + 상점아이디 + 상점주문번호 + 취소금액(평문) + 해쉬키 |

## 8.3 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의합니다.

      
| 파라미터 |     | 이름  | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- | --- |
| params | mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(12) | ●   | "pg\_test" |
| ver | 버전  | 전문의 버전 | AN(4) | ●   | "0A18"  <br>※ 고정값 |
| method | 결제수단 | 결제수단 | A(2) | ●   | "WL"  <br>※ 고정값 |
| bizType | 업무구분 | 업무 구분코드 | AN(2) | ●   | "C4"  <br>※ 고정값 |
| encCd | 암호화 구분 | 암호화 구분 코드 | N(2) | ●   | "23"  <br>※ 고정값 |
| mchtTrdNo | 상점주문번호 | 상점에서 생성하는 고유한 주문번호 | AN(100) | ●   | "ORDER20211231100000" |
| trdNo | 헥토파이낸셜 거래번호 | 헥토파이낸셜에서 생성하는 고유한 거래번호 | AN(40) | ●   | "STFP\_PGCApg\_test0000231218092215M1103678" |
| trdDt | 취소응답일자 | 현재 응답 전문을 전송하는 일자(YYYYMMDD) | N(8) | ●   | "20231218" |
| trdTm | 취소응답시간 | 현재 응답 전문을 전송하는 시간(HHMMSS) | N(6) | ●   | "100000" |
| outStatCd | 거래상태 | 거래상태코드(성공/실패)  <br>0021:성공  <br>0031:실패 | AN(4) | ●   | "0021" |
| outRsltCd | 거절코드 | 거래상태가 "0031"일 경우, 상세 코드 전달  <br>\[[거절 코드 표](#item-544)\] 참고 | AN(4) | ●   | "0000" |
| outRsltMsg | 결과메세지 | 결과 메세지 전달  <br>URL Encoding, UTF-8 | AHN(200) | ●   | "정상적으로 처리되었습니다." |
| data | pktHash | 해쉬값 | 요청시, hash 값 그대로 return | AN(64) | ●   |     |
| mchtCustId | 상점고객아이디 | 상점 고객아이디 | AN(100) | ●   | "HongGilDong" |
| payMethod | 업무구분코드 | 업무구분코드 | A(2) | ●   | "RT" : 간편결제취소  <br>"CA" : 신용카드취소 |
| orgTrdNo | 원거래번호 | 결제 시, 헥토파이낸셜에서 발급한 거래번호 | AN(40) | ●   | "STFP\_PGCApg\_test0000231218090723M1717578" |
| taxTypeCd | 면세여부 | Y:면세, N:과세, G:복합과세. 공백일 경우 상점 기본 정보에 따름. | A(1) | ○   | "N" |
| trdAmt | 거래금액 | 거래금액  <br>※AES 암호화 | N(12) | ○   | "1000" |
| taxAmt | 과세금액 | 취소금액 중 과세금액(복합과세인 경우 필수)  <br>※ AES 암호화 | N(12) | ○   | "909" |
| vatAmt | 부가세금액 | 취소금액 중 부가세금액(복합과세인 경우 필수)  <br>※ AES 암호화 | N(12) | ○   | "91" |
| taxFreeAmt | 비과세금액 | 취소금액 중 면세금액(복합과세인 경우 필수)  <br>※ AES 암호화 | N(12) | ○   | "0" |
| svcAmt | 봉사료 | 취소금액 중 봉사료  <br>※ AES 암호화 | N(12) | ○   | "0" |
| crcCd | 통화구분 | 통화 구분 값 | A(3) | ○   | (신용카드 전용) |
| cnclOrd | 취소회차 | 001부터 시작. 부분취소 2회차의 경우 002 | N(3) | ○   | (신용카드 전용) |
| cardCnclAmt | 신용카드취소금액 | 신용카드 거래금액  <br>※ AES 암호화 | N(12) | ○   | (신용카드 전용) "0" |
| blcAmt | 취소가능잔액 | 취소가능잔액  <br>※ AES 암호화 | N(12) | ○   | "0" |
| pktNo | 전문번호 | 전문번호 | AN(20) | ○   | (간편현금결제 전용) |

## 8.4 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash | 거래상태코드 + 취소응답일자 + 취소응답시간 + 상점아이디 + 상점주문번호 + 거래금액(평문) + 해쉬키 |

# 9\. 실시간 거래 조회 API (Non-UI)

## 9.1 연동 방법

*   요청 전문을 확인하셔서 파라미터를 세팅합니다.
*   Server to Server로 HTTP Connection 하여 JSON데이터 ([34.4 JSON 요청 데이터 예시](#item-947))로 POST 요청합니다.

#### 결제수단 별 단건 거래상태 조회

*   원 거래 일자는 조회하고자 하는 원 거래 번호의 요청 당시 일자를 입력 (해당 거래일 기준 전일 ~ 익일 사이 거래 건 조회)
*   원 거래 번호가 확인이 되는 경우 원 거래 번호를 추가 전달

## 9.2 API URI

 
| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tbgw.settlebank.co.kr/spay/APITrdcheck.do |
| 상용 환경 | https://gw.settlebank.co.kr/spay/APITrdcheck.do |

## 9.3 요청 및 응답 헤더

 
| 구분  | 내용  |
| --- | --- |
| 요청  | Content-type=application/json; charset=UTF-8 |
| 응답  | Content-type=application/json; charset=UTF-8 |

## 9.4 JSON 요청 데이터 예시

```
{
"params" : {
"mchtId" : "pg_test",
"ver" : "0A1M",
"mchtTrdNo" : "WL_Info_20210806075154649",
"trdDt" : "20210806",
"trdTm" : "080101"
},
"data" : {
"pktHash" : "996E651D9435700D54E0D69B5726B5489AD0691C3FC86BE572314D39A2AE8B6D",
"method" : "WL",
"trdAmt" : "500",
"orgTrdDt" : "20210806",
"orgMchtTrdNo" : "WL_Pay_20210806075154648",
"orgTrdNo" : "STFP_PGCApg_test00210806075210M1853381"
}
}
```

## 9.5 요청 전문 (가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

      
| 파라미터 |     | 이름  | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- | --- |
| params | mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(12) | ●   | "nx\_mid\_il" |
| ver | 버전  | 전문의 버전 | AN(4) | ●   | "0A1M"  <br>※ 고정값 |
| mchtTrdNo | 상점주문번호 | 상점에서 생성하는 고유한 거래번호 | AN(100) | ●   | "ORDER20211231100000" |
| trdDt | 요청일자 | 현재 전문을 전송하는 일자(YYYYMMDD) | N(8) | ●   | "20211231" |
| trdTm | 요청시간 | 현재 전문을 전송하는 시간(HHMMSS) | N(6) | ●   | "100000" |
| data | pktHash | hash데이터 | SHA256 방식으로 생성한 해쉬값  <br>\[[요청 전문 해쉬 코드](#item-948)\] 참고 | AN(200) | ●   | "f395b6725a9a18f2563ce34f8bc76698051d27c05e5ba815f463f00429061c0c" |
| method | 결제수단 | 결제수단 2자리  <br>\[[결제수단 코드](#item-951)\] 참고 | A(2) | ●   | "WL" |
| trdAmt | 거래금액 | 거래금액  <br>1,000원 -> 1000 | N(12) | ●   | "1000" |
| orgTrdDt | 원 거래 일자 | 원거래 결제 요청시 요청일자  <br>(YYYYMMDD) | N(8) | ●   | "20211231" |
| orgMchtTrdNo | 원거래 상점주문번호 | 원 거래의 상점주문번호 | AN(100) | ●   | "ORDER20211231100000" |
| orgTrdNo | 원 거래 번호 | 결제 시, 헥토파이낸셜에서 발급한 거래번호 | AN(40) | ○   | "STFP\_PGCAnxca\_jt\_il0211129135810M1494620" |

## 9.6 응답 전문 (헥토파이낸셜 → 가맹점)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

      
| 파라미터 |     | 이름  | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- | --- |
| params | mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(12) | ●   | "nx\_mid\_il" |
| ver | 버전  | 전문의 버전 | AN(4) | ●   | "0A1M"  <br>※ 고정값 |
| mchtTrdNo | 상점주문번호 | 요청시의 주문번호 bypass | AN(100) | ●   | "ORDER20211231100000" |
| trdNo | 거래번호 | 헥토파이낸셜 거래번호 | AN(40) | ●   | "STFP\_PGHMnx\_mid\_il00220623130711M1872705" |
| trdDt | 요청일자 | 현재 전문을 전송하는 일자(YYYYMMDD) | N(8) | ●   | "20211231" |
| trdTm | 요청시간 | 현재 전문을 전송하는 시간(HHMMSS) | N(6) | ●   | "100000" |
| outStatCd | 거래상태코드 | 0021:성공, 0031:실패  <br>(성공건 확인: 거래상태=0021 + 결과코드=0000) | N(4) | ●   | "0000" |
| outRsltCd | 결과코드 | 결과 코드  <br>0000 : 정상거래(가상계좌는 입금성공을 의미)  <br>0001 : 취소상태(가상계좌는 환불상태를 의미)  <br>0009 : 결제실패(결제실패내역 존재)  <br>그 외 \[[거절 코드 표\]](#item-544) 참고 | AN(4) | ●   | "0000" |
| outRsltMsg | 결과메세지 | 결과메세지 | AHN(200) | ●   | "정상거래" |
| data | pktHash | 해쉬값 | 요청시, hash 값 그대로 return | AN(64) | ●   |     |
| method | 결제수단 | 결제수단 2자리  <br>\[[결제수단 코드\]](#item-951) 참고 | A(2) | ●   | "WL" |
| trdAmt | 거래금액 | 거래금액 | N(12) | ●   | "1000" |
| cnclAmt | 취소금액 | 취소금액  <br>※ 취소 건 미존재 시 0원 | N(12) | ○   | "1000" |

## 9.7 결제수단 코드

결제수단 코드는 다음과 같습니다.

   
| 코드  | 결제수단 |
| --- | --- |
| WL  | 화이트라벨 |

# 10\. 기타

## 10.1 거절코드 표

※ 사용하시는 결제수단(간편현금결제, PG)에 따라서 같은 응답코드의 응답 메시지가 상이할 수 있습니다.  
    아래 응답코드를 모두 참고해주십시오.

*   화이트라벨 전용 응답 코드  
     
    
       
    | 코드  | 내용  | 코드  | 내용  |
    | --- | --- | --- | --- |
    | 0000 | 정상처리 | 0009 | 사용자 취소 |
    | 1001 | 결제요청 정보 누락(상점아이디) | 1002 | 결제요청 정보 누락(요청일자) |
    | 1003 | 결제요청 정보 누락(요청시간) | 1004 | 결제요청 정보 누락(상점주문번호) |
    | 1005 | 결제요청 정보 누락(거래금액) | 1006 | 결제요청 정보 누락(결과화면 URL) |
    | 1007 | 결제요청 정보 누락(결제취소 URL) | 1008 | 결제요청 정보 누락(상점고객아이디) |
    | 1009 | 결제요청 정보 누락(이메일) | 1010 | 결제요청 정보 누락(hash 데이터) |
    | 1011 | 결제요청 정보 누락(상품명) | 1101 | 결제 요청 정보 길이 오류(상점아이디) |
    | 1102 | 결제 요청 정보 길이 오류(요청일자) | 1103 | 결제 요청 정보 길이 오류(요청시간) |
    | 1104 | 결제 요청 정보 길이 오류(상점주문번호) | 1105 | 결제 요청 정보 길이 오류(거래금액) |
    | 1106 | 결제 요청 정보 길이 오류(결과화면 URL) | 1107 | 결제 요청 정보 길이 오류(결제취소 URL) |
    | 1108 | 결제 요청 정보 길이 오류(상점고객아이디) | 1109 | 결제 요청 정보 길이 오류(hash 데이터) |
    | 1110 | 결제 요청 정보 길이 오류(상점명) | 1111 | 결제 요청 정보 길이 오류(상점 예약필드) |
    | 1112 | 결제 요청 정보 길이 오류(이메일) | 1113 | 결제 요청 정보 길이 오류(면세여부) |
    | 1114 | 결제 요청 정보 길이 오류(과세금액) | 1115 | 결제 요청 정보 길이 오류(부가세금액) |
    | 1116 | 결제 요청 정보 길이 오류(비과세금액) | 1117 | 결제 요청 정보 길이 오류(봉사료금액) |
    | 1118 | 결제 요청 정보 길이 오류(상품명) | 1119 | 결제 요청 정보 길이 오류(통장인자내용) |
    | 1120 | 결제 요청 정보 길이 오류(자원순환보증금) | 1121 | 결제 요청 정보 길이 오류(현금영수증추가공제구분) |
    | 1122 | 결제 요청 정보 길이 오류(CI검증여부) | 1901 | 해쉬값 불일치 오류 |
    | 1902 | 암호화 항목 미처리 오류 | 2005 | 비밀번호 검증 실패 |
    | 2010 | 고객 서비스 해지 | 5001 | token null |
    | 5002 | token expired | 5003 | token encoding error |
    | 5004 | token parse error | 5005 | token mapping error |
    | 5006 | token io error | 6001 | 유효하지 않은 요청 전문 |
    | 9002 | 결제창옵션 조회 오류 | 9003 | 결제창배너 조회 오류 |
    | 9004 | 약관리스트 조회 오류 | 9005 | 공지사항 조회 오류 |
    | 9006 | 제휴할인 조회 오류 | 9007 | 결제정보 조회 오류 |
    | 9901 | 게이트웨이 요청 전문 오류 | 9902 | 게이트웨이 응답 전문 오류 |
    | 9903 | 게이트웨이 요청오류 | 9904 | 게이트웨이 응답오류 |
    | 9905 | 게이트웨이 시스템 오류 | 9999 | 내부 시스템 오류 |
    | WL01 | 일정 시간 동안 10회 이상 동일한 IP로 인증을  <br>시도하여 15분 간 인증이 제한됩니다.  <br>잠시 후 다시 시도해 주세요. | WL02 | 고객 정보가 유효하지 않습니다.  <br>본인인증 하신 개인정보를 확인해 주세요. |
    | 9998 | 서비스 사용 해지한 사용자가 잘못된 경로로 접근하였습니다. |     |     |
    
      
     
*   간편현금결제 응답 코드  
      
    ※ 최신 공통 거절코드는 [공통거절코드](https://develop.sbsvc.online/22/bbsList.do?tx=R&articleSeq=522)에서 다운로드 받으실 수 있습니다.
    
       
    | 코드  | 내용  | 코드  | 내용  |
    | --- | --- | --- | --- |
    | 0021 | 성공  | 0031 | 실패  |
    | ST01 | 존재하지 않는 계좌 | ST02 | 유효하지 않는 계좌 |
    | ST03 | 이중출금 발생 | ST04 | VAN 요청중 시스템 에러 |
    | ST05 | VAN 응답정보 없음 | ST06 | 거래번호 정보가 없음 |
    | ST07 | 통신장애 | ST08 | 이미 등록된 계좌 |
    | ST09 | 유효하지않는 요청전문 | ST10 | 내부 시스템 에러 |
    | ST11 | 은행점검 시간 | ST12 | 출금계좌 잔액부족 |
    | ST13 | ARS인증 결과가 없음 | ST14 | ARS 인증 요청 값이 상이함 |
    | ST15 | 자동이체 해지계좌 | ST16 | 출금계좌 거래제한 |
    | ST17 | 주민번호 사업자번호 오류 | ST18 | 계좌오류  <br>(간편계좌등록 불가) |
    | ST19 | 기타거래불가 | ST20 | 계좌오류 |
    | ST21 | 수취인 계좌 없음 | ST22 | 법적제한 계좌 |
    | ST23 | 비실명 계좌 | ST24 | 예금주 불일치 |
    | ST25 | 이미 취소된 거래 | ST26 | 취소금액 오류 |
    | ST27 | ARS인증 실패 | ST28 | ARS수신불가 |
    | ST29 | 계좌 등록 진행 중 | ST30 | 환불 진행 중 |
    | ST31 | 이중 송금 발생 | ST32 | 납부자 성명조회 실패 |
    | ST33 | 1회 한도 초과 | ST34 | 1일 한도 초과 |
    | ST35 | 사고계좌입니다 | ST36 | 일정시간이 지나 연결이 끊어졌습니다. |
    | ST37 | 간편결제 취소 | ST38 | 요청 진행 중 |
    | ST39 | 환불 중복 요청 | ST40 | 처리 중 요청이 있음 |
    | ST41 | 서비스 용량초과 | ST42 | 시스템 BUSY |
    | ST43 | 이미 등록된 계좌입니다. | ST44 | 거래불가은행 |
    | ST50 | 중복전문 요청 | ST51 | 이미등록된 현금영수증 사용자 |
    | ST52 | 미등록 현금영수증 사용자 | ST53 | 이미 해지된 계좌 |
    | ST60 | 거래실패 | ST61 | 1회한도 금액초과 |
    | ST62 | 일한도 금액초과 | ST63 | 월한도 금액초과 |
    | ST64 | 일한도 건수 초과 | ST65 | 월한도 건수 초과 |
    | ST66 | 비밀번호 등록 실패 | ST67 | 비밀번호 불일치 |
    | ST68 | 서비스 이용정지 | ST69 | 정책상 해당 결제서비스를 이용할 수 없습니다.  <br>다른 결제수단으로 이용 부탑드립니다. |
    | ST70 | 정책상 해당 결제서비스를 이용할 수 없습니다.  <br>헥토파이낸셜 고객센터로 문의 바랍니다. (1600-5220) | ST72 | 결제시 ARS 2차인증 필요 |
    | ST86 | 인증 실패입니다. (휴대폰 본인인증) | ST87 | 간편본인확인 미가입자 입니다. (휴대폰 본인인증) |
    | VTIM | 중계기관 TIMEOUT | ST99 | 간편결제 시스템 점검중 |
    | SE01 | 인증 유효 시간이 만료되었습니다. | SE02 | 인증 번호가 불일치합니다. |
    | SE03 | 인증확인 허용횟수를 초과하였습니다. |     |     |
    
      
     
*   PG 공통 응답 코드  
     
    
       
    | 코드  | 내용  | 코드  | 내용  |
    | --- | --- | --- | --- |
    | ST01 | 고객정보 없음 | STR1~STR8 | 내부 정책 |
    | ST06 | 거래정보 없음 | ST03 | 기 결제건 |
    | ST08 | 이미 등록된 계좌입니다 | ST07 | 유효하지 않은 전문 |
    | ST09 | 유효하지 않은 요청전문 | ST10 | 내부 시스템 오류 |
    | ST11 | 원천사 점검 시간 | ST13 | 인증내역 없음 |
    | ST19 | 기타 거래 불가 | ST24 | 예금주 불일치 |
    | ST25 | 중복 취소 요청 | ST26 | 취소 정보 오류 |
    | ST30 | 인증 시간 만료 | ST32 | 예금주 성명 오류 |
    | ST38 | 처리 진행 중 | ST39 | 환불 중복 요청 |
    | ST41 | 트래픽 과다 | ST44 | 원천사 정보 오류 |
    | ST45 | 취소 실패 | ST46 | 취소기간 경과 |
    | ST47 | 미등록 상점 | ST48 | 미등록 가맹점 |
    | ST50 | 중복요청 | ST54 | 부분취소 불가 |
    | ST55 | 복합과세 금액 불일치 | ST56 | 취소회차 오류 |
    | ST57 | 취소금액(환불금액)이 원거래금액을 초과합니다. | ST58 | 취소요청금액이 원거래금액과 일치하지 않습니다. |
    | ST60 | 비정상 처리 | ST68 | 서비스 중지 |
    | ST69 | 서비스 불가 | ST70 | 정책 차단 |
    | ST79 | 시스템 오류 | ST90~ST97 | 결제 수단별 개별 정의 |
    | ST99 | 기타 오류 | VTIM | 원천사 타임아웃 |
    | 3007 | 취소 한도 초과 |     |     |
    
      
     
*   신용카드 응답 코드  
     
    
       
    | 코드  | 내용  | 코드  | 내용  |
    | --- | --- | --- | --- |
    | CA01 | 원천사 점검 | CA02 | 원천사 장애 |
    | CA03 | 전문 유효성 체크 | CA04 | 결제 중계사 장애 |
    | CA10 | 거래정보 없음 | CA11 | 기매입 거래 |
    | CA12 | 기취소 거래 | CA13~CA19 | 요청정보 오류 |
    | CA20 | 카드 유효기간이 유효하지 않습니다. | CA21~CA23 | 할부 관련 오류 |
    | CA26 | 사용횟수 초과 | CA27~CA29 | 비밀번호 관련 오류 |
    | CA30 | 식별번호 오류 | CA31~CA37 | 한도 관련 오류 |
    | CA38 | 포인트한도 미달로 거래 불가 | CA40~CA41 | 거래금액 오류 |
    | CA42 | 1000원 미만 99,999,999원 이상 금액 거래 불가 | CA50~CA57 | 카드상태 오류 |
    | CA58 | 미등록 카드입니다. 카드사로 문의해 주세요. | CA60~CA64 | 가맹점상태 오류 |
    | CA59 | 법인카드는 거래가 불가능합니다. | J999 | 카드사 전화 요망 |
    | CA65 | 인증거래미약정가맹점 | CA70 | 식별번호(생년월일/사업자번호)+비밀번호가 유효하지 않음 |
    | CA75 | 공동인증서 인증정보가 유효하지 않습니다. | CA80 | 서비스 불가 거래 |
    | CA81 | 거래 처리 중 오류 발생 | 0905 | 본인확인요망 |
    | CA82 | 카드사 전화 요망 | CA83 | 해당 거래는 취소가 불가합니다. |
    | CA84 | 기타 오류가 발생하였습니다. | CA85 | 취소거래 처리 시 오류가 발생하였습니다. |
    | CA86 | 이중 거래 입니다. | CA87 | 가맹점 번호가 유효하지 않습니다. |
    | CA88 | 해당 선불카드(기프트카드)는 부분취소가 불가합니다. | 8373 | 카드사 전화 요망 |
    | 8375 | 기타 에러 처리 |     |     |
    

## 10.2 금융기관 식별자

신용카드 고유 식별 코드는 다음과 같습니다.

   
| 신용카드사 코드 | 신용카드사 명 | 신용카드사 코드 | 신용카드사 명 |
| --- | --- | --- | --- |
| BCC | 비씨  | KBC | 국민  |
| HNC | 하나(외환) | SSC | 삼성  |
| SHN | 신한  | WRI | 우리  |
| HDC | 현대  | LTC | 롯데  |
| 007 | 수협  | NHC | NH농협 |
| 035 | 제주  | 034 | 광주  |
| 037 | 전북  | 027 | 시티  |
| 218 | KB증권 | 050 | 저축은행 |
| 071 | 우체국 | 048 | 신협  |
| 002 | 산업  | 090 | 카카오뱅크 |
| 089 | 케이뱅크 | KBP | KBPay |
| SSP | 삼성페이 |     |     |

  
금융기관 고유 식별 코드는 다음과 같습니다.

   
| 금융기관 코드 | 금융기관 명 | 금융기관 코드 | 금융기관 명 |
| --- | --- | --- | --- |
| 002 | 산업은행 | 088 | 신한은행 |
| 003 | 기업은행 | 089 | K뱅크 |
| 092 | 토스뱅크 | 271 | 토스증권 |
| 004 | 국민은행 | 090 | 카카오뱅크 |
| 005 | 외환은행 | 209 | 유안타증권 |
| 007 | 수협은행/수협중앙회 | 218 | KB증권 |
| 011 | NH농협 | 238 | 미래에셋증권 |
| 012 | 농협중앙회 | 240 | 삼성증권 |
| 020 | 우리은행 | 243 | 한국투자증권 |
| 023 | SC 제일은행 | 247 | NH 투자증권 |
| 027 | 한국씨티은행 | 261 | 교보증권 |
| 031 | iM뱅크(대구은행) | 262 | 하이투자증권 |
| 032 | 부산은행 | 263 | 현대차투자증권 |
| 034 | 광주은행 | 264 | 키움증권 |
| 035 | 제주은행 | 265 | 이베스트투자증권 |
| 037 | 전북은행 | 266 | SK 증권 |
| 039 | 경남은행 | 267 | 대신증권 |
| 045 | 새마을금고중앙회 | 269 | 한화투자증권 |
| 048 | 신협중앙회 | 270 | 하나금융투자 |
| 050 | 상호저축은행 | 278 | 신한금융투자 |
| 054 | HSBC 은행 | 279 | 동부증권 |
| 055 | 도이치은행 | 280 | 유진투자증권 |
| 057 | 제이피모간체이스은행 | 287 | 메리츠종합금융증권 |
| 060 | BOA은행 | 290 | 부국증권 |
| 062 | 중국공상은행 | 291 | 신영증권 |
| 064 | 산림조합중앙회 | 292 | 케이프투자증권 |
| 071 | 우체국 | 103 | SBI 저축은행 |
| 081 | KEB 하나은행 |     |     |

## 10.3 은행 정기점검 시간

상기 업무시간은 은행별 업무시간으로 헥토파이낸셜에서는 **01:00 ~ 23:30 사이 거래를 권장**드립니다.  
은행별로 점검시간은 연장될 수 있습니다.  
  
 

| 금융기관코드 | 금융기관명 | 은행점검시간 | 헥토파이낸셜 업무시간 |     | 정기 점검 |
| --- | --- | --- | --- | --- | --- |
| 업무 중단시간 | 업무 개시시간 |
| --- | --- | --- | --- | --- | --- |
| 002 | 산업은행 | 23:30~00:30 | 23:50 | 00:15 | 매월 2번째 일요일 00:00~04:00 |
| 003 | 기업은행 | 24:00~00:30 | 23:50 | 00:12 | 매주 일요일 00:00~00:30 |
| 004 | 국민은행 | 24:00~00:30 | 23:50 | 00:12 | 매월 3번째 일요일  <br>00:00~00:30, 05:00~05:30  <br>대외계 01:00~06:00 (간헐적 거래안됨) |
| 007 | 수협은행/수협중앙회 | 23:50~00:30 | 23:30 | 00:30 | 없음  |
| 011 | 농협은행 | 24:00~00:30 | 23:50 | 00:12 | 매월 3번째 월요일 00:00~04:00  <br>(해당일 공유일일 경우, 익영업일) |
| 020 | 우리은행 | 23:50~00:30 | 23:50 | 00:10 | 매월 2번째 일요일 02:00~06:00  <br>(작업일자는 은행에서 사전공지) |
| 023 | SC 제일은행 | 23:30~00:30 | 23:50 | 00:12 | 없음  |
| 027 | 한국씨티은행 | 23:40~00:30 | 23:50 | 00:30 | 매일 00:30~04:30 |
| 031 | iM뱅크(대구은행) | 23:40~00:30 | 23:50 | 00:05 | 없음  |
| 032 | 부산은행 | 23:30~00:30 | 23:50 | 00:05 | 없음  |
| 034 | 광주은행 | 23:40~00:30 | 23:50 | 00:05 | 매월 2번째 일요일 02:00~06:00 |
| 035 | 제주은행 | 23:40~00:30 | 23:50 | 00:12 | 매주 일요일 04:30~05:00 |
| 037 | 전북은행 | 24:00~00:30 | 23:50 | 00:05 | 매월 2번째 토요일 00:00~04:00 |
| 039 | 경남은행 | 23:40~00:30 | 23:50 | 00:05 | 매월 2번째 일요일 00:00~07:00 |
| 045 | 새마을금고 | 23:50~00:30 | 23:30 | 00:30 | 없음  |
| 048 | 신협  | 23:40~00:30 | 23:50 | 00:05 | 없음  |
| 050 | 저축은행중앙회 | 23:50~00:10 | 23:50 | 00:35 | 없음  |
| 064 | 산림조합중앙회 | 23:30~00:30 | 23:30 | 01:00 | 없음  |
| 071 | 우체국 | 23:40~00:30 | 23:50 | 00:05 | 없음  |
| 081 | 하나은행 | 23:40~00:30 | 23:50 | 00:15 | 매월 2번째 일요일 00:00~08:00 |
| 088 | 신한은행 | 23:40~00:30 | 23:50 | 00:05 | 없음  |
| 089 | 케이뱅크 | 23:40~00:30 | 23:35 | 00:35 | 없음  |
| 090 | 카카오뱅크 | 23:50~00:10 | 23:50 | 00:05 | 없음  |
| 092 | 토스뱅크 | 23:55~00:05 | 23:55 | 00:05 | 없음  |
| 103 | SBI저축은행 | 23:55~00:10 | 23:50 | 00:05 | 없음  |
| 209 | 유안타증권 | 23:50~00:10 | 23:50 | 00:10 | 없음  |
| 238 | 미래에셋증권 | 23:30~00:20 | 23:30 | 00:20 | 없음  |
| 240 | 삼성증권 | 23:30~00:20 | 23:50 | 00:10 | 없음  |
| 243 | 한국투자증권 | 23:40~00:10 | 23:40 | 00:10 | 없음  |
| 247 | NH투자증권 | 23:50~00:15 | 23:50 | 00:05 | 없음  |
| 266 | SK증권 | 23:50~00:30 | 23:30 | 00:30 | 없음  |
| 267 | 대신증권 | 23:55~00:25 | 23:55 | 00:25 | 없음  |
| 278 | 신한금융투자 | 23:25~00:15 | 23:30 | 00:15 | 매일 23:30~00:10, 03:00~03:10 |
| 280 | 유진투자증권 | 23:30~00:30 | 23:50 | 00:35 | 없음  |
| 287 | 메리츠증권 | 23:50~00:20 | 23:50 | 00:20 | 없음  |
