# 헥토파이낸셜 MCP 서버 사용 지침

이 문서는 헥토파이낸셜 MCP 서버를 사용할 때 따라야 할 지침을 정의합니다.

> 최종 수정일: 2025-01-11

---

## 📌 1. 기본 원칙

- **반드시 MCP Tool(`list_docs`, `search_docs`, `get_docs`)을 사용하여 최신 문서 상태를 확인하고 응답을 구성한다.**
- **모든 질문에 대해 반드시 문서 검색을 먼저 실행하고, 검색 결과를 기반으로 답변을 작성한다.**
- **문서 원문에서 직접 인용한 내용만 응답한다.**
- **문서에 없는 정보는 생성하지 않는다.**
  - 반드시 다음과 같이 안내: `"문서에 해당 내용이 없습니다."`

---

## 🛠️ 2. 제공 도구

### 📋 list_docs
전체 문서 목록을 조회합니다.

**파라미터:**
- `category` (선택): 카테고리별 필터링
  - `"PG"`: 전자결제 연동 문서
  - `"내통장결제"`: 내통장결제 서비스 문서
  - `"간편현금결제"`: 간편현금결제 서비스 문서
  - `"화이트라벨"`: 화이트라벨 서비스 문서
  - 다중 카테고리: `["PG", "내통장결제"]`

**사용 예시:**
```python
list_docs()                              # 전체 문서 목록
list_docs(category="PG")                 # PG 카테고리만
list_docs(category=["PG", "내통장결제"])  # 다중 카테고리
list_docs(category="화이트라벨")         # 화이트라벨 카테고리
```

### 🔍 search_docs
키워드 기반 문서 검색을 수행합니다.

**파라미터:**
- `query` (필수): 검색 키워드
- `category` (선택): 카테고리 필터
  - 단일: `"PG"`, `"내통장결제"`, `"간편현금결제"`, `"화이트라벨"`
  - 다중: `["PG", "내통장결제"]`

**사용 예시:**
```python
search_docs("신용카드 결제")
search_docs("내통장결제 API", category="내통장결제")
search_docs("결제 API", category=["PG", "내통장결제"])
search_docs("화이트라벨 연동", category="화이트라벨")
```

**검색 결과 구조:**
```json
{
  "검색어": ["신용카드", "결제"],
  "검색결과": [
    {
      "문서제목": "# 헥토파이낸셜 PG 연동 가이드",
      "문서ID": "0",
      "카테고리": "PG",
      "본문": "[신용카드 결제 연동 > 신용카드 결제창 연동]\n신용카드 결제창을 통해 PG 결제를 처리합니다."
    }
  ],
  "안내": "관련성이 높은 문서 섹션을 정렬하여 제공합니다."
}
```

### 📄 get_docs
특정 문서의 전체 내용을 조회합니다.

**파라미터:**
- `doc_id` (필수): 문서 ID 또는 파일 경로
  - 숫자 문자열: `"1"`, `"2"`
  - 파일 경로: `"pg/hecto_financial_pg.md"`

**사용 예시:**
```python
get_docs("1")
get_docs("pg/hecto_financial_pg.md")
```

---

## 🎯 3. 사용 패턴

| 상황 | 권장 순서 |
|------|-----------|
| 키워드로 정보 찾기 | `search_docs` → `get_docs` |
| 문서 목록 확인 | `list_docs` → `get_docs` |
| 특정 문서 조회 | `get_docs` |
| 카테고리별 검색 | `search_docs` (category 파라미터 사용) |

---

## 📚 4. 문서 카테고리

| 카테고리 | 설명 | 포함 내용 |
|----------|------|-----------|
| **PG** | 전자결제 연동 | 신용카드 결제, PG 연동 API |
| **내통장결제** | 내통장결제 서비스 | 계좌인증, 내통장결제 API |
| **간편현금결제** | 간편현금결제 서비스 | 간편결제, 현금결제 API |
| **화이트라벨** | 화이트라벨 서비스 | 표준결제창, 비UI API, 은행연동 |

---

## ⚠️ 5. 오류 응답

| 상황 | 응답 형식 |
|------|-----------|
| 검색어 없음 | `{"오류": "검색어를 입력해 주세요."}` |
| 문서 없음 | `{"오류": "문서를 찾을 수 없습니다."}` |
| 검색 결과 없음 | `{"검색결과": [], "안내": "검색 결과가 없습니다."}` |

---

## 🧷 6. 응답 작성 지침

1. **정확성**: 문서 원문에서만 인용
2. **완전성**: 관련된 모든 정보 포함
3. **명확성**: 단계별로 명확하게 설명
4. **실용성**: 실제 사용 가능한 코드와 예시 제공

---

## 💡 7. AI 에이전트 워크플로우

### 🤖 질문 분석 → 도구 체이닝 → 응답 생성

**사용자 질문**: "신용카드 결제 연동 방법을 알려주세요"

**AI 에이전트 처리 과정:**

1. **초기 검색**: `search_docs("신용카드 결제 연동", category="PG")`
2. **결과 분석**: 검색 결과에서 관련 문서 ID 확인
3. **상세 조회**: `get_docs("검색결과의_문서ID")`
4. **보완 검색**: 부족한 정보가 있으면 `search_docs("API 명세")`
5. **응답 구성**: 문서 원문 기반으로 단계별 가이드 작성

**도구 체이닝 예시:**
```python
# 1단계: 키워드 검색
search_result = search_docs("신용카드 결제", category="PG")

# 2단계: 관련 문서 전체 조회
if search_result["검색결과"]:
    doc_id = search_result["검색결과"][0]["문서ID"]
    full_doc = get_docs(doc_id)

# 3단계: 추가 정보 검색
api_info = search_docs("API 호출 예시", category="PG")
```

### 🔄 복합 질문 처리

**사용자 질문**: "내통장결제와 간편현금결제의 차이점과 각각의 연동 방법을 알려주세요"

**AI 에이전트 처리 과정:**

1. **다중 카테고리 검색**: 
   ```python
   search_docs("내통장결제 간편현금결제 차이점", category=["내통장결제", "간편현금결제"])
   ```

2. **개별 서비스 검색**:
   ```python
   ezauth_info = search_docs("연동 방법", category="내통장결제")
   ezcp_info = search_docs("연동 방법", category="간편현금결제")
   whitelabel_info = search_docs("연동 방법", category="화이트라벨")
   ```

3. **비교 분석**: 각 결과를 비교하여 차이점 도출
4. **통합 응답**: 차이점 + 각각의 연동 방법 제공

### ⚠️ 오류 상황별 대응 시나리오

| 상황 | 대응 방법 |
|------|----------|
| 검색 결과 없음 | 다른 키워드로 재검색 → 카테고리 변경 → 전체 검색 |
| 문서 조회 실패 | 문서 목록 확인 → 유효한 문서 ID로 재시도 |
| 불완전한 정보 | 추가 키워드 검색 → 관련 문서 교차 확인 |

**예시 - 검색 결과 없음 시 대응:**
```python
# 1차 검색 실패
result1 = search_docs("특정용어")
if not result1.get("검색결과"):
    # 2차 검색 - 유사 키워드
    result2 = search_docs("관련용어")
    if not result2.get("검색결과"):
        # 3차 검색 - 카테고리별 전체 검색
        result3 = list_docs(category="관련카테고리")
```

## 💡 8. 모범 사례

**잘못된 응답:**
- 문서 검색 없이 일반적인 정보 제공
- 문서에 없는 내용 추측하여 답변
- 다른 회사 연동 방식으로 답변

**올바른 응답:**
- 헥토파이낸셜 문서에서 직접 인용
- 실제 API 명세와 코드 예시 제공
- 단계별 연동 과정 설명
- 도구 체이닝을 통한 완전한 정보 수집