# 간편현금결제 소개

실시간 펌뱅킹 기술을 기반으로 고객이 최초 1회 본인 계좌를 등록하여 PIN 번호로 간편하게 결제, 송금 등을 이용하는 현금결제 서비스입니다.  
표준 웹 결제창 API 호출을 통하여 간단히 '계좌 등록/결제/송금' 서비스를 이용하실 수 있습니다.  
편리함과 안전함을 한번에 All-in-One 서비스(휴대폰 본인 인증, 예금주 성명 조회, ARS 출금 동의. ARS 2차 인증, 간편 송금 등)를 제공합니다.  
  
※ 이 문서는 [표준연동규격서](https://develop.sbsvc.online/22/bbsList.do?tx=R&articleSeq=432)에서 다운로드 받으실 수 있습니다.  

# 표준 WEB API 연동 규격서

#  1\. 개요

## 1.1. 목적

본 문서는 헥토파이낸셜에서 제공하는 간편현금결제 Non-UI API 연동 개발에 필요한 기술적 이해를 돕고 상세 규격을 정의하기 위해 작성 되었습니다.

## 1.2. 대상

본 문서는 헥토파이낸셜 간편결제 시스템을 통해 간편현금결제를 수행하기 위한 고객사 개발자를 대상으로 합니다.

## 1.3. API URI

간편현금결제 API 는 아래와 같은 API 를 제공하며, 하나의 API 는 하나의 웹 서비스 URI 로 매핑됩니다.

| 기능구분 | API 명 | URI | HTTP  <br>Method |
| --- | --- | --- | --- |
| 인증 서비스 | [본인인증 요청](#item-96) | https://npay.settlebank.co.kr/v1/api/auth/mobile/req | POST |
| [본인인증 확인](#item-552) | https://npay.settlebank.co.kr/v1/api/auth/mobile/check | POST |
| [예금주성명조회Ⅰ](#item-558) | https://npay.settlebank.co.kr/v1/api/auth/acnt/ownercheck1 | POST |
| [예금주성명조회Ⅱ](#item-564) | https://npay.settlebank.co.kr/v1/api/auth/acnt/ownercheck2 | POST |
| [예금주성명조회(금액포함)](#item-1077) | https://npay.settlebank.co.kr/v1/api/auth/acnt/ownercheckWithAmount | POST |
| [계좌점유인증](#item-587) | https://npay.settlebank.co.kr/v1/api/auth/acnt/ownership | POST |
| [계좌점유인증 요청](#item-1083) | https://npay.settlebank.co.kr/v1/api/auth/ownership/req | POST |
| [계좌점유인증 확인](#item-1089) | https://npay.settlebank.co.kr/v1/api/auth/ownership/check | POST |
| [ARS 인증 요청](#item-593) | https://npay.settlebank.co.kr/v1/api/auth/ars | POST |
| [ARS 인증 확인](#item-656) | https://npay.settlebank.co.kr/v1/api/auth/arscheck | POST |
| 계좌관리 | [계좌등록](#item-882) | https://npay.settlebank.co.kr/v1/api/acnt/reg | POST |
| [계좌해지](#item-887) | https://npay.settlebank.co.kr/v1/api/acnt/unreg | POST |
| [가맹점 자체 계좌등록  <br>(\*오픈뱅킹 계좌등록) 항목 有](#item-888) | https://npay.settlebank.co.kr/v1/api/acnt/reg/self | POST |
| 이체 서비스 | [결제](#item-889) | https://npay.settlebank.co.kr/v1/api/pay/confirm | POST |
| [결제 취소/환불](#item-890) | https://npay.settlebank.co.kr/v1/api/pay/cancel | POST |
| [송금](#item-895) | https://npay.settlebank.co.kr/v1/api/pay/rmt | POST |
| [송금계좌잔액 조회](#item-896) | https://npay.settlebank.co.kr/v2/api/pay/rmt/blc | POST |
| 정기결제 | [정기결제 키 발행](#item-1631) | https://npay.settlebank.co.kr/v1/api/regular/reg | POST |
| [정기결제 승인](#item-891) | https://npay.settlebank.co.kr/v1/api/regular/confirm | POST |
| [정기결제 해지](#item-892) | https://npay.settlebank.co.kr/v1/api/regular/unreg | POST |
| [정기결제 정보 조회](#item-893) | https://npay.settlebank.co.kr/v1/api/regular/info | POST |
| [정기결제 거래내역 조회](#item-894) | https://npay.settlebank.co.kr/v1/api/regular/translist | POST |
| 조회 서비스 | [거래결과조회](#item-698) | https://npay.settlebank.co.kr/v1/api/pay/morw | POST |
| [거래내역조회](#item-897) | https://npay.settlebank.co.kr/v1/api/pay/translist | POST |
| [계좌목록조회](#item-898) | https://npay.settlebank.co.kr/v1/api/acnt/list | POST |
| [은행목록조회](#item-899) | https://npay.settlebank.co.kr/v1/api/bank/list | POST |
| [은행점검조회](#item-900) | https://npay.settlebank.co.kr/v1/api/bank/timecheck | POST |
| [계좌점유인증 내역 조회](#item-901) | https://npay.settlebank.co.kr/v1/api/auth/ownership/translist | POST |
| [계좌점유인증 은행점검조회](#item-902) | https://npay.settlebank.co.kr/v1/api/bank/timecheck/detail | POST |
| [금융결제원 출금이체정보  <br>해지 조회](#item-903) | https://nspay.settlebank.co.kr/v1/api/acnt/isttunreg/list | POST |
| [테스트콜](#item-1095) | https://npay.settlebank.co.kr/v1/api/test/testcall | POST |
| [결제비밀번호 확인](#item-1100) | https://npay.settlebank.co.kr/v1/api/auth/pwdcnf | POST |

## 1.4. 주의사항

####  주의사항

*   운영환경에서 테스트가 필요 한 경우 헥토파이낸셜 담당자와 협의가 필요합니다. 사전협의 없이 진행되는 운영테스트 거래로 발생하는 비용은 가맹점 부담입니다.
*   **응답 파라미터는 예고 없이 변동될 수 있으며, 개발시 파라미터 변동에 따른 영향이 발생하지 않도록 개발하여 주시기 바랍니다.**
*   ※ \[간편현금결제 **UI** 표준 결제창 사용 가맹점\]  
    간편결제 UI 표준 결제창을 사용하시는 경우, iframe 태그를 통해 표준 결제창을 호출하시면 일부 브라우저나 기기에서 정상적으로 작동하지 않는 경우가 있습니다. 간편결제 UI 표준 결제창을 사용하시는 경우에는 iframe tag 사용을 삼가 주십시오.

#  2\. 간편현금결제 API 일반

## 2.1. 간편현금결제 프로세스

간편현금결제 프로세스를 간략히 도식화 하면 다음과 같습니다.

![간편현금결제 프로세스](/images/contents/docs/process_stdpay_01_m.gif?ver=20220126) ![간편현금결제 프로세스](/images/contents/docs/process_stdpay_01.gif?ver=20220126)

  
1.  고객의 휴대폰정보를 이용하여 본인인증 처리  
3.  본인인증 결과 조회  
5.  휴대폰본인인증 후 성명과 계좌정보를 이용하여 예금주성명조회 실행  
7.  ARS 인증으로 출금이체등록 증빙자료 생성  
12\. 계좌등록 (출금이체등록)  
14\. 등록된 계좌로 결제 실행

## 2.2. 일반 사항

다음은 본 문서에서 언급하는 연동상의 일반적인 사항에 대하여 설명합니다.

*   요청/응답 파라메터 중 필수 필드는 ‘●’ 기호를 사용하며 선택 필드는 ‘○’ 기호를 사용합니다.
*   데이터 타입
    *   N : Numeric Characters
    *   A : Alphabetic Characters
*   요청 파라메터 검증
    *   필수값 누락, 위변조 여부를 판단하는 HASH 데이터 불일치, 요청 변수 길이 체크등 파라메터 검증 후 이상이 있을 경우 아래와 같은 응답 코드를 반환합니다.

```
{
	"outStatCd": "0031",
	"outRsltCd": "ST09",
	"outRsltMsg": "유효하지 않는 요청전문"
}
```

#  3\. API 호출

## 3.1. API 접속 정보

API 서버 접속 정보는 다음과 같습니다.

   
| 구분  |     | 도메인 이름 | IP주소 |
| --- | --- | --- | --- |
| 인증서비스 및   <br>계좌관리 API  <br>(Non-UI) | 테스트 베드 | tbnpay.settlebank.co.kr  <br>HTTPS(TCP/443) | 61.252.169.31 |
| 상용 환경 | npay.settlebank.co.kr  <br>HTTPS(TCP/443) | 61.252.169.27(primary) |
| 14.34.14.24(secondary) |
| 이체 서비스 및 정기결제 API  <br>(Non-UI) | 테스트 베드 | tbnpay.settlebank.co.kr  <br>HTTPS(TCP/443) | 61.252.169.31 |
| 상용 환경 | npay.settlebank.co.kr  <br>HTTPS(TCP/443) | 61.252.169.27(primary) |
| 14.34.14.24(secondary) |
| 조회서비스 API  <br>(Non-UI) | 테스트 베드 | tbnpay.settlebank.co.kr  <br>HTTPS(TCP/443) | 61.252.169.31 |
| 상용 환경 | npay.settlebank.co.kr  <br>HTTPS(TCP/443) | 61.252.169.27(primary) |
| 14.34.14.24(secondary) |
| 금융결제원 출금  <br>이체정보 해지  <br>조회 API (Non-UI) | 테스트 베드 | tb-nspay.settlebank.co.kr  <br>HTTPS(TCP/443) | 필요 시 별도 문의 |
| 상용 환경 | nspay.settlebank.co.kr  <br>HTTPS(TCP/443) | 필요 시 별도 문의 |

 

*   헥토파이낸셜 간편현금결제 시스템은 IDC센터 이중화 구성되어 있습니다.(상용 환경)  
    따라서 예고 없이 GLB시스템 운영으로 주센터와 보조센터 전환이 이루어질 수 있으며, DNS Lookup에 의한 접속을 권장하고 있습니다.  
    따라서 안내드린 2개의 공인 IP주소(상용)를 방화벽에서 접속허용 요청드리며, hosts파일 구성은 권장하지 않습니다.
*   만약 귀사의 내부 정책으로 인하여 hosts파일에 Domain주소를 고정설정으로 구성하시는 경우 헥토파이낸셜 IDC센터 전환시에는 아래와 같이 "#(코멘트) 표시된 IP주소"로 반드시 모든 서버의 hosts파일을 수작업으로 변경처리를 해야만 정상적으로 결제서비스를 이용하실 수 있습니다.
*   모든 통신은 HTTPS(TCP/443) 프로토콜을 사용하며, TLS 1.2 이상을 사용하여 접속하는것을 강력하게 권장드립니다. TLS 1.1 이하버전은 보안권고사항에 따라 사전에 통지 없이 지원이 중단 될 수 있습니다 

## 3.2. 요청 및 응답 헤더

API 요청 및 응답 헤더 포맷은 다음과 같습니다.

|     |     |
| --- | --- | 
| 요청  | Content-type=application/json;charset=UTF-8 |
| 응답  | Content-type=application/json;charset=UTF-8 |

## 3.3. 타임아웃

API 의 응답 타임아웃 처리는 30초를 적용합니다.  
 

## 3.4. 기타

다음은 HTTP 규격의 일반 요건에 대하여 설명합니다.

*   제공하는 API 는 REST 를 지향하나, REST 의 규격 전체를 만족하지 않습니다. (대부분의 트랜잭션 요청은 POST Method 만 사용)
*   요청은 POST method 만을 사용합니다.
*   변수값에 공통적으로 :,&,?,’,new line, <, > 기호는 전달 불가합니다.

#  4\. 중요 정보 보안

## 4.1. 개인정보 및 중요정보 암복호화(암호화/복호화)

데이터 송수신시 개인정보/중요정보 필드에 대해서는 다음과 같은 암복호화(암호화/복호화)를 수행해야 합니다.

| 구분  | 항목  | 적용  | 인코딩 |
| --- | --- | --- | --- |
| 개인정보 | 알고리즘 | AES-256/ECB/PKCS5Padding | Base64 Encoding |
| 대상 필드 | 담당자명, 유선번호, 휴대폰번호, 이메일, 예금주명, 계좌번호 등  <br>\- 암호화 대상 필드는 개별 API 의 요청 필드 규격의 설명란에 명시됩니다.  <br>\- 해당 필드에 한글 입력이 가능한 경우, 한글의 byte크기는 설명란을 참고해주시기 바랍니다. |     |     |

## 4.2. 개인정보 암호키

개인 정보 및 중요정보 암복호화시 키 정보는 운영 환경에 따라 다르며 다음과 같습니다.

 
| 구분  | 암복호화키 |
| --- | --- |
| 테스트베드 키 | pgSettle30y739r82jtd709yOfZ2yK5K(32byte) |
| 상용 환경 키 | 서비스 이행시 별도 통보 |

## 4.3. 위변조 방지 알고리즘

요청 데이터의 위변조 여부를 검증하기 위해 추가적으로 해쉬키 검증을 수행하며, 해쉬키 생성 알고리즘은 다음과 같습니다.

| 구분  | 항목  | 적용  | 인코딩 |
| --- | --- | --- | --- |
| 위변조 | 알고리즘 | SHA-256 | Hex Encoding |

## 4.4. 해쉬생성 인증키

 
| 구분  | 인증키 |
| --- | --- |
| 테스트베드 키 | ST1009281328226982205(21byte) |
| 상용 환경 키 | 서비스 이행시 별도 통보 |

#  5\. 휴대폰본인인증 요청

## 5.1. API 요약 설명

가맹점 서버에서 헥토파이낸셜 서버로 휴대폰 본인인증을 요청합니다.  
예금주 본인확인에 필요한 고객(예금주)성명 및 ARS 인증에 필요한 본인 소유의 휴대전화번호를 획득하기 위해 휴대폰 본인인증을 사용합니다. APP 및 SMS 방식을 지원하며 APP 인증 요청 시 고객 모바일앱을 호출하고 SMS 인증 요청 시 6 자리의 인증번호를 고객의 기기로 SMS 전송을 하게 됩니다.  
  
※ 휴대폰 본인인증 서비스는 헥토파이낸셜 간편결제 등록을 위한 용도로만 사용 가능 합니다. 

## 5.2. API URL

 
| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tbnpay.settlebank.co.kr/v1/api/auth/mobile/req |
| 상용 환경 | https://npay.settlebank.co.kr/v1/api/auth/mobile/req |

## 5.3. 요청 전문 (가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문정보 | 전문정보 코드 | AN(50) | ●   | “SPAY\_M100\_1.0”  <br>※ 고정값 |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “midtest” |
| mchtCustId | 고객아이디 | 상점에서 보내주는 고유 고객아이디 혹은 Unique 한 Key  <br>AES 암호화 | AN(100) | ●   | “honggildong” |
| reqDt | 요청일자 | yyyyMMdd | AN(8) | ●   | “20191231” |
| reqTm | 요청시간 | HH24MISS | AN(6) | ●   | “120000” |
| uii | 생년월일  <br>/사업자번호 | yymmdd+성별구분, 사업자번호(‘-‘ 제외)  <br>AES 암호화 | AN(10) | ●   | “8001012” |
| telecomCd | 통신사 | SKT: 1, KT: 2 LGT: 3,  <br>SKT 알뜰폰:4 KT 알뜰폰:5  <br>LGT 알뜰폰:6 | N(1) | ●   | “1” |
| cphoneNo | 휴대폰번호 | 010xxxxyyyy (하이픈 제거)  <br>AES 암호화 | AN(11) | ●   | “01000001234” |
| mchtCustNm | 고객명 | 고객명 **(한글 3byte)**  <br>AES 암호화 | AN(60) | ●   | “홍길동” |
| authMthdCd | 인증구분 | SMS : 1, APP : 2 | N(1) | ●   | “1” |
| custIp | 고객 IP 주소 | 가맹점 서버의 IP가 아닌 고객 기기의 IP 주소 | AN(15) | ○   | “127.0.0.1” |
| pktHash | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 5.4. 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash 값 | 상점아이디 + 고객아이디(평문) + 요청일자 + 요청시간 + 생년월일(평문) + 휴대폰번호(평문) + 인증구분 + 인증키 |

## 5.5. 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| outStatCd | 거래상태 | 거래상태코드(성공/실패) | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031 |
| outRsltCd | 거절코드 | [거절코드 테이블](#item-1010)참조 | AN(4) | ●   |     |
| outRsltMsg | 결과메시지 | 오류가 발생시 오류에 대한 메시지 전달 | AN(300) | ●   | “정상처리되었습니다.” |
| tid | 본인인증키 | 문자로 전송된 인증번호와 매칭이 되는 본인인증키 | AN(50) | ●   |     |
| trdNo | 거래번호 | 휴대폰 인증요청에 대한 헥토파이낸셜 거래번호 | AN(40) | ●   | “SFP\_FIRM12345678901234567890” |

#  6\. 휴대폰본인인증 확인

## 6.1 API 요약 설명

휴대폰 본인인증 요청에 대한 상태 확인을 실행하는 API 를 제공합니다.  
'휴대폰 본인인증 요청' API를 통해 고객의 기기로 SMS 문자전송 또는 APP 인증 요청을 하게 되고 고객이 이를 실행 후 본 API를 통하여 해당 인증의 완료 여부를 확인 합니다. SMS 인증방식일 경우 전송 된 인증번호와 함께 확인 요청을 하게 되며 APP 인증일 경우 APP에서 완료되었는지 확인 요청을 합니다.  
  
※ 휴대폰 본인인증 서비스는 헥토파이낸셜 간편결제 등록을 위한 용도로만 사용 가능 합니다. 

## 6.2 API URL

 
| 구분  | URL |
| --- | --- |
| 테스트베드 키 | https://tbnpay.settlebank.co.kr/v1/api/auth/mobile/check |
| 상용 환경 키 | https://npay.settlebank.co.kr/v1/api/auth/mobile/check |

## 6.3 요청 전문 (가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문정보 | 전문정보 코드 | AN(50) | ●   | “SPAY\_M200\_1.0”  <br>※ 고정값 |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “midtest” |
| reqDt | 요청일자 | yyyyMMdd | AN(8) | ●   | “20191231” |
| reqTm | 요청시간 | HH24MISS | AN(6) | ●   | “120000” |
| authNo | 인증번호 | 문자로 전송된 인증번호  <br>※ 휴대폰 본인인증 요청의 인증구분이 SMS일 경우 필수 | N(6) | ○   | “123456” |
| tid | 본인인증키 | 요청시 응답값으로   <br>전달된 본인인증키 값 | AN(50) | ●   | “settlebank20190430034655251226” |
| trdNo | 거래번호 | 헥토파이낸셜 거래번호 | AN(50) | ●   | “SFP\_FIRM12345678901234567890” |
| custIp | 고객 IP 주소 | 가맹점 서버의 IP가 아닌 고객 기기의 IP 주소 | AN(15) | ○   | “127.0.0.1” |
| pktHash | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 6.4 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash 값 | 상점아이디 + 요청일자 + 요청시간 + 본인인증키 + 인증키 |

## 6.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| outStatCd | 거래상태 | 거래상태코드(성공/실패) | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031 |
| outRsltCd | 거절코드 | [거절코드 테이블](#item-1010) 참조 | AN(4) | ●   |     |
| outRsltMsg | 결과메시지 | 오류가 발생시 오류에 대한 메시지 전달 | AN(300) | ●   | “정상처리되었습니다.” |

#  7\. 예금주 성명 조회 (생년월일 미포함)

## 7.1 API 요약 설명

은행, 계좌, 예금주명으로 정합성을 체크하는 API를 제공합니다.  
휴대폰 본인인증을 통하여 획득한 고객(예금주)명과 입력 받은 은행 및 계좌번호를 이용하여 해당 계좌가 고객의 성명으로 개설된 것인지 확인합니다.   
  
예금주명을 입력하여 요청 시 입력받은 예금주명과 은행에서 전달 받은 예금주명의 일치여부를 헥토파이낸셜에서 비교 확인 후 성공/실패 코드로 전달드리며 예금주명이 미입력으로 은행코드와 계좌번호만 전달 시에는 은행에서 전달 된 예금주명을 결과 값으로 전달 드립니다.  
  
예금주명은 일반은행은 최대 12 바이트를 주지만 특정 은행(SC 은행, 농협, 우리, 기업, 제주, 광주, 카카오뱅크)에서는 20 바이트를 주고 있으며, SC은행에서 제공하는 예금주명은 전각문자를 사용합니다. 헥토파이낸셜에서 고객사에게 제공시에는 모든 은행 반각으로 변환하여 최대 10자리로 제공합니다.   
  
등록불가계좌 확인은 헥토파이낸셜 내부에서 등록불가능한 계좌인지를 우선적으로 확인하고, 등록불가 계좌로 확인되는 경우에는 은행에 예금주명 확인을 요청하지 않습니다.

## 7.2 API URL

 
| 구분  | URL |
| --- | --- |
| 테스트베드 키 | https://tbnpay.settlebank.co.kr/v1/api/auth/acnt/ownercheck1 |
| 상용 환경 키 | https://npay.settlebank.co.kr/v1/api/auth/acnt/ownercheck1 |

## 7.3 요청 전문 (가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문정보 | 전문정보 코드 | AN(50) | ●   | “SPAY\_NA00\_1.0”  <br>※ 고정값 |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “midtest” |
| mchtTrdNo | 주문번호 | 상점주문번호  <br>※ 한글제외 | AN(100) | ○   | "OID201902210001" |
| mchtCustId | 고객아이디 | 상점에서 보내주는 고유 고객아이디 혹은 Unique 한 Key  <br>AES 암호화 | AN(100) | ●   | "honggildong" |
| reqDt | 요청일자 | yyyyMMdd | AN(8) | ●   | “20191231” |
| reqTm | 요청시간 | HH24MISS | AN(6) | ●   | “120000” |
| bankCd | 은행코드 | [금융기관코드 테이블](#item-926) 참조 | AN(3) | ●   | "004" |
| custAcntNo | 계좌번호 | 계좌번호 "-" 제외  <br>AES 암호화 | AN(15) | ●   | "1234567890" |
| mchtCustNm | 예금주명 | 영문/숫자/한글 **(한글 3byte)**  <br>AES 암호화 | AN(30) | ○   | "홍길동" |
| acctNoChkYn | 등록불가계좌  <br>확인여부 | 예금주 성명조회 전 계좌등록 불가능한 계좌인지 확인  <br>※ 등록 불가능한 계좌인 경우 거래상태는 0031, 거절코드는 1001로 응답 | AN(1) | ○   | Y 혹은 N  <br>\* Default : N |
| custIp | 고객 IP 주소 | 가맹점 서버의 IP가 아닌 고객 기기의 IP 주소 | AN(15) | ○   | “127.0.0.1” |
| pktHash | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 7.4 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash 값 | 상점아이디 + 고객아이디(평문) + 요청일자 + 요청시간 + 계좌번호(평문) + 인증키 |

## 7.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| outStatCd | 거래상태 | 거래상태코드(성공/실패) | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031 |
| outRsltCd | 거절코드 | [거절코드 테이블](#item-1010) 참조 | AN(4) | ●   |     |
| outRsltMsg | 결과메시지 | 오류가 발생시 오류에 대한 메시지 전달 | AN(300) | ●   | “정상처리되었습니다.” |
| mchtTrdNo | 주문번호 | 상점 주문번호  <br>\* 한글제외 | AN(100) | ○   | "OID201902210001" |
| trdNo | 거래번호 | 헥토파이낸셜 거래번호 | AN(40) | ●   | "SFP\_FIRM12345678901234567890" |
| mchtCustNm | 예금주명 | 은행에서 조회된 예금주명 **(한글 3byte)**  <br>AES 암호화 | AN(30) | ○   | "홍길동" |

#  8\. 예금주 성명 조회 (생년월일 포함)

## 8.1 API 요약 설명

   
은행, 계좌, 예금주명, 생년월일으로 정합성을 체크하는 API를 제공합니다.  
휴대폰 본인인증을 통하여 획득한 고객(예금주)명, 생년월일과 입력받은 은행 및 계좌 번호를 이용하여 해당 계좌가 고객의 성명으로 개설된 것인지 확인 합니다.   
  
예금주명을 입력하여 요청 시 입력받은 예금주명과 은행에서 전달 받은 예금주명의 일치여부를 헥토파이낸셜에서 비교 확인 후 성공/실패 코드로 전달드리며 예금주명이 미입력으로 은행 코드와 계좌번호만 전달 시에는 은행에서 전달 된 예금주명을 결과 값으로 전달 드립니다.  
  
예금주명은 일반은행은 최대 12 바이트를 주지만 특정 은행(SC 은행, 농협, 우리, 기업, 제주, 광주, 카카오뱅크)에서는 20 바이트를 주고 있으며, SC은행에서 제공하는 예금주명은 전각문자를 사용합니다. 헥토파이낸셜에서 고객사에게 제공시에는 모든 은행 반각으로 변환하여 최대 10자리로 제공합니다.  
   
등록불가계좌 확인은 헥토파이낸셜 내부에서 등록불가능한 계좌인지를 우선적으로 확인하고, 등록불가 계좌로 확인되는 경우에는 은행에 예금주명 확인을 요청하지 않습니다.

## 8.2 API URL

 
| 구분  | URL |
| --- | --- |
| 테스트베드 키 | https://tbnpay.settlebank.co.kr/v1/api/auth/acnt/ownercheck2 |
| 상용 환경 키 | https://npay.settlebank.co.kr/v1/api/auth/acnt/ownercheck2 |

## 8.3 요청 전문 (가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문정보 | 전문정보 코드 | AN(50) | ●   | “SPAY\_NA00\_1.0”  <br>※ 고정값 |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “midtest” |
| mchtTrdNo | 주문번호 | 상점주문번호  <br>※ 한글제외 | AN(100) | ○   | "OID201902210001" |
| mchtCustId | 고객아이디 | 상점에서 보내주는 고유 고객아이디 혹은 Unique 한 Key  <br>AES 암호화 | AN(100) | ●   | "honggildong" |
| reqDt | 요청일자 | yyyyMMdd | AN(8) | ●   | “20191231” |
| reqTm | 요청시간 | HH24MISS | AN(6) | ●   | “120000” |
| bankCd | 은행코드 | [금융기관코드 테이블](#item-926) 참조 | AN(3) | ●   | "004" |
| custAcntNo | 계좌번호 | 계좌번호 "-" 제외  <br>AES 암호화 | AN(15) | ●   | "1234567890" |
| mchtCustNm | 예금주명 | 영문/숫자/한글 **(한글 3byte)**  <br>AES 암호화 | AN(30) | ○   | "홍길동" |
| uii | 생년월일/사업자번호 | 생년월일:yyMMdd  <br>사업자번호: 10자리  <br>AES암호화 | AN(10) | ●   | "800101" |
| acctNoChkYn | 등록불가계좌  <br>확인여부 | 예금주 성명조회 전 계좌등록 불가능한 계좌인지 확인  <br>※ 등록 불가능한 계좌인 경우 거래상태는 0031, 거절코드는 1001로 응답 | AN(1) | ○   | Y 혹은 N  <br>\* Default : N |
| custIp | 고객 IP 주소 | 가맹점 서버의 IP가 아닌 고객 기기의 IP 주소 | AN(15) | ○   | “127.0.0.1” |
| pktHash | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 8.4 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash 값 | 상점아이디 + 고객아이디(평문) + 요청일자 + 요청시간 + 계좌번호(평문) + 생년월일(평문) + 인증키 |

## 8.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| outStatCd | 거래상태 | 거래상태코드(성공/실패) | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031 |
| outRsltCd | 거절코드 | [거절코드 테이블](#item-1010) 참조 | AN(4) | ●   |     |
| outRsltMsg | 결과메시지 | 오류가 발생시 오류에 대한 메시지 전달 | AN(300) | ●   | “정상처리되었습니다.” |
| mchtTrdNo | 주문번호 | 상점 주문번호  <br>\* 한글제외 | AN(100) | ○   | "OID201902210001" |
| trdNo | 거래번호 | 헥토파이낸셜 거래번호 | AN(40) | ●   | "SFP\_FIRM12345678901234567890" |
| mchtCustNm | 예금주명 | 은행에서 조회된 예금주명 **(한글 3byte)**  <br>AES 암호화 | AN(30) | ○   | "홍길동" |

#  9\. 예금주 성명 조회 (금액포함)

## 9.1 API 요약 설명

  
은행, 계좌, 예금주명, 금액으로 정합성을 체크하는 API를 제공합니다.  
휴대폰 본인인증을 통하여 획득한 고객(예금주)명 입력받은 은행, 계좌번호, 금액을 이용하여 해당 계좌가 고객의 성명으로 개설된 것인지 확인합니다.  
  
예금주명을 입력하여 요청 시 입력받은 예금주명과 은행에서 전달받은 예금주명의 일치여부를 헥토파이낸셜에서 비교 확인 후 성공/실패 코드로 전달드리며 예금주명이 미입력으로 은행코드와 계좌번호만 전달 시에는 은행에서 전달 된 예금주명을 결과 값으로 전달 드립니다.  
  
예금주명은 일반은행은 최대 12 바이트를 주지만 특정 은행(SC 은행, 농협, 우리, 기업, 제주, 광주, 카카오뱅크)에서는 20 바이트를 주고 있으며, SC은행에서 제공하는 예금주명은 전각문자를 사용합니다. 헥토파이낸셜에서 고객사에게 제공시에는 모든 은행 반각으로 변환하여 최대 10자리로 제공합니다.  
  
등록불가계좌 확인은 헥토파이낸셜 내부에서 등록불가능한 계좌인지를 우선적으로 확인하고, 등록불가 계좌로 확인되는 경우에는 은행에 예금주명 확인을 요청하지 않습니다.

## 9.2 API URL

 
| 구분  | URL |
| --- | --- |
| 테스트베드 키 | https://tbnpay.settlebank.co.kr/v1/api/auth/acnt/ownercheckWithAmount |
| 상용 환경 키 | https://npay.settlebank.co.kr/v1/api/auth/acnt/ownercheckWithAmount |

## 9.3 요청 전문 (가맹점 → 헥토파이낸셜)

  
가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문정보 | 전문정보 코드 | AN(50) | ●   | “SPAY\_NN00\_1.0”  <br>※ 고정값 |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “midtest” |
| mchtTrdNo | 주문번호 | 상점주문번호  <br>※ 한글제외 | AN(100) | ○   | "OID201902210001" |
| mchtCustId | 고객아이디 | 상점에서 보내주는 고유 고객아이디 혹은 Unique 한 Key  <br>AES 암호화 | AN(100) | ●   | "honggildong" |
| reqDt | 요청일자 | yyyyMMdd | AN(8) | ●   | “20191231” |
| reqTm | 요청시간 | HH24MISS | AN(6) | ●   | “120000” |
| bankCd | 은행코드 | [금융기관코드 테이블](https://develop.sbsvc.online/1/onlineDocList.do#item-926) 참조 | AN(3) | ●   | "004" |
| custAcntNo | 계좌번호 | 계좌번호 "-" 제외  <br>AES 암호화 | AN(15) | ●   | "1234567890" |
| mchtCustNm | 예금주명 | 영문/숫자/한글 **(한글 3byte)**  <br>AES 암호화 | AN(30) | ○   | "홍길동" |
| trdAmt | 거래금액 | 거래금액  <br>AES 암호화 | N(13) | ●   | "2000" |
| acctNoChkYn | 등록불가계좌  <br>확인여부 | 예금주 성명조회 전 계좌등록 불가능한 계좌인지 확인  <br>※ 등록 불가능한 계좌인 경우 거래상태는 0031, 거절코드는 1001로 응답 | AN(1) | ○   | Y 혹은 N  <br>\* Default : N |
| custIp | 고객 IP 주소 | 가맹점 서버의 IP가 아닌 고객 기기의 IP 주소 | AN(15) | ○   | “127.0.0.1” |
| pktHash | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

  
   
 

## 9.4 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash 값 | 상점아이디 + 고객아이디(평문) + 요청일자 + 요청시간 + 계좌번호(평문) + 거래금액(평문) + 인증키 |

## 9.5 응답 전문 (헥토파이낸셜 → 가맹점)

  
헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| outStatCd | 거래상태 | 거래상태코드(성공/실패) | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031 |
| outRsltCd | 거절코드 | [거절코드 테이블](#item-1010) 참조 | AN(4) | ●   |     |
| outRsltMsg | 결과메시지 | 오류가 발생시 오류에 대한 메시지 전달 | AN(300) | ●   | “정상처리되었습니다.” |
| mchtTrdNo | 주문번호 | 상점 주문번호  <br>\* 한글제외 | AN(100) | ○   | "OID201902210001" |
| trdNo | 거래번호 | 헥토파이낸셜 거래번호 | AN(40) | ●   | "SFP\_FIRM12345678901234567890" |
| mchtCustNm | 예금주명 | 은행에서 조회된 예금주명 **(한글 3byte)**  <br>AES 암호화 | AN(30) | ○   | "홍길동" |

#  10\. 계좌점유인증

## 10.1 API 요약 설명

고객이 실제 계좌를 점유(소유)하고 있는지 확인하기 위해 계좌에 1원을 송금하여 점유유무를 파악 할 수 있는 기능을 제공 합니다. 1원과 함께 요청시 설정된 통장인자를 보내어 고객이 통장 확인 후 통장 인자명을 대조하여 해당 계좌를 점유 하고 있는지 확인 할 수 있습니다.  
  
※ 부정사용을 방지 하기 위해 운영 서비스 시작 시 계좌번호에 대해 1일 5회로 사용 제한 됩니다.   
횟수에 대한 조정은 요청시 변경 가능 합니다. 

## 10.2 API URL

 
| 구분  | URL |
| --- | --- |
| 테스트베드 키 | https://tbnpay.settlebank.co.kr/v1/api/auth/acnt/ownership |
| 상용 환경 키 | https://npay.settlebank.co.kr/v1/api/auth/acnt/ownership |

## 10.3 요청 전문 (가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문정보 | 전문정보 코드 | AN(50) | ●   | “SPAY\_AA00\_1.0”  <br>※ 고정값 |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “midtest” |
| mchtTrdNo | 주문번호 | 상점주문번호  <br>※ 한글제외 | AN(100) | ○   | "OID201902210001" |
| mchtCustId | 고객아이디 | 상점에서 보내주는 고유 고객아이디 혹은 Unique 한 Key  <br>AES 암호화 | AN(100) | ●   | "honggildong" |
| reqDt | 요청일자 | yyyyMMdd | AN(8) | ●   | “20191231” |
| reqTm | 요청시간 | HH24MISS | AN(6) | ●   | “120000” |
| bankCd | 은행코드 | [금융기관코드 테이블](#item-926) 참조 | AN(3) | ●   | "004" |
| custAcntNo | 계좌번호 | 계좌번호 "-" 제외  <br>AES 암호화 | AN(15) | ●   | "1234567890" |
| custAcntSumry | 통장인자내용 | 고객의 통장에 찍힐 인자내용  <br>**(한글 size 2byte 기준)**  <br>AES 암호화 | AN(12) | ●   | "홍길동" |
| custIp | 고객 IP 주소 | 가맹점 서버의 IP가 아닌 고객 기기의 IP 주소 | AN(15) | ○   | “127.0.0.1” |
| pktHash | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 10.4 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash 값 | 상점아이디 + 고객아이디(평문) + 요청일자 + 요청시간 + 계좌번호(평문) + 인증키 |

## 10.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| outStatCd | 거래상태 | 거래상태코드(성공/실패) | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031 |
| outRsltCd | 거절코드 | [거절코드 테이블](#item-1010) 참조 | AN(4) | ●   |     |
| outRsltMsg | 결과메시지 | 오류가 발생시 오류에 대한 메시지 전달 | AN(100) | ●   | “정상처리되었습니다.” |
| mchtTrdNo | 주문번호 | 상점 주문번호  <br>\* 한글제외 | AN(100) | ○   | "OID201902210001" |
| trdNo | 거래번호 | 헥토파이낸셜 거래번호 | AN(40) | ●   | "SFP\_FIRM12345678901234567890" |

#  11\. 계좌점유인증 요청

## 11.1 API 요약 설명

고객이 실제 계좌를 점유(소유)하고 있는지 확인하기 위해 계좌에 1원을 송금하여 점유유무를 파악 할 수 있는 기능을 제공 합니다. 1원과 함께 요청시 설정된 통장인자를 보내어 고객이 통장 확인 후 통장 인자명을 대조하여 해당 계좌를 점유 하고 있는지 확인 할 수 있습니다.  
지정된 기간 내 반복적으로 요청하는 경우 1원 입금을 진행하지 않고 처리중으로 응답합니다. 지정된 기간은 별도 협의가 필요합니다.

## 11.2 API URL

 
| 구분  | URL |
| --- | --- |
| 테스트베드 키 | https://tbnpay.settlebank.co.kr/v1/api/auth/ownership/req |
| 상용 환경 키 | https://npay.settlebank.co.kr/v1/api/auth/ownership/req |

## 11.3 요청 전문 (가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문정보 | 전문정보 코드 | AN(50) | ●   | “SPAY\_AA00\_1.0”  <br>※ 고정값 |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “midtest” |
| mchtTrdNo | 가맹점 거래번호 | 가맹점 거래번호  <br>※ 한글제외 | AN(100) | ●   | "OID201902210001" |
| mchtCustId | 고객아이디 | 상점에서 보내주는 고유 고객아이디 혹은 Unique 한 Key  <br>AES 암호화 | AN(100) | ●   | "honggildong" |
| reqDt | 요청일자 | yyyyMMdd | AN(8) | ●   | “20191231” |
| reqTm | 요청시간 | HH24MISS | AN(6) | ●   | “120000” |
| mchtCustNm | 통장예금주명 | 통장예금주명 **(한글 3byte)**  <br>AES 암호화 | AN(20) | ○   | "홍길동" |
| bankCd | 은행코드 | [금융기관코드 테이블](#item-926) 참조 | AN(3) | ●   | "004" |
| custAcntNo | 계좌번호 | 계좌번호 "-" 제외  <br>AES 암호화 | AN(15) | ●   | "1234567890" |
| authType | 인증번호유형 | 인증번호 생성유형 | AN(1) | ●   | "1" : 숫자 3자리  <br>"2" : 영문대문자 + 숫자 2자리  <br>"3" : 한글단어조합 4 글자  <br>"4" : 숫자 4자리 |
| remitterNm | 보낸사람 정보  <br>(송금인명칭) | 고객의 통장에 찍힐 인자 내용의 앞 또는 뒷고정 문자아열  <br>영대문자 또는 한글 **(한글 2byte)**  <br>AES 암호화 | AN(8) | ○   | "이베이" 또는 "│"(최대 4글자)  <br>※ 요청된 문자 앞 또는 뒤에 랜덤한 3자리(숫자, 한글)  <br>조합하여 고객통장에 찍힘  <br>  <br>고객인자내용  <br>ex) 이베이A12 or A12이베이  <br>※ 인증번호유형이 "3"이고, 인증번호생성주체가  <br>"자동생성"이면 해당 항목이 무시됨.  <br>※ 인증번호유형이 "4"이면, 최대 3글자 지원 |
| textPos | 보낸사람 정보  <br>(송금인명칭)  <br>위치 | 보낸사람 정보(송금인명칭)  <br>문구의 위치 | AN(1) | ○   | "F" : 전위 도는 "R" : 후위  <br>Default : "R" |
| authVldTm | 인증 유효시간 | 초 단위 | N(5) | ○   | "600"  <br>※ 계좌점유인증 요청 후 성공 응답시  <br>거래번호 발생 기준으로 인증 유효시간 지정  <br>Default : 600초 |
| apintTm | 반복 요청  <br>방지시간 | 초 단위 | N(5) | ○   | "600"  <br>※ 지정된 시간 내 반복적으로 요청하는 경우  <br>1원 입금을 진행하지 않고 처리중으로 응답  <br>Default : 600초 |
| custIp | 고객 IP 주소 | 가맹점 서버의 IP가 아닌 고객 기기의 IP 주소 | AN(15) | ○   | “127.0.0.1”  <br>IP 차단 정책 설정시 필요 |
| pktHash | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 11.4 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash 값 | 상점아이디 + 요청일자 + 요청시간 + 은행코드 + 계좌번호(평문) + 인증키 |

## 11.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| outStatCd | 거래상태 | 거래상태코드(성공/실패) | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031 |
| outRsltCd | 거절코드 | [거절코드 테이블](#item-1010) 참조 | AN(4) | ●   |     |
| outRsltMsg | 결과메시지 | 오류가 발생시 오류에 대한 메시지 전달 | AN(300) | ●   | “정상처리되었습니다.” |
| mchttrdNo | 가맹점 거래번호 | 가맹점 거래번호  <br>\* 한글 제외 | AN(100) | ●   | "OID201902210001" |
| trdNo | 거래번호 | 헥토파이낸셜 거래번호 | AN(40) | ●   | "SFP\_FIRM12345678901234567890" |
| mchtCustld | 고객아이디 | 상점에서 보내주는 고유 고객아이디 혹은 Unique 한 Key  <br>AES 암호화 | AN(100) | ●   | "honggildong" |
| bankChkYn | 은행점검여부 | 요청시점 기준  <br>은행점검 여부 | AN(1) | ●   | "Y" 또는 "N"  <br>※ 은행의 정기/비정기 점검시간인 경우,  <br>은행으로부터 장애상황에 대한 공유나  <br>거래지연으로 확인되는 경우에 은행점검으로 응답됩니다. |
| stDtm | 점검시작일시 | yyyyMMddhhmmss | AN(14) | ○   | "20200729000900" |
| edDtm | 점검종료일시 | yyyyMMddhhmmss | AN(14) | ○   | "20200729001000" |

#  12\. 계좌점유인증 확인

## 12.1 API 요약 설명

계좌점유인증 요청을 통해 고객 통장으로 1원과 함꼐 보낸 통장 인자명을 대조하여 해당 계좌를 점유 하고 있는지 확인 할 수 있습니다.

## 12.2 API URL

 
| 구분  | URL |
| --- | --- |
| 테스트베드 키 | https://tbnpay.settlebank.co.kr/v1/api/auth/ownership/check |
| 상용 환경 키 | https://npay.settlebank.co.kr/v1/api/auth/ownership/check |

## 12.3 요청 전문 (가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문정보 | 전문정보 코드 | AN(50) | ●   | “SPAY\_RC10\_1.0”  <br>※ 고정값 |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “midtest" |
| mchtTrdNo | 가맹점 거래번호 | 가맹점 거래번호  <br>※ 한글제외  <br>인증요청시 가맹점 거래번호 | AN(100) | ●   | "OID201902210001" |
| mchtCustId | 고객아이디 | 상점에서 보내주는 고유 고객아이디 혹은 Unique 한 Key  <br>AES 암호화 | AN(100) | ●   | "honggildong" |
| reqDt | 요청일자 | yyyyMMdd | AN(8) | ●   | “20191231” |
| reqTm | 요청시간 | HH24MISS | AN(6) | ●   | “120000” |
| authNo | 인증번호 | 고객의 통장인자내용에 찍힌 보낸사람 정보(송금인명칭)를 제외한 인증번호  <br>AES 암호화 | AN(12) | ●   | "A12"  <br>※ 요청시 보낸사람 정보 앞 또는 뒤에  <br>랜덤한 3자리 인증번호  <br>ex) 이베이 A12 or A12이베이 경우  <br>"A12"로 요청  <br>※ 인증번호유형이 "3"인 경우  <br>한글단어조합 4글자 |
| custIp | 고객 IP 주소 | 가맹점 서버의 IP가 아닌 고객 기기의 IP 주소 | AN(15) | ○   | “127.0.0.1” |
| pktHash | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 12.4 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash 값 | 상점아이디 + 요청일자 + 요청시간 + 가맹점 거래번호 + 인증키 |

## 12.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| outStatCd | 거래상태 | 거래상태코드(성공/실패) | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031 |
| outRsltCd | 거절코드 | [거절코드 테이블](#item-1010) 참조 | AN(4) | ●   |     |
| outRsltMsg | 결과메시지 | 오류가 발생시 오류에 대한 메시지 전달 | AN(300) | ●   | “성공” |
| mchtCustld | 고객아이디 | 상점에서 보내주는 고유 고객아이디 혹은 Unique 한 Key  <br>AES 암호화 | AN(100) | ●   | "honggildong" |
| trdNo | 거래번호 | 헥토파이낸셜 거래번호 | AN(40) | ●   | "SFP\_FIRM12345678901234567890" |
| mchtTrdNo | 가맹점거래번호 | 가맹점 거래번호  <br>\* 한글제외 | AN(100) | ●   | "OID201902210001" |

#  13\. ARS인증 요청

## 13.1 API 요약 설명

가맹점 서버에서 헥토파이낸셜 서버로 ARS 인증을 요청 합니다.  
고객의 계좌 출금이체 등록을 인증하는 목적으로 해당 API를 제공하며 ARS 인증 확인 API를 통하여 인증 결과를 확인할 수 있습니다.

## 13.2 API URL

 
| 구분  | URL |
| --- | --- |
| 테스트베드 키 | https://tbnpay.settlebank.co.kr/v1/api/auth/ars |
| 상용 환경 키 | https://npay.settlebank.co.kr/v1/api/auth/ars |

## 13.3 요청 전문 (가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문정보 | 전문정보 코드 | AN(50) | ●   | “SPAY\_AU00\_1.0”  <br>※ 고정값 |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “midtest” |
| procDiv | 업무구분 | A0 : 출금등록  <br>XX : ARS 시나리오 | AN(2) | ○   | "A0" : 기본값  <br>"XX" : ARS 시나리오별 인증구분 |
| mchtTrdNo | 주문번호 | 상점주문번호  <br>※ 한글제외 | AN(100) | ○   | "OID201902210001" |
| mchtCustId | 고객아이디 | 상점에서 보내주는 고유 고객아이디 혹은 Unique 한 Key  <br>AES 암호화 | AN(100) | ●   | "honggildong" |
| reqDt | 요청일자 | yyyyMMdd | AN(8) | ●   | “20191231” |
| reqTm | 요청시간 | HH24MISS | AN(6) | ●   | “120000” |
| bankCd | 출금은행코드 | [금융기관코드 테이블](#item-926) 참조 | AN(3) | ●   | "004" |
| custAcntNo | 출금계좌번호 | 고객 출금 계좌번호  <br>계좌번호 "-" 제외  <br>AES 암호화 | AN(15) | ○   | "1234567890" |
| mchtCustNm | 예금주명 | 영문/숫자/한글 **(한글 3byte)**  <br>AES 암호화 | AN(60) | ●   | "홍길동" |
| authNo | 인증번호 | 고객의 휴대기기로 인증해야할 6자리 이하의 숫자 | N(6) | ●   | "910228"(생년월일은 지양)  <br>"56"(없을경우 임의 발생) |
| cphoneNo | 휴대전화번호 | ARS인증 시 필요한 고객 휴대전화번호 '-'제외  <br>AES 암호화 | AN(11) | ●   | "01000001234" |
| payerNo | 납부자번호 | 출금을 위한 납부자번호  <br>\* 해당 항목은 별도 협의 후 사용 | AN(20) | ○   | "TESTMCHT00000001" |
| custIp | 고객 IP 주소 | 가맹점 서버의 IP가 아닌 고객 기기의 IP 주소 | AN(15) | ○   | “127.0.0.1” |
| pktHash | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 13.4 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash 값 | 상점아이디 + 고객아이디(평문) + 요청일자 + 요청시간 + 휴대전화번호(평문) + 인증키 |

## 13.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| outStatCd | 거래상태 | 거래상태코드(성공/실패) | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031 |
| outRsltCd | 거절코드 | [거절코드 테이블](#item-1010) 참조 | AN(4) | ●   |     |
| outRsltMsg | 결과메시지 | 오류가 발생시 오류에 대한 메시지 전달 | AN(300) | ●   | “정상처리되었습니다.” |
| mchtTrdNo | 주문번호 | 상점 주문번호  <br>\*한글제외 | AN(100) | ○   | "OID201902210001" |
| trdNo | 거래번호 | 휴대폰 인증요청에 대한 헥토파이낸셜 거래번호 | AN(40) | ●   | “SFP\_FIRM12345678901234567890” |

#  14\. ARS 인증 확인

## 14.1 API 요약 설명

가맹점 서버에서 헥토파이낸셜 서버로 ARS 인증결과를 조회 요청합니다.  
인증을 요청받은 고객이 ARS인증을 정상적으로 수행하였는지 확인하는 API 입니다. 고객의 계좌 출금이체등록을 인증하는 목적으로 ARS 인증/확인 API를 제공하며 ARS 확인 요청의 응답인 거래번호가 출금이체등록(계좌등록) API 에 사용됩니다.

## 14.2 API URL

 
| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tbnpay.settlebank.co.kr/v1/api/auth/arscheck |
| 상용 환경 | https://npay.settlebank.co.kr/v1/api/auth/arscheck |

## 14.3 요청 전문 (가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문정보 | 전문정보 코드 | AN(50) | ●   | “SPAY\_RC0W\_1.0”  <br>※ 고정값 |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “midtest” |
| mchtTrdNo | 주문번호 | 상점주문번호  <br>\*한글제외 | AN(100) | ○   | "OID201902210001" |
| mchtCustId | 고객아이디 | 상점에서 보내주는 고유 고객아이디 혹은 Unique 한 Key  <br>AES 암호화 | AN(100) | ●   | “honggildong” |
| reqDt | 요청일자 | yyyyMMdd | AN(8) | ●   | “20191231” |
| reqTm | 요청시간 | HH24MISS | AN(6) | ●   | “120000” |
| trdNo | 거래번호 | 헥토파이낸셜 거래번호 | AN(50) | ●   | "SFP\_FIRM1234465767890998"  <br>ARS인증 요청의 결과로 가맹점측에서 수신한  <br>(헥토파이낸셜이 생성한) 거래번호 |
| custIp | 고객 IP 주소 | 가맹점 서버의 IP가 아닌 고객 기기의 IP 주소 | AN(15) | ○   | “127.0.0.1” |
| pktHash | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 14.4 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash 값 | 상점아이디 + 고객아이디(평문) + 요청일자 + 요청시간 + 거래번호 + 인증키 |

## 14.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| outStatCd | 거래상태 | 거래상태코드(성공/실패) | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031  <br>거래없음 : 0092  <br>진행중 : 0000 |
| outRsltCd | 거절코드 | [거절코드 테이블](#item-1010) 참조 | AN(4) | ●   |     |
| outRsltMsg | 결과메시지 | 오류가 발생시 오류에 대한 메시지 전달 | AN(300) | ●   | “정상처리되었습니다.” |
| retCd | 오류코드 | 인증진행중 : 000  <br>성공 : 0000  <br>실패 :  <br>04 인증번호불일치  <br>08 인증번호입력시간 초과  <br>10 연결실패(없는번호)  <br>11 연결실패(수신거부)  <br>12 연결실패(시간초과)  <br>20 ARS인증취소  <br>99 기타오류  <br>005 파라미터 오류  <br>007 데이터오류  <br>100 ARS인증 초기값  <br>700 ARS 미요청  <br>800 ARS 요청실패  <br>999 DB 초기값 | AN(3) | ●   |     |
| mchtTrdNo | 주문번호 | 상점 주문번호  <br>\*한글제외 | AN(100) | ○   | "OID201902210001" |
| trdNo | 거래번호 | 헥토파이낸셜 거래번호 | AN(40) | ●   | “SFP\_FIRM12345678901234567890” |

#  15\. 계좌 등록

## 15.1 API 요약 설명

가맹점 서버에서 헥토파이낸셜 서버로 계좌등록을 요청합니다.  
'ARS 인증 확인' API의 결과 값인 거래번호(trdNo)를 사용하여 계좌등록 (출금이체 등록)을 진행 합니다. 등록된 계좌로 추후 결제(출금)을 진행 할수 있습니다. 

## 15.2 ARI URL

 
| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tbnpay.settlebank.co.kr/v1/api/acnt/reg |
| 상용 환경 | https://npay.settlebank.co.kr/v1/api/acnt/reg |

## 15.3 요청 전문 (가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문정보 | 전문정보 코드 | AN(50) | ●   | “SPAY\_RE0W\_1.0”  <br>※ 고정값 |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “midtest” |
| mchtTrdNo | 주문번호 | 상점 주문번호  <br>\* 한글제외 | AN(100) | ●   | "OID201902210001" |
| trdNo | 거래번호 | 헥토파이낸셜 거래번호.  <br>ARS인증시 리턴받은 거래번호 셋팅  <br>authMthdCd : ARS인경우 필수 | AN(50) | ○   | "T2019022100001" |
| mchtCustId | 고객아이디 | 상점에서 보내주는 고유 고객아이디 혹은 Unique 한 Key  <br>AES 암호화 | AN(100) | ●   | “honggildong” |
| reqDt | 요청일자 | yyyyMMdd | AN(8) | ●   | “20191231” |
| reqTm | 요청시간 | HH24MISS | AN(6) | ●   | “120000” |
| mchtCustNm | 예금주명 | 영문/숫자/한글 **(한글 3byte)**  <br>AES 암호화 | AN(60) | ●   | "홍길동" |
| uii | 생년월일  <br>/사업자번호 | 생년월일: yyMMdd  <br>사업자번호: 10자리 (‘-‘ 제외)  <br>AES 암호화 | AN(10) | ●   | “8001012” |
| bankCd | 은행코드 | [금융기관코드 테이블](#item-926) 참조 | AN(3) | ●   | “004” |
| custAcntNo | 계좌번호 | 계좌번호 "-" 제외 최소 9, 최대 15  <br>AES 암호화 | AN(15) | ●   | “1234567890” |
| authMthdCd | 인증구분코드 | 출금이체 동의 자료  <br>WR : 서면파일  <br>ARS  : ARS인증  <br>PASS : PASS 인증서  <br>기본값 : ARS | AN(5) | ○   | “ARS” |
| custIp | 고객 IP 주소 | 가맹점 서버의 IP가 아닌 고객 기기의 IP 주소 | AN(15) | ○   | “127.0.0.1” |
| pktHash | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 15.4 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash 값 | 상점아이디 + 고객아이디(평문) + 요청일자 + 요청시간 + 계좌번호(평문) + 인증키 |

## 15.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| outStatCd | 거래상태 | 거래상태코드(성공/실패) | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031 |
| outRsltCd | 거절코드 | [거절코드 테이블](#item-1010) 참조 | AN(4) | ●   | ST08 : 이미 등록된 계좌일 경우 등록된 계좌 정보 전달 |
| outRsltMsg | 결과메시지 | 오류가 발생시 오류에 대한 메시지 전달 | AN(300) | ●   | “정상처리되었습니다.” |
| mchtCustId | 고객아이디 | 상점에서 보내주는 고유 고객아이디 혹은 Unique 한 Key  <br>AES 암호화 | AN(100) | ●   | "honggildong" |
| bankCd | 은행코드 | 3자리 은행코드 | AN(3) | ●   | "004" |
| custAcntNo | 계좌번호 | 계좌번호 마스킹 처리  <br>ex) 234\*\*\*\*\*\*\*123 | AN(15) | ●   | "234\*\*\*\*\*\*\*123" |
| custAcntKey | 계좌번호키 | 출금이체등록된 계좌의 일련번호 | AN(50) | ●   | "d894kjd93kd9" |
| svcDivCd | 계좌등록서비스구분 | 출금이체 등록 된 서비스 | N(1) | ●   | 1: 펌뱅킹 |
| mchtTrdNo | 주문번호 | 상점 주문번호  <br>\*한글제외 | AN(100) | ○   | "OID201902210001" |
| trdNo | 거래번호 | 헥토파이낸셜 거래번호 | AN(40) | ●   | “SFP\_FIRM12345678901234567890” |
| payerNo | 납부자번호 | 출금을 위한 납부자번호 | AN(20) | ●   | "TESTMCHT00000001" |

#  16\. 계좌 해지

## 16.1 API 요약 설명

가맹점 서버에서 헥토파이낸셜 서버로 계좌해지를 요청합니다.  
계좌등록(출금이체등록)을 통해 등록 된 계좌의 등록(출금이체) 해지를 진행합니다. 

## 16.2 API URL

 
| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tbnpay.settlebank.co.kr/v1/api/acnt/unreg |
| 상용 환경 | https://npay.settlebank.co.kr/v1/api/acnt/unreg |

## 16.3 요청 전문 (가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문정보 | 전문정보 코드 | AN(50) | ●   | “SPAY\_DE0W\_1.0”  <br>※ 고정값 |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “midtest” |
| bankCd | 은행코드 | 3자리 은행코드 | AN(3) | ●   | "004" |
| custAcntKey | 계좌번호키 | 출금이체등록된 계좌의 일련번호 | AN(50) | ○   | "d894kjd93kd9" |
| mchtTrdNo | 주문번호 | 상점 주문번호  <br>\* 한글제외 | AN(100) | ●   | "OID201902210001" |
| mchtCustId | 고객아이디 | 상점에서 보내주는 고유 고객아이디 혹은 Unique 한 Key  <br>AES 암호화 | AN(100) | ●   | “honggildong” |
| reqDt | 요청일자 | yyyyMMdd | AN(8) | ●   | “20191231” |
| reqTm | 요청시간 | HH24MISS | AN(6) | ●   | “120000” |
| custIp | 고객 IP 주소 | 가맹점 서버의 IP가 아닌 고객 기기의 IP 주소 | AN(15) | ○   | “127.0.0.1” |
| pktHash | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 16.4 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash 값 | 상점아이디 + 고객아이디(평문) + 요청일자 + 요청시간 + 인증키 |

## 16.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| outStatCd | 거래상태 | 거래상태코드(성공/실패) | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031 |
| outRsltCd | 거절코드 | [거절코드 테이블](#item-1010) 참조 | AN(4) | ●   | ST08 : 이미 등록된 계좌일 경우 등록된 계좌 정보 전달 |
| outRsltMsg | 결과메시지 | 오류가 발생시 오류에 대한 메시지 전달 | AN(300) | ●   | “정상처리되었습니다.” |
| mchtCustId | 고객아이디 | 상점에서 보내주는 고유 고객아이디 혹은 Unique 한 Key  <br>AES 암호화 | AN(100) | ●   | "honggildong" |
| mchtTrdNo | 주문번호 | 상점 주문번호  <br>\*한글제외 | AN(100) | ○   | "OID201902210001" |
| trdNo | 거래번호 | 헥토파이낸셜 거래번호 | AN(40) | ●   | “SFP\_FIRM12345678901234567890” |

#  17\. 가맹점 자체 계좌 등록

## 17.1 API 요약 설명

가맹점이 자체적으로 출금 등록한 계좌 정보를 가맹점 서버에서 헥토파이낸셜 서버로 계좌등록을 요청합니다.   
등록된 계좌로 추후 결제(출금)을 진행 할 수 있습니다. 

## 17.2 API URL

 
| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tbnpay.settlebank.co.kr/v1/api/acnt/reg/self |
| 상용 환경 | https://npay.settlebank.co.kr/v1/api/acnt/reg/self |

## 17.3 요청 전문 (가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문정보 | 전문정보 코드 | AN(50) | ●   | “SPAY\_RB0W\_1.0”  <br>※ 고정값 |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “midtest” |
| mchtTrdNo | 주문번호 | 상점 주문번호  <br>\* 한글제외 | AN(100) | ●   | "OID201902210001" |
| payerNo | 납부자번호 | 출금을 위한 납부자번호 | AN(20) | ●   | "TESTMCHT0000001" |
| mchtCustId | 고객아이디 | 상점에서 보내주는 고유 고객아이디 혹은 Unique 한 Key  <br>AES 암호화 | AN(100) | ●   | “honggildong” |
| reqDt | 요청일자 | yyyyMMdd | AN(8) | ●   | “20191231” |
| reqTm | 요청시간 | HH24MISS | AN(6) | ●   | “120000” |
| mchtCustNm | 예금주명 | 영문/숫자/한글 **(한글 3byte)**  <br>AES 암호화 | AN(30) | ●   | "홍길동" |
| uii | 생년월일  <br>/사업자번호 | 생년월일 : yymmdd  <br>사업자번호 : 10자리 (‘-‘ 제외)  <br>AES 암호화 | AN(10) | ●   | “800101” |
| bankCd | 은행코드 | [금융기관코드 테이블](#item-926) 참조 | AN(3) | ●   | “004” |
| custAcntNo | 계좌번호 | 계좌번호 "-" 제외 최소 9, 최대 15  <br>AES 암호화 | AN(15) | ●   | “1234567890” |
| custIp | 고객 IP 주소 | 가맹점 서버의 IP가 아닌 고객 기기의 IP 주소 | AN(15) | ○   | “127.0.0.1” |
| pktHash | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 17.4 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash 값 | 상점아이디 + 고객아이디(평문) + 요청일자 + 요청시간 + 계좌번호(평문) + 인증키 |

## 17.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| outStatCd | 거래상태 | 거래상태코드(성공/실패) | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031 |
| outRsltCd | 거절코드 | [거절코드 테이블](#item-1010) 참조 | AN(4) | ●   | ST08 : 이미 등록된 계좌일 경우 등록된 계좌 정보 전달 |
| outRsltMsg | 결과메시지 | 오류가 발생시 오류에 대한 메시지 전달 | AN(300) | ●   | “정상처리되었습니다.” |
| mchtCustId | 고객아이디 | 상점에서 보내주는 고유 고객아이디 혹은 Unique 한 Key  <br>AES 암호화 | AN(100) | ●   | "honggildong" |
| bankCd | 은행코드 | 은행기관코드 3자리 | AN(3) | ●   | "004" |
| custAcntNo | 계좌번호 | 계좌번호 마스킹 처리  <br>ex) 234\*\*\*\*\*\*\*123 | AN(15) | ●   | "234\*\*\*\*\*\*\*123" |
| custAcntKey | 계좌번호키 | 출금이체등록된 계좌의 일련번호 | AN(50) | ○   | "d894kjd93kd9" |
| mchtTrdNo | 주문번호 | 상점 주문번호  <br>\*한글제외 | AN(100) | ●   | "OID201902210001" |
| trdNo | 거래번호 | 헥토파이낸셜 거래번호 | AN(40) | ●   | “SFP\_FIRM12345678901234567890” |

#  18\. 결제

## 18.1 API 요약 설명

가맹점 서버에서 헥토파이낸셜 서버로 결제를 요청합니다.   
계좌등록(출금이체 등록)을 통해 등록된 계좌를 결제(고객 계좌에서 출금이체)를 진행 할 수 있습니다. 본 API 수행 결과로 고객의 계좌에서 가맹점의 모계좌로 현금이 이동 됩니다. 

## 18.2 API URL

 
| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tbnpay.settlebank.co.kr/v1/api/pay/confirm |
| 상용 환경 | https://npay.settlebank.co.kr/v1/api/pay/confirm |

## 18.3 요청 전문(가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문정보 | 전문정보 코드 | AN(50) | ●   | “SPAY\_RP0W\_1.0”  <br>※ 고정값 |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “midtest” |
| mchtTrdNo | 주문번호 | 상점주문번호  <br>※ 한글제외 | AN(100) | ●   | "OID201902210001" |
| mchtCustId | 고객아이디 | 상점에서 보내주는 고유 고객아이디 혹은 Unique 한 Key  <br>AES 암호화 | AN(100) | ●   | "honggidong" |
| reqDt | 요청일자 | yyyyMMdd | AN(8) | ●   | “20191231” |
| reqTm | 요청시간 | HH24MISS | AN(6) | ●   | “120000” |
| trdAmt | 거래금액 | 출금할 금액(거래금액) | AN(13) | ●   | "1000" |
| bankCd | 출금은행코드 | 등록된 고객 출금은행 코드 | AN(3) | ●   | "004" |
| custAcntKey | 계좌번호키 | 출금이체 등록된 계좌의 일련번호 | AN(50) | ○   | "d894kjd93kd9" |
| splAmt | 공급가액 | 공급가액 | N(13) | ○   | "0" |
| vat | 부가세 | 부가세 | N(13) | ○   | "0" |
| svcAmt | 봉사료 | 봉사료 | N(13) | ○   | "0" |
| pmtPrdtNm | 결제상품명 | 결제한 상품명을 설정 **(한글 3byte)** | AN(100) | ○   | "상품명" |
| custAcntSumry | 통장인자내용 | 고객의 통장에 찍힐 인자명 **(한글 3byte)** | AN(30) | ○   | "홍길동" |
| csrcIssReqYn | 현금영수증 발행여부 | Y : 현금영수증 발행  <br>N : 현금영수증 미발행 | A(1) | ○   | "N" |
| csrcIssPsblYn | 현금영수증 발행가능 여부 | Y : 현금영수증 발행 가능 거래  <br>N : 현금영수증 발행 불가 거래 | A(1) | ○   | "N" |
| taxTypeCd | 면세여부 | Y : 면세  <br>N : 과세  <br>csrcIssReqYn  <br>Y (발행) 일 경우 필수 | A(1) | ○   | "N" |
| csrcRegProposYn | 용도구분 | 0 : 소득공제   <br>1 : 지출증빙  <br>csrcIssReqYn  <br>Y (발행) 일 경우 필수 | N(1) | ○   |     |
| csrcRegNoDivCd | 발행정보 구분 | 1 : 카드  <br>2 : 주민등록번호  <br>3 : 사업자등록 번호  <br>4 : 휴대폰번호  <br>csrcIssReqYn  <br>Y (발행) 일 경우 필수 | N(1) | ○   |     |
| csrcRegNo | 발행정보 | csrcRegNoDivCd 값에 따른 실제값  <br>csrcIssReqYn  <br>Y (발행) 일 경우 필수  <br>AES 암호화 | AN(20) | ○   |     |
| addDdtTypeCd | 추가공제구분 | Y : 대중교통  <br>C : 도서, 공연비 | A(1) | ○   |     |
| rglPmtYn | 정기결제여부 | Y : 정기결제  <br>N : 일반결제 | A(1) | ○   | DEFAULT  : N |
| rglEdDt | 정기결제종료일 | yyyyMMdd | AN(8) | ○   | "20210830" |
| custIp | 고객 IP 주소 | 가맹점 서버의 IP가 아닌 고객 기기의 IP 주소 | AN(15) | ○   | “127.0.0.1” |
| cupDepositAmt | 자원순환보증금  <br>(컵보증금) | 자원순환보증금액(컵보증금)이 포함될 경우 거래금액에   <br>자원순환보증금액을 포함해서 요청해야함 | N(13) | ○   |     |
| cmsCd | 추가인증고유번호 | 추가인증용 고유번호 | AN(16) | ○   |     |
| pktHash | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 18.4 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash 값 | 상점아이디 + 고객아이디(평문) + 주문일자 + 주문시간 + 거래금액 + 출금은행코드 + 인증키 |

## 18.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| outStatCd | 거래상태 | 거래상태코드(성공/실패) | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031 |
| outRsltCd | 거절코드 | [거절코드 테이블](#item-1010) 참조 | AN(4) | ●   | ST08 : 이미 등록된 계좌일 경우 등록된 계좌 정보 전달 |
| outRsltMsg | 결과메시지 | 오류가 발생시 오류에 대한 메시지 전달 | AN(300) | ●   | “정상처리되었습니다.” |
| trdNo | 거래번호 | 헥토파이낸셜 거래번호 | AN(40) | ●   | “SFP\_FIRM12345678901234567890” |
| trdAmt | 거래금액 | 출금한 금액 (거래금액) | N(13) | ●   | "1000" |
| mchtTrdNo | 주문번호 | 상점 주문번호  <br>\*한글제외 | AN(100) | ●   | "OID201902210001" |
| rglChrgKey | 정기결제키 | 정기결제용으로 생성된 유니크한 키 | AN(32) | ○   |     |
| svcDivCd | 결제시 사용된 서비스 | 결제(출금이체)된 서비스 | N(4) | ●   | 1 : 펌뱅킹 |
| custAcntNo | 계좌번호 | 계좌번호 마스킹 처리  <br>ex)234\*\*\*\*\*\*\*\*\*\*123 | AN(15) | ●   | "234\*\*\*\*\*\*\*\*\*\*123" |
| macntNo | 모계좌 계좌번호 | 모계좌 계좌번호 "-" 제외  <br>AES 암호화 | AN(24) | ○   |     |

#  19\. 결제 취소/환불

## 19.1 API 요약 설명

가맹점 서버에서 헥토파이낸셜 서버로 결제 취소/환불을 요청합니다.  
결제(출금)된 거래건에 대하여 환불(결제취소)를 실행 합니다. 결제 거래건의 거래번호로 해당건의 환불을 진행할 수 있습니다. 

## 19.2 API URL

 
| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tbnpay.settlebank.co.kr/v1/api/pay/cancel |
| 상용 환경 | https://npay.settlebank.co.kr/v1/api/pay/cancel |

## 19.3 요청 전문(가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문정보 | 전문정보 코드 | AN(50) | ●   | “SPAY\_RT0W\_1.0”  <br>※ 고정값 |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “midtest” |
| mchtTrdNo | 주문번호 | 상점취소주문번호  <br>※ 한글제외  <br>원거래에 대한 번호가 아닌 취소요청의   <br>주문번호 | AN(100) | ●   | "OID201902210001" |
| mchtCustId | 고객아이디 | 상점에서 보내주는 고유 고객아이디 혹은 Unique 한 Key  <br>AES 암호화 | AN(100) | ●   | "honggildong" |
| mchtTrdDt | 취소주문일자 | yyyyMMdd | AN(8) | ●   | “20191231” |
| mchtTrdTm | 취소주문시간 | HH24MISS | AN(6) | ●   | “120000” |
| trdAmt | 거래금액 | 취소거래금액 또는 부분 취소 금액 | N(13) | ●   | "1000" |
| custAcntSumry | 통장인자내용 | 고객의 통장에 찍힐 인자명 **(한글 3byte)** | AN(30) | ○   | "홍길동" |
| splAmt | 공급가액 | 공급가액 | N(13) | ○   | "910" |
| vat | 부가세 | 부가세 | N(13) | ○   | "90" |
| svcAmt | 봉사료 | 봉사료 | N(13) | ○   | "0" |
| trdNo | 원거래번호 | 헥토파이낸셜 거래번호 | AN(50) | ●   | "SFP\_FIRM12345676709" |
| custIp | 고객 IP 주소 | 가맹점 서버의 IP가 아닌 고객 기기의 IP 주소 | AN(15) | ○   | “127.0.0.1” |
| pktHash | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 19.4 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash 값 | 상점아이디 + 고객아이디(평문) + 취소주문일자 + 취소주문시간 + 거래금액 + 원거래번호 + 인증키 |

## 19.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| outStatCd | 거래상태 | 거래상태코드(성공/실패) | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031 |
| outRsltCd | 거절코드 | [거절코드 테이블](#item-1010) 참조 | AN(4) | ●   | ST08 : 이미 등록된 계좌일 경우 등록된 계좌 정보 전달 |
| outRsltMsg | 결과메시지 | 오류가 발생시 오류에 대한 메시지 전달 | AN(300) | ●   | “정상처리되었습니다.” |
| mchtTrdNo | 취소 주문번호 | 상점 주문번호  <br>\*한글제외 | AN(100) | ●   | "OID201902210001" |
| trdNo | 취소 거래번호 | 헥토파이낸셜 거래번호 | AN(40) | ●   | “SFP\_FIRM12345678901234567890” |
| trdAmt | 환불금액 | 출금한 금액(거래금액) | N(13) | ●   | "1000" |
| svcDivCd | 환불시 사용된 서비스 | 환불시 사용된 서비스 | N(4) | ●   | 1 : 펌뱅킹 |

#  20\. 정기결제 승인

## 20.1 API 요약 설명

정기결제 거래건에 대한 승인요청 WEB API를 호출합니다.  
정기결제 키는 아래와 같은 방법으로 발행 가능하고, 발행 후에 해당 API를 통해 정기결제 키를 사용하여 정기결제를 실행하게 됩니다.  
\- [결제 요청](#item-993)시 정기결제여부 파라미터를 'Y'로 설정하여 최초 결제를 실행 한 경우, 해당 계좌에 대한 정기결제 키가 발행됩니다.  
\- [계좌 등록](#item-882) 이후 [정기결제 키 발행](#item-1631) 요청을 통해 등록된 계좌의 정기결제 키를 발행합니다.

## 20.2 API URL

 
| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tbnpay.settlebank.co.kr/v1/api/regular/confirm |
| 상용 환경 | https://npay.settlebank.co.kr/v1/api/regular/confirm |

## 20.3 요청 전문(가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문정보 | 전문정보 코드 | AN(50) | ●   | “SPAY\_SP10\_1.0”  <br>※ 고정값 |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “midtest” |
| mchtTrdNo | 주문번호 | 상점주문번호  <br>※ 한글제외 | AN(100) | ●   | "OID201902210001" |
| mchtCustId | 고객아이디 | 상점에서 보내주는 고유 고객아이디 혹은 Unique 한 Key  <br>AES 암호화 | AN(100) | ●   | "honggildong" |
| reqDt | 요청일자 | yyyyMMdd | AN(8) | ●   | “20191231” |
| reqTm | 요청시간 | HH24MISS | AN(6) | ●   | “120000” |
| trdAmt | 거래금액 | 출금할 금액(거래금액) | N(13) | ●   | "1000" |
| rglChrgKey | 정기결제키 | 정기결제용으로 생성된 유니크한 키 | AN(32) | ●   |     |
| splAmt | 공급가액 | 공급가액 | N(13) | ○   | "0" |
| vat | 부가세 | 부가세 | N(13) | ○   | "0" |
| svcAmt | 봉사료 | 봉사료 | N(13) | ○   | "0" |
| pmtPrdtNm | 결제상품명 | 결제한 상품명을 설정 | AN(50) | ○   | "상품명" |
| custAcntSumry | 통장인자내용 | 고객의 통장에 찍힐 인자명 | AN(7) | ○   | "홍길동" |
| csrslssReqYn | 현금영수증  <br>발행여부 | Y: 현금영수증 발행  <br>N: 현금영수증 미발행 | A(1) | ○   | "N" |
| csrcIssPsblYn | 현금영수증  <br>발행가능여부 | Y: 현금영수증 발행가능  <br>N: 현금영수증 발행 불가능 | A(1) | ○   | "N" |
| taxTypeCd | 면세여부 | Y : 면세  <br>N : 과세  <br>csrcIssReqYn  <br>Y 발행일 경우 필수 | A(1) | ○   | "N" |
| csrcReqPrposYn | 용도구분 | 0: 소득공제  <br>1: 지출증빙  <br>csrcIssReqYn  <br>Y 발행일 경우 필수 | N(1) | ○   |     |
| csrcRegNoDivCd | 발행정보구분 | 1: 카드  <br>2: 주민등록 번호  <br>3: 사업자등록번호  <br>4: 휴대폰번호  <br>csrcIssReqYn  <br>Y 발행일 경우 필수 | N(1) | ○   |     |
| csrcRegNo | 발행정보 | PidentityGb 값에 따른 실제값  <br>csrcIssReqYn Y발행 일 경우 필수  <br>AES암호화 | AN(20) | ○   |     |
| addDdtTypeCd | 추가공제구분 | Y : 대중교통  <br>C : 도서공연비  <br>csrcIssReqYn  <br>Y 발행일 경우 필수 | A(1) | ○   |     |
| custIp | 고객 IP 주소 | 가맹점 서버의 IP가 아닌 고객 기기의 IP 주소 | AN(15) | ○   | “127.0.0.1” |
| cupDepositAmt | 자원순환보증금  <br>(컵보증금) | 자원순환보증금액(컵보증금)이 포함될 경우 거래금액에   <br>자원순환보증금액을 포함해서 요청해야함 | N(13) | ○   |     |
| pktHash | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 20.4 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash 값 | 상점아이디 + 고객아이디(평문) + 요청일자 + 요청시간 + 거래금액 + 정기결제키 + 인증키 |

## 20.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| outStatCd | 거래상태 | 거래상태코드(성공/실패) | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031 |
| outRsltCd | 거절코드 | [거절코드 테이블](#item-1010) 참조 | AN(4) | ●   | ST08 : 이미 등록된 계좌일 경우 등록된 계좌 정보 전달 |
| outRsltMsg | 결과메시지 | 오류가 발생시 오류에 대한 메시지 전달 | AN(300) | ●   | “정상처리되었습니다.” |
| mchtTrdNo | 주문번호 | 상점 주문번호  <br>\*한글제외 | AN(100) | ●   | "OID201902210001" |
| trdNo | 거래번호 | 헥토파이낸셜 거래번호 | AN(40) | ○   | “SFP\_FIRM12345678901234567890” |
| rglPmtProcStatCd | 정기결제 처리상태 | 정기결제 요청건의 처리상태 응답 | A(1) | ○   | R : 정기결제 재처리 필요  <br>C : 정기결제 해지대상 |
| trdAmt | 거래금액 | 출금한 금액 (거래금액) | N(13) | ○   | "1000" |
| svcDivCd | 결제시 사용된 서비스 | 결제(출금이체) 된 서비스 | N(4) | ○   | 1: 펌뱅킹 |

#  21\. 정기결제 해지

## 21.1 API 요약 설명

기 등록된 정기결제를 해지하는 WEB API 를 호출합니다.

## 21.2 API URL

 
| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tbnpay.settlebank.co.kr/v1/api/regular/unreg |
| 상용 환경 | https://npay.settlebank.co.kr/v1/api/regular/unreg |

## 21.3 요청 전문(가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문정보 | 전문정보 코드 | AN(50) | ●   | “SPAY\_SE00\_1.0”  <br>※ 고정값 |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “midtest” |
| mchtTrdNo | 주문번호 | 상점주문번호  <br>※ 한글제외 | AN(100) | ●   | "OID201902210001" |
| mchtCustId | 고객아이디 | 상점에서 보내주는 고유 고객아이디 혹은 Unique 한 Key  <br>AES 암호화 | AN(100) | ●   | "honggildong" |
| reqDt | 요청일자 | yyyyMMdd | N(8) | ●   | “20191231” |
| reqTm | 요청시간 | HH24MISS | N(6) | ●   | “120000” |
| rglChrgKey | 정기결제키 | 정기결제용으로 생성된 유니크한 키 | AN(32) | ●   |     |
| custIp | 고객 IP 주소 | 가맹점 서버의 IP가 아닌 고객 기기의 IP 주소 | AN(15) | ○   | “127.0.0.1” |
| pktHash | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 21.4 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash 값 | 상점아이디 + 고객아이디(평문) + 요청일자 + 요청시간 + 정기결제키 + 인증키 |

## 21.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| outStatCd | 거래상태 | 거래상태코드(성공/실패) | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031 |
| outRsltCd | 거절코드 | [거절코드 테이블](#item-1010) 참조 | AN(4) | ●   | ST08 : 이미 등록된 계좌일 경우 등록된 계좌 정보 전달 |
| outRsltMsg | 결과메시지 | 오류가 발생시 오류에 대한 메시지 전달 | AN(300) | ●   | “정상처리되었습니다.” |
| mchtCustId | 고객아이디 | 상점에서 보내주는 고유 고객아이디 혹은 Unique 한 Key  <br>AES 암호화 | AN(100) | ●   | "honggildong" |
| mchtTrdNo | 주문번호 | 상점 주문번호  <br>\*한글제외 | AN(100) | ●   | "OID201902210001" |
| trdNo | 거래번호 | 헥토파이낸셜 거래번호 | AN(40) | ●   | “SFP\_FIRM12345678901234567890” |

#  22\. 정기결제 정보 조회

## 22.1 API 요약 설명

고객의 정기결제 계좌 정보를 요청합니다. 

## 22.2 API URL

 
| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tbnpay.settlebank.co.kr/v1/api/regular/info |
| 상용 환경 | https://npay.settlebank.co.kr/v1/api/regular/info |

## 22.3 요청 전문(가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문정보 | 전문정보 코드 | AN(50) | ●   | “SPAY\_SO00\_1.0”  <br>※ 고정값 |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “midtest” |
| mchtCustId | 고객아이디 | 상점에서 보내주는 고유 고객아이디 혹은 Unique 한 Key  <br>AES 암호화 | AN(100) | ●   | "honggildong" |
| reqDt | 요청일자 | yyyyMMdd | AN(8) | ●   | “20191231” |
| reqTm | 요청시간 | HH24MISS | AN(6) | ●   | “120000” |
| rglChrgKey | 정기결제키 | 정기결제용으로 생성된 유니크한 키 | AN(32) | ●   |     |
| pktHash | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 22.4 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash 값 | 상점아이디 + 고객아이디(평문) + 요청일자 + 요청시간 + 정기결제키 + 인증키 |

## 22.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| outStatCd | 거래상태 | 거래상태코드(성공/실패) | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031 |
| outRsltCd | 거절코드 | [거절코드 테이블](#item-1010) 참조 | AN(4) | ●   | ST08 : 이미 등록된 계좌일 경우 등록된 계좌 정보 전달 |
| outRsltMsg | 결과메시지 | 오류가 발생시 오류에 대한 메시지 전달 | AN(100) | ●   | “정상처리되었습니다.” |
| bankCd | 은행코드 | 은행코드 | AN(3) | ○   | "011" |
| bankNm | 은행명 | 은행명 **(한글 3byte)** | AN(45) | ○   | "국민은행" |
| custAcntNo | 계좌번호 | 계좌번호 마스킹 처리  <br>ex)234\*\*\*\*\*\*\*\*\*123 | AN(15) | ○   | "234\*\*\*\*\*\*\*\*\*123" |
| useStDt | 정기결제시작인 | yyyyMMdd | AN(8) | ○   | "20210830" |
| useEdDt | 정기결제종료일 | yyyyMMdd | AN(8) | ○   | "20991231" |
| rglPmtAmt | 정기결제금액 | 정기결제 첫 결제금액 | N(13) | ○   | "1000" |
| pmtAcmAmt | 결제누적금액 | 정기결제 성공 누적금액 | N(13) | ○   | "5000" |
| pmtAcmOrd | 결제누적회차 | 정기결제 성공 카운트 | N(13) | ○   | "5" |
| unregDt | 해지일자 | yyyyMMddhhmmss | AN(14) | ○   | "20210830080000" |
| unregStatCd | 해지코드 | 해지내용, 사용자입력이나  <br>은행 시스템 해지 코드 | AN(10) | ○   | EXPORE : 기간종료  <br>FAIL : 결제실패  <br>CANCEL : 가맹점해지  <br>ADMIN : 관리자해지 |

#  23\. 정기결제 거래내역 조회

## 23.1 API 요약 설명

정기결제 및 환불에 관한 거래 내역을 요청합니다. 

## 23.2 API URL

 
| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tbnpay.settlebank.co.kr/v1/api/regular/translist |
| 상용 환경 | https://npay.settlebank.co.kr/v1/api/regular/translist |

## 23.3 요청 전문(가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문정보 | 전문정보 코드 | AN(50) | ●   | “SPAY\_LS00\_1.0”  <br>※ 고정값 |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “midtest” |
| mchtCustId | 고객아이디 | 상점에서 보내주는 고유 고객아이디 혹은 Unique 한 Key  <br>AES 암호화 | AN(100) | ●   | "honggildong" |
| reqDt | 요청일자 | yyyyMMdd | AN(8) | ●   | “20191231” |
| reqTm | 요청시간 | HH24MISS | AN(6) | ●   | “120000” |
| rglChrgKey | 정기결제키 | 정기결제용으로 생성된 유니크한 키 | AN(32) | ●   |     |
| useStDt | 조회시작일 | yyyyMMdd | AN(8) | ●   | 조회 기간은 최대 1년 (365일) |
| useEdDt | 조회종료일 | yyyyMMdd | AN(8) | ●   |     |
| pktHash | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 23.4 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash 값 | 상점아이디 + 고객아이디(평문) + 요청일자 + 요청시간 + 정기결제키 + 인증키 |

## 23.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| outStatCd | 거래상태 | 거래상태코드(성공/실패) | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031 |
| outRsltCd | 거절코드 | [거절코드 테이블](#item-1010) 참조 | AN(4) | ●   | ST08 : 이미 등록된 계좌일 경우 등록된 계좌 정보 전달 |
| outRsltMsg | 결과메시지 | 오류가 발생시 오류에 대한 메시지 전달 | AN(300) | ●   | “정상처리되었습니다.” |
| dataCnt | 거래건수 | 거래내역이 존재하는 경우   <br>거래건수 | N(4) | ●   | "10" |
| trRecords | 거래내역 |     | <object> | ●   |     |
| \--recordTrdDt | 거래일자 | yyyyMMddhhmmss | AN(14) | ○   | "20210830080000" |
| \--recordBankCd | 은행코드 | 은행코드 | AN(3) | ○   | "011" |
| \--recordBankNm | 은행명 | 은행명 **(한글 3byte)** | AN(45) | ○   | "국민은행" |
| \--recordCustAcntNo | 은행 계좌 | 계좌번호 마스킹 처리 | AN(15) | ○   | "1234\*\*\*\*\*\*\*\*\*\*\*6546" |
| \--recordRglChrgKey | 정기결제키 | 정기결제용으로 생성된 유니크한 키 | AN(32) | ○   |     |
| \--recordTrdNo | 거래번호 | 헥토파이낸셜 거래번호 | AN(50) | ○   | "SFP\_FIRM1234576789890" |
| \--recordMchtTrdNo | 주문번호 | 상점 주문번호  <br>\*한글제외 | AN(100) | ○   | "OID2021083021343" |
| \--recordTrdAmt | 거래금액 | 거래금액 | N(13) | ○   | "50000" |
| \--recordUseOrd | 이용회차 | 이용회차 | N(13) | ○   | "1" |
| \--recordOutStatCd | 거래상태코드 | 상태코드 | AN(4) | ○   | 성공 : 0021  <br>실패 : 0031 |
| \--recordOutRsltCd | 거래결과코드 | 거절코드 테이블 참조 | AN(4) | ○   | "0000" |
| \--recordOutRsltMsg | 거래결과메시지 | 결과메시지 | AN(200) | ○   | "성공" |

#  24\. 송금

## 24.1 API 요약 설명

가맹점 서버에서 헥토파이낸셜 서버로 송금을 요청합니다. 

## 24.2 API URL

 
| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tbnpay.settlebank.co.kr/v1/api/pay/rmt |
| 상용 환경 | https://npay.settlebank.co.kr/v1/api/pay/rmt |

## 24.3 요청 전문(가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문정보 | 전문정보 코드 | AN(50) | ●   | “SPAY\_AR0W\_1.0”  <br>※ 고정값 |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “midtest” |
| mchtTrdNo | 주문번호 | 상점 주문번호  <br>\* 한글제외 | AN(100) | ●   | "OID2021083012345" |
| mchtCustId | 고객아이디 | 상점에서 보내주는 고유 고객아이디 혹은 Unique 한 Key  <br>AES 암호화 | AN(100) | ○   | "honggildong" |
| trdDt | 거래일자 | yyyyMMdd | AN(8) | ●   | “20191231” |
| trdTm | 거래시간 | HH24MISS | AN(6) | ●   | “120000” |
| bankCd | 입금은행코드 | [금융기관코드 테이블](#item-926) 참조 | AN(3) | ●   | "004" |
| custAcntNo | 입금은행계좌번호 | 계좌번호 "-"제외  <br>AES 암호화 | AN(15) | ●   | "123456664" |
| custAcntSumry | 입금통장인자내용 | 고객의 통장에 찍힐 인자명  <br>**※ 전각문자 사용 (7자)**  <br>AES 암호화 | AN(14) | ●   | "홍길동" |
| remitterNm | 송금인 실명 | 송금하는 사람의 본명  <br>**※ 전각문자 사용 (8자)**  <br>국민카드 송금일 경우 필수  <br>AES 암호화 | AN(16) | ○   | "홍길동" |
| directYn | 은행직계약여부 | N : 재판매 (기본값)  <br>Y : 직계약 | A(1) | ○   |     |
| macntBankCd | 모계좌 은행코드 | [금융기관코드 테이블](#item-926)  <br>참고(은행직계약시)  <br>PDirecYn Y 직계약 경우 필수 | AN(3) | ○   |     |
| macntNo | 모계좌 입금계좌번호 | 모계좌 계좌번호 "-" 제외(은행 직계약시)  <br>AES 암호화  <br>directYn Y (직계약) 인 경우 필수 | AN(15) | ○   |     |
| macntSumry | 모계좌 통장인자내용 | 모계좌 통장에 찍힐 인자내용(은행직계약시)  <br>**※ 전각문자 사용 (6자)**  <br>AES 암호화  <br>directYn Y (직계약) 인 경우 필수 | AN(12) | ○   |     |
| scrtCardVal | 안전코드번호 | 직계약 SC 은행 산출된 안전카드 번호  <br>AES 암호화 | AN(6) | ○   |     |
| firmPktNo | 펌뱅킹전문번호 |     | N(6) | ○   |     |
| macntPwd | 모계좌 비밀번호 | 은행별 계약에 따른 선택 입력사항  <br>**(새마을금고 필수)**  <br>AES 암호화 | AN(4) | ○   |     |
| trdAmt | 거래금액 | 송금할 금액(거래금액)  <br>최대 10억원 | N(13) | ●   | "1000" |
| custIp | 고객 IP주소 | 가맹점 서버의 IP가 아닌   <br>고객 기기의 IP주소 | AN(15) | ○   | "127.0.0.1" |
| pktHash | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 24.4 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash 값 | 상점아이디 + 주문번호 + 거래일자 + 거래시간 + 입금은행코드 + 입금계좌번호(평문) + 거래금액 + 인증키 |

## 24.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| outStatCd | 거래상태 | 거래상태코드(성공/실패) | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031 |
| outRsltCd | 거절코드 | [거절코드 테이블](#item-1010) 참조 | AN(4) | ●   | ST08 : 이미 등록된 계좌일 경우 등록된 계좌 정보 전달 |
| outRsltMsg | 결과메시지 | 오류가 발생시 오류에 대한 메시지 전달 | AN(300) | ●   | “정상처리되었습니다.” |
| mchtTrdNo | 주문번호 | 상점 주문번호   <br>\*한글제외 | AN(100) | ●   | "OID20210830080000" |
| trdNo | 거래번호 | 헥토파이낸셜 거래번호 | AN(40) | ●   | "SFP\_FIRM1233444365430698" |
| trdAmt | 거래금액 | 송금금액 | N(13) | ●   | "1000" |
| svcDivCd | 송금시 사용된 서비스 | 송금시 사용된 서비스 | N(4) | ●   | 1 : 펌뱅킹 |

#  25\. 송금계좌잔액 조회

## 25.1 API 요약 설명

가맹점 서버에서 헥토파이낸셜 서버로 송금계좌 잔액을 조회 합니다. 

## 25.2 API URL

 
| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tbnpay.settlebank.co.kr/v2/api/pay/rmt/blc |
| 상용 환경 | https://npay.settlebank.co.kr/v2/api/pay/rmt/blc |

## 25.3 요청 전문(가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문정보 | 전문정보 코드 | AN(50) | ●   | “SPAY\_CA0W\_1.0”  <br>※ 고정값 |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “midtest” |
| mchtTrdNo | 주문번호 | 상점 주문번호  <br>\* 한글제외 | AN(100) | ●   | "OID2021083012345" |
| trdDt | 거래일자 | yyyyMMdd | AN(8) | ●   | “20191231” |
| trdTm | 거래시간 | HH24MISS | AN(6) | ●   | “120000” |
| pktHash | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 25.4 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash 값 | 상점아이디 + 주문번호 + 거래일자 + 거래시간 + 인증키 |

## 25.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| outStatCd | 거래상태 | 거래상태코드(성공/실패) | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031 |
| outRsltCd | 거절코드 | [거절코드 테이블](#item-1010) 참조 | AN(4) | ●   | ST08 : 이미 등록된 계좌일 경우 등록된 계좌 정보 전달 |
| outRsltMsg | 결과메시지 | 오류가 발생시 오류에 대한 메시지 전달 | AN(300) | ●   | “정상처리되었습니다.” |
| mchtTrdNo | 주문번호 | 상점 주문번호   <br>\*한글제외 | AN(100) | ●   | "OID20210830080000" |
| trdNo | 거래번호 | 헥토파이낸셜 거래번호 | AN(40) | ●   | "SFP\_FIRM1233444365430698" |
| blcAmt | 잔액  | 송금계좌잔액  <br>AES 암호화 | N(13) | ●   | "1000" |

#  26\. 거래 결과조회

## 26.1 API요약 설명

결제승인결과 및 송금요청 결과에서 결과코드를 '처리중'으로 받았을 경우 또는 타임아웃이 발생한 경우 '성공' 혹은 '실패' 코드를 수신 할 때 까지 해당 API를 반복적으로 호출하여야 합니다.  
거래(송금/출금)와 거래 결과조회의 API간 호출 간격이 너무 짧을 경우 잘못된 응답을 받을 수 있으므로, 처리중 또는 타임아웃 응답이 발생한 이 후 10분 뒤 사용하는 것을 권장합니다.

## 26.2 API URL

 
| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tbnpay.settlebank.co.kr/v1/api/pay/morw |
| 상용 환경 | https://npay.settlebank.co.kr/v1/api/pay/morw |

## 26.3 요청 전문 (가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문정보 | 전문정보 코드 | AN(50) | ●   | “SPAY\_MORW\_1.0”  <br>※ 고정값 |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “midtest” |
| pktDivCd | 업무구분 | **기본값 : RP**  <br>출금 RP, 송금 AR | AN(2) | ●   | "RP" |
| mchtTrdNo | 주문번호 | 상점주문번호  <br>※ 한글제외  <br>거래요청시 주문번호 | AN(100) | ●   | "OID201902210001" |
| mchtTrdDt | 주문일자 | yyyyMMdd | AN(8) | ●   | “20201131” |
| reqDt | 요청일자 | yyyyMMdd | AN(8) | ●   | “20201231” |
| reqTm | 요청시간 | HH24MISS | AN(6) | ●   | “120000” |
| pktHash | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 26.4 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash 값 | 상점아이디 + 주문번호 + 주문일자 + 요청일자 + 요청시간 + 인증키 |

## 26.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| outStatCd | 거래상태 | 거래상태코드(성공/실패) | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031 |
| outRsltCd | 거절코드 | [거절코드 테이블](#item-1010) 참조 | AN(4) | ●   |     |
| outRsltMsg | 결과메시지 | 오류가 발생시 오류에 대한 메시지 전달 | AN(300) | ●   | “정상처리되었습니다.” |
| trdNo | 거래번호 | 헥토파이낸셜 거래번호 | AN(40) | ○   | “SFP\_FIRM12345678901234567890” |
| bankCd | 출금은행코드 | 출금은행코드 | AN(3) | ○   | "011" |
| svcDivCd | 거래시 사용된 서비스 | 거래시 사용된 서비스 | N(1) | ○   | 1: 펌뱅킹 |

#  27\. 거래내역조회

## 27.1 API 요약 설명

결제 및 환불에 관한 거래 내역을 요청합니다.  
가맹점의 주문일자, 주문 번호로 거래(결제/환불)에 대한 정보를 확인 할 수 있습니다.

## 27.2 API URL

 
| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tbnpay.settlebank.co.kr/v1/api/pay/translist |
| 상용 환경 | https://npay.settlebank.co.kr/v1/api/pay/translist |

## 27.3 요청 전문 (가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문정보 | 전문정보 코드 | AN(50) | ●   | “SPAY\_LT00\_1.0”  <br>※ 고정값 |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “midtest” |
| pktDivCd | 업무구분 | 결제 : RP,  취소 : RT  <br>주문번호의 업무구분 | AN(2) | ●   | "RP" |
| mchtTrdNo | 주문번호 | 상점주문번호  <br>※ 한글제외 | AN(100) | ●   | "OID201902210001" |
| mchtTrdDt | 주문일자 | yyyyMMdd | AN(8) | ●   | "20191231" |
| reqDt | 요청일자 | yyyyMMdd | AN(8) | ●   | “20191231” |
| reqTm | 요청시간 | HH24MISS | AN(6) | ●   | “120000” |
| pktHash | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 27.4 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash 값 | 상점아이디 + 주문번호  + 주문일자 + 요청일자 + 요청시간 + 인증키 |

## 27.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| outStatCd | 거래상태 | 거래상태코드(성공/실패) | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031 |
| outRsltCd | 결과코드 | [거절코드 테이블](#item-1010) 참조 | AN(4) | ●   |     |
| outRsltMsg | 결과메시지 | 오류가 발생시 오류에 대한 메시지 전달 | AN(300) | ●   | “정상처리되었습니다.” |
| dataCnt | 거래건수 | 거래내역이 존재하는 경우 | N(4) | ●   | "10" |
| trRecords | 거래내역 |     | <object> | ●   |     |
| \--recordOutRsltCd | 거래결과코드 | 거절코드 테이블 참조 | AN(4) | ●   | "ST00" |
| \--recordOutRsltMsg | 거래결과메시지 | 결과메시지 | AN(200) | ●   | "성공" |
| \--recordOutStatCd | 거래상태코드 | 상태코드 | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031 |
| \--recordPktDivCd | 거래구분 | 결제 : RP , 취소 : RT | AN(2) | ●   | "RP" |
| \--recordMchtTrdNo | 주문번호 | 상점 주문번호  <br>\*한글제외 | AN(100) | ●   | "OID203739450" |
| \--recordTrdNo | 거래번호 | 헥토파이낸셜 거래번호 | AN(40) | ○   | "SFP\_FIRM123454667789" |
| \--recordTrdDt | 거래일자 | yyyymmdd | AN(8) | ●   | "20210820" |
| \--recordTrdAmt | 거래금액 | 출금할 금액(거래금액) | N(13) | ●   | "1000" |
| \--recordBankCd | 출금은행코드 | 출금은행코드 | AN(3) | ●   | "011" |
| \--recordCustAcntNo | 출금은행계좌 | 계좌전호 마스킹 처리 | AN(15) | ●   | "831\*\*\*\*\*\*\*11" |
| \--recordSvcDivCd | 거래시 사용된 서비스 | 거래시 사용된 서비스 | N(1) | ○   | 1 : 펌뱅킹 |

#  28\. 계좌목록조회

## 28.1 API 요약 설명

고객의 계좌목록 정보를 요청합니다.  
고객의 아이디로 등록(출금이체등록) 된 계좌의 목록을 조회 할 수 있습니다. 

## 28.2 API URL

 
| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tbnpay.settlebank.co.kr/v1/api/acnt/list |
| 상용 환경 | https://npay.settlebank.co.kr/v1/api/acnt/list |

## 28.3 요청 전문 (가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문정보 | 전문정보 코드 | AN(50) | ●   | “SPAY\_LA00\_1.0”  <br>※ 고정값 |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “midtest” |
| mchtCustId | 고객아이디 | 상점에서 보내주는 고유 고객아이디  <br>혹은 Unique 한 Key  <br>AES 암호화 | AN(100) | ●   | "honggildong" |
| bankCd | 은행코드 | 3자리 은행코드 | AN(3) | ○   | "004" |
| reqDt | 요청일자 | yyyyMMdd | AN(8) | ●   | “20191231” |
| reqTm | 요청시간 | HH24MISS | AN(6) | ●   | “120000” |
| pktHash | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   | "1000" |

## 28.4 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash 값 | 상점아이디 + 고객아이디(평문) + 요청일자 + 요청시간  + 인증키 |

## 28.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| outStatCd | 거래상태 | 거래상태코드(성공/실패) | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031 |
| outRsltCd | 거절코드 | [거절코드 테이블](#item-1010) 참조 | AN(4) | ●   |     |
| outRsltMsg | 결과메시지 | 오류가 발생시 오류에 대한 메시지 전달 | AN(300) | ●   | “정상처리되었습니다.” |
| dataCnt | 계좌건수 | 거래내역이 존재하는 경우 거래건수 | N(4) | ●   | "10" |
| acntRecords | 계좌내역 |     | <object> | ●   |     |
| \--recordTrdDt | 등록일시 | yyyyMMddhhmmss | AN(14) | ●   | "20210820000000" |
| \--recordBankCd | 은행코드 | 은행코드 | AN(3) | ●   | "011" |
| \--recordCustAcntNoMask | 계좌번호 | 계좌번호 마스킹 처리  <br>ex) 234\*\*\*\*\*\*\*\*123 | AN(15) | ●   | "831\*\*\*\*\*\*\*11" |
| \--recordCustAcntKey | 계좌번호키 | 출금이체 등록된 계좌의 일련번호 | AN(50) | ●   | "d5409fdsl3558" |
| \--recordSvcDivCd | 계좌등록서비스구분 | 출금이체 등록 된 서비스 | N(1) | ●   | 1 : 펌뱅킹  <br>2 : 오픈뱅킹  <br>3 : 펌&오픈뱅킹 |
| \--recordUnregDt | 해지일시 | yyyyMMddhhmmss | AN(14) | ○   | "20210820000000" |

#  29\. 은행목록조회

## 29.1 API 요약 설명

가맹점에서 사용 가능한 은행 목록을 응답합니다.   
주로 가맹점의 결제창에서 해당 API를 호출하여 UI를 구성 할 때 사용 합니다. 

## 29.2 API URL

 
| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tbnpay.settlebank.co.kr/v1/api/bank/list |
| 상용 환경 | https://npay.settlebank.co.kr/v1/api/bank/list |

## 29.3 요청 전문 (가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문정보 | 전문정보 코드 | AN(50) | ●   | “SPAY\_LB00\_1.0”  <br>※ 고정값 |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “midtest” |
| reqDt | 요청일자 | yyyyMMdd | AN(8) | ●   | “20191231” |
| reqTm | 요청시간 | HH24MISS | AN(6) | ●   | “120000” |
| pktHash | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 29.4 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash 값 | 상점아이디 + 요청일자 + 요청시간 + 인증키 |

## 29.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| outStatCd | 거래상태 | 거래상태코드(성공/실패) | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031 |
| outRsltCd | 거절코드 | [거절코드 테이블](#item-1010) 참조 | AN(4) | ●   |     |
| outRsltMsg | 결과메시지 | 오류가 발생시 오류에 대한 메시지 전달 | AN(300) | ●   | “정상처리되었습니다.” |
| dataCnt | 은행 개수 | 거래내역이 존재하는경우 거래건수 | N(4) | ●   | "10" |
| bankRecords | 은행내역 |     | <object> | ●   |     |
| \--recordBankCd | 은행코드 | 은행코드 | AN(3) | ●   | "004" |
| \--recordBankNm | 은행명 | 은행명 **(한글 3byte)** | AN(45) | ●   | "국민은행" |
| \--recordBankOrd | 순서  | UI에서 표시된 순서 | N(2) | ●   |     |
| \--recordUseYn | 사용가능 여부 | 은행 오픈 및 사용가능 여부 | A(1) | ●   | "Y" |

#  30\. 은행점검조회

## 30.1 API 요약 설명

각 업무 별 은행의 점검여부를 확인 할 수 있습니다.

## 30.2 API URL

 
| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tbnpay.settlebank.co.kr/v1/api/bank/timecheck |
| 상용 환경 | https://npay.settlebank.co.kr/v1/api/bank/timecheck |

## 30.3 요청 전문 (가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문정보 | 전문정보 코드 | AN(50) | ●   | “SPAY\_TP00\_1.0”  <br>※ 고정값 |
| pktDivCd | 업무구분 | RE, DE, RP, RT, NA, NN, AA, AR | AN(2) | ●   | RE : 계좌등록  <br>DE : 계좌해지  <br>RP : 결제  <br>RT : 결제취소 (환불)  <br>NA : 예금주성명조회(생년월일 미포함)  <br>NN : 예금주성명조회 (생년월일 포함)   <br>AA : 계좌점유인증  <br>AR : 송금 |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | "midtest” |
| reqDt | 요청일자 | yyyyMMdd | AN(8) | ●   | “20191231” |
| reqTm | 요청시간 | HH24MISS | AN(6) | ●   | “120000” |
| bankCd | 은행코드 | 3자리 은행코드 | AN(3) | ●   | "004" |
| pktHash | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 30.4 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash 값 | 상점아이디 + 요청일자 + 요청시간 + 은행코드 + 인증키 |

## 30.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| outStatCd | 거래상태 | 거래상태코드(성공/실패) | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031 |
| outRsltCd | 거절코드 | [거절코드 테이블](#item-1010) 참조 | AN(4) | ●   |     |
| outRsltMsg | 결과메시지 | 오류가 발생시 오류에 대한 메시지 전달 | AN(300) | ●   | “정상처리되었습니다.” |
| bankCd | 은행코드 | 3자리 은행코드 | AN(3) | ●   | "004" |

#  31\. 계좌점유인증 내역 조회

## 31.1 API 요약 설명

계좌점유인증 내역을 조회 할 수 있습니다.

## 31.2 API URL

 
| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tbnpay.settlebank.co.kr/v1/api/auth/ownership/translist |
| 상용 환경 | https://npay.settlebank.co.kr/v1/api/auth/ownership/translist |

## 31.3 요청 전문 (가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문정보 | 전문정보 코드 | AN(50) | ●   | “SPAY\_LT00\_1.0”  <br>※ 고정값 |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “midtest” |
| orgTrdDt | 원거래일자 | 원거래일자(yyyyMMdd) | AN(6) | ●   |     |
| mchtTrdNo | 주문번호 | 가맹점 거래번호  <br>※ 한글제외  <br>인증 요청시 가맹점 거래번호 | AN(100) | ○   | "OID201902210001" |
| trdNo | 거래번호 | 헥토파이낸셜 거래번호 인증 요청시 응답받은 거래번호 | AN(50) | ●   | "SFP\_FIRM123344568901234567890" |
| mchtCustId | 고객아이디 | 상점에서 보내주는 고유 고객아이디 혹은 Unique 한 Key  <br>AES 암호화 | AN(100) | ●   | "honggildong" |
| reqDt | 요청일자 | yyyyMMdd | AN(8) | ●   | “20191231” |
| reqTm | 요청시간 | HH24MISS | AN(6) | ●   | “120000” |
| custIp | 고객 IP 주소 | 가맹점 서버의 IP가 아닌 고객 기기의 IP 주소 | AN(15) | ○   | “127.0.0.1” |
| pktHash | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 31.4 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash 값 | 상점아이디 + 요청일자 + 요청시간 + 가맹점거래번호 + 인증키 |

## 31.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| outStatCd | 거래상태 | 거래상태코드(성공/실패) | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031 |
| outRsltCd | 거절코드 | [거절코드 테이블](#item-1010) 참조 | AN(4) | ●   |     |
| outRsltMsg | 결과메시지 | 오류가 발생시 오류에 대한 메시지 전달 | AN(300) | ●   | “성공” |
| mchtTrdNo | 가맹점거래번호 | 가맹점거래번호  <br>\* 한글제외 | AN(100) | ●   | "OID20210830000000" |
| mchtCustId | 고객아이디 | 상점에서 보내주는  <br>고유 고객아이디 혹은  <br>Unique 한 Key  <br>AES 암호화 | AN(100) | ○   | "honggildong" |
| trdNo | 거래번호 | 헥토파이낸셜 거래번호 | AN(50) | ●   | "SFP\_FIRM123454657890" |
| bankCd | 은행코드 | [금융기관코드](#) 테이블 참조 | AN(3) | ●   | "004" |
| custAcntNo | 계좌번호  <br>(마스킹) | 계좌번호 "-" 제외 | AN(15) | ●   | "12345\*\*\*\*\*\*\*\*890" |
| custAcntSumry | 통장인자내용 | 고객의 통장에 찍힌 인자내용  <br>AES 암호화 | AN(21) | ●   | "이베이A12" |
| reqTrdDtm | 인증 요청일시 | yyyyMMddhhmmss | AN(14) | ●   | "20210830000000" |
| chkTrdDtm | 인증 확인일시 | yyyyMMddhhmmss | AN(14) | ●   | "20210830000000" |
| trdStatCd | 인증 거래상태 | 인증 성공/실패 | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031 |
| trdRsltCd | 인증 실패코드 | 거절코드 테이블 참조 | AN(4) | ●   |     |
| trdRsltMsg | 인증 결과메시지 | 오류 발생시 오류에 대한 메시지전달 | AN(600) | ●   | "성공" |

#  32\. 계좌점유인증 은행점검조회

## 32.1 API 요약 설명

은행 점검 여부를 확인 할 수 있습니다. 

## 32.2 API URL

 
| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tbnpay.settlebank.co.kr/v1/api/bank/timecheck/detail |
| 상용 환경 | https://npay.settlebank.co.kr/v1/api/bank/timecheck/detail |

## 32.3 요청 전문 (가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문정보 | 전문정보 코드 | AN(50) | ●   | “SPAY\_TP1W\_1.0”  <br>※ 고정값 |
| pktDivCd | 처리구분 | AA  | AN(2) | ●   | AA : 계좌점유인증  <br>※ 고정값 |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “midtest” |
| reqDt | 요청일자 | yyyyMMdd | AN(8) | ●   | “20191231” |
| reqTm | 요청시간 | HH24MISS | AN(6) | ●   | “120000” |
| bankCd | 은행코드 | 3자리은행코드 | AN(3) | ●   | "004" |
| pktHash | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 32.4 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash 값 | 상점아이디 + 요청일자 + 요청시간 + 은행코드 + 인증키 |

## 32.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| outStatCd | 거래상태 | 거래상태코드(성공/실패) | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031 |
| outRsltCd | 거절코드 | [거절코드 테이블](#item-1010) 참조 | AN(4) | ●   |     |
| outRsltMsg | 결과메시지 | 오류가 발생시 오류에 대한 메시지 전달 | AN(300) | ●   | “성공.” |
| bankCd | 은행코드 | 3자리 은행코드 | AN(3) | ●   | "004" |
| bankChkYn | 은행점검여부 | 요청시점 기준  <br>은행 점검여부 | AN(1) | ●   | "Y" 또는 "N"  <br>※ 은행의 정기/비정기  <br>점검시간인 경우, 은행으로부터  <br>장애 상황에 대한 공유나  <br>거래지연으로 확인되는 경우에  <br>은행점검으로 응답됩니다. |
| stDtm | 점검시작일시 | yyyyMMddhhmmss | AN(14) | ○   | "20210830000000" |
| edDtm | 점검종료일시 | yyyyMMddhhmmss | AN(14) | ○   | "20210830000000" |

#  33\. 금융결제원 출금이체정보 해지 조회

## 33.1 API 요약 설명

 고객이 금융기관(은행 등) 또는 금융 결제원(PAYINFO)에서 계좌해지를 신청한 경우 헥토파이낸셜 간편결제 시스템에서 고객 계좌의 출금이체 해지를 신청일 기준으로 익영업일(오전 11시 이전) 진행 합니다.  
해지 후 가맹점의 고객 출금이체 정보와 정합성을 맞추기 위해 해당 API를 제공 합니다. 오전 11시 이후 부터 해당일에 출금이체 해지된 계좌정보 목록을 확인 할 수 있습니다. 

## 33.2 API URL

 
| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tb-nspay.settlebank.co.kr/v1/api/acnt/isttunreg/list |
| 상용 환경 | https://nspay.settlebank.co.kr/v1/api/acnt/isttunreg/list |

## 33.3 요청 전문 (가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문정보 | 전문정보 코드 | AN(50) | ●   | “SPAY\_PI0C\_1.0”  <br>※ 고정값 |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “midtest” |
| unregDt | 해지일자 | 고객계좌의 출금이체가 해지 된 일자 | AN(8) | ●   | "20191231" |
| reqDt | 요청일자 | yyyyMMdd | AN(8) | ●   | “20191231” |
| reqTm | 요청시간 | HH24MISS | AN(6) | ●   | “120000” |
| pktHash | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 33.4 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash 값 | 상점아이디 + 해지일자 + 요청일자 + 요청시간 + 인증키 |

## 33.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| outStatCd | 거래상태 | 거래상태코드(성공/실패) | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031 |
| outRsltCd | 거절코드 | [거절코드 테이블](#item-1010) 참조 | AN(4) | ●   |     |
| outRsltMsg | 결과메시지 | 오류가 발생시 오류에 대한 메시지 전달 | AN(300) | ●   | “정상처리 되었습니다.” |
| unregDt | 해지일자 | yyyyMMdd | AN(14) | ●   | "20210830" |
| dataCnt | 해지계좌건수 | 금융결제원을 통해 출금이체 해지된 계좌 건수 | N(4) | ●   | "10" |
| unregAcntRecords | 해지계좌목록 |     | <object> | ●   |     |
| \--recordMchtCustId | 고객아이디 | 상점에서 보내주는   <br>고유 고객아이디 혹은  <br>Unique 한 Key | AN(100) | ●   | "honggildong" |
| \--recordBankCd | 은행코드 | 은행코드 | AN(3) | ●   | "004" |
| \--recordCustAcntNo | 계좌번호 | 계좌번호 마스킹 처리  <br>ex) 234\*\*\*\*\*\*\*\*123 | AN(15) | ●   | "234\*\*\*\*\*\*123" |
| \--recordCustAcntKey | 계좌번호키 | 출금이체 등록된 계좌의 일련번호 | AN(50) | ●   | "d894kjd93kd9" |
| \--recordUnregDtm | 해지일시 | yyyyMMddhhmmss | AN(14) | ●   | "20210831080000" |
| \--recordUnregOculstt | 해지발생기관 | 금융회사/통합관리시스템 | N(1) | ●   | 1 : 금융회사  <br>2 : 이용기관해지  <br>3 : 인터넷지로 해지접수  <br>4 : 통합관리시스템 |
| \--recordUnregDivCd | 해지구분 | 0/1/2/9/N/(공백) | AN(1) | ●   | 0 : 고객요청  <br>1 : 금융회사 임의해지  <br>(자동이체 등)  <br>2 :  금융회사 계좌변경  <br>9 : 기타  <br>N : 동의자료 부재  <br>(공백) : 해지발생기관 값이 3일 경우 발생 |

#  35\. 테스트콜

## 35.1 API 요약 설명

 가맹점 서버에서 헥토파이낸셜 서버로 테스트콜을 요청합니다.  
해당 전문을 통해 서비스의 Alive 상태를 확인합니다.

## 35.2 API URL

 
| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tbnpay.settlebank.co.kr/v1/api/test/testcall |
| 상용 환경 | https://npay.settlebank.co.kr/v1/api/test/testcall |

## 35.3 요청 전문 (가맹점 → 헥토파이낸셜)

 가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문정보 | 전문정보 코드 | AN(50) | ●   | “SPAY\_TC00\_1.0”  <br>※ 고정값 |
| --- | --- | --- | --- | --- | --- |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “midtest” |
| --- | --- | --- | --- | --- | --- |
| procDiv | 업무구분 | "TC" : 테스트콜 | AN(2) | ○   |     |
| --- | --- | --- | --- | --- | --- |
| mchtTrdNo | 주문번호 | 상점 주문번호  <br>\*한글제외 | AN(100) | ●   | "OID201902210001" |
| --- | --- | --- | --- | --- | --- |
| reqDt | 요청일자 | yyyyMMdd | AN(8) | ●   | “20191231” |
| --- | --- | --- | --- | --- | --- |
| reqTm | 요청시간 | HH24MISS | AN(6) | ●   | “120000” |
| --- | --- | --- | --- | --- | --- |

## 35.4 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의 합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| outStatCd | 거래상태 | 거래상태코드(성공/실패) | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031 |
| --- | --- | --- | --- | --- | --- |
| outRsltCd | 거절코드 | [거절코드 테이블](#item-1010) 참조 | AN(4) | ●   |     |
| --- | --- | --- | --- | --- | --- |
| outRsltMsg | 결과메시지 | 오류가 발생시 오류에 대한 메시지 전달 | AN(300) | ●   | “정상처리 되었습니다.” |
| --- | --- | --- | --- | --- | --- |
| mchtTrdNo | 주문번호 | 상점 주문번호  <br>\* 한글제외 | AN(100) | ●   | "OLD20190221001" |
| --- | --- | --- | --- | --- | --- |
| trdNo | 거래번호 | 헥토파이낸셜 거래번호 | AN(40) | ●   | "SFP\_FRIM12345678901234567890" |
| --- | --- | --- | --- | --- | --- |

#  36\. 결제비밀번호 확인

## 36.1 API 요약 설명

가맹점 서버에서 헥토파이낸셜 서버로 결제비밀번호 확인을 요청합니다.  
해당 고객아이디에 대해 입력된 결제비밀번호가 등록된 결제비밀번호와 일치하는지 확인합니다.  
 

## 36.2 API URL

 
| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tbnpay.settlebank.co.kr/v1/api/auth/pwdcnf |
| 상용 환경 | https://npay.settlebank.co.kr/v1/api/auth/pwdcnf |

## 36.3 요청 전문 (가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문정보 | 전문정보 코드 | AN(50) | ●   | “SPAY\_PW00\_1.0”  <br>※ 고정값 |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “midtest” |
| mchtTrdNo | 주문번호 | 상점 주문번호  <br>※ 한글제외 | AN(100) | ●   | "OID201902210001" |
| mchtCustId | 고객아이디 | 상점에서 보내주는 고유 고객아이디 혹은 Unique 한 Key  <br>AES 암호화 | AN(100) | ●   | "honggildong" |
| reqDt | 요청일자 | yyyyMMdd | AN(8) | ●   | “20191231” |
| reqTm | 요청시간 | HH24MISS | AN(6) | ●   | “120000” |
| pmtPwd | 결제비밀번호 | 고객이 설정한 6자리 숫자를 암호화한 값  <br>AES 암호화 | AN(24) | ●   | "314257" |
| custIp | 고객 IP 주소 | 가맹점 서버의 IP가 아닌 고객 기기의 IP 주소 | AN(15) | ○   | “127.0.0.1” |
| pktHash | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 36.4 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash 값 | 상점아이디 + 고객아이디(평문) + 요청일자 + 요청시간 + 결제비밀번호(평문) + 인증키 |

## 36.5 응답 전문 (헥토파이낸셜 → 가맹점)

  
  헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| outStatCd | 거래상태 | 거래상태코드(성공/실패) | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031 |
| --- | --- | --- | --- | --- | --- |
| outRsltCd | 거절코드 | [거절코드 테이블](#item-1010) 참조 | AN(4) | ●   | ST01 : 결제비밀번호가 없는 경우 해당 응답코드 리턴 |
| --- | --- | --- | --- | --- | --- |
| outRsltMsg | 결과메시지 | 오류가 발생시 오류에 대한 메시지 전달 | AN(300) | ●   | “정상처리 되었습니다.” |
| --- | --- | --- | --- | --- | --- |
| mchtCustld | 고객아이디 | 상점에서 보내주는 고유 고객아이디 혹은 Unique 한 Key  <br>AES 암호화 | AN(100) | ●   | "honggildong" |
| --- | --- | --- | --- | --- | --- |
| mchtTrdNo | 주문번호 | 상점 주문번호  <br>\* 한글제외 | AN(100) | ○   | "OLD20190221001" |
| --- | --- | --- | --- | --- | --- |
| trdNo | 거래번호 | 헥토파이낸셜 거래번호 | AN(40) | ●   | "SFP\_FRIM12345678901234567890" |
| --- | --- | --- | --- | --- | --- |

#  37\. 정기결제 키 발행

## 37.1 API 요약 설명

가맹점 서버에서 헥토파이낸셜 서버로 정기결제 키 발행을 요청합니다.

## 37.2 API URL

 
| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tbnpay.settlebank.co.kr/v1/api/regular/reg |
| 상용 환경 | https://npay.settlebank.co.kr/v1/api/regular/reg |

## 37.3 요청 전문 (가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문정보 | 전문정보 코드 | AN(50) | ●   | “SPAY\_SR10\_1.0”  <br>※ 고정값 |
| mchtId | 상점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “midtest” |
| mchtTrdNo | 주문번호 | 상점 주문번호  <br>※ 한글제외 | AN(100) | ●   | "OID201902210001" |
| mchtCustId | 고객아이디 | 상점에서 보내주는 고유 고객아이디 혹은 Unique 한 Key  <br>AES 암호화 | AN(100) | ●   | "honggildong" |
| reqDt | 요청일자 | yyyyMMdd | AN(8) | ●   | “20191231” |
| reqTm | 요청시간 | HH24MISS | AN(6) | ●   | “120000” |
| bankCd | 은행코드 | [금융기관코드 테이블](#item-926) 참조 | AN(3) | ●   | "004" |
| custAcntKey | 계좌번호키 | 출금이체등록된 계좌의 일련번호 | AN(50) | ○   | "d894kjd93kd9" |
| pktHash | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 37.4 요청 전문 해쉬 코드

 
| 항목  | 조합 필드 |
| --- | --- |
| pktHash 값 | 상점아이디 + 주문번호 + 고객아이디(평문) + 요청일자 + 요청시간 + 은행코드 + 인증키 |

## 37.5 응답 전문 (헥토파이낸셜 → 가맹점)

  
  헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| outStatCd | 거래상태 | 거래상태코드(성공/실패) | AN(4) | ●   | 성공 : 0021  <br>실패 : 0031 |
| --- | --- | --- | --- | --- | --- |
| outRsltCd | 거절코드 | [거절코드 테이블](#item-1010) 참조 | AN(4) | ●   |     |
| --- | --- | --- | --- | --- | --- |
| outRsltMsg | 결과메시지 | 오류가 발생시 오류에 대한 메시지 전달 | AN(300) | ●   | “정상처리 되었습니다.” |
| --- | --- | --- | --- | --- | --- |
| trdNo | 거래번호 | 헥토파이낸셜 거래번호 | AN(40) | ●   | "SFP\_FRIM12345678901234567890" |
| --- | --- | --- | --- | --- | --- |
| rglChrgKey | 정기결제키 | 정기결제용으로 생성된 유니크한 키 | AN(32) | ●   |     |
| --- | --- | --- | --- | --- | --- |

#  38\. 기타

## 38.1 거절 코드 표

서버측 응답의 거절코드 필드 상세 설명은 다음과 같습니다.  
※ 최신 공통 거절코드는 [공통거절코드](https://develop.sbsvc.online/22/bbsList.do?tx=R&articleSeq=522)에서 다운로드 받으실 수 있습니다.    
 

| 코드  | 내용  | 코드  | 내용  |
| --- | --- | --- | --- |
| 0000 | 성공  |     |     |
| ST01 | 존재하지 않는 계좌 | ST02 | 유효하지 않는 계좌 |
| ST03 | 이중출금 발생 | ST04 | VAN 요청중 시스템 에러 |
| ST05 | VAN 응답정보 없음 | ST06 | 거래번호 정보가 없음 |
| ST07 | 통신장애 | ST08 | 이미 등록된 계좌 |
| ST09 | 유효하지않는 요청전문 | ST10 | 내부 시스템 에러 |
| ST11 | 은행점검 시간 | ST12 | 출금계좌 잔액부족 |
| ST13 | ARS인증 결과가 없음 | ST14 | ARS 인증 요청 값이 상이함 |
| ST15 | 자동이체 해지계좌 | ST16 | 출금계좌 거래제한 |
| ST17 | 주민번호 사업자번호 오류 | ST18 | 계좌오류  <br>(간편계좌등록 불가) |
| ST19 | 기타거래불가 | ST20 | 계좌오류 |
| ST21 | 수취인 계좌 없음 | ST22 | 법적제한 계좌 |
| ST23 | 비실명 계좌 | ST24 | 예금주 불일치 |
| ST25 | 이미 취소된 거래 | ST26 | 취소금액 오류 |
| ST27 | ARS인증 실패 | ST28 | ARS수신불가 |
| ST29 | 계좌 등록 진행 중 | ST30 | 환불 진행 중 |
| ST31 | 이중 송금 발생 | ST32 | 납부자 성명조회 실패 |
| ST33 | 1회 한도 초과 | ST34 | 1일 한도 초과 |
| ST35 | 사고계좌입니다 | ST36 | 일정시간이 지나 연결이 끊어졌습니다. |
| ST37 | 간편결제 취소 | ST38 | 요청 진행 중 |
| ST39 | 환불 중복 요청 | ST40 | 처리 중 요청이 있음 |
| ST41 | 서비스 용량초과 | ST42 | 시스템 BUSY |
| ST43 | 이미 등록된 계좌입니다. | ST44 | 거래불가은행 |
| ST50 | 중복전문 요청 | ST51 | 이미등록된 현금영수증 사용자 |
| ST52 | 미등록 현금영수증 사용자 | ST53 | 이미 해지된 계좌 |
| ST60 | 거래실패 | ST61 | 1회한도 금액초과 |
| ST62 | 일한도 금액초과 | ST63 | 월한도 금액초과 |
| ST64 | 일한도 건수 초과 | ST65 | 월한도 건수 초과 |
| ST66 | 비밀번호 등록 실패 | ST67 | 비밀번호 불일치 |
| ST68 | 서비스 이용정지 | ST69 | 정책상 해당 결제서비스를 이용할 수 없습니다.  <br>다른 결제수단으로 이용 부탑드립니다. |
| ST70 | 정책상 해당 결제서비스를 이용할 수 없습니다.  <br>헥토파이낸셜 고객센터로 문의 바랍니다. (1600-5220) | ST71 | 취소/환불 한도 초과 |
| ST72 | 결제시 ARS 2차인증 필요 | ST75 | 잘못된 정보로 다수시도하여 계좌이용불가. 익일 재시도바람 |
| ST76 | 잘못된 정보로 다수시도하여 계좌이용불가. 익일 재시도바람 | ST86 | 인증 실패입니다. (휴대폰 본인인증) |
| ST87 | 간편본인확인 미가입자 입니다. (휴대폰 본인인증) | VTIM | 중계기관 TIMEOUT |
| ST99 | 간편결제 시스템 점검중 | SE01 | 인증 유효 시간이 만료되었습니다. |
| SE02 | 인증 번호가 불일치합니다. | SE03 | 인증확인 허용횟수를 초과하였습니다. |
| SE04 | 오픈뱅킹 해지계좌입니다. 해지필요 | SE05 | 오픈뱅킹 유효하지 않는 계좌입니다. 해지필요 |
| SE06 | SMS본인인증 요청 횟수가 초과되었습니다. 잠시 후 시도 바랍니다. | SE09 | SMS인증번호가 존재하지 않습니다. |
| SE12 | 오픈뱅킹 안심차단 중인 사용자 |     |     |

  
※ ST75: 예금주조회 어뷰징시도(계좌번호다건)로 인한 계좌이용불가  
※ ST76: 예금주조회 어뷰징시도(실패횟수초과)로 인한 계좌이용불가

## 38.2 금융기관 식별자

헥토파이낸셜에서 제공하는 금융기관 고유 식별 코드는 다음과 같습니다.  
 

| 금융기관코드 | 금융기관명 | 금융기관코드 | 금융기관명 |
| --- | --- | --- | --- |
| 002 | 산업은행 | 090 | 카카오뱅크 |
| 003 | 기업은행 | 092 | 토스뱅크 |
| 004 | 국민은행 | 103 | SBI저축은행 |
| 007 | 수협은행/수협중앙회 | 209 | 유안타증권 |
| 011 | NH농협은행 | 218 | KB증권 |
| 012 | 농협중앙회(지역농축협) | 221 | 상상인증권 |
| 020 | 우리은행 | 224 | BNK투자증권 |
| 023 | SC 제일은행 | 225 | IBK투자증권 |
| 027 | 한국씨티은행 | 227 | 다올투자증권 |
| 031 | iM뱅크(대구은행) | 238 | 미래에셋증권 |
| 032 | 부산은행 | 240 | 삼성증권 |
| 034 | 광주은행 | 243 | 한국투자증권 |
| 035 | 제주은행 | 247 | NH투자증권 |
| 037 | 전북은행 | 261 | 교보증권 |
| 039 | 경남은행 | 262 | 하이투자증권 |
| 045 | 새마을금고 | 263 | 현대차증권 |
| 048 | 신협  | 264 | 키움증권 |
| 050 | 저축은행중앙회(상호저축은행) | 265 | 이베스트투자증권 |
| 051 | 기타외국은행 | 266 | SK증권 |
| 054 | HSBC은행 | 267 | 대신증권 |
| 055 | 도이치은행 | 269 | 한화투자증권 |
| 057 | 제이피모간체이스은행 | 270 | 하나증권 |
| 059 | 미쓰비시도쿄은행 | 271 | 토스증권 |
| 060 | BOA은행 | 278 | 신한금융투자 |
| 061 | BNP파리바은행 | 279 | DB금융투자 |
| 062 | 중국공상은행 | 280 | 유진투자증권 |
| 063 | 중국은행 | 287 | 메리츠증권 |
| 064 | 산림조합중앙회 | 288 | 카카오페이증권 |
| 067 | 중국건설은행 | 290 | 부국증권 |
| 071 | 우체국 | 291 | 신영증권 |
| 081 | 하나은행 | 292 | 케이프투자증권 |
| 088 | 신한은행 | 294 | 한국포스증권 |
| 089 | 케이뱅크 | 099 | 금융결제원 |

## 38.3 은행 정기점검 시간

상기 업무시간은 은행별 업무시간으로 헥토파이낸셜에서는 **01:00 ~ 23:30 사이 거래를 권장**드립니다.  
은행별로 점검시간은 연장될 수 있습니다.  
  
 

| 금융기관코드 | 금융기관명 | 은행점검시간 | 헥토파이낸셜 업무시간 |     | 정기 점검 |
| --- | --- | --- | --- | --- | --- |
| 업무 중단시간 | 업무 개시시간 |
| --- | --- | --- | --- | --- | --- |
| 002 | 산업은행 | 23:30~00:30 | 23:50 | 00:15 | 매월 2번째 일요일 00:00~04:00 |
| 003 | 기업은행 | 24:00~00:30 | 23:50 | 00:12 | 매주 일요일 00:00~00:30 |
| 004 | 국민은행 | 24:00~00:30 | 23:50 | 00:12 | 매월 3번째 일요일  <br>00:00~00:30, 05:00~05:30  <br>대외계 01:00~06:00 (간헐적 거래안됨) |
| 007 | 수협은행/수협중앙회 | 23:50~00:30 | 23:30 | 00:30 | 없음  |
| 011 | 농협은행 | 24:00~00:30 | 23:50 | 00:12 | 매월 3번째 월요일 00:00~04:00  <br>(해당일 공휴일일 경우, 익영업일) |
| 020 | 우리은행 | 23:50~00:30 | 23:50 | 00:10 | 매월 2번째 일요일 02:00~06:00  <br>(작업일자는 은행에서 사전공지) |
| 023 | SC 제일은행 | 23:30~00:30 | 23:50 | 00:12 | 없음  |
| 027 | 한국씨티은행 | 23:40~00:30 | 23:50 | 00:30 | 매일 00:00~04:30 |
| 031 | iM뱅크(대구은행) | 23:40~00:30 | 23:50 | 00:05 | 없음  |
| 032 | 부산은행 | 23:30~00:30 | 23:50 | 00:05 | 없음  |
| 034 | 광주은행 | 23:40~00:30 | 23:50 | 00:05 | 매월 2번째 일요일 02:00~06:00 |
| 035 | 제주은행 | 23:40~00:30 | 23:50 | 00:12 | 매주 일요일 04:30~05:00 |
| 037 | 전북은행 | 24:00~00:30 | 23:50 | 00:05 | 매월 2번째 토요일 00:00~04:00 |
| 039 | 경남은행 | 23:40~00:30 | 23:50 | 00:05 | 매월 2번째 일요일 00:00~07:00 |
| 045 | 새마을금고 | 23:50~00:30 | 23:30 | 00:30 | 없음  |
| 048 | 신협  | 23:40~00:30 | 23:50 | 00:05 | 없음  |
| 050 | 저축은행중앙회 | 23:50~00:10 | 23:50 | 00:35 | 없음  |
| 064 | 산림조합중앙회 | 23:30~00:30 | 23:30 | 01:00 | 없음  |
| 071 | 우체국 | 23:40~00:30 | 23:50 | 00:05 | 없음  |
| 081 | 하나은행 | 23:40~00:30 | 23:50 | 00:15 | 매월 2번째 일요일 00:00~08:00 |
| 088 | 신한은행 | 23:40~00:30 | 23:50 | 00:05 | 없음  |
| 089 | 케이뱅크 | 23:40~00:30 | 23:35 | 00:35 | 없음  |
| 090 | 카카오뱅크 | 23:50~00:10 | 23:50 | 00:05 | 없음  |
| 092 | 토스뱅크 | 23:55~00:05 | 23:55 | 00:05 | 없음  |
| 103 | SBI저축은행 | 23:55~00:10 | 23:50 | 00:05 | 없음  |
| 209 | 유안타증권 | 23:50~00:10 | 23:50 | 00:10 | 없음  |
| 238 | 미래에셋증권 | 23:30~00:20 | 23:30 | 00:20 | 없음  |
| 240 | 삼성증권 | 23:30~00:20 | 23:50 | 00:10 | 없음  |
| 243 | 한국투자증권 | 23:40~00:10 | 23:40 | 00:10 | 없음  |
| 247 | NH투자증권 | 23:50~00:15 | 23:50 | 00:05 | 없음  |
| 266 | SK증권 | 23:50~00:30 | 23:30 | 00:30 | 없음  |
| 267 | 대신증권 | 23:55~00:25 | 23:55 | 00:25 | 없음  |
| 278 | 신한금융투자 | 23:25~00:15 | 23:30 | 00:15 | 매일 23:30~00:10, 03:00~03:10 |
| 280 | 유진투자증권 | 23:30~00:30 | 23:50 | 00:35 | 없음  |
| 287 | 메리츠증권 | 23:50~00:20 | 23:50 | 00:20 | 없음  |

  
  