# 내통장결제 소개

간편현금결제 기술을 기반으로 최초 1회 인증 후 제휴 가맹점 어디서든 간편하게 결제할 수 있는 서비스입니다.  
다양한 금융기관 및 서비스를 통합 연결한 시스템으로 계약부터 정산까지 편리하게 이용하실 수 있습니다.  
이제 내통장결제로 자체 현금결제 서비스를 손쉽게 적용하세요.

# 표준 결제창 연동 규격서

# 1\. 개요

## 1.1 목적

본 문서는 헥토파이낸셜에서 제공하는 내통장결제 표준 결제창 연동 개발에 필요한 기술적 이해를 돕고 상세 규격을 정의하기 위해 작성 되었습니다.

## 1.2 대상

본 문서는 헥토파이낸셜에서 제공하는 내통장결제 결제창을 연동 하는 방법과 사용하는데 필요한 API 연동 규격 및 코딩 가이드를 제공합니다.

## 1.3 API URI

내통장결제 API 는 아래와 같은 API 를 제공하며, 하나의 API 는 하나의 웹 서비스 URI 로 매핑됩니다.

| 기능구분 | API 명 | URI | HTTP  <br>Method |
| --- | --- | --- | --- |
| 이체서비스 | 결제인증(UI) | 결제창 연동 | POST |
| 결제승인(Non-UI) | https://ezauthapi.settlebank.co.kr:8081/v3/APIPayApprov.do | POST |
| 결제취소/환불(Non-UI) | https://ezauthapi.settlebank.co.kr:8081/v3/APIPayCancel.do | POST |
| 정기결제키발급(Non-UI) | https://ezauthapi.settlebank.co.kr:8081/v2/APIRegularpayKey.do | POST |
| 정기결제승인(Non-UI) | https://ezauthapi.settlebank.co.kr:8081/v3/APIRegularPayment.do | POST |
| 정기결제해지(Non-UI) | https://ezauthapi.settlebank.co.kr:8081/APIUnRegistRegular.do | POST |
| 망취소(Non-UI) | https://ezauthapi.settlebank.co.kr:8081/APINetPayCancel.do | POST |
| 조회 서비스 | 거래결과조회 | https://ezauthapi.settlebank.co.kr:8081/APIMoInfo.do | POST |
| 거래내역조회 | https://ezauthapi.settlebank.co.kr:8081/APITrInfo.do | POST |
| 현금영수증발행조회 | 결제창 연동 | POST |

# 2\. 내통장결제 API 일반

## 2.1 내통장결제 프로세스

내통장결제 프로세스를 간략히 도식화 하면 다음과 같습니다.

![내통장결제 프로세스](/images/contents/docs/process_myaccount_01_m.gif) ![내통장결제 프로세스](/images/contents/docs/process_myaccount_01.gif?ver=20220629)

2.1.1.  하위몰 또는 고객이 결제 요청
    
2.1.2.  내통장결제 UI 연동 호출
    
2.1.3.  휴대폰본인인증 후 성명과 계좌정보를 이용하여 예금주성명조회 실행
    
2.1.4.  ARS 인증으로 출금이체등록 증빙자료 생성
    
2.1.5.  계좌등록 (출금이체등록)
    
2.1.6.  인증결과 응답  
    \* callbackUrl 을 통하여 가맹점 페이지로 이동하며 인증결과를 전달합니다. 
    
2.1.7.  인증결과로 응답된 정보의 정합성을 확인
    
2.1.8.  인증결과 확인 후 API 로 결제승인 요청
    
2.1.9.  간편결제 Core 에서 출금이체 실행
    

## 2.2 일반 사항

다음은 본 문서에서 언급하는 연동상의 일반적인 사항에 대하여 설명합니다.

*   요청/응답 파라메터 중 필수 필드는 '●' 기호를 사용하며 선택 필드는 '○' 기호를 사용합니다.
    
*   데이터 타입
    
    N : Numeric Characters  
    A : Alphabetic Characters
    
*   요청 파라메터 검증
    

필수값 누락, 위변조 여부를 판단하는 HASH 데이터 불일치, 요청 변수 길이 체크등 파라메터 검증 후 이상이 있을 경우 아래와 같은 응답 코드를 반환합니다.

```
{
	"resultCd": "-1",
	"errCd": "ST09",
	"resultMsg": "유효하지 않는 요청전문"
}
```

# 3\. 결제창 연동

## 3.1 연동 스크립트 제공

API 서버 접속 정보는 다음과 같습니다.

| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tbezauth.settlebank.co.kr/js/SettlePay.js |
| 상용 환경 | https://ezauth.settlebank.co.kr/js/SettlePay.js |

## 3.2 연동 방법

결제창은 Form Post로 요청되며 form tag 속성 및 동작은 제공되는 스크립트에 의해 수행됩니다.  
※ Iframe 태그를 통해 결제창 호출시 특정 모바일 브라우저에서 정상 동작을 보장하지 않습니다.   따라서 결제창 연동시 iframe tag 사용을 권장하지 않습니다.

```
<head>
	<script language="javascript" type="text/javascript"src="https://tbezauth.settlebank.co.kr/js/SettlePay.js" charset="UTF-8"></script>
	<script>SettlePay.execute(sampleFm);</script>
</head>
<body>
	<form name="sampleFm">
		<input name="">
	</form>
</body>
```

# 4\. API 호출

## 4.1 API 접속 정보

API 서버 접속 정보는 다음과 같습니다.

| 구분  | URL | IP 주소 |
| --- | --- | --- |
| 테스트베드 | https://tbezauthapi.settlebank.co.kr | 211.236.228.36 |
| 상용 환경 | https://ezauthapi.settlebank.co.kr:8081 | 61.252.169.45:8081 (주 센터) |
| 14.34.14.39:8081 (보조 센터) |

*   헥토파이낸셜 내통장결제 서비스 시스템은 IDC센터 이중화 구성되어 있습니다.(상용 환경)  
    따라서 예고 없이 GLB시스템 운영으로 주 센터와 보조 센터 전환이 이루어질 수 있으며, DNS Lookup에 의한 접속을 권장하고 있습니다.  
    안내드린 2개의 공인 IP주소(상용)를 방화벽에서 접속 허용 요청드리며, hosts파일 구성은 권장하지 않습니다.

## 4.2 요청 및 응답 헤더

API 요청 및 응답 헤더 포맷은 다음과 같습니다.

|     |     |
| --- | --- |
| 요청  | Content-type: application/json;charset=UTF-8 |
| 응답  | Content-type: text/html;charset=UTF-8 |

## 4.3 타임아웃

UI 를 제외한 API 의 타임아웃 처리는 35 초를 적용합니다. 결제요청에서 타임아웃이 발생한 경우 해당 결제건의 거래결과조회 API 를 통해 상태를 확인하고 결제성공 상태로 확인이 되면 망취소 API 를 통해 해당 거래건을 취소할 수 있습니다.

## 4.4 기타

다음은 HTTP 규격의 일반 요건에 대하여 설명합니다.

*   제공하는 API 는 REST 를 지향하나, REST 의 규격 젂체를 만족하지 않습니다. (대부분의 트랜잭션 요청은 POST Method 만 사용)
    
*   요청은 POST method 만을 사용합니다.
    
*   변수값에 공통적으로 :,&,?,',new line, <, > 기호는 전달 불가합니다.
    

# 5\. 중요 정보 보안

## 5.1 개인정보 및 중요정보 암복호화, 암호화/복호화

데이터 송수신시 개인정보/중요정보 필드에 대해서는 다음과 같은 암복호화, 암호화/복호화를 수행해야 합니다.

| 구분  | 항목  | 적용  | 인코딩 |
| --- | --- | --- | --- |
| 개인정보 | 알고리즘 | AES-256/ECB/PKCS5Padding | Hex Encoding |
| 대상 필드 | 담당자명, 유선번호, 휴대폰번호, 이메일, 예금주명, 계좌번호 등  <br>(암호화 대상 필드는 개별 API 의 요청 필드 규격의 비고란에 명시됩니다) |     |     |

## 5.2 개인정보 암호키

개인 정보 및 중요정보 암복호화시 키 정보는 운영 환경에 따라 다르며 다음과 같습니다.

| 구분  | 암복호화 키 |
| --- | --- |
| 테스트베드 키 | SETTLEBANKISGOODSETTLEBANKISGOOD(32byte) |
| 상용 환경 키 | 서비스 이행시 별도 통보 |

## 5.3 위변조 방지 알고리즘

요청 데이터의 위변조 여부를 검증하기 위해 추가적으로 해쉬키 검증을 수행하며, 해쉬키 생성 알고리즘은 다음과 같습니다.

| 구분  | 항목  | 적용  | 인코딩 |
| --- | --- | --- | --- |
| 위변조 | 알고리즘 | SHA-256 | Hex Encoding |

## 5.4 해쉬생성 인증키

| 구분  | 인증키 |
| --- | --- |
| 테스트베드 키 | SETTLEBANKISGOODSETTLEBANKISGOOD(32byte) |
| 상용 환경 키 | 서비스 이행시 별도 통보 |

# 6\. 결제인증 (UI)

## 6.1 요약 설명

헥토파이낸셜 내통장결제 결제창 UI 를 실행하고 결제에 필요한 파라메터를 전달 합니다.

해당 결제창에서 계좌 출금이체 등록을 위한 휴대폰본인인증, 예금주성명조회, ARS 인증등을 수행하며 출금이체등록 후 해당 계좌로 결제인증을 수행하여 그 결과를 가맹점측으로 응답합니다. (가맹점측 성공 URL 호출)

## 6.2 연동 스크립트 메소드

```
settlePay.execute(form obj);
```

## 6.3 요청 폼(Form) 파라메터

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

     
| Parameter | Parameter 명 | 설명  | 타입 (길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문 정보 | 전문정보 코드 | AN(50) | ●   | "IA\_AUTHPAGE\_1.0\_1.0"  <br>※ 고정값 |
| apiVer | 전문 버전 | 전문버전  <br>\* 전문 버전에 따른 signature값 다름 | AN(4) | ●   | "1.0"  <br>※ 고정값(기존)  <br>"2.0"  <br>※ 변경예정(리다이렉트 기능을 이용한 피싱 방지) |
| processType | 처리구분 | 프로세스 구분 | A(1) | ●   | "D"  <br>※ 고정값 |
| mercntId | 가맹점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | "settleId" |
| ordNo | 주문번호 | 가맹점에서 생성한 고유 주문번호(동일 거래일자에 유일성을 보장해야 함) | AN(100) | ●   | "OID201902210001" |
| trDay | 거래일자 | 가맹점에서 생성한 거래일자  <br>yyyyMMdd  <br>\* trTime과 조합하여 서버시간과 비교하여 1시간 이내 차이인 경우만 결제 인증 진행 가능 | N(8) | ●   | "20190221" |
| trTime | 거래시간 | 가맹점에서 생성한 거래일시  <br>HH24MISS  <br>\* trDay와 조합하여 서버시간과 비교하여 1시간 이내 차이인 경우만 결제 인증 진행 가능 | N(6) | ●   | "142120" |
| trPrice | 거래금액 | AES 암호화  <br>결제금액  <br>\* 자원순환보증금액이 있는 경우 포함 | N(13) | ●   | 과세금액 + 면세금액 +<br><br>부가세금액 = "12800" |
| taxPrice | 과세금액 | AES 암호화  <br>결제금액 중 과세금액 면세여부가 복합과세일 경우만 해당 | N(13) | ○   | "8000" |
| vatPrice | 부가세금액 | AES 암호화  <br>결제금액 중 부가세금액 과세금액의 10% 면세여부가 복합과세일 경우만 해당 | N(13) | ○   | 과세금액의 10% = "800" |
| dutyFreePrice | 면세금액 | AES 암호화  <br>결제금액 중 비과세금액 면세여부가 복합과세일 경우만 해당 | N(13) | ○   | 4000 |
| containerDeposit | 자원순환보증금액 | AES 암호화  <br>자원순환보증금액 대상 거래인 경우 금액  <br>(현금영수증 비대상) | N(5) | ○   | 300 |
| productNm | 상품명 | 상품명 | AN(15) | ●   | "배추" |
| dutyFreeYn | 면세여부 | Y:면세, N:과세, G:복합과세 | A(1) | ●   | "N" |
| criPsblYn | 현금영수증발행가능여부 | Y: 발행가능, N:발행불가능  <br>""(빈값)일 경우 Y로 인식 | A(1) | ○   | "Y" |
| addDeductionYn | 추가공제구분 | 대중교통 : Y  <br>도서, 공연비 : C  <br>추가공제없음 : N | A(1) | ○   | "N" |
| shopNm | 상점명 |     | AN(10) | ○   | "A 농장" |
| cphoneNo | 휴대폰번호 | AES 암호화  <br>주문자 휴대폰번호  <br>"-" 제외 | N(11) | ○   | "01032012938" |
| email | 이메일 | AES 암호화  <br>주문자 이메일 | AN(30) | ○   | ["](mailto:id@mail.com)id@mail.com_"_ |
| custCi | 고객 CI | AES 암호화  <br>주문자 CI  <br>\* 해당 파라메터의 값과 내통장결제측 고객 CI 값이 다를 경우 cancelUrl로 이동 | AN(192) | ○   |     |
| callbackUrl | 결과통보 URL | 인증 완료후 결제창에서 호출될 URL  <br>\*callbackUrl 을 통해 응답받은 값을 검증후 결제승인 API 호출  <br>\*http:// 로 요청 시 요청받은 URL 로 form submit(method=POST) 호출 할 때 크롬 브라우저 87버전부터 http 차단 정책 배포됨에 따라 '안전하지 않은 정보를 제출하려함' 메시지 창 노출 현상 발생할 수 있음. | AN(255) | ●   | ["](http://callback.co.kr/)https://callback.co.kr" |
| cancelUrl | 인증창취소 URL | 결제 과정중사용자 취소시 호출될 URL  <br>\*http:// 로 요청 시 요청받은 URL 로 form submit(method=POST) 호출 할 때 크롬 브라우저 87버전부터 http 차단 정책 배포됨에 따라 '안전하지 않은 정보를 제출하려함' 메시지 창 노출 현상 발생할 수 있음.  <br>\*callbackUrl과 메인도메인이 같아야 함.  <br>ex)  <br>callbackUrl : api.sample.co.kr  <br>cancelUrl : web.sample.co.kr | AN(255) | ○   | ["](http://aaa.co.kr/cancel)https://aaa.co.kr/cancel" |
| regularpayYn | 자동결제등록여부 | 추후 해당계좌로 자동결제를 이용할 것인지 여부 | A(1) | ○   | "N" |
| mercntParam1 | 가맹점데이터 1 | 가맹점 측 추가 정보 1(해당 필드는 응답 및 거래 내역  <br>조회시 리턴) | AN(100 0) | ○   |     |
| mercntParam2 | 가맹점데이터 2 | 가맹점 측 추가 정보 2(해당 필드는 응답 및 거래 내역<br><br>조회시 리턴) | AN(1000) | ○   |     |
| payLimitCd | 결제 한도 코드 | 내통장결제에 설정되어 있는 정책에 따라 고객의 결제한도를 확인합니다. | AN(10) | ○   |     |
| signature | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 6.4 요청 전문 해쉬 코드

| 전문버전 | 항목  | 조합 필드 |
| --- | --- | --- |
| 1.0 | signature 값 | 상점아이디 + 주문번호 + 거래일자 + 거래시간 + 거래금액(plain 값) + 인증키 |
| 2.0 | signature 값 | 상점아이디 + 주문번호 + 거래일자 + 거래시간 + 거래금액(plain 값) + 결과통보URL(callbackUrl) HOST +인증키<br><br>  <br>**결과통보URL(callbackUrl) HOST 규칙 및 예제**  <br>1\. https://develop.sbsvc.online/callback/success => develop.sbsvc.online 으로 조합  <br>2\. https://develop.sbsvc.online:60001/callback/success => port를 제외한 develop.sbsvc.online 으로 조합  <br>3\. https://www.develop.sbsvc.online/callback/success => www.develop.sbsvc.online 으로 조합  <br>\* 프로토콜(https://, http://), 포트 를 제외한 host 로 조합  <br>  <br>ex) JAVA에서 URL 에서 host 가져오는 방법  <br>URL aURL = new URL("https://develop.sbsvc.online:60001/callback/success"); //import java.net.URL  <br>String host = aURL.getHost(); //develop.sbsvc.online   <br>  <br>ex) callbackUrl 이 https://develop.sbsvc.online/callback/success 인 경우 조합 필드  <br>settleIdOID2019022100012019022114212012800develop.sbsvc.onlineSETTLEBANKISGOODSETTLEBANKISGOOD |

## 6.5 응답 파라메터 (헥토파이낸셜 → 가맹점)

결제(등록)창에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의 합니다.

     
| Parameter | Parameter 명 | 설명  | 타입 (길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| resultCd | 결과코드 | 결과코드(성공/실패) | N(1) | ●   | 성공 : "0"<br><br>실패 : "-1" |
| errCd | 실패코드 | 실패코드 테이블 참조 | AN(5) | ●   |     |
| resultMsg | 결과메세지 | 육안 식별 가능한 메세지이며, 서버측에 의해 임의 변동 가능성 존재 | AN(200) | ●   | "성공" |
| mercntId | 가맹점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | "settleId" |
| ordNo | 주문번호 | 가맹점에서 요청시생성한 고유 주문번호 | AN(100) | ●   | "OID201902210001" |
| authNo | 인증번호 | 헥토파이낸셜에서 생성한 고유 인증번호 | AN(20) | ●   | "PAR20190220000000001" |
| trPrice | 거래금액 | 가맹점에서 최초 결제 요청한 금액 | N(13) | ●   | "15000" |
| discntPrice | 할인금액 | 결제 모듈에 의해 차감된 금액  <br>(ex: 프로모션 선할인) | N(13) | ●   | "1000" |
| payPrice | 결제금액 | 최초 결제 요청 금액에서 할인된 최종 출금 금액 | N(13) | ●   | "14000" |
| trDay | 거래일자 | 가맹점에서 생성한 거래일자<br><br>yyyyMMdd | N(8) | ●   | "20190221" |
| trTime | 거래시간 | 가맹점에서 생성한 거래일시<br><br>HH24MISS | N(6) | ●   | "142120" |
| mercntParam1 | 가맹점데이터 1 | 가맹점 측 추가 정보 1(최초 요청시 전달한 추가정보 1) | AN(1000) | ○   |     |
| mercntParam2 | 가맹점데이터 2 | 가맹점 측 추가 정보 1(최초 요청시 전달한 추가정보 1) | AN(1000) | ○   |     |

# 7\. 결제승인 (API)

## 7.1 API 요약 설명

결제 인증요청 페이지에서 설정된 callbackUrl 을 통해 응답받은 값을 검증 후 이상이 없을 경우 결제승인 요청 WEB API 를 호출합니다.

## 7.2 API URL

| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tbezauthapi.settlebank.co.kr/v3/APIPayApprov.do |
| 상용 환경 | https://ezauthapi.settlebank.co.kr:8081/v3/APIPayApprov.do |

## 7.3 요청 전문 (가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의 합니다.

     
| meter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문 정보 | 전문정보 코드 | AN(50) | ●   | "IA\_APPROV"  <br>※ 고정값 |
| apiVer | 전문 버전 | 전문버전 | AN(4) | ●   | "3.0"  <br>※ 고정값 |
| mercntId | 가맹점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | "settleId" |
| authNo | 인증번호 | 헥토파이낸셜에서 생성한 인증 단계 응답값 | AN(20) | ●   | "PAR20190220000000001" |
| reqDay | 요청일자 | 가맹점에서 생성한 결제승인시 요청일자  <br>문자열 포맷)yyyyMMdd | N(8) | ●   | "20190221" |
| reqTime | 요청시간 | 가맹점에서 생성한 결제승인시 요청시간  <br>문자열 포맷)HH24MISS | N(6) | ●   | "142120" |
| custParam1 | 가맹점 추가필드 1 | 승인요청시 정의한 요청필드 외 가맹점에서 임의로 정의 저장되는 필드값 1  <br>거래조회시 해당 값이 응답전문에 표기됩니다. | AN(128) | ○   | "추가필드정보"  <br>가맹점관리자에서 해당값으로 거래건 조회 가능 |
| custParam2 | 가맹점 추가필드 2 | 승인요청시 정의한 요청필드 외 가맹점에서 임의로 정의 저장되는 필드값 2  <br>거래조회시 해당 값이 응답전문에 표기됩니다 | AN(128) | ○   | "추가필드정보"  <br>가맹점관리자에서 해당값으로 거래건 조회 가능 |
| custParam3 | 가맹점 추가필드 3 | 승인요청시 정의한 요청필드 외 가맹점에서 임의로 정의 저장되는 필드값 3  <br>거래조회시 해당 값이 응답전문에 표기됩니다 | AN(128) | ○   | "추가필드정보"  <br>가맹점관리자에서 해당값으로 거래건 조회 가능 |
| custParam4 | 가맹점 추가필드 4 | 승인요청시 정의한 요청필드 외 가맹점에서 임의로 정의 저장되는 필드값 4  <br>거래조회시 해당 값이 응답전문에 표기됩니다 | AN(128) | ○   | "추가필드정보" |
| signature | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 7.4 요청 전문 해쉬 코드

| 항목  | 조합 필드 |
| --- | --- |
| signature 값 | 가맹점아이디 + 인증번호 + 요청일자 + 요청시간 + 인증키 |

## 7.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의 합니다.

     
| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| resultCd | 결과코드 | 결과코드(성공/실패) | N(1) | ●   | 성공 : "0"  <br>실패 : "-1" |
| errCd | 실패코드 | 실패코드 테이블 참조 | AN(5) | ●   |     |
| resultMsg | 결과메세지 | 육안 식별 가능한 메세지이며, 서버측에 의해 임의 변동 가능성 존재 | AN(200) | ●   | "성공" |
| mercntId | 가맹점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | "settleId" |
| ordNo | 주문번호 | 가맹점에서 요청시생성한 고유 주문번호 | AN(100) | ●   | "OID201902210001" |
| trNo | 거래번호 | 헥토파이낸셜에서 생성한 결제 거래번호 | AN(50) | ●   | "STFP\_PNPTms00001t00220922182409M1962430" |
| trPrice | 거래금액 | 가맹점에서 최초 결제 요청한 금액 | N(13) | ●   | "15000" |
| discntPrice | 할인금액 | 결제 모듈에 의해 차감된 금액 (ex: 프로모션 선할인) | N(13) | ●   | "1000" |
| payPrice | 결제금액 | 최초 결제 요청 금액에서 할인된 최종 출금 금액 | N(13) | ●   | "14000" |
| criPrice | 현금영수증 발급 금액 | 현금영수증 발급 금액 (현금성 결제 금액만 발급대상)  <br>\*현금성 결제 금액만 현금영수증 발급 금액에 포함됩니다. | N(13) | ●   | "13000" |
| criTaxVatPrice | 현금영수증 과세 금액(부가세 포함) | 현금영수증 발급 금액 중 과세금액만 표기 (부가세 포함) | N(13) | ●   | "11000" |
| criDutyFreePrice | 현금영수증 비과세 금액 | 현금영수증 발급 금액 중 비과세금액만 표기 | N(13) | ●   | "2000" |
| trDay | 거래일자 | 결제 승인 일자  <br>yyyyMMdd | N(8) | ●   | "20190221" |
| trTime | 거래시간 | 결제 승인 일시  <br>HH24MISS | N(6) | ●   | "142120" |
| regularpayKey | 자동결제키 | 자동결제용으로 생성된 유니크한 키 | AN(32) | ○   |     |
| bankAcctNo | 계좌번호 | 자동결제 키 발급 시 마스킹된 계좌번호 파라메터 응답 | AN(20) | ○   | 123\*\*\*\*\*789 |
| bankCd | 은행코드 | 자동결제 키 발급 시 은행코드 파라메터 응답 | AN(3) | ○   | "011" |

# 8\. 결제취소/환불 (API)

## 8.1 API 요약 설명

결제된 거래건에 대한 환불 기능을 별도 WEB API 형식으로 제공합니다.

## 8.2 API URL

| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tbezauthapi.settlebank.co.kr/v3/APIPayCancel.do |
| 상용 환경 | https://ezauthapi.settlebank.co.kr:8081/v3/APIPayCancel.do |

## 8.3 요청 전문 (가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의 합니다.

     
| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문 정보 | 전문정보 코드 | AN(50) | ●   | "IA\_CANCEL"  <br>※ 고정값 |
| apiVer | 전문 버전 | 전문버전 | AN(4) | ●   | "3.0"  <br>※ 고정값 |
| mercntId | 가맹점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | "settleId" |
| oldTrNo | 원거래번호 | 헥토파이낸셜에서 결제요청에 대한 응답으로 전달한 거래번호 | AN(50) | ●   | "STFP\_PNPTms00001t00220922182409M1962430" |
| ordNo | 취소주문번호 | 가맹점에서 생성한 고유 주문번호(동일 거래일자에 유일성을 보장해야 함) | AN(100) | ●   | "OID201902210001"  <br>결제 요청시 생성한 주문번호와다른 취소 요청에 대한 주문번호 |
| cancelPrice | 취소요청금액 | AES 암호화  <br>숫자만 입력  <br>거래금액 또는 부분취소 금액  <br>\* 자원순환보증금액이 있는 경우 부분취소 불가 | N(13) | ●   | "9000" |
| taxPrice | 과세금액 | AES 암호화  <br>취소금액 중 과세금액 원거래면세여부가 복합과세일 경우만 해당  <br>전체금액 취소일 경우 생략 | N(13) | ○   | "5000" |
| vatPrice | 부가세금액 | AES 암호화  <br>취소금액 중 부가세 금액 과세금액의 10% 원거래면세여부가 복합과세일 경우만 해당  <br>전체금액 취소일 경우 생략 | N(13) | ○   | "500" |
| dutyFreePrice | 비과세금액 | AES 암호화  <br>취소금액 중 비과세금액 원거래면세여부가 복합과세일 경우만 해당  <br>전체금액 취소일 경우 생략 | N(13) | ○   | "3500" |
| reqDay | 요청일자 | 가맹점에서 생성한 결제취소 요청일자  <br>문자열 포맷)yyyyMMdd | N(8) | ●   | "20190221" |
| reqTime | 요청시각 | 가맹점에서 생성한 결제취소 요청시간  <br>문자열 포맷)HH24MISS | N(6) | ●   | "142120" |
| signature | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 8.4 요청 전문 해쉬 코드

| 항목  | 조합 필드 |
| --- | --- |
| signature 값 | 가맹점아이디 + 거래번호 + 취소주문번호 + 취소요청금액(plain 값) + 요청일자 + 요청시간 + 인증키 |

## 8.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의 합니다.

     
| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| resultCd | 결과코드 | 결과코드(성공/실패) | N(1) | ●   | 성공 : "0"  <br>실패 : "-1" |
| errCd | 실패코드 | 실패코드 테이블 참조 | AN(5) | ●   |     |
| resultMsg | 결과메세지 | 육안 식별 가능한 메세지이며, 서버측에 의해 임의 변동 가능성 존재 | AN(200) | ●   | "성공" |
| oldTrNo | 취소  <br>원거래번호 | 취소 대상 결제거래번호 | AN(50) | ●   | "STFP\_PNPTms00001t00220922182409M1962430" |
| trNo | 취소거래번호 | 취소시 생성된 거래번호 | AN(50) | ●   | "STFP\_PNPTms00001t00220404134307M1550602" |
| cancelPrice | 취소금액 | 취소 거래금액 | N(13) | ●   | "9000" |
| disntCancelPrice | 취소 할인(프로모션) 금액 | 취소 거래 금액 중 할인 금액 취소 분 (즉시할인, 쿠폰) | N(13) | ●   | "1000" |
| payCancelPrice | 결제 취소 금액 | 취소 거래 금액 중 할인을 제외한 취소 금액 | N(13) | ●   | "8000" |
| criPrice | 현금영수증 발급 금액 | 현금영수증 발급 금액 (현금성 결제 금액만 발급대상) | N(13) | ●   | "7000" |
| criTaxVatPrice | 현금영수증 취소 과세 금액(부가세 포함) | 현금영수증 취소 금액 중 과세 금액만 표기 (부가세 포함) | N(13) | ●   | "5500" |
| criDutyFreePice | 현금영수증 취소 비과세 금액 | 현금영수증 취소 금액 중 비과세 금액만 표기 | N(13) | ●   | "1500" |
| cancelDay | 취소일자 | 취소일자  <br>문자열 포맷 yyyyMMdd | N(8) | ●   | "20190222" |

# 9\. 망취소 (API)

## 9.1 API 요약 설명

내통장결제에 결제요청 후 가맹점 측에서 타임아웃 된 거래건에 대하여 거래결과조회 API 응답상태가 결제성공일 경우 망취소를 요청하는 기능을 별도 WEB API 형식으로 제공합니다.

## 9.2 API URL

| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tbezauthapi.settlebank.co.kr/APINetPayCancel.do |
| 상용 환경 | https://ezauthapi.settlebank.co.kr:8081/APINetPayCancel.do |

## 9.3 요청 전문 (가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의 합니다.

     
| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 잔문 정보 | 전문정보 코드 | AN(50) | ●   | "IA\_NC\_1.0\_1.0"  <br>※ 고정값 |
| apiVer | 전문 버전 | 전문버전 | AN(4) | ●   | "1.0"  <br>※ 고정값 |
| mercntId | 가맹점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | "settleId" |
| trDay | 거래일자 | 가맹점에서 주문시 생성한 거래일자 | N(8) | ●   | "20190221" |
| ordNo | 주문번호 | 가맹점에서 생성한 결제<br><br>주문번호 | AN(100) | ●   | "OID201902210001" |
| reqDay | 요청일자 | 가맹점에서 생성한 거래취소 요청일자  <br>문자열 포맷)yyyyMMdd | N(8) | ●   | "20190221" |
| reqTime | 요청시간 | 가맹점에서 생성한 거래취소 요청시간  <br>문자열 포맷)HH24MISS | N(6) | ●   | "142120" |
| signature | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 9.4 요청 전문 해쉬 코드

| 항목  | 조합 필드 |
| --- | --- |
| signature 값 | 가맹점아이디 + 주문번호 + 거래일자 + 요청일자 + 요청시간 + 인증키 |

## 9.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의 합니다.

     
| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| resultCd | 결과코드 | 결과코드(성공/실패) | N(1) | ●   | 성공 : "0"  <br>실패 : "-1" |
| errCd | 실패코드 | 실패코드 테이블 참조 | AN(5) | ●   |     |
| resultMsg | 결과메세지 | 육안 식별 가능한 메세지이며, 서버측에 의해 임의 변동 가능성 존재 | AN(200) | ●   | "성공" |
| apiVer | API 버전 | API 버전 | AN(10) | ●   |     |

# 10\. 거래결과조회 (API)

## 10.1 API 요약 설명

거래건에 대한 결과조회 기능을 별도 WEB API 형식으로 제공합니다.  
결제요청 시 타임아웃이 발생한 거래의 결과를 확인하기 위한 용도입니다. 타임아웃 거래의 결과가 성공일 경우 망취소 API 를 이용하여 거래를 취소해야 합니다.

## 10.2 API URL

| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tbezauthapi.settlebank.co.kr/APIMoInfo.do |
| 상용 환경 | https://ezauthapi.settlebank.co.kr:8081/APIMoInfo.do |

## 10.3 요청 전문 (가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

     
| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문 정보 | 전문정보 코드 | AN(50) | ●   | "IA\_MO\_1.0\_1.0"  <br>※ 고정값 |
| apiVer | 전문 버전 | 전문버전 | AN(4) | ●   | "1.0"  <br>※ 고정값 |
| mercntId | 가맹점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | "settleId" |
| trDay | 거래일자 | 가맹점에서 주문시 생성한 거래일자 | N(8) | ●   | "20190221" |
| ordNo | 주문번호 | 가맹점에서 생성한 결제 주문번호 | AN(100) | ●   | "OID201902210001" |
| reqDay | 요청일자 | 가맹점에서 생성한 거래조회 요청일자  <br>문자열 포맷)yyyyMMdd | N(8) | ●   | "20190221" |
| reqTime | 요청시간 | 가맹점에서 생성한 거래조회 요청시간  <br>문자열 포맷)HH24MISS | N(6) | ●   | "142120" |
| signature | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 10.4 요청 전문 해쉬 코드

| 항목  | 조합 필드 |
| --- | --- |
| signature 값 | 가맹점아이디 + 주문번호 + 거래일자 + 요청일자 + 요청시간 + 인증키 |

## 10.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의 합니다.

     
| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| resultCd | 결과코드 | 결과코드(성공/실패) | N(1) | ●   | 성공 : "0"  <br>실패 : "-1" |
| errCd | 실패코드 | 실패코드 테이블 참조 | AN(5) | ●   |     |
| resultMsg | 결과메세지 | 육안 식별 가능한 메세지이며, 서버측에 의해 임의 변동 가능성 존재 | AN(200) | ●   | "성공" |
| trPrice | 거래금액 | 가맹점에서 최초 결제 요청한 금액 | N(13) | ●   | "10000" |
| trNo | 거래번호 | 헥토파이낸셜에서 생성한 결제 거래번호 | AN(50) | ●   | "STFP\_PNPTms00001t00220922182409M1962430" |
| trDay | 거래일자 | 결제 승인 일자  <br>문자열 포맷)yyyyMMdd | N(8) | ●   | "20190221" |
| trTime | 거래시간 | 결제 승인 일시  <br>HH24MISS | N(6) | ●   | "142120" |

# 11\. 거래내역조회 (API)

## 11.1 API 요약 설명

거래건에 대한 정보조회 기능을 별도 WEB API 형식으로 제공합니다.

## 11.2 API URL

| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tbezauthapi.settlebank.co.kr/v3/APITrInfo.do |
| 상용 환경 | https://ezauthapi.settlebank.co.kr:8081/v3/APITrInfo.do |

## 11.3 요청 전문 (가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의 합니다.

     
| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문 정보 | 전문정보 코드 | AN(50) | ●   | "IA\_MO\_1.0\_1.0"  <br>※ 고정값 |
| apiVer | 전문 버전 | 전문버전 | AN(4) | ●   | "1.0"  <br>※ 고정값 |
| mercntId | 가맹점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | "settleId" |
| trDay | 거래일자 | 가맹점에서 주문시 생성한 거래일자 | N(8) | ●   | "20190221" |
| ordNo | 주문번호 | 가맹점에서 생성한 결제 주문번호 | AN(100) | ●   | "OID201902210001" |
| reqDay | 요청일자 | 가맹점에서 생성한 거래조회 요청일자  <br>문자열 포맷)yyyyMMdd | N(8) | ●   | "20190221" |
| reqTime | 요청시간 | 가맹점에서 생성한 거래조회 요청시간  <br>문자열 포맷)HH24MISS | N(6) | ●   | "142120" |
| signature | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 11.4 요청 전문 해쉬 코드

| 항목  | 조합 필드 |
| --- | --- |
| signature 값 | 가맹점아이디 + 주문번호 + 거래일자 + 요청일자 + 요청시간 + 인증키 |

## 11.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의 합니다.

     
| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| resultCd | 결과코드 | 결과코드(성공/실패) | N(1) | ●   | 성공 : "0"  <br>실패 : "-1" |
| errCd | 실패코드 | 실패코드 테이블 참조 | AN(5) | ●   |     |
| resultMsg | 결과메세지 | 육안 식별 가능한 메세지이며, 서버측에 의해 임의변동 가능성 존재 | AN(200) | ●   | "성공" |
| trCnt | 거래내역건수 | 거래내역이 존재하는 경우 거래건수 | N(4) | ●   | "2" |
| trList | 거래내역 |     | <object> | ●   |     |
| \--trStatus | 거래상태 | 거래성공:0021 or 3010 or 0  <br>거래실패:0031 출금요청중:0011  <br>환불처리중:0051 | AN(4) | ●   | "0021" |
| \--errCd | 실패코드 | 실패코드 테이블 참조 | AN(5) | ●   |     |
| \--trType | 거래구분 | 결제:RP, 취소:RT | AN(2) | ●   | "RP" |
| \--trDay | 거래일자 | 문자열  <br>포맷)yyyyMMdd | N(8) | ●   | "20190221" |
| \--trTime | 거래시갂 | 문자열  <br>포맷)HH24MISS | N(6) | ●   | "142120" |
| \--bankCd | 출금은행코드 | 등록된 고객  <br>출금은행코드 | N(3) | ●   | "001" |
| \--trPrice | 거래금액 | 가맹점측 결제 요청 금액 | N(13) | ●   | "1000" |
| \--discntPrice | 할인금액 | 결제 모듈에 의해 차감된 금액  <br>(ex: 프로모션 선할인) | N(13) | ●   | "0" |
| \--payPrice | 결제금액 | 최초 결제 요청 금액에서 할인된 최종 출금 금액 | N(13) | ●   | "10000" |
| \--criPrice | 현금영수증 발급 금액 | 현금영수증 발급 금액(현금성 결제 금액 만 발급 대상)  <br>\*현금성 결제 금액만 현금영수증 발급 금액에 포함됩니다. | N(13) | ●   | "13000" |
| \--criTaxVatPrice | 현금영수증 과세 금액(부가세 포함) | 현금영수증 발급 금액 중 과세금액만 표기(부가세 포함) | N(13) | ●   | "11000" |
| \--criDutyFreePrice | 현금영수증 비과세 금액 | 현금영수증 발급 금액 중 비과세금액만 표기 | N(13) | ●   | "2000" |
| \--ordNo | 주문번호 | 가맹점 주문번호 | AN(100) | ●   | "OID201902210001" |
| \--trNo | 거래번호 | 헥토파이낸셜에서 생성한 거래번호 | AN(50) | ●   | "STFP\_PNPTms00001t00220922182409M1962430" |
| \--custParam1 | 가맹점추가필드 1 | 승인요청시 정의한 요청필드 외 가맹점에서 임의로 정의한 필드값 1 | AN(128) | ○   | "추가필드정보" |
| \--custParam2 | 가맹점추가필드 2 | 승인요청시 정의한 요청필드 외 가맹점에서 임의로 정의한 필드값 2 | AN(128) | ○   | "추가필드정보" |
| \--custParam3 | 가맹점추가필드 3 | 승인요청시 정의한 요청필드 외 가맹점에서 임의로 정의한 필드값 3 | AN(128) | ○   | "추가필드정보" |
| \--custParam4 | 가맹점추가필드 4 | 승인요청시 정의한 요청필드 외 가맹점에서 임의로 정의한 필드값 4 | AN(128) | ○   | "추가필드정보" |

# 12\. 현금영수증발행조회 (UI)

## 12.1 요약 설명

내통장결제를 통하여 현금영수증을 발급한 경우 해당 UI 연동을 통하여 현금영수증 정보를 확인할 수 있습니다.

## 12.2 연동 스크립트 메소드

```
settlePay.cashRcptInfo(form obj);
```

## 12.3 요청 폼(Form) 파라메터

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의합니다.

| Parameter | Parameter 명 | 설명  | 타입 (길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문 정보 | 전문정보 코드 | AN(50) | ●   | “IA\_CASHRCPTINFO\_1.0\_1.0”  <br>※ 고정값 |
| apiVer | 전문 버전 | 전문버전 | AN(4) | ●   | “1.0”  <br>※ 고정값 |
| mercntId | 가맹점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “settleId” |
| ordNo | 주문번호 | 가맹점에서 생성한 고유 주문번호(동일 거래일자에 유일성을 보장해야 함) | AN(100) | ●   | “OID201902210001” |
| trNo | 거래번호 | 헥토파이낸셜에서 생성한 결제 거래번호 | AN(50) | ●   | “STFP\_PNPTms00001t00220922182409M1962430” |
| trDay | 거래일자 | yyyyMMdd | N(8) | ●   | “20190221” |
| signature | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 12.4 요청 전문 해쉬 코드

| 항목  | 조합 필드 |
| --- | --- |
| signature 값 | 가맹점아이디 + 주문번호 + 거래번호 + 거래일자 + 인증키 |

# 13\. 자동결제 키 발급 (API)

## 13.1 API 요약 설명

자동결제 키 발급 요청 WEB API를 호출합니다.  
자동결제여부 파라메터를 'Y', 결제금액을 0원으로 설정하여 결제창을 연동한 후 인증완료 CAllback 후 해당 API를 호출하여 결제없이 자동결제 키를 발급받을 수 있습니다.  
자동결제 키 발급 후 해당 키를 사용하여 결제인증 UI 단계를 생략하고 자동결제승인 API를 통하여 결제를 진행할 수 있습니다.

## 13.2 API URL

| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tbezauthapi.settlebank.co.kr/APIRegularpayKey.do |
| 상용 환경 | https://ezauthapi.settlebank.co.kr:8081/APIRegularpayKey.do |

## 13.3 요청 전문 (가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의 합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문 정보 | 전문정보 코드 | AN(50) | ●   | “IA\_RK\_1.0\_1.0”  <br>※ 고정값 |
| apiVer | 전문 버전 | 전문버전 | AN(4) | ●   | “1.0”  <br>※ 고정값 |
| mercntId | 가맹점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “settleId” |
| authNo | 인증번호 | 헥토파이낸셜에서 생서한 인증 단계 응답값 | AN(20) | ●   | "PAR20190220000000001" |
| reqDay | 요청일자 | 가맹점에서 생성한 키발급 요청일자  <br>문자열 포맷)yyyyMMdd | N(8) | ●   | “20190221” |
| reqTime | 요청시간 | 가맹점에서 생성한 키발급 요청시간  <br>문자열 포맷)HH24MISS | N(6) | ●   | “142120” |
| signature | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 13.4 요청 전문 해쉬 코드

| 항목  | 조합 필드 |
| --- | --- |
| signature 값 | 가맹점아이디 + 인증번호 + 요청일자 + 요청시간 + 인증키 |

## 13.5 응답 전문 (헥토파이낸셜 → 가맹점)

  
헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의 합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| resultCd | 결과코드 | 결과코드(성공/실패) | N(1) | ●   | 성공 : “0”  <br>실패 : “-1” |
| errCd | 실패코드 | 실패코드 테이블 참조 | AN(5) | ●   |     |
| resultMsg | 결과메세지 | 육안 식별 가능한 메세지이며, 서버측에 의해 임의변동 가능성 존재 | AN(200) | ●   | “성공” |
| mercntId | 가맹점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | "settleId" |
| ordNo | 주문번호 | 가맹점에서 요청시 생성한 고유 주문번호 | AN(100) | ●   | "OID201902210001 |
| trNo | 거래번호 | 헥토파이낸셜에서 생성한 거래번호 | AN(50) | ●   | "STFP\_PNPTms00001t00220922182409M1962430" |
| trDay | 거래일자 | 가맹점 최초 UI 요청일자  <br>문자열 포맷 yyyyMMdd | N(8) | ●   | "20190221" |
| trTime | 거래시간 | 가맹점 최초 UI 요청일시 HH24MISS | N(8) | ●   | "142120" |
| regularpayKey | 자동결제키 | 자동결제용으로 생성된 유키크 키 | AN(32) | ●   |     |
| bankAcctNo | 계좌번호 | 자동결제 키 발급 시 마스킹된 전계좌번호 파라메터 응답 | AN(20) | ○   | 123\*\*\*\*\*789 |
| bankCd | 은행코드 | 자동결제 키 발급 시 은행코드 파라메터 응답 | AN(3) | ○   | "011" |

# 14\. 자동결제 승인 (API)

## 14.1 API 요약 설명

자동결제 거래건에 대한 승인요청 WEB API 를 호출합니다.  
자동결제여부 파라메터를 ‘Y’로 설정하여 결제창을 연동한 후 최초 결제를 실행한 경우 해당 계좌에 자동결제가 등록(빌키 응답)이 되며 그 후에는 빌키를 사용하여 해당 API 를 통해 자동결제를 실행하게 됩니다.

## 14.2 API URL

| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tbezauthapi.settlebank.co.kr/v3/APIRegularPayment.do |
| 상용 환경 | https://ezauthapi.settlebank.co.kr:8081/v3/APIRegularPayment.do |

## 14.3 요청 전문 (가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의 합니다.

     
| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문 정보 | 전문정보 코드 | AN(50) | ●   | “IA\_SP\_1.0\_1.0”  <br>※ 고정값 |
| apiVer | 전문 버전 | 전문버전 | AN(4) | ●   | “1.0”  <br>※ 고정값 |
| mercntId | 가맹점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “settleId” |
| trDay | 거래일자 | 가맹점에서 주문시 생성한 거래일자 | N(8) | ●   | “20190221” |
| trTime | 거래시각 | 가맹점에서 생성한 거래일시  <br>HH24MISS | N(6) | ●   | “142120” |
| ordNo | 주문번호 | 가맹점에서 생성한 결제 주문번호 | AN(100) | ●   | “OID201902210001” |
| reqDay | 요청일자 | 가맹점에서 생성한 결제승인 요청일자  <br>문자열 포맷)yyyyMMdd | N(8) | ●   | “20190221” |
| reqTime | 요청시간 | 가맹점에서 생성한 결제승인 요청시간  <br>문자열 포맷)HH24MISS | N(6) | ●   | “142120” |
| trPrice | 거래금액 | AES 암호화  <br>결제금액  <br>\*자원순환보증금액이 있는 경우 포함 | N(13) | ●   | “10000” |
| taxPrice | 과세금액 | AES 암호화  <br>결제금액 중 과세금액 면세여부가 복합과세일 경우만 해당 | N(13) | ○   | “8000” |
| vatPrice | 부가세금액 | AES 암호화  <br>결제금액 중 부가세금액 과세금액의 10% 면세여부가 복합과세일 경우만 해당 | N(13) | ○   | 과세금액의 10% = “800” |
| dutyFreePrice | 면세금액 | AES 암호화  <br>결제금액 중 비과세금액 면세여부가 복합과세일 경우만 해당 | N(13) | ○   | 4000 |
| containerDeposit | 자원순환보증금액 | AES 암호화  <br>자원순환보증금액 대상 거래인 경우 금액  <br>(현금영수증 비대상) | N(5) | ○   | 300 |
| productNm | 상품명 | 상품명 | AN(15) | ●   | “배추” |
| dutyFreeYn | 면세여부 | Y:면세, N:과세, G:복합과세 | A(1) | ●   | “G” |
| criPsblYn | 현금영수증발행가능여부 | Y: 발행가능, N: 발행불가능  <br>""(빈값)일 경우 Y로 인식 | A(1) | ○   | "Y" |
| addDeductionYn | 추가공제구분 | 대중교통 : Y  <br>도서, 공연비 : C  <br>추가공제없음 : N | A(1) | ○   | “N” |
| regularpayKey | 자동결제키 | 자동결제용 확인을 위해 생성된 유니크한 키 | AN(32) | ●   |     |
| signature | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |
| custParam1 | 가맹점 추가필드 1 | 승인요청시 정의한 요청필드 외 가맹점에서 임의로 정의 저장되는 필드값 1  <br>거래조회시 해당 값이 응답전문에 표기됩니다. | AN(256) | ○   | “추가필드정보”  <br>가맹점관리자에서 해당값으로 거래건 조회 가능 |
| custParam2 | 가맹점 추가필드 2 | 승인요청시 정의한 요청필드 외 가맹점에서 임의로 정의 저장되는 필드값 2  <br>거래조회시 해당 값이 응답전문에 표기됩니다. | AN(256) | ○   | “추가필드정보”  <br>가맹점관리자에서 해당값으로 거래건 조회 가능 |
| custParam3 | 가맹점 추가필드 3 | 승인요청시 정의한 요청필드 외 가맹점에서 임의로 정의 저장되는 필드값 3  <br>거래조회시 해당 값이 응답전문에 표기됩니다. | AN(256) | ○   | “추가필드정보”  <br>가맹점관리자에서 해당값으로 거래건 조회 가능 |
| custParam4 | 가맹점 추가필드 4 | 승인요청시 정의한 요청필드 외 가맹점에서 임의로 정의 저장되는 필드값 4  <br>거래조회시 해당 값이 응답전문에 표기됩니다. | AN(256) | ○   | “추가필드정보” |
| payLimitCd | 결제 한도 코드 | 내통장결제에 설정되어 있는 정책에 따라 고객의 결제한도를 확인합니다. | AN(1) | ○   |     |

## 14.4 요청 전문 해쉬 코드

| 항목  | 조합 필드 |
| --- | --- |
| signature 값 | 가맹점아이디 + 주문번호 + 거래일자 + 요청일자 + 요청시간 + 거래금액(plain 값) + 자동결제키+ 인증키 |

## 14.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의 합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| resultCd | 결과코드 | 결과코드(성공/실패) | N(1) | ●   | 성공 : “0”  <br>실패 : “-1” |
| errCd | 실패코드 | 실패코드 테이블 참조 | AN(5) | ●   |     |
| resultMsg | 결과메세지 | 육안 식별 가능한 메세지이며, 서버측에 의해 임의 변동 가능성 존재 | AN(200) | ●   | “성공” |
| trNo | 거래번호 | 헥토파이낸셜 거래번호 | A(50) | ●   | "STFP\_PNPTms00001t00220922182409M1962430" |
| ordNo | 주문번호 | 가맹점에서 요청시생성한 고유 주문번호 | AN(100) | ●   | “OID201902210001” |
| regularStatus | 자동결제 처리상태 | 자동결제 요청건의 처리상태 응답 | A(1) | ○   | 자동결제 재처리필요 : R  <br>자동결제 해지대상 : C |
| trPrice | 거래금액 | 가맹점에서 최초 결제 요청한 금액 | N(13) | ●   | “15000” |
| discntPrice | 할인(프로모션)금액 | 결제 모듈에 의해 차감된 금액(즉시할인, 쿠폰) | N(13) | ●   | “1000” |
| payPrice | 결제금액 | 최초 거래 요청 금액에서 할인금액을 제외한 결제금액 | N(13) | ●   | “14000” |
| criPrice | 현금영수증 발급 금액 | 현금영수증 발급 금액(현금성 결제 금액 만 발급대상)  <br>\*현금성 결제 금액만 현금영수증 발급 금액에 포함됩니다. | N(13) | ●   | “13000” |
| criTaxVatPrice | 현금영수증 과세 금액(부가세 포함) | 현금영수증 발급 금액 중 과세 금액만 표기(부가세 포함) | N(13) | ●   | “11000” |
| criDutyFreePrice | 현금영수증 비과세 금액 | 현금영수증 발급 금액 중 비과세금액만 표기 | N(13) | ●   | “2000” |
| ordDay | 주문일자 | 가맹점 최초 결제 요청 일자  <br>문자열 포맷)yyyyMMdd | N(8) | ●   | “20190221” |
| ordTime | 주문시간 | 가맹점 최초 결제 요청 시간  <br>HH24MISS | N(6) | ●   | "142120" |
| trDay | 거래일자 | 내통장결제측 거래 일자  <br>문자열 포맷)yyyyMMdd | N(8) | ●   | "20190221" |
| trTime | 거래시간 | 내통장결제측 거래 시간  <br>HH24MISS | N(6) | ●   | "142122" |

# 15\. 자동결제 해지 (API)

## 15.1 API 요약 설명

기 등록된 자동결제를 해지하는 WEB API 를 호출합니다.

## 15.2 API URL

| 구분  | URL |
| --- | --- |
| 테스트베드 | https://tbezauthapi.settlebank.co.kr/APIUnRegistRegular.do |
| 상용 환경 | https://ezauthapi.settlebank.co.kr:8081/APIUnRegistRegular.do |

## 15.3 요청 전문 (가맹점 → 헥토파이낸셜)

가맹점 서버에서 헥토파이낸셜측으로 요청하는 컬럼을 다음과 같이 정의 합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| hdInfo | 전문 정보 | 전문정보 코드 | AN(50) | ●   | “IA\_MO\_1.0\_1.0”  <br>※ 고정값 |
| apiVer | 전문 버전 | 전문버전 | AN(4) | ●   | “1.0”  <br>※ 고정값 |
| mercntId | 가맹점아이디 | 헥토파이낸셜에서 부여하는 고유 상점아이디 | AN(8) | ●   | “settleId” |
| reqDay | 요청일자 | 가맹점에서 생성한 해지 요청일자  <br>문자열 포맷)yyyyMMdd | N(8) | ●   | “20190221” |
| reqTime | 요청시간 | 가맹점에서 생성한 해지 요청시간  <br>문자열 포맷)HH24MISS | N(6) | ●   | “142120” |
| regularpayKey | 자동결제키 | 자동결제용 확인을 위해 생성된 유니크한 키 | AN(32) | ●   |     |
| signature | hash 데이터 | sha256 방식으로 생성한 해쉬값 | AN(200) | ●   |     |

## 15.4 요청 전문 해쉬 코드

| 항목  | 조합 필드 |
| --- | --- |
| signature 값 | 가맹점아이디 + 요청일자 + 요청시간 + 자동결제키 + 인증키 |

## 15.5 응답 전문 (헥토파이낸셜 → 가맹점)

헥토파이낸셜 서버에서 가맹점측으로 응답하는 컬럼을 다음과 같이 정의 합니다.

| Parameter | Parameter 명 | 설명  | 타입(길이) | 필수  | 비고  |
| --- | --- | --- | --- | --- | --- |
| resultCd | 결과코드 | 결과코드(성공/실패) | N(1) | ●   | 성공 : “0”  <br>실패 : “-1” |
| errCd | 실패코드 | 실패코드 테이블 참조 | AN(5) | ●   |     |
| resultMsg | 결과메세지 | 육안 식별 가능한 메세지이며, 서버측에 의해 임의 변동 가능성 존재 | AN(200) | ●   | “성공” |

# 16\. 기타

## 16.1 실패코드

서버측 응답의 거절코드 필드 상세 설명은 다음과 같습니다.

| 코드  | 내용  | 코드  | 내용  |
| --- | --- | --- | --- |
| 1   | 유효하지 않는 요청전문 | 2   | IP 권한 없음 |
| 19  | 내부 시스템 오류 | 1103 | Signature 오류 |
| 1112 | 취소기한 초과 | 1201 | 결제 API 통신오류 |
| 10001 | 존재하지 않는 계좌 | 10002 | 유효하지 않는 계좌 |
| 10003 | 이중출금 발생 | 10004 | VAN 요청중 시스템 에러 |
| 10005 | VAN 응답정보 없음 | 10006 | 거래번호 정보가 없음 |
| 10007 | 통신장애 | 10008 | 이미 등록된 계좌 |
| 10009 | 유효하지 않는 요청전문 | 10010 | 내부 시스템 에러 |
| 10011 | 은행점검 시간 | 10012 | 출금계좌잔액부족 |
| 10013 | ARS 인증 결과가 없음 | 10014 | ARS 인증 요청 값이 상이함 |
| 10015 | 자동이체해지계좌 | 10016 | 출금계좌거래제한 |
| 10017 | 주민번호 사업자번호 오류 | 10018 | 계좌오류 (간편계좌등록불가) |
| 10019 | 기타거래불가 | 10020 | 계좌오류 |
| 10021 | 수취인 계좌 없음 | 10022 | 법적 제한 계좌 |
| 10023 | 비실명 계좌 | 10024 | 예금주 불일치 |
| 10025 | 이미 취소된 거래 | 10026 | 취소금액 오류 |
| 10027 | ARS인증 실패 | 10028 | ARS수신불가 |
| 10029 | 계좌 등록 진행중 | 10030 | 환불 진행중 |
| 10031 | 이중송금 발생 | 10032 | 납부자 성명조회 실패 |
| 10033 | 1회 한도초과 | 10034 | 1일 한도초과 |
| 10035 | 사고계좌 입니다. | 10036 | 일정시간이 지나 연결이 끊어졌습니다 |
| 10037 | 간편결제 취소 | 10038 | 요청 진행 중 |
| 10039 | 환불중복 요청 | 10040 | 처리 중 요청이 있음 |
| 10041 | 서비스 용량초과 | 10042 | 시스템 BUSY |
| 10043 | 이미 등록된 계좌입니다 | 10044 | 거래 불가 은행 |
| 10050 | 중복전문요청 | 10051 | 이미 등록된 현금영수증 사용자 |
| 10052 | 미등록 현금영수증 사용자 | 10053 | 이미 해지된 계좌 |
| 10060 | 거래실패 | 10061 | 1회한도 금액초과 |
| 10062 | 일한도 금액초과 | 10063 | 월한도 금액초과 |
| 10064 | 일한도 건수초과 | 10065 | 월한도 건수초과 |
| 10066 | 비밀번호 등록 실패 | 10067 | 비밀번호 불일치 |
| 10068 | 서비스 이용정지 | 10069 | 정책상 해당 결제서비스를 이용할 수 없습니다.  <br>다른 결제수단으로 이용 부탁드립니다 |
| 10070 | 정책상 선택하신 결제서비스를 이용할 수 없습니다.  <br>헥토파이낸셜 고객센터로 문의바랍니다. (1600-5220) | 10071 | 부분취소 제한 가맹점 |
| 10072 | 오픈뱅킹 유효하지 않은 계좌입니다. 해지필요 | 10073 | 오픈뱅킹 해지 계좌입니다. 해지필요 |
| 10074 | 취소/환불 한도 초과 | 10099 | 간편결제 시스템 점검중 |
| 10100 | 중계기관 TIMEOUT | 10110 | 오픈뱅킹 안심차단 사용자 |
|     |     |     |     |

## 16.2 금융기관 식별자

금융기관 고유 식별 코드는 다음과 같습니다.

| 금융기관코드 | 금융기관명 | 금융기관코드 | 금융기관명 |
| --- | --- | --- | --- |
| 002 | 산업은행 | 064 | 산림조합중앙회 |
| 003 | 기업은행 | 071 | 우체국 |
| 004 | 국민은행 | 081 | 하나은행 |
| 007 | 수협은행/수협중앙회 | 088 | 신한은행 |
| 011 | NH농협은행 | 089 | 케이뱅크 |
| 012 | 농협중앙회(지역농축협) | 090 | 토스뱅크 |
| 020 | 우리은행 | 092 | 카카오뱅크 |
| 023 | SC 제일은행 | 103 | SBI 저축은행 |
| 027 | 한국씨티은행 | 209 | 유안타증권 |
| 031 | iM뱅크(대구은행) | 238 | 미래에셋증권 |
| 032 | 부산은행 | 240 | 삼성증권 |
| 034 | 광주은행 | 243 | 한국투자증권 |
| 035 | 제주은행 | 247 | NH투자증권 |
| 037 | 전북은행 | 266 | SK증권 |
| 039 | 경남은행 | 267 | 대신증권 |
| 045 | 새마을금고 | 278 | 신한금융투자 |
| 048 | 신협  | 280 | 유진투자증권 |
| 050 | 저축은행중앙회(상호저축은행) | 287 | 메리츠증권 |

## 16.3 은행 정기점검 시간

상기 업무시간은 은행별 업무시간으로 헥토파이낸셜에서는 **01:00 ~ 23:30 사이 거래를 권장**드립니다.  
은행별로 점검시간은 연장될 수 있습니다.

| 금융기관코드 | 금융기관명 | 은행점검시간 | 헥토파이낸셜 업무시간 |     | 정기 점검 |
| --- | --- | --- | --- | --- | --- |
| 업무 중단시간 | 업무 개시시간 |
| --- | --- | --- | --- | --- | --- |
| 002 | 산업은행 | 23:30~00:30 | 23:50 | 00:15 | 매월 2번째 일요일 00:00~04:00 |
| 003 | 기업은행 | 24:00~00:30 | 23:50 | 00:12 | 매주 일요일 00:00~00:30 |
| 004 | 국민은행 | 24:00~00:30 | 23:50 | 00:12 | 매월 3번째 일요일  <br>대외계 00:00~06:00 (간헐적 거래안됨)  <br>(업무중단 00:00~00:30, 05:00~05:30) |
| 007 | 수협은행/수협중앙회 | 23:50~00:30 | 23:30 | 00:30 | 없음  |
| 011 | 농협은행 | 24:00~00:30 | 23:50 | 00:12 | 매월 3번째 월요일 00:00~04:00  <br>(해당일 공유일일 경우, 익영업일) |
| 020 | 우리은행 | 23:50~00:30 | 23:50 | 00:10 | 매월 2번째 일요일 02:00~06:00  <br>(작업일자는 은행에서 사전공지) |
| 023 | SC 제일은행 | 23:30~00:30 | 23:50 | 00:12 | 없음  |
| 027 | 한국씨티은행 | 23:40~00:30 | 23:50 | 00:30 | 매일 00:30~04:30 |
| 031 | 대구은행 | 23:40~00:30 | 23:50 | 00:05 | 없음  |
| 032 | 부산은행 | 23:30~00:30 | 23:50 | 00:05 | 없음  |
| 034 | 광주은행 | 23:40~00:30 | 23:50 | 00:05 | 매월 2번째 일요일 02:00~06:00 |
| 035 | 제주은행 | 23:40~00:30 | 23:50 | 00:12 | 매주 일요일 04:30~05:00 |
| 037 | 전북은행 | 24:00~00:30 | 23:50 | 00:05 | 매월 2번째 토요일 00:00~06:00 |
| 039 | 경남은행 | 23:40~00:30 | 23:50 | 00:05 | 매월 2번째 일요일 00:00~07:00 |
| 045 | 새마을금고 | 23:50~00:30 | 23:30 | 00:30 | 없음  |
| 048 | 신협  | 23:40~00:30 | 23:50 | 00:05 | 없음  |
| 050 | 저축은행중앙회 | 23:50~00:10 | 23:50 | 00:35 | 없음  |
| 064 | 산림조합중앙회 | 23:30~00:30 | 23:30 | 01:00 | 없음  |
| 071 | 우체국 | 23:40~00:30 | 23:50 | 00:05 | 없음  |
| 081 | 하나은행 | 23:40~00:30 | 23:50 | 00:15 | 매월 2번째 일요일 00:00~08:00 |
| 088 | 신한은행 | 23:40~00:30 | 23:50 | 00:05 | 없음  |
| 089 | 케이뱅크 | 23:40~00:30 | 23:35 | 00:35 | 없음  |
| 090 | 카카오뱅크 | 23:50~00:10 | 23:50 | 00:05 | 없음  |
| 092 | 토스뱅크 | 23:55~00:05 | 23:55 | 00:05 | 없음  |
| 103 | SBI저축은행 | 23:55~00:10 | 23:50 | 00:05 | 없음  |
| 209 | 유안타증권 | 23:50~00:10 | 23:50 | 00:10 | 없음  |
| 238 | 미래에셋증권 | 23:30~00:20 | 23:30 | 00:20 | 매주 토요일 08:00~08:30 |
| 240 | 삼성증권 | 23:30~00:20 | 23:50 | 00:10 | 없음  |
| 243 | 한국투자증권 | 23:40~00:10 | 23:40 | 00:10 | 없음  |
| 247 | NH투자증권 | 23:50~00:15 | 23:50 | 00:05 | 없음  |
| 266 | SK증권 | 23:50~00:30 | 23:30 | 00:30 | 없음  |
| 267 | 대신증권 | 23:55~00:25 | 23:55 | 00:25 | 없음  |
| 278 | 신한금융투자 | 23:25~00:15 | 23:30 | 00:15 | 매일 23:30~00:10, 03:00~03:10 |
| 280 | 유진투자증권 | 23:30~00:30 | 23:50 | 00:35 | 없음  |
| 287 | 메리츠증권 | 23:50~00:20 | 23:50 | 00:20 | 없음  |