# coding: utf-8

"""
    Groupe PSA Connected Car - WEB API B2C

    *PSA B2C Connected Car API*  # Introduction This is the description of the *Groupe PSA Connected Car V2 API*. The speccification is  is based on **OpenAPI Specification version 3** and can be displayed via [ReDoc](https://github.com/Rebilly/ReDoc)a or [Swagger](http://swagger.io).   This API allows applications to fetch data from the connected Vehicles data platform. # Authentication PSA Connected Car APIs uses the [OAuth 2.0](https://tools.ietf.org/html/rfc6749) protocol for authentication and Authorization. any application require a valid [Access Token](https://tools.ietf.org/html/rfc6749#section-1.4) to access to user data. # Errors   Error codes returned by all REST APIs comply with the standard. Nevertheless, PSA Services (callers) need to have more complete data structures (even when the answer is not Http-OK) to better detail the type of error by providing application code, message and a debugging code(for investigation purposes). The http code of the response is managed by the protocol itself (in the header).      **Errors are  returned as a generic error response:**    * ```xError``` object model.       # noqa: E501

    OpenAPI spec version: 4.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class MonitorParameter(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'extended_event_param': 'list[object]',
        'label': 'str',
        'locale': 'str',
        'subscribe_param': 'MonitorSubscribe',
        'trigger_param': 'MonitorParameterTriggerParam'
    }

    attribute_map = {
        'extended_event_param': 'extendedEventParam',
        'label': 'label',
        'locale': 'locale',
        'subscribe_param': 'subscribeParam',
        'trigger_param': 'triggerParam'
    }

    def __init__(self, extended_event_param=None, label=None, locale=None, subscribe_param=None, trigger_param=None):  # noqa: E501
        """MonitorParameter - a model defined in Swagger"""  # noqa: E501

        self._extended_event_param = None
        self._label = None
        self._locale = None
        self._subscribe_param = None
        self._trigger_param = None
        self.discriminator = None

        if extended_event_param is not None:
            self.extended_event_param = extended_event_param
        self.label = label
        if locale is not None:
            self.locale = locale
        self.subscribe_param = subscribe_param
        self.trigger_param = trigger_param

    @property
    def extended_event_param(self):
        """Gets the extended_event_param of this MonitorParameter.  # noqa: E501

        Allow to set extra vehicle data (defined in data model) to add to the monitor event when publishing. The possible values are   |value|description|Related model | |----------|:-------------|------:| |vehicle.doorsState|Latest know door state (timestamped)|DoorState| |vehicle.status|Latest know vehicle status (timestamped)|Status| |vehicle.maintenance|Latest know maintenance(timestamped)|Maintenance| |vehicle.position|Last vehicle position (timestamped)|Position| |vehicle.telemetry${.TelemetryEnum}|Latest known telemetry (timestamped). |Telemetry |vehicle.alerts|List of active alerts|Alert|  * For telemetry extension:     * The suffix ```${.TelemetryEnum}``` can be selected to refine with telemetry type (from the TelemetryEnum list). This value (with suffix) can be selected **_several times_** to included suitable telemetry messages with the extention.   * Using ```vehicle.telemetry``` without suffix means to include all available telemetries.    # noqa: E501

        :return: The extended_event_param of this MonitorParameter.  # noqa: E501
        :rtype: list[object]
        """
        return self._extended_event_param

    @extended_event_param.setter
    def extended_event_param(self, extended_event_param):
        """Sets the extended_event_param of this MonitorParameter.

        Allow to set extra vehicle data (defined in data model) to add to the monitor event when publishing. The possible values are   |value|description|Related model | |----------|:-------------|------:| |vehicle.doorsState|Latest know door state (timestamped)|DoorState| |vehicle.status|Latest know vehicle status (timestamped)|Status| |vehicle.maintenance|Latest know maintenance(timestamped)|Maintenance| |vehicle.position|Last vehicle position (timestamped)|Position| |vehicle.telemetry${.TelemetryEnum}|Latest known telemetry (timestamped). |Telemetry |vehicle.alerts|List of active alerts|Alert|  * For telemetry extension:     * The suffix ```${.TelemetryEnum}``` can be selected to refine with telemetry type (from the TelemetryEnum list). This value (with suffix) can be selected **_several times_** to included suitable telemetry messages with the extention.   * Using ```vehicle.telemetry``` without suffix means to include all available telemetries.    # noqa: E501

        :param extended_event_param: The extended_event_param of this MonitorParameter.  # noqa: E501
        :type: list[object]
        """

        self._extended_event_param = extended_event_param

    @property
    def label(self):
        """Gets the label of this MonitorParameter.  # noqa: E501

        Monitor lablel (usually its name).  # noqa: E501

        :return: The label of this MonitorParameter.  # noqa: E501
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """Sets the label of this MonitorParameter.

        Monitor lablel (usually its name).  # noqa: E501

        :param label: The label of this MonitorParameter.  # noqa: E501
        :type: str
        """
        if label is None:
            raise ValueError("Invalid value for `label`, must not be `None`")  # noqa: E501

        self._label = label

    @property
    def locale(self):
        """Gets the locale of this MonitorParameter.  # noqa: E501

        Locale is used for rendering text according to language and country for. It should match the  REGEX ```\\w(-\\w)?```. For more details about possible standard values, please refer to [locals list](https://en.wikipedia.org/wiki/Language_localisation).   # noqa: E501

        :return: The locale of this MonitorParameter.  # noqa: E501
        :rtype: str
        """
        return self._locale

    @locale.setter
    def locale(self, locale):
        """Sets the locale of this MonitorParameter.

        Locale is used for rendering text according to language and country for. It should match the  REGEX ```\\w(-\\w)?```. For more details about possible standard values, please refer to [locals list](https://en.wikipedia.org/wiki/Language_localisation).   # noqa: E501

        :param locale: The locale of this MonitorParameter.  # noqa: E501
        :type: str
        """
        if locale is not None and not re.search(r'\\w(-\\w)?', locale):  # noqa: E501
            raise ValueError(r"Invalid value for `locale`, must be a follow pattern or equal to `/\\w(-\\w)?/`")  # noqa: E501

        self._locale = locale

    @property
    def subscribe_param(self):
        """Gets the subscribe_param of this MonitorParameter.  # noqa: E501


        :return: The subscribe_param of this MonitorParameter.  # noqa: E501
        :rtype: MonitorSubscribe
        """
        return self._subscribe_param

    @subscribe_param.setter
    def subscribe_param(self, subscribe_param):
        """Sets the subscribe_param of this MonitorParameter.


        :param subscribe_param: The subscribe_param of this MonitorParameter.  # noqa: E501
        :type: MonitorSubscribe
        """
        if subscribe_param is None:
            raise ValueError("Invalid value for `subscribe_param`, must not be `None`")  # noqa: E501

        self._subscribe_param = subscribe_param

    @property
    def trigger_param(self):
        """Gets the trigger_param of this MonitorParameter.  # noqa: E501


        :return: The trigger_param of this MonitorParameter.  # noqa: E501
        :rtype: MonitorParameterTriggerParam
        """
        return self._trigger_param

    @trigger_param.setter
    def trigger_param(self, trigger_param):
        """Sets the trigger_param of this MonitorParameter.


        :param trigger_param: The trigger_param of this MonitorParameter.  # noqa: E501
        :type: MonitorParameterTriggerParam
        """
        if trigger_param is None:
            raise ValueError("Invalid value for `trigger_param`, must not be `None`")  # noqa: E501

        self._trigger_param = trigger_param

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(MonitorParameter, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MonitorParameter):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
