pjplan: Python библиотека для планирования и анализа проектов
=============================

```{toctree}
---
caption: Установить pjplan и познакомиться с возможностями библиотеки помогут следующие разделы
maxdepth: 1
hidden: true
titlesonly: true
---

installation
getting-started/getting-started
```

**pjplan** превращает [Jupyter Notebook](https://jupyter.org/) в инструмент управления проектами.
Эта библиотека предоставляет простой API со следующими возможностями:
- Описание Иерархической Структуры Работ (ИСР) проекта в коде или загрузка ИСР из внешнего источника.
- Управление задачами в ИСР: создание связей предшественник/последователь, поиск, удаление, изменение порядка работ и т.д.
- Назначение ресурсов на задачи
- Управление рабочими календарями
- Расчет расписания проекта несколькими способами
- Поиск критического пути
- Визуализация ИСР с помощью диаграмм Ганта и сетевой диаграммы
- Чтение/Запись ИСР в csv-файл
- Экспорт структуры работ в [pandas](https://pandas.pydata.org/)

## Для чего можно использовать pjplan?
**pjplan** создавалась в первую очередь как дополнительный инструмент для других систем управления проектами, таких как 
Jira, Asure Devops, Trello и т.п. В большинстве своем данные системы не обладают серьезными инструментами планирования,
оценки сроков и анализа больших проектов. В этом случае предполагается следующий сценарий использования:
1. Из внешней системы выгружается список работ, например, в виде csv-файла
2. Данные о работах загружаются в pjplan
3. Далее с помощью API в pjplan выполняются дополнительные действия: удаление "мусорных" работ, группировка, связывание и т.д. 
Таким образом ИСР приводится к виду, пригодном для планирования
4. Наконец, с помощью алгоритмов pjplan строится и визуализируется расписание проекта и выполняется дальнейший анализ

С другой стороны, pjplan содержит все необходимое для того, чтобы быть самостоятельным инструментом планирования проекта

## Где можно использовать pjplan?

**pjplan** хорошо подходит для работы в [Jupyter Notebook](https://jupyter.org/) и подобных ей средах. Все объекты библиотеки
имеют готовые визуализации, которые удобно просматривать внутри ноутбуков.

Но, как и любая другая библиотека, pjplan может использоваться в любых python-программах.

