# Generated by Django 3.2.13 on 2022-06-28 08:16

import django.db.models.deletion
from django.db import migrations, models


def make_reverse_link(apps, schema_editor):
    Answer = apps.get_model("caluma_form.Answer")
    HistoricalAnswer = apps.get_model("caluma_form.HistoricalAnswer")
    HistoricalFile = apps.get_model("caluma_form.HistoricalFile")

    # All files on current answers need to get the pointer file -> answer
    for ans in Answer.objects.filter(question__type="file"):
        file = ans.file
        file.answer = ans
        file.save()

    # Find the historical files that were once part of this
    # answer, then have them point to the answer as well
    for hans in HistoricalAnswer.objects.filter(
        question__type="file", file__isnull=False
    ):
        file = hans.file
        hist = HistoricalFile.objects.filter(id=file.pk)
        hist.all().update(answer_id=hans.id)


def _rename_type(from_type, to_type, model):
    file_questions = model.objects.filter(type=from_type)
    file_questions.update(type=to_type)


def rename_file_type(apps, schema_editor):
    _rename_type("file", "files", apps.get_model("caluma_form.Question"))
    _rename_type("file", "files", apps.get_model("caluma_form.HistoricalQuestion"))


def rename_file_type_reverse(apps, schema_editor):
    _rename_type("files", "file", apps.get_model("caluma_form.Question"))
    _rename_type("files", "file", apps.get_model("caluma_form.HistoricalQuestion"))


class Migration(migrations.Migration):

    dependencies = [
        ("caluma_form", "0045_simple_history"),
    ]

    operations = [
        migrations.AddField(
            model_name="file",
            name="answer",
            field=models.ForeignKey(
                default=None,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="files",
                to="caluma_form.answer",
            ),
        ),
        migrations.AddField(
            model_name="historicalfile",
            name="answer",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                default=None,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="caluma_form.answer",
            ),
        ),
        migrations.AlterField(
            model_name="answer",
            name="file",
            field=models.OneToOneField(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to="caluma_form.file",
            ),
        ),
        migrations.RunPython(make_reverse_link, migrations.RunPython.noop),
        migrations.RemoveField(
            model_name="answer",
            name="file",
        ),
        migrations.RemoveField(
            model_name="historicalanswer",
            name="file",
        ),
        migrations.AlterField(
            model_name="historicalanswer",
            name="history_question_type",
            field=models.CharField(
                choices=[
                    ("multiple_choice", "multiple_choice"),
                    ("integer", "integer"),
                    ("float", "float"),
                    ("date", "date"),
                    ("choice", "choice"),
                    ("textarea", "textarea"),
                    ("text", "text"),
                    ("table", "table"),
                    ("form", "form"),
                    ("files", "files"),
                    ("dynamic_choice", "dynamic_choice"),
                    ("dynamic_multiple_choice", "dynamic_multiple_choice"),
                    ("static", "static"),
                    ("calculated_float", "calculated_float"),
                    ("action_button", "action_button"),
                ],
                max_length=23,
            ),
        ),
        migrations.AlterField(
            model_name="historicalquestion",
            name="type",
            field=models.CharField(
                choices=[
                    ("multiple_choice", "multiple_choice"),
                    ("integer", "integer"),
                    ("float", "float"),
                    ("date", "date"),
                    ("choice", "choice"),
                    ("textarea", "textarea"),
                    ("text", "text"),
                    ("table", "table"),
                    ("form", "form"),
                    ("files", "files"),
                    ("dynamic_choice", "dynamic_choice"),
                    ("dynamic_multiple_choice", "dynamic_multiple_choice"),
                    ("static", "static"),
                    ("calculated_float", "calculated_float"),
                    ("action_button", "action_button"),
                ],
                max_length=23,
            ),
        ),
        migrations.AlterField(
            model_name="question",
            name="type",
            field=models.CharField(
                choices=[
                    ("multiple_choice", "multiple_choice"),
                    ("integer", "integer"),
                    ("float", "float"),
                    ("date", "date"),
                    ("choice", "choice"),
                    ("textarea", "textarea"),
                    ("text", "text"),
                    ("table", "table"),
                    ("form", "form"),
                    ("files", "files"),
                    ("dynamic_choice", "dynamic_choice"),
                    ("dynamic_multiple_choice", "dynamic_multiple_choice"),
                    ("static", "static"),
                    ("calculated_float", "calculated_float"),
                    ("action_button", "action_button"),
                ],
                max_length=23,
            ),
        ),
        migrations.RunPython(rename_file_type, rename_file_type_reverse),
    ]
