import bcrypt
from flaskr import db

class User(db.Model):
    __tablename__ = 'users'

    id = db.Column(db.Integer, primary_key=True)
    email = db.Column(db.String, nullable=False)
    passwordhash = db.Column(db.String, nullable=False)

    videos = db.relationship('Video', back_populates='user')

    def __init__(self, email, password):
        self.email = email
        salt = bcrypt.gensalt()
        self.passwordhash = bcrypt.hashpw(password, salt)

    def to_dict(self):
        return {
            'id': self.id,
            'email': self.email
        }

