"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasMapping = exports.findMappings = void 0;
const section_1 = require("./section");
function findMappings(template, logicalId, props = {}) {
    const section = template.Mappings;
    const result = section_1.matchSection(section_1.filterLogicalId(section, logicalId), props);
    if (!result.match) {
        return {};
    }
    return result.matches;
}
exports.findMappings = findMappings;
function hasMapping(template, logicalId, props) {
    const section = template.Mappings;
    const result = section_1.matchSection(section_1.filterLogicalId(section, logicalId), props);
    if (result.match) {
        return;
    }
    if (result.closestResult === undefined) {
        return 'No mappings found in the template';
    }
    return [
        `Template has ${result.analyzedCount} mappings, but none match as expected.`,
        section_1.formatFailure(result.closestResult),
    ].join('\n');
}
exports.hasMapping = hasMapping;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWFwcGluZ3MuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJtYXBwaW5ncy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSx1Q0FBeUU7QUFHekUsU0FBZ0IsWUFBWSxDQUFDLFFBQWtCLEVBQUUsU0FBaUIsRUFBRSxRQUFhLEVBQUU7SUFDakYsTUFBTSxPQUFPLEdBQTJCLFFBQVEsQ0FBQyxRQUFRLENBQUM7SUFDMUQsTUFBTSxNQUFNLEdBQUcsc0JBQVksQ0FBQyx5QkFBZSxDQUFDLE9BQU8sRUFBRSxTQUFTLENBQUMsRUFBRSxLQUFLLENBQUMsQ0FBQztJQUV4RSxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssRUFBRTtRQUNqQixPQUFPLEVBQUUsQ0FBQztLQUNYO0lBRUQsT0FBTyxNQUFNLENBQUMsT0FBTyxDQUFDO0FBQ3hCLENBQUM7QUFURCxvQ0FTQztBQUVELFNBQWdCLFVBQVUsQ0FBQyxRQUFrQixFQUFFLFNBQWlCLEVBQUUsS0FBVTtJQUMxRSxNQUFNLE9BQU8sR0FBMEIsUUFBUSxDQUFDLFFBQVEsQ0FBQztJQUN6RCxNQUFNLE1BQU0sR0FBRyxzQkFBWSxDQUFDLHlCQUFlLENBQUMsT0FBTyxFQUFFLFNBQVMsQ0FBQyxFQUFFLEtBQUssQ0FBQyxDQUFDO0lBRXhFLElBQUksTUFBTSxDQUFDLEtBQUssRUFBRTtRQUNoQixPQUFPO0tBQ1I7SUFFRCxJQUFJLE1BQU0sQ0FBQyxhQUFhLEtBQUssU0FBUyxFQUFFO1FBQ3RDLE9BQU8sbUNBQW1DLENBQUM7S0FDNUM7SUFFRCxPQUFPO1FBQ0wsZ0JBQWdCLE1BQU0sQ0FBQyxhQUFhLHdDQUF3QztRQUM1RSx1QkFBYSxDQUFDLE1BQU0sQ0FBQyxhQUFhLENBQUM7S0FDcEMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7QUFDZixDQUFDO0FBaEJELGdDQWdCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IGZpbHRlckxvZ2ljYWxJZCwgZm9ybWF0RmFpbHVyZSwgbWF0Y2hTZWN0aW9uIH0gZnJvbSAnLi9zZWN0aW9uJztcbmltcG9ydCB7IFRlbXBsYXRlIH0gZnJvbSAnLi90ZW1wbGF0ZSc7XG5cbmV4cG9ydCBmdW5jdGlvbiBmaW5kTWFwcGluZ3ModGVtcGxhdGU6IFRlbXBsYXRlLCBsb2dpY2FsSWQ6IHN0cmluZywgcHJvcHM6IGFueSA9IHt9KTogeyBba2V5OiBzdHJpbmddOiB7IFtrZXk6IHN0cmluZ106IGFueSB9IH0ge1xuICBjb25zdCBzZWN0aW9uOiB7IFtrZXk6IHN0cmluZ10gOiB7fSB9ID0gdGVtcGxhdGUuTWFwcGluZ3M7XG4gIGNvbnN0IHJlc3VsdCA9IG1hdGNoU2VjdGlvbihmaWx0ZXJMb2dpY2FsSWQoc2VjdGlvbiwgbG9naWNhbElkKSwgcHJvcHMpO1xuXG4gIGlmICghcmVzdWx0Lm1hdGNoKSB7XG4gICAgcmV0dXJuIHt9O1xuICB9XG5cbiAgcmV0dXJuIHJlc3VsdC5tYXRjaGVzO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gaGFzTWFwcGluZyh0ZW1wbGF0ZTogVGVtcGxhdGUsIGxvZ2ljYWxJZDogc3RyaW5nLCBwcm9wczogYW55KTogc3RyaW5nIHwgdm9pZCB7XG4gIGNvbnN0IHNlY3Rpb246IHsgW2tleTogc3RyaW5nXToge30gfSA9IHRlbXBsYXRlLk1hcHBpbmdzO1xuICBjb25zdCByZXN1bHQgPSBtYXRjaFNlY3Rpb24oZmlsdGVyTG9naWNhbElkKHNlY3Rpb24sIGxvZ2ljYWxJZCksIHByb3BzKTtcblxuICBpZiAocmVzdWx0Lm1hdGNoKSB7XG4gICAgcmV0dXJuO1xuICB9XG5cbiAgaWYgKHJlc3VsdC5jbG9zZXN0UmVzdWx0ID09PSB1bmRlZmluZWQpIHtcbiAgICByZXR1cm4gJ05vIG1hcHBpbmdzIGZvdW5kIGluIHRoZSB0ZW1wbGF0ZSc7XG4gIH1cblxuICByZXR1cm4gW1xuICAgIGBUZW1wbGF0ZSBoYXMgJHtyZXN1bHQuYW5hbHl6ZWRDb3VudH0gbWFwcGluZ3MsIGJ1dCBub25lIG1hdGNoIGFzIGV4cGVjdGVkLmAsXG4gICAgZm9ybWF0RmFpbHVyZShyZXN1bHQuY2xvc2VzdFJlc3VsdCksXG4gIF0uam9pbignXFxuJyk7XG59Il19