/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.apidb.v0_6.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.openstreetmap.osmosis.core.database.RowMapperListener;
import org.openstreetmap.osmosis.core.domain.v0_6.CommonEntityData;
import org.openstreetmap.osmosis.core.domain.v0_6.OsmUser;
import org.springframework.jdbc.core.RowCallbackHandler;

public class EntityDataRowMapper
implements RowCallbackHandler {
    private RowMapperListener<CommonEntityData> listener;
    private boolean readAllUsers;

    public EntityDataRowMapper(RowMapperListener<CommonEntityData> listener, boolean readAllUsers) {
        this.listener = listener;
        this.readAllUsers = readAllUsers;
    }

    private OsmUser readUserField(boolean dataPublic, int userId, String userName) {
        if (userId == OsmUser.NONE.getId()) {
            return OsmUser.NONE;
        }
        if (dataPublic || this.readAllUsers) {
            String correctedUserName = userName == null ? "" : userName;
            return new OsmUser(userId, correctedUserName);
        }
        return OsmUser.NONE;
    }

    public void processRow(ResultSet resultSet) throws SQLException {
        long id = resultSet.getLong("id");
        int version = resultSet.getInt("version");
        Date timestamp = new Date(resultSet.getTimestamp("timestamp").getTime());
        OsmUser user = this.readUserField(resultSet.getBoolean("data_public"), resultSet.getInt("user_id"), resultSet.getString("display_name"));
        long changesetId = resultSet.getLong("changeset_id");
        CommonEntityData entityData = new CommonEntityData(id, version, timestamp, user, changesetId);
        this.listener.process((Object)entityData, resultSet);
    }
}

