/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.writer;

import gnu.trove.map.hash.TShortIntHashMap;
import gnu.trove.procedure.TShortIntProcedure;
import gnu.trove.set.hash.TShortHashSet;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.mapsforge.map.writer.model.OSMTag;
import org.mapsforge.map.writer.osmosis.MapFileWriterTask;
import org.mapsforge.map.writer.util.OSMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class OSMTagMapping {
    private static final Logger LOGGER = Logger.getLogger(OSMTagMapping.class.getName());
    private static OSMTagMapping mapping;
    private static final String XPATH_EXPRESSION_DEFAULT_ZOOM = "/tag-mapping/@default-zoom-appear";
    private static final String XPATH_EXPRESSION_POIS = "//pois/osm-tag[(../@enabled='true' or not(../@enabled)) and (./@enabled='true' or not(./@enabled)) or (../@enabled='false' and ./@enabled='true')]";
    private static final String XPATH_EXPRESSION_WAYS = "//ways/osm-tag[(../@enabled='true' or not(../@enabled)) and (./@enabled='true' or not(./@enabled)) or (../@enabled='false' and ./@enabled='true')]";
    private final Map<Short, OSMTag> idToPoiTag = new LinkedHashMap<Short, OSMTag>();
    private final Map<Short, OSMTag> idToWayTag = new LinkedHashMap<Short, OSMTag>();
    private final Map<Short, Short> optimizedPoiIds = new LinkedHashMap<Short, Short>();
    private final Map<Short, Short> optimizedWayIds = new LinkedHashMap<Short, Short>();
    private short poiID = 0;
    private final Map<Short, Set<OSMTag>> poiZoomOverrides = new LinkedHashMap<Short, Set<OSMTag>>();
    private final Map<String, OSMTag> stringToPoiTag = new LinkedHashMap<String, OSMTag>();
    private final Map<String, OSMTag> stringToWayTag = new LinkedHashMap<String, OSMTag>();
    private boolean tagValues;
    private short wayID = 0;
    private final Map<Short, Set<OSMTag>> wayZoomOverrides = new LinkedHashMap<Short, Set<OSMTag>>();

    public static synchronized OSMTagMapping getInstance() {
        if (mapping == null) {
            mapping = OSMTagMapping.getInstance(MapFileWriterTask.class.getClassLoader().getResource("tag-mapping.xml"));
        }
        return mapping;
    }

    public static OSMTagMapping getInstance(URL tagConf) {
        if (mapping != null) {
            throw new IllegalStateException("mapping already initialized");
        }
        mapping = new OSMTagMapping(tagConf);
        return mapping;
    }

    private OSMTagMapping(URL tagConf) {
        try {
            HashSet<OSMTag> overriddenTags;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(tagConf.openStream());
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression xe = xpath.compile(XPATH_EXPRESSION_DEFAULT_ZOOM);
            byte defaultZoomAppear = Byte.parseByte((String)xe.evaluate(document, XPathConstants.STRING));
            HashMap<Short, HashSet<String>> tmpPoiZoomOverrides = new HashMap<Short, HashSet<String>>();
            HashMap<Short, HashSet<String>> tmpWayZoomOverrides = new HashMap<Short, HashSet<String>>();
            xe = xpath.compile(XPATH_EXPRESSION_POIS);
            NodeList pois = (NodeList)xe.evaluate(document, XPathConstants.NODESET);
            for (int i = 0; i < pois.getLength(); ++i) {
                boolean labelPosition;
                boolean forcePolygonLine;
                boolean renderable;
                byte zoom;
                OSMTag osmTag;
                NamedNodeMap attributes = pois.item(i).getAttributes();
                String key = attributes.getNamedItem("key").getTextContent();
                String value = attributes.getNamedItem("value").getTextContent();
                String[] equivalentValues = null;
                if (attributes.getNamedItem("equivalent-values") != null) {
                    equivalentValues = attributes.getNamedItem("equivalent-values").getTextContent().split(",");
                }
                if (!this.addPoiTag(osmTag = new OSMTag(this.poiID, key, value, zoom = attributes.getNamedItem("zoom-appear") == null ? defaultZoomAppear : Byte.parseByte(attributes.getNamedItem("zoom-appear").getTextContent()), renderable = attributes.getNamedItem("renderable") == null ? true : Boolean.parseBoolean(attributes.getNamedItem("renderable").getTextContent()), forcePolygonLine = attributes.getNamedItem("force-polygon-line") == null ? false : Boolean.parseBoolean(attributes.getNamedItem("force-polygon-line").getTextContent()), labelPosition = attributes.getNamedItem("label-position") == null ? false : Boolean.parseBoolean(attributes.getNamedItem("label-position").getTextContent())), equivalentValues)) continue;
                NodeList zoomOverrideNodes = pois.item(i).getChildNodes();
                for (int j = 0; j < zoomOverrideNodes.getLength(); ++j) {
                    Node overriddenNode = zoomOverrideNodes.item(j);
                    if (!(overriddenNode instanceof Element)) continue;
                    String keyOverridden = overriddenNode.getAttributes().getNamedItem("key").getTextContent();
                    String valueOverridden = overriddenNode.getAttributes().getNamedItem("value").getTextContent();
                    HashSet<String> s2 = (HashSet<String>)tmpPoiZoomOverrides.get(this.poiID);
                    if (s2 == null) {
                        s2 = new HashSet<String>();
                        tmpPoiZoomOverrides.put(this.poiID, s2);
                    }
                    s2.add(OSMTag.tagKey(keyOverridden, valueOverridden));
                }
                this.poiID = (short)(this.poiID + 1);
            }
            xe = xpath.compile(XPATH_EXPRESSION_WAYS);
            NodeList ways = (NodeList)xe.evaluate(document, XPathConstants.NODESET);
            for (int i = 0; i < ways.getLength(); ++i) {
                boolean labelPosition;
                boolean forcePolygonLine;
                boolean renderable;
                byte zoom;
                OSMTag osmTag;
                NamedNodeMap attributes = ways.item(i).getAttributes();
                String key = attributes.getNamedItem("key").getTextContent();
                String value = attributes.getNamedItem("value").getTextContent();
                String[] equivalentValues = null;
                if (attributes.getNamedItem("equivalent-values") != null) {
                    equivalentValues = attributes.getNamedItem("equivalent-values").getTextContent().split(",");
                }
                if (!this.addWayTag(osmTag = new OSMTag(this.wayID, key, value, zoom = attributes.getNamedItem("zoom-appear") == null ? defaultZoomAppear : Byte.parseByte(attributes.getNamedItem("zoom-appear").getTextContent()), renderable = attributes.getNamedItem("renderable") == null ? true : Boolean.parseBoolean(attributes.getNamedItem("renderable").getTextContent()), forcePolygonLine = attributes.getNamedItem("force-polygon-line") == null ? false : Boolean.parseBoolean(attributes.getNamedItem("force-polygon-line").getTextContent()), labelPosition = attributes.getNamedItem("label-position") == null ? false : Boolean.parseBoolean(attributes.getNamedItem("label-position").getTextContent())), equivalentValues)) continue;
                NodeList zoomOverrideNodes = ways.item(i).getChildNodes();
                for (int j = 0; j < zoomOverrideNodes.getLength(); ++j) {
                    Node overriddenNode = zoomOverrideNodes.item(j);
                    if (!(overriddenNode instanceof Element)) continue;
                    String keyOverridden = overriddenNode.getAttributes().getNamedItem("key").getTextContent();
                    String valueOverridden = overriddenNode.getAttributes().getNamedItem("value").getTextContent();
                    HashSet<String> s3 = (HashSet<String>)tmpWayZoomOverrides.get(this.wayID);
                    if (s3 == null) {
                        s3 = new HashSet<String>();
                        tmpWayZoomOverrides.put(this.wayID, s3);
                    }
                    s3.add(OSMTag.tagKey(keyOverridden, valueOverridden));
                }
                this.wayID = (short)(this.wayID + 1);
            }
            for (Map.Entry entry : tmpPoiZoomOverrides.entrySet()) {
                overriddenTags = new HashSet<OSMTag>();
                for (String tagString : (Set)entry.getValue()) {
                    OSMTag tag = this.stringToPoiTag.get(tagString);
                    if (tag == null) continue;
                    overriddenTags.add(tag);
                }
                if (overriddenTags.isEmpty()) continue;
                this.poiZoomOverrides.put((Short)entry.getKey(), (Set<OSMTag>)overriddenTags);
            }
            for (Map.Entry entry : tmpWayZoomOverrides.entrySet()) {
                overriddenTags = new HashSet();
                for (String tagString : (Set)entry.getValue()) {
                    OSMTag tag = this.stringToWayTag.get(tagString);
                    if (tag == null) continue;
                    overriddenTags.add(tag);
                }
                if (overriddenTags.isEmpty()) continue;
                this.wayZoomOverrides.put((Short)entry.getKey(), (Set<OSMTag>)overriddenTags);
            }
        }
        catch (SAXParseException spe) {
            LOGGER.severe("\n** Parsing error, line " + spe.getLineNumber() + ", uri " + spe.getSystemId());
            throw new IllegalStateException(spe);
        }
        catch (SAXException sxe) {
            throw new IllegalStateException(sxe);
        }
        catch (ParserConfigurationException pce) {
            throw new IllegalStateException(pce);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException(e);
        }
    }

    private boolean addPoiTag(OSMTag osmTag, String[] equivalentValues) {
        if (this.stringToPoiTag.containsKey(osmTag.tagKey())) {
            LOGGER.warning("duplicate osm-tag found in tag-mapping configuration (ignoring): " + osmTag);
            return false;
        }
        LOGGER.finest("adding poi: " + osmTag);
        this.stringToPoiTag.put(osmTag.tagKey(), osmTag);
        if (equivalentValues != null) {
            for (String equivalentValue : equivalentValues) {
                this.stringToPoiTag.put(OSMTag.tagKey(osmTag.getKey(), equivalentValue), osmTag);
            }
        }
        this.idToPoiTag.put(this.poiID, osmTag);
        this.optimizedPoiIds.put(this.poiID, this.poiID);
        return true;
    }

    private boolean addWayTag(OSMTag osmTag, String[] equivalentValues) {
        if (this.stringToWayTag.containsKey(osmTag.tagKey())) {
            LOGGER.warning("duplicate osm-tag found in tag-mapping configuration (ignoring): " + osmTag);
            return false;
        }
        LOGGER.finest("adding way: " + osmTag);
        this.stringToWayTag.put(osmTag.tagKey(), osmTag);
        if (equivalentValues != null) {
            for (String equivalentValue : equivalentValues) {
                this.stringToWayTag.put(OSMTag.tagKey(osmTag.getKey(), equivalentValue), osmTag);
            }
        }
        this.idToWayTag.put(this.wayID, osmTag);
        this.optimizedWayIds.put(this.wayID, this.wayID);
        return true;
    }

    public Map<Short, Short> getOptimizedPoiIds() {
        return this.optimizedPoiIds;
    }

    public Map<Short, Short> getOptimizedWayIds() {
        return this.optimizedWayIds;
    }

    public OSMTag getPoiTag(short id) {
        return this.idToPoiTag.get(id);
    }

    public OSMTag getPoiTag(String key, String value) {
        OSMTag tag = this.stringToPoiTag.get(OSMTag.tagKey(key, value));
        if (tag != null) {
            return tag;
        }
        if (!this.tagValues) {
            return null;
        }
        String vType = OSMUtils.getValueType(key, value);
        if (vType.charAt(1) != 's') {
            tag = this.stringToPoiTag.get(OSMTag.tagKey(key, "%f"));
            if (tag == null) {
                return null;
            }
            tag = this.getPoiTagAlternative(key, vType, tag);
        } else {
            tag = this.stringToPoiTag.get(OSMTag.tagKey(key, vType));
            if (tag != null) {
                LOGGER.fine(key + ":\t" + value);
            }
        }
        return tag;
    }

    private OSMTag getPoiTagAlternative(String key, String value, OSMTag original) {
        assert (original != null);
        OSMTag tag = this.stringToPoiTag.get(OSMTag.tagKey(key, value));
        if (tag == null) {
            tag = new OSMTag(this.poiID, original.getKey(), value, original.getZoomAppear(), original.isRenderable(), original.isForcePolygonLine(), original.isLabelPosition());
            if (this.addPoiTag(tag, null)) {
                this.poiID = (short)(this.poiID + 1);
            } else {
                tag = original;
            }
        }
        return tag;
    }

    public List<OSMTag> getPoiTags(short[] ids) {
        ArrayList<OSMTag> tags = new ArrayList<OSMTag>();
        for (short id : ids) {
            tags.add(this.getPoiTag(id));
        }
        return tags;
    }

    public OSMTag getWayTag(short id) {
        return this.idToWayTag.get(id);
    }

    public OSMTag getWayTag(String key, String value) {
        OSMTag tag = this.stringToWayTag.get(OSMTag.tagKey(key, value));
        if (tag != null) {
            return tag;
        }
        if (!this.tagValues) {
            return null;
        }
        String vType = OSMUtils.getValueType(key, value);
        if (vType.charAt(1) != 's') {
            tag = this.stringToWayTag.get(OSMTag.tagKey(key, "%f"));
            if (tag == null) {
                return null;
            }
            tag = this.getWayTagAlternative(key, vType, tag);
        } else {
            tag = this.stringToWayTag.get(OSMTag.tagKey(key, vType));
            if (tag != null) {
                LOGGER.fine(key + ":\t" + value);
            }
        }
        return tag;
    }

    private OSMTag getWayTagAlternative(String key, String value, OSMTag original) {
        assert (original != null);
        OSMTag tag = this.stringToWayTag.get(OSMTag.tagKey(key, value));
        if (tag == null) {
            tag = new OSMTag(this.wayID, original.getKey(), value, original.getZoomAppear(), original.isRenderable(), original.isForcePolygonLine(), original.isLabelPosition());
            if (this.addWayTag(tag, null)) {
                this.wayID = (short)(this.wayID + 1);
            } else {
                tag = original;
            }
        }
        return tag;
    }

    public List<OSMTag> getWayTags(Set<Short> ids) {
        ArrayList<OSMTag> tags = new ArrayList<OSMTag>();
        for (short id : ids) {
            tags.add(this.getWayTag(id));
        }
        return tags;
    }

    public byte getZoomAppearPOI(Set<Short> tagSet) {
        if (tagSet == null || tagSet.size() == 0) {
            return 127;
        }
        TShortHashSet tmp = new TShortHashSet(tagSet);
        if (!this.poiZoomOverrides.isEmpty()) {
            for (short s2 : tagSet) {
                Set<OSMTag> overriddenTags = this.poiZoomOverrides.get(s2);
                if (overriddenTags == null) continue;
                for (OSMTag osmTag : overriddenTags) {
                    tmp.remove(osmTag.getId());
                }
            }
            if (tmp.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (short s3 : tagSet) {
                    sb.append(this.idToPoiTag.get(s3).tagKey() + "; ");
                }
                LOGGER.severe("ERROR: You have a cycle in your zoom-override definitions. Look for these tags: " + sb.toString());
            }
        }
        byte zoomAppear = 127;
        for (short s4 : tmp.toArray()) {
            OSMTag tag = this.idToPoiTag.get(s4);
            if (!tag.isRenderable()) continue;
            zoomAppear = (byte)Math.min(zoomAppear, tag.getZoomAppear());
        }
        return zoomAppear;
    }

    public byte getZoomAppearWay(Set<Short> tagSet) {
        if (tagSet == null || tagSet.size() == 0) {
            return 127;
        }
        TShortHashSet tmp = new TShortHashSet(tagSet);
        if (!this.wayZoomOverrides.isEmpty()) {
            for (short s2 : tagSet) {
                Set<OSMTag> overriddenTags = this.wayZoomOverrides.get(s2);
                if (overriddenTags == null) continue;
                for (OSMTag osmTag : overriddenTags) {
                    tmp.remove(osmTag.getId());
                }
            }
            if (tmp.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (short s3 : tagSet) {
                    sb.append(this.idToWayTag.get(s3).tagKey() + "; ");
                }
                LOGGER.severe("ERROR: You have a cycle in your zoom-override definitions. Look for these tags: " + sb.toString());
            }
        }
        byte zoomAppear = 127;
        for (short s4 : tmp.toArray()) {
            OSMTag tag = this.idToWayTag.get(s4);
            if (!tag.isRenderable()) continue;
            zoomAppear = (byte)Math.min(zoomAppear, tag.getZoomAppear());
        }
        return zoomAppear;
    }

    public void optimizePoiOrdering(TShortIntHashMap histogram) {
        this.optimizedPoiIds.clear();
        final TreeSet poiOrdering = new TreeSet();
        histogram.forEachEntry(new TShortIntProcedure(){

            @Override
            public boolean execute(short tag, int amount) {
                poiOrdering.add(new HistogramEntry(tag, amount));
                return true;
            }
        });
        short tmpPoiID = 0;
        OSMTag currentTag = null;
        for (HistogramEntry histogramEntry : poiOrdering.descendingSet()) {
            currentTag = this.idToPoiTag.get(histogramEntry.id);
            this.optimizedPoiIds.put(histogramEntry.id, tmpPoiID);
            LOGGER.finer("adding poi tag: " + currentTag.tagKey() + " id:" + tmpPoiID + " amount: " + histogramEntry.amount);
            tmpPoiID = (short)(tmpPoiID + 1);
        }
    }

    public void optimizeWayOrdering(TShortIntHashMap histogram) {
        this.optimizedWayIds.clear();
        final TreeSet wayOrdering = new TreeSet();
        histogram.forEachEntry(new TShortIntProcedure(){

            @Override
            public boolean execute(short tag, int amount) {
                wayOrdering.add(new HistogramEntry(tag, amount));
                return true;
            }
        });
        short tmpWayID = 0;
        OSMTag currentTag = null;
        for (HistogramEntry histogramEntry : wayOrdering.descendingSet()) {
            currentTag = this.idToWayTag.get(histogramEntry.id);
            this.optimizedWayIds.put(histogramEntry.id, tmpWayID);
            LOGGER.finer("adding way tag: " + currentTag.tagKey() + " id:" + tmpWayID + " amount: " + histogramEntry.amount);
            tmpWayID = (short)(tmpWayID + 1);
        }
    }

    public void setTagValues(boolean tagValues) {
        OSMTag tag;
        this.tagValues = tagValues;
        if (this.tagValues && (tag = this.stringToWayTag.get(OSMTag.tagKey("id", "%f"))) == null && this.addWayTag(tag = new OSMTag(this.wayID, "id", "%f", 127, false, false, false), null)) {
            this.wayID = (short)(this.wayID + 1);
        }
    }

    private class HistogramEntry
    implements Comparable<HistogramEntry> {
        final int amount;
        final short id;

        public HistogramEntry(short id, int amount) {
            this.id = id;
            this.amount = amount;
        }

        @Override
        public int compareTo(HistogramEntry o) {
            if (this.amount > o.amount) {
                return 1;
            }
            if (this.amount < o.amount) {
                return -1;
            }
            if (this.id < o.id) {
                return 1;
            }
            if (this.id > o.id) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HistogramEntry other = (HistogramEntry)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.amount != other.amount) {
                return false;
            }
            return this.id == other.id;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + this.amount;
            result = 31 * result + this.id;
            return result;
        }

        private OSMTagMapping getOuterType() {
            return OSMTagMapping.this;
        }
    }
}

