/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.store;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.lifecycle.Completable;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.store.DataInputStoreReader;
import org.openstreetmap.osmosis.core.store.DataOutputStoreWriter;
import org.openstreetmap.osmosis.core.store.DynamicStoreClassRegister;
import org.openstreetmap.osmosis.core.store.EmptyIterator;
import org.openstreetmap.osmosis.core.store.ObjectSerializationFactory;
import org.openstreetmap.osmosis.core.store.ObjectStreamIterator;
import org.openstreetmap.osmosis.core.store.ObjectWriter;
import org.openstreetmap.osmosis.core.store.StorageStage;
import org.openstreetmap.osmosis.core.store.StoreClassRegister;
import org.openstreetmap.osmosis.core.store.Storeable;

public class SimpleObjectStore<T extends Storeable>
implements Completable {
    private static final Logger LOG = Logger.getLogger(SimpleObjectStore.class.getName());
    private ObjectSerializationFactory serializationFactory;
    private StorageStage stage;
    private String storageFilePrefix;
    private File file;
    private FileOutputStream fileOutStream;
    private DataOutputStream dataOutStream;
    private StoreClassRegister storeClassRegister;
    private ObjectWriter objectWriter;
    private boolean useCompression;

    public SimpleObjectStore(ObjectSerializationFactory serializationFactory, String storageFilePrefix, boolean useCompression) {
        this.serializationFactory = serializationFactory;
        this.storageFilePrefix = storageFilePrefix;
        this.useCompression = useCompression;
        this.storeClassRegister = new DynamicStoreClassRegister();
        this.stage = StorageStage.NotStarted;
    }

    public void add(T data) {
        if (this.stage.compareTo(StorageStage.Add) > 0) {
            throw new OsmosisRuntimeException("Cannot add to storage in stage " + (Object)((Object)this.stage) + ".");
        }
        if (this.stage.compareTo(StorageStage.Add) < 0) {
            try {
                this.file = File.createTempFile(this.storageFilePrefix, null);
                this.fileOutStream = new FileOutputStream(this.file);
                this.dataOutStream = this.useCompression ? new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(this.fileOutStream), 65536)) : new DataOutputStream(new BufferedOutputStream(this.fileOutStream, 65536));
                this.objectWriter = this.serializationFactory.createObjectWriter(new DataOutputStoreWriter(this.dataOutStream), this.storeClassRegister);
                this.stage = StorageStage.Add;
            }
            catch (IOException e) {
                throw new OsmosisRuntimeException("Unable to create object stream writing to temporary file " + this.file + ".", e);
            }
        }
        this.objectWriter.writeObject((Storeable)data);
    }

    private boolean initializeIteratingStage() {
        if (this.stage.compareTo(StorageStage.Released) >= 0) {
            throw new OsmosisRuntimeException("Cannot iterate over storage in stage " + (Object)((Object)this.stage) + ".");
        }
        if (this.stage.compareTo(StorageStage.NotStarted) <= 0) {
            return false;
        }
        if (this.stage.compareTo(StorageStage.Add) == 0) {
            try {
                this.dataOutStream.close();
                this.fileOutStream.close();
            }
            catch (IOException e) {
                throw new OsmosisRuntimeException("Unable to close output stream.", e);
            }
            finally {
                this.dataOutStream = null;
                this.fileOutStream = null;
            }
            this.stage = StorageStage.Reading;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReleasableIterator<T> iterate() {
        FileInputStream fileStream = null;
        try {
            DataInputStream dataInStream;
            if (!this.initializeIteratingStage()) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            try {
                fileStream = new FileInputStream(this.file);
            }
            catch (IOException e) {
                throw new OsmosisRuntimeException("Unable to open file for reading.", e);
            }
            try {
                dataInStream = this.useCompression ? new DataInputStream(new BufferedInputStream(new GZIPInputStream(fileStream), 65536)) : new DataInputStream(new BufferedInputStream(fileStream, 65536));
            }
            catch (IOException e) {
                throw new OsmosisRuntimeException("Unable to open object stream.", e);
            }
            fileStream = null;
            ObjectStreamIterator objectStreamIterator = new ObjectStreamIterator(dataInStream, this.serializationFactory.createObjectReader(new DataInputStoreReader(dataInStream), this.storeClassRegister));
            return objectStreamIterator;
        }
        finally {
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, "Unable to close file input stream.", e);
                }
            }
        }
    }

    @Override
    public void complete() {
    }

    @Override
    public void close() {
        if (this.fileOutStream != null) {
            try {
                this.fileOutStream.close();
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Unable to close file output stream.", e);
            }
            this.fileOutStream = null;
        }
        if (this.file != null) {
            if (!this.file.delete()) {
                LOG.warning("Unable to delete file " + this.file);
            }
            this.file = null;
        }
        this.stage = StorageStage.Released;
    }
}

