/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.replication.v0_6.impl;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.util.PropertiesPersister;

public class ReplicationDownloaderConfiguration {
    private static final String KEY_BASE_URL = "baseUrl";
    private static final String KEY_MAX_INTERVAL = "maxInterval";
    private Properties properties;

    public ReplicationDownloaderConfiguration(File configFile) {
        this.properties = new PropertiesPersister(configFile).load();
    }

    public URL getBaseUrl() {
        String baseUrl = this.properties.getProperty(KEY_BASE_URL);
        if (!baseUrl.substring(baseUrl.length() - 1).equals("/")) {
            baseUrl = baseUrl + "/";
        }
        try {
            return new URL(baseUrl);
        }
        catch (MalformedURLException e) {
            throw new OsmosisRuntimeException("Unable to convert URL string (" + baseUrl + ") into a URL.", (Throwable)e);
        }
    }

    public int getMaxInterval() {
        return Integer.parseInt(this.properties.getProperty(KEY_MAX_INTERVAL)) * 1000;
    }
}

