/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pbf2.v0_6.impl;

import com.google.protobuf.InvalidProtocolBufferException;
import java.util.function.Function;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.osmbinary.Fileformat;
import org.openstreetmap.osmosis.osmbinary.Osmformat;
import org.openstreetmap.osmosis.pbf2.v0_6.impl.BlobDecompressor;
import org.openstreetmap.osmosis.pbf2.v0_6.impl.PbfBlock;
import org.openstreetmap.osmosis.pbf2.v0_6.impl.RawBlob;

public class BlobToBlockMapper
implements Function<RawBlob, PbfBlock> {
    private static final String HEADER_TYPE = "OSMHeader";
    private static final String PRIMITIVE_TYPE = "OSMData";
    private BlobDecompressor decompressor = new BlobDecompressor();

    @Override
    public PbfBlock apply(RawBlob rawBlob) {
        Fileformat.Blob pbfBlob = this.parseBlob(rawBlob.getData());
        byte[] data = this.decompressor.apply(pbfBlob);
        if (HEADER_TYPE.equals(rawBlob.getType())) {
            return new PbfBlock(this.parseHeaderBlock(data));
        }
        if (PRIMITIVE_TYPE.equals(rawBlob.getType())) {
            return new PbfBlock(this.parsePrimitiveBlock(data));
        }
        return new PbfBlock();
    }

    private Fileformat.Blob parseBlob(byte[] data) {
        try {
            return Fileformat.Blob.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            throw new OsmosisRuntimeException("Unable to parse PBF blob", (Throwable)e);
        }
    }

    private Osmformat.HeaderBlock parseHeaderBlock(byte[] data) {
        try {
            return Osmformat.HeaderBlock.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            throw new OsmosisRuntimeException("Unable to parse PBF header block", (Throwable)e);
        }
    }

    private Osmformat.PrimitiveBlock parsePrimitiveBlock(byte[] data) {
        try {
            return Osmformat.PrimitiveBlock.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            throw new OsmosisRuntimeException("Unable to parse PBF primitive block", (Throwable)e);
        }
    }
}

