# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class QueueUserEventTopicQueueMember(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        QueueUserEventTopicQueueMember - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'member_id': 'str',
            'name': 'str',
            'ring_number': 'int',
            'type': 'str',
            'joined': 'bool'
        }

        self.attribute_map = {
            'member_id': 'memberId',
            'name': 'name',
            'ring_number': 'ringNumber',
            'type': 'type',
            'joined': 'joined'
        }

        self._member_id = None
        self._name = None
        self._ring_number = None
        self._type = None
        self._joined = None

    @property
    def member_id(self):
        """
        Gets the member_id of this QueueUserEventTopicQueueMember.


        :return: The member_id of this QueueUserEventTopicQueueMember.
        :rtype: str
        """
        return self._member_id

    @member_id.setter
    def member_id(self, member_id):
        """
        Sets the member_id of this QueueUserEventTopicQueueMember.


        :param member_id: The member_id of this QueueUserEventTopicQueueMember.
        :type: str
        """
        
        self._member_id = member_id

    @property
    def name(self):
        """
        Gets the name of this QueueUserEventTopicQueueMember.


        :return: The name of this QueueUserEventTopicQueueMember.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this QueueUserEventTopicQueueMember.


        :param name: The name of this QueueUserEventTopicQueueMember.
        :type: str
        """
        
        self._name = name

    @property
    def ring_number(self):
        """
        Gets the ring_number of this QueueUserEventTopicQueueMember.


        :return: The ring_number of this QueueUserEventTopicQueueMember.
        :rtype: int
        """
        return self._ring_number

    @ring_number.setter
    def ring_number(self, ring_number):
        """
        Sets the ring_number of this QueueUserEventTopicQueueMember.


        :param ring_number: The ring_number of this QueueUserEventTopicQueueMember.
        :type: int
        """
        
        self._ring_number = ring_number

    @property
    def type(self):
        """
        Gets the type of this QueueUserEventTopicQueueMember.


        :return: The type of this QueueUserEventTopicQueueMember.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this QueueUserEventTopicQueueMember.


        :param type: The type of this QueueUserEventTopicQueueMember.
        :type: str
        """
        
        self._type = type

    @property
    def joined(self):
        """
        Gets the joined of this QueueUserEventTopicQueueMember.


        :return: The joined of this QueueUserEventTopicQueueMember.
        :rtype: bool
        """
        return self._joined

    @joined.setter
    def joined(self, joined):
        """
        Sets the joined of this QueueUserEventTopicQueueMember.


        :param joined: The joined of this QueueUserEventTopicQueueMember.
        :type: bool
        """
        
        self._joined = joined

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

