# -*- coding: utf-8 -*-

"""
firstlanguage_python

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from firstlanguage_python.decorators import lazy_property
from firstlanguage_python.configuration import Configuration
from firstlanguage_python.configuration import Environment
from firstlanguage_python.http.auth.custom_header_authentication import CustomHeaderAuthentication
from firstlanguage_python.controllers.basic_api_controller\
    import BasicAPIsController
from firstlanguage_python.controllers.advanced_api_controller\
    import AdvancedAPIsController
from firstlanguage_python.controllers.enterprise_only_controller\
    import EnterpriseOnlyController


class Client(object):

    @lazy_property
    def basic_api(self):
        return BasicAPIsController(self.config, self.auth_managers)

    @lazy_property
    def advanced_api(self):
        return AdvancedAPIsController(self.config, self.auth_managers)

    @lazy_property
    def enterprise_only(self):
        return EnterpriseOnlyController(self.config, self.auth_managers)

    def __init__(self, http_client_instance=None,
                 override_http_client_configuration=False, timeout=60,
                 max_retries=0, backoff_factor=2,
                 retry_statuses=[408, 413, 429, 500, 502, 503, 504, 521, 522, 524],
                 retry_methods=['GET', 'PUT'],
                 environment=Environment.PRODUCTION, apikey='TODO: Replace',
                 config=None):
        if config is None:
            self.config = Configuration(
                                         http_client_instance=http_client_instance,
                                         override_http_client_configuration=override_http_client_configuration,
                                         timeout=timeout,
                                         max_retries=max_retries,
                                         backoff_factor=backoff_factor,
                                         retry_statuses=retry_statuses,
                                         retry_methods=retry_methods,
                                         environment=environment, apikey=apikey)
        else:
            self.config = config
        self.initialize_auth_managers(self.config)

    def initialize_auth_managers(self, config):
        self.auth_managers = { key: None for key in ['global']}
        self.auth_managers['global'] = CustomHeaderAuthentication(config.apikey)
        return self.auth_managers
