# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['ax',
 'ax.utils',
 'ax.utils.ax_tree',
 'axlib',
 'axlib.ax_tree',
 'devapp',
 'devapp.app_token',
 'devapp.arch',
 'devapp.arch.gitlab',
 'devapp.arch.gitlab.solution.conf',
 'devapp.components',
 'devapp.lib',
 'devapp.operations',
 'devapp.plugins.ops_devapp',
 'devapp.plugins.ops_devapp.arch',
 'devapp.spec',
 'devapp.testing',
 'devapp.tests',
 'devapp.utils',
 'mdvl',
 'structlogging',
 'structlogging.tests',
 'theming',
 'theming.filesize',
 'theming.formatting',
 'theming.tests',
 'tree_builder',
 'tree_builder.arch']

package_data = \
{'': ['*'],
 'devapp': ['third/*'],
 'devapp.arch.gitlab': ['solution/*'],
 'devapp.spec': ['templates/*']}

install_requires = \
['PyJWT',
 'PyYAML',
 'Pygments',
 'Rx',
 'absl-py',
 'bpytop',
 'decorator',
 'gevent',
 'httpx',
 'humanize',
 'inflection',
 'jsondiff',
 'lz4',
 'msgpack',
 'psutil',
 'pycond',
 'requests',
 'snoop',
 'structlog',
 'tabulate',
 'toml',
 'ujson']

entry_points = \
{'console_scripts': ['app = devapp.plugin_tools:main',
                     'ops = devapp.plugin_tools:main']}

setup_kwargs = {
    'name': 'devapps',
    'version': '2021.8.1',
    'description': 'Apps - End to End.',
    'long_description': '\n# About `devapp`\n\n\n<p attr="autogenerated by make_badges"></p>\n\n<p attr="autogenerated by make_badges"></p>\n\n![](img/page-teaser.png){: style="width:1550px" }\n\n\nThis is an enabler repo to develop "ops friendly" apps in a normalized way, incl:\n\n- logging ([structlog](https://www.structlog.org/en/stable/))\n- cli flags handling ([abseil](https://abseil.io/docs/python/), with addons)\n- docu ([mkdocs-material](https://squidfunk.github.io/mkdocs-material/getting-started/))\n- project setup\n- (test) resoures management, including daemons and container filesystem layers\n\nand more.\n\n\n\n<!-- pre_proc_marker -->\n\n\n----\n\n\nLast modified: Sun Aug  1 20:21:25 2021',
    'author': 'Gunther Klessinger',
    'author_email': 'gunther.klessinger@axiros.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'http://github.com/AXGKl/devapps',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
