# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class WhatsAppIntegrationUpdateRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        WhatsAppIntegrationUpdateRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'supported_content': 'SupportedContentReference',
            'messaging_setting': 'MessagingSettingRequestReference',
            'action': 'str',
            'authentication_method': 'str',
            'confirmation_code': 'str',
            'phone_number': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'supported_content': 'supportedContent',
            'messaging_setting': 'messagingSetting',
            'action': 'action',
            'authentication_method': 'authenticationMethod',
            'confirmation_code': 'confirmationCode',
            'phone_number': 'phoneNumber',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._supported_content = None
        self._messaging_setting = None
        self._action = None
        self._authentication_method = None
        self._confirmation_code = None
        self._phone_number = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this WhatsAppIntegrationUpdateRequest.
        The globally unique identifier for the object.

        :return: The id of this WhatsAppIntegrationUpdateRequest.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this WhatsAppIntegrationUpdateRequest.
        The globally unique identifier for the object.

        :param id: The id of this WhatsAppIntegrationUpdateRequest.
        :type: str
        """
        

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this WhatsAppIntegrationUpdateRequest.
        WhatsApp Integration name

        :return: The name of this WhatsAppIntegrationUpdateRequest.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this WhatsAppIntegrationUpdateRequest.
        WhatsApp Integration name

        :param name: The name of this WhatsAppIntegrationUpdateRequest.
        :type: str
        """
        

        self._name = name

    @property
    def supported_content(self):
        """
        Gets the supported_content of this WhatsAppIntegrationUpdateRequest.
        Defines the SupportedContent profile configured for an integration

        :return: The supported_content of this WhatsAppIntegrationUpdateRequest.
        :rtype: SupportedContentReference
        """
        return self._supported_content

    @supported_content.setter
    def supported_content(self, supported_content):
        """
        Sets the supported_content of this WhatsAppIntegrationUpdateRequest.
        Defines the SupportedContent profile configured for an integration

        :param supported_content: The supported_content of this WhatsAppIntegrationUpdateRequest.
        :type: SupportedContentReference
        """
        

        self._supported_content = supported_content

    @property
    def messaging_setting(self):
        """
        Gets the messaging_setting of this WhatsAppIntegrationUpdateRequest.
        Defines the message settings to be applied for this integration

        :return: The messaging_setting of this WhatsAppIntegrationUpdateRequest.
        :rtype: MessagingSettingRequestReference
        """
        return self._messaging_setting

    @messaging_setting.setter
    def messaging_setting(self, messaging_setting):
        """
        Sets the messaging_setting of this WhatsAppIntegrationUpdateRequest.
        Defines the message settings to be applied for this integration

        :param messaging_setting: The messaging_setting of this WhatsAppIntegrationUpdateRequest.
        :type: MessagingSettingRequestReference
        """
        

        self._messaging_setting = messaging_setting

    @property
    def action(self):
        """
        Gets the action of this WhatsAppIntegrationUpdateRequest.
        The action used to activate and then confirm a WhatsApp Integration.

        :return: The action of this WhatsAppIntegrationUpdateRequest.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """
        Sets the action of this WhatsAppIntegrationUpdateRequest.
        The action used to activate and then confirm a WhatsApp Integration.

        :param action: The action of this WhatsAppIntegrationUpdateRequest.
        :type: str
        """
        allowed_values = ["Activate", "Confirm"]
        if action.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for action -> " + action)
            self._action = "outdated_sdk_version"
        else:
            self._action = action

    @property
    def authentication_method(self):
        """
        Gets the authentication_method of this WhatsAppIntegrationUpdateRequest.
        The authentication method used to confirm a WhatsApp Integration activation. If action is set to Activate, then authenticationMethod is a required field. 

        :return: The authentication_method of this WhatsAppIntegrationUpdateRequest.
        :rtype: str
        """
        return self._authentication_method

    @authentication_method.setter
    def authentication_method(self, authentication_method):
        """
        Sets the authentication_method of this WhatsAppIntegrationUpdateRequest.
        The authentication method used to confirm a WhatsApp Integration activation. If action is set to Activate, then authenticationMethod is a required field. 

        :param authentication_method: The authentication_method of this WhatsAppIntegrationUpdateRequest.
        :type: str
        """
        allowed_values = ["Sms", "Voice"]
        if authentication_method.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for authentication_method -> " + authentication_method)
            self._authentication_method = "outdated_sdk_version"
        else:
            self._authentication_method = authentication_method

    @property
    def confirmation_code(self):
        """
        Gets the confirmation_code of this WhatsAppIntegrationUpdateRequest.
        The confirmation code sent by Whatsapp to you during the activation step. If action is set to Confirm, then confirmationCode is a required field.

        :return: The confirmation_code of this WhatsAppIntegrationUpdateRequest.
        :rtype: str
        """
        return self._confirmation_code

    @confirmation_code.setter
    def confirmation_code(self, confirmation_code):
        """
        Sets the confirmation_code of this WhatsAppIntegrationUpdateRequest.
        The confirmation code sent by Whatsapp to you during the activation step. If action is set to Confirm, then confirmationCode is a required field.

        :param confirmation_code: The confirmation_code of this WhatsAppIntegrationUpdateRequest.
        :type: str
        """
        

        self._confirmation_code = confirmation_code

    @property
    def phone_number(self):
        """
        Gets the phone_number of this WhatsAppIntegrationUpdateRequest.
        Phone number to associate with the WhatsApp integration

        :return: The phone_number of this WhatsAppIntegrationUpdateRequest.
        :rtype: str
        """
        return self._phone_number

    @phone_number.setter
    def phone_number(self, phone_number):
        """
        Sets the phone_number of this WhatsAppIntegrationUpdateRequest.
        Phone number to associate with the WhatsApp integration

        :param phone_number: The phone_number of this WhatsAppIntegrationUpdateRequest.
        :type: str
        """
        

        self._phone_number = phone_number

    @property
    def self_uri(self):
        """
        Gets the self_uri of this WhatsAppIntegrationUpdateRequest.
        The URI for this object

        :return: The self_uri of this WhatsAppIntegrationUpdateRequest.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this WhatsAppIntegrationUpdateRequest.
        The URI for this object

        :param self_uri: The self_uri of this WhatsAppIntegrationUpdateRequest.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

